/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.util;

import com.sun.portal.rproxy.configservlet.client.PlatformProfile;
import com.sun.portal.util.SystemProperties;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class GWLocale {
    public static final String RESOURCENAME = "srapGateway";
    private static ResourceBundle platformRB;
    private static ResourceBundle userRB;
    private static Hashtable rbHash;
    private static Locale platformLocale;
    private static Locale userLocale;

    public static Locale getLocale(String stringformat) {
        if (stringformat == null) {
            return Locale.getDefault();
        }
        StringTokenizer tk = new StringTokenizer(stringformat, "_");
        String lang = "";
        String country = "";
        String variant = "";
        if (tk.hasMoreTokens()) {
            lang = tk.nextToken();
        }
        if (tk.hasMoreTokens()) {
            country = tk.nextToken();
        }
        if (tk.hasMoreTokens()) {
            variant = tk.nextToken();
        }
        return new Locale(lang, country, variant);
    }

    public static ResourceBundle getResourceBundle(String bundle, String stringformat) {
        return ResourceBundle.getBundle(bundle, GWLocale.getLocale(stringformat));
    }

    public static ResourceBundle getInstallResourceBundle(String bundle) {
        String loc = null;
        loc = SystemProperties.get("gateway.locale", "en_US");
        return ResourceBundle.getBundle(bundle, GWLocale.getLocale(loc));
    }

    public static void createDefault() {
        try {
            String platformLocaleStr = PlatformProfile.getString("locale", "en_US");
            platformRB = GWLocale.getResourceBundle(RESOURCENAME, platformLocaleStr);
            platformLocale = GWLocale.getLocale(platformLocaleStr);
            rbHash.put(platformLocaleStr, platformRB);
            String userLocaleStr = SystemProperties.get("gateway.locale", "en_US");
            userRB = GWLocale.getResourceBundle(RESOURCENAME, userLocaleStr);
            rbHash.put(userLocaleStr, userRB);
            userLocale = GWLocale.getLocale(userLocaleStr);
        }
        catch (MissingResourceException mre) {
            System.out.println(platformRB.getString("ResourceFileNotFound"));
            System.exit(1);
        }
    }

    public static String getPFString(String key) {
        try {
            return platformRB.getString(key);
        }
        catch (Exception ex) {
            return key;
        }
    }

    public static String getPFString(String key, Object[] args) {
        try {
            MessageFormat mf = new MessageFormat("");
            mf.setLocale(platformLocale);
            mf.applyPattern(GWLocale.getPFString(key));
            return mf.format(args, new StringBuffer(), (FieldPosition)null).toString();
        }
        catch (Exception ex) {
            return key;
        }
    }

    public static String getPFString(String key, Object[] args, String locale) {
        try {
            MessageFormat mf = new MessageFormat("");
            mf.setLocale(GWLocale.getLocale(locale));
            mf.applyPattern(GWLocale.getString(key, locale));
            return mf.format(args, new StringBuffer(), (FieldPosition)null).toString();
        }
        catch (Exception ex) {
            return key;
        }
    }

    public static String getUserString(String key) {
        try {
            return userRB.getString(key);
        }
        catch (Exception ex) {
            return key;
        }
    }

    public static String getUserString(String key, Object[] args) {
        try {
            MessageFormat mf = new MessageFormat("");
            mf.setLocale(userLocale);
            mf.applyPattern(GWLocale.getUserString(key));
            return mf.format(args, new StringBuffer(), (FieldPosition)null).toString();
        }
        catch (Exception ex) {
            return key;
        }
    }

    public static String getString(String key, String localeStr) {
        ResourceBundle rb;
        if (localeStr == null) {
            localeStr = "en_US";
        }
        if (rbHash.contains(localeStr)) {
            rb = (ResourceBundle)rbHash.get(localeStr);
        } else {
            try {
                rb = GWLocale.getResourceBundle(RESOURCENAME, localeStr);
            }
            catch (Exception ex) {
                return key;
            }
            rbHash.put(localeStr, rb);
        }
        return rb.getString(key);
    }

    static {
        rbHash = new Hashtable();
    }
}

