/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.rewriter.util.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;

public class ChunkedContent {
    public static byte[] readChunkedContent(InputStream in) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int chunkSize = ChunkedContent.getChunkSize(in);
        while (chunkSize > 0) {
            byte[] buf = new byte[chunkSize];
            in.read(buf);
            ChunkedContent.readCRLF(in);
            baos.write(buf);
            chunkSize = ChunkedContent.getChunkSize(in);
        }
        return baos.toByteArray();
    }

    private static int getChunkSize(InputStream in) throws IOException {
        int chunksize = 0;
        String line = ChunkedContent.readLine(in);
        if (line == null) {
            throw new IOException("Could not read chunk block size");
        }
        StringTokenizer st = new StringTokenizer(line, "\t \n\r(;");
        if (st.hasMoreTokens()) {
            String hex = st.nextToken();
            try {
                chunksize = Integer.parseInt(hex, 16);
            }
            catch (NumberFormatException e) {
                throw new IOException("Chunk size should be a hex number: '" + line + "', '" + hex + "'.");
            }
        } else {
            throw new IOException("Chunk could not be read.");
        }
        return chunksize;
    }

    public static void readCRLF(InputStream in) throws IOException {
        int cr = in.read();
        int lf = in.read();
        if (cr != 13 && lf != 10) {
            throw new IOException("Could not read CR & LF correctly: " + cr + ", " + lf);
        }
    }

    private static String readLine(InputStream in) throws IOException {
        int c;
        StringBuffer sb = new StringBuffer(50);
        int l = -1;
        int count = 0;
        while ((c = in.read()) != -1) {
            ++count;
            if (l == 13 && c == 10) {
                sb.setLength(sb.length() - 1);
                break;
            }
            sb.append((char)c);
            l = c;
        }
        if (count == 0) {
            return null;
        }
        return sb.toString();
    }
}

