/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.connectionhandler;

import com.iplanet.services.comm.client.PLLNotificationServlet;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.portal.cli.cert.JSSUtil;
import com.sun.portal.netlet.eproxy.EProxy;
import com.sun.portal.perf.rproxy.PerfContext;
import com.sun.portal.perf.rproxy.PerfContextObject;
import com.sun.portal.perf.rproxy.TimerData;
import com.sun.portal.rproxy.configservlet.client.GatewayProfile;
import com.sun.portal.rproxy.configservlet.client.PlatformProfile;
import com.sun.portal.rproxy.configservlet.client.UserProfile;
import com.sun.portal.rproxy.connectionhandler.Base64;
import com.sun.portal.rproxy.connectionhandler.CSBufferedInputStream;
import com.sun.portal.rproxy.connectionhandler.ErrorResponse;
import com.sun.portal.rproxy.connectionhandler.FileNotFoundResponse;
import com.sun.portal.rproxy.connectionhandler.GatewayServletResponse;
import com.sun.portal.rproxy.connectionhandler.HTTPRequest;
import com.sun.portal.rproxy.connectionhandler.HTTPResponse;
import com.sun.portal.rproxy.connectionhandler.HTTPRetriever;
import com.sun.portal.rproxy.connectionhandler.HeaderResponse;
import com.sun.portal.rproxy.connectionhandler.RedirectResponse;
import com.sun.portal.rproxy.connectionhandler.Request;
import com.sun.portal.rproxy.connectionhandler.Response;
import com.sun.portal.rproxy.connectionhandler.RetrievalFactory;
import com.sun.portal.rproxy.connectionhandler.Retriever;
import com.sun.portal.rproxy.connectionhandler.RewriterProxyRouter;
import com.sun.portal.rproxy.connectionhandler.StatisticsResponse;
import com.sun.portal.rproxy.rewriter.SRAPAdapter;
import com.sun.portal.rproxy.rewriter.SRAPTranslatorHelper;
import com.sun.portal.util.Debug;
import com.sun.portal.util.DomainWebProxyConfig;
import com.sun.portal.util.GWDebug;
import com.sun.portal.util.GWLocale;
import com.sun.portal.util.GWLogManager;
import com.sun.portal.util.LogInfoContainer;
import com.sun.portal.util.SRAPSocket;
import com.sun.portal.util.SSOUtil;
import com.sun.portal.util.ServersList;
import com.sun.portal.util.ServiceIdentifier;
import com.sun.portal.util.SystemProperties;
import java.io.BufferedInputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.ssl.SSLSocket;

public abstract class Session {
    protected Socket _theSocket;
    protected boolean _moreElements = true;
    protected Integer _logId;
    protected static String _platformloginURL;
    protected static String _platformlogoutURL;
    protected static boolean _useHTTPProxy;
    protected static String _hpport;
    protected static String _hpprot;
    protected static String rphost;
    protected static List srapGateway_certificateEnabledList_lc;
    private static List virtualHost;
    private static List virtualHostActual;
    private static List nonAuthPathList;
    protected String _gwport;
    protected String _gwprotocol;
    protected int port;
    private static int _numRequests;
    public static int _numBytesRead;
    public static int _numBytesSent;
    private static final String UNKNOWN_HOST = "Unknown Host";
    private static Debug server_traffic;
    private static Debug browser_traffic;
    static final String defaultLocale;
    static final String exceptionErrorMessage = "ExceptionErrorMessage";
    static final String notificationErrorMessage = "NotificationErrorMessage";
    static final String invalidGatewayHostNameErrorMessage = "InvalidGatewayHostNameErrorMessage";
    static final String accessDeniedErrorMessage = "AccessDeniedErrorMessage";
    static final String webProxErrorMessage = "WebProxErrorMessage";
    static final String hostConnectErrorMessage = "HostConnectErrorMessage";
    private static final boolean isPerSessionLoggingEnabled;
    private static final boolean detailedRproxLog;
    private Socket actualClientSocket = null;
    private Socket nonsslsocket = null;
    private static final int DEFAULT_TIMEOUT = 60000;
    protected final int readTimeout = GatewayProfile.getInt("RProxyPortTimeout", 60000);
    protected int this_req = 0;
    public static final boolean processKeepAliveConnections;
    private static final int timeoutseconds;
    public static final int GRACE_PERIOD;
    public static final long maxTimeOutSetting;
    private int MAX_PER_SESS = GatewayProfile.getInt("EProxyKeepAliveMaxConnection", 10);
    public static final long THREAD_SLEEP_TIME = 50L;
    private long nullTimeout = maxTimeOutSetting;
    protected boolean thisreqKeepAlive = processKeepAliveConnections;
    public static boolean doingPDC;
    static final String defDomain;
    static final String sessionCookieName;
    static final int sessionCookieLen;
    protected static String defaultOrg;
    protected boolean pdcHeaderFound;
    protected boolean initiatePDC;
    protected boolean invalidateSSL;
    private static String gwDomain;
    private static final String PDC_COOKIE_HEADER = "DoPDC@";
    private static List serverList;
    private static final String notificationURL;
    private static final String REWRITER_PROXY = "__sra_rewriter_proxy__";
    private static List ignoreURIList;
    private static HashMap virtualHostOrgMapping;
    public static final String PDC_CERT_INFO = "__sra_pdc_cert__";
    static List expandedSessionServersList;
    private static final String pdcHeaderKey = "PS-GW-PDC";
    private static final String netletHeaderKey = "PS-Netlet";
    private static final String proxyletHeaderKey = "PS-Proxylet";
    private static String clientIPHeaderKey;
    private static String gatewayURLInfoHeaderKey;
    private static String gatewayInstanceHeaderKey;
    private static String gatewayRWURLInfoHeaderKey;
    protected static String faviconLocation;

    public Session(Socket s) {
        this._theSocket = s;
        this.getLoggingInfo();
    }

    public Session(Socket s, String ip) {
        this._theSocket = s;
        this.getLoggingInfo();
    }

    private void getLoggingInfo() {
        String unqID;
        Object tmp_1;
        Object tmp = GWLogManager.logIdMap.remove(new Integer(this._theSocket.getPort()));
        if (tmp != null) {
            LogInfoContainer info = (LogInfoContainer)tmp;
            this._logId = info.getLogID();
            this.actualClientSocket = info.getClientSocket();
        }
        if ((tmp_1 = GWLogManager.logIdMap.remove(unqID = this.actualClientSocket.getPort() + "_" + "A")) != null) {
            LogInfoContainer info = (LogInfoContainer)tmp_1;
            this.nonsslsocket = info.getClientSocket();
        }
    }

    public boolean isStillActive() {
        return this._moreElements;
    }

    public void setStillActive(boolean v) {
        this._moreElements = v;
    }

    public void addNetletCustomHeader(Request req) {
        StringBuffer netletHeaderValue = new StringBuffer();
        if (EProxy.isNetletEnabled) {
            if (req.isGatewayProtocolSecure()) {
                netletHeaderValue.append("enabled=true; encryption=ssl");
            } else {
                netletHeaderValue.append("enabled=true; encryption=plain");
            }
        } else {
            netletHeaderValue.append("enabled=false");
        }
        netletHeaderValue = new StringBuffer(netletHeaderKey).append(": ").append(netletHeaderValue);
        req.setRequestHeader(netletHeaderKey, netletHeaderValue.toString());
        req.setRequestHeader("X-PS-Netlet", "X-" + netletHeaderValue.toString());
    }

    private void addGatewayInstanceHeader(Request req) {
        String profileName = System.getProperty("gateway.profilename", "default");
        String gatewayInstanceHeaderValue = gatewayInstanceHeaderKey + ": " + profileName;
        req.setRequestHeader(gatewayInstanceHeaderKey, gatewayInstanceHeaderValue);
        req.setRequestHeader("X-" + gatewayInstanceHeaderKey, "X-" + gatewayInstanceHeaderValue);
    }

    private void addProxyletCustomHeader(Request req) {
        String proxyletHeaderValue = "enabled=false";
        if (EProxy.isProxyletEnabled) {
            proxyletHeaderValue = "enabled=true";
            this.addGatewayInstanceHeader(req);
        }
        proxyletHeaderValue = "PS-Proxylet: " + proxyletHeaderValue;
        String pHeader = req.getRequestHeader(proxyletHeaderKey);
        if (null != pHeader) {
            proxyletHeaderValue = proxyletHeaderValue + "; RT-Proxylet=true";
        }
        req.setRequestHeader(proxyletHeaderKey, proxyletHeaderValue);
        req.setRequestHeader("X-PS-Proxylet", "X-" + proxyletHeaderValue);
    }

    public void addClientIP(Request req) {
        StringBuffer buff = new StringBuffer();
        buff = EProxy.isProxyletEnabled && this.nonsslsocket != null ? new StringBuffer().append(clientIPHeaderKey).append(": ").append(this.nonsslsocket.getInetAddress().getHostAddress()) : new StringBuffer().append(clientIPHeaderKey).append(": ").append(this.actualClientSocket.getInetAddress().getHostAddress());
        String clientIPHeaderValue = buff.toString();
        req.setRequestHeader(clientIPHeaderKey, clientIPHeaderValue);
        req.setRequestHeader("X-" + clientIPHeaderKey, "X-" + clientIPHeaderValue);
    }

    public void addGatewayInfo(Request req) {
        StringBuffer buff = null;
        if (req instanceof HTTPRequest) {
            HTTPRequest httpreq = (HTTPRequest)req;
            buff = new StringBuffer().append(gatewayURLInfoHeaderKey).append(": ").append(httpreq.getUnEncodedGatewayURL());
            req.setRequestHeader(gatewayURLInfoHeaderKey, buff.toString());
            req.setRequestHeader("X-" + gatewayURLInfoHeaderKey, "X-" + buff.toString());
            buff = httpreq.isCookieSupported() ? new StringBuffer().append(gatewayRWURLInfoHeaderKey).append(": ").append(httpreq.getGatewayURL()) : (httpreq.isForwardCookieHost() ? new StringBuffer().append(gatewayRWURLInfoHeaderKey).append(": ").append(httpreq.getGatewayURL()) : new StringBuffer().append(gatewayRWURLInfoHeaderKey).append(": ").append(httpreq.getUnEncodedGatewayURL() + "$SessionID"));
            req.setRequestHeader(gatewayRWURLInfoHeaderKey, buff.toString());
            req.setRequestHeader("X-" + gatewayRWURLInfoHeaderKey, "X-" + buff.toString());
        } else {
            buff = new StringBuffer().append(gatewayURLInfoHeaderKey).append(": ").append(req.getGatewayURL());
            req.setRequestHeader(gatewayURLInfoHeaderKey, buff.toString());
            req.setRequestHeader("X-" + gatewayURLInfoHeaderKey, "X-" + buff.toString());
            buff = new StringBuffer().append(gatewayRWURLInfoHeaderKey).append(": ").append(req.getGatewayURL());
            req.setRequestHeader(gatewayRWURLInfoHeaderKey, buff.toString());
            req.setRequestHeader("X-" + gatewayRWURLInfoHeaderKey, "X-" + buff.toString());
        }
    }

    public void addPDCInfo(Request req) {
        String pdcHeaderKeyValue = pdcHeaderKey;
        pdcHeaderKeyValue = doingPDC && req.isGatewayProtocolSecure() ? pdcHeaderKeyValue + ": true" : pdcHeaderKeyValue + ": false";
        req.setRequestHeader(pdcHeaderKey, pdcHeaderKeyValue);
        req.setRequestHeader("X-PS-GW-PDC", "X-" + pdcHeaderKeyValue);
    }

    public void addCustomHeaders(Request req) {
        this.addNetletCustomHeader(req);
        this.addProxyletCustomHeader(req);
        this.addClientIP(req);
        this.addGatewayInfo(req);
        this.addPDCInfo(req);
    }

    private static int writeContent(OutputStream out, Response resp, Session sess) throws IOException {
        int numbytes;
        String lContentLength = resp.getResponseHeader("Content-length");
        BufferedInputStream buffIn = resp.getContentStream();
        byte[] content = new byte[2048];
        if (buffIn == null) {
            return 0;
        }
        if (lContentLength != null) {
            int length = Integer.parseInt(lContentLength.substring(lContentLength.indexOf(58) + 1).trim());
            int read = 0;
            int totalRead = 0;
            while (totalRead < length) {
                int left = length - totalRead;
                read = buffIn.read(content, 0, left < content.length ? left : content.length);
                if (read == -1) {
                    sess.setStillActive(false);
                    break;
                }
                if (read <= 0) continue;
                totalRead += read;
                out.write(content, 0, read);
                out.flush();
            }
            return totalRead;
        }
        int totalRead = 0;
        while ((numbytes = buffIn.read(content)) != -1) {
            totalRead += numbytes;
            out.write(content, 0, numbytes);
            out.flush();
        }
        return totalRead;
    }

    public abstract Request getRequest();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void processNextRequest() {
        Response rep;
        block102: {
            boolean needtoRewrite = false;
            long initialtime = 0L;
            if (processKeepAliveConnections) {
                initialtime = System.currentTimeMillis();
            }
            Request req = this.getRequest();
            rep = null;
            boolean loop = true;
            boolean repeatCount = false;
            ++_numRequests;
            String rep_code = null;
            int responseLength = 0;
            if (browser_traffic.messageEnabled() && req != null) {
                browser_traffic.message("Request sent from Browser:\n" + req);
            }
            if (req != null) {
                needtoRewrite = this.rewriteRequest(req);
                String gwhost = req.getGatewayHost();
                if (gwhost != null) {
                    String fqdnHost = this.getFQDN(gwhost);
                    GWDebug.debug.message("FQDN -> " + fqdnHost + " , gwhost -> " + gwhost + " , rphost -> " + rphost);
                    if (fqdnHost != null && !gwhost.equalsIgnoreCase(rphost)) {
                        String gatewayProtocol = req.getProtocolFromCustomUrl(this._gwprotocol);
                        String gatewayPort = req.getPortFromCustomUrl(this._gwport);
                        StringBuffer buff = new StringBuffer();
                        buff.append(gatewayProtocol).append("://").append(fqdnHost);
                        if (this._gwprotocol.equalsIgnoreCase("http")) {
                            if (!gatewayPort.equals("80")) {
                                buff.append(':').append(gatewayPort);
                            }
                        } else if (!gatewayPort.equals("443")) {
                            buff.append(':').append(gatewayPort);
                        }
                        buff.append('/');
                        String newGatewayURL = buff.toString();
                        GWDebug.debug.message("newGatewayURL -> " + newGatewayURL);
                        req.setGatewayURL(newGatewayURL);
                    }
                }
            }
            this.processKeepAlive(initialtime, req);
            if (PerfContextObject.ENABLE_PERF) {
                PerfContext context = PerfContextObject.getPerfContext();
                TimerData td = new TimerData("Session.java , after getting request object");
                context.record(td);
            }
            this.initiatePDC = false;
            this.invalidateSSL = false;
            this.pdcHeaderFound = false;
            while (loop) {
                block101: {
                    String myUri;
                    int indexOfPsScript;
                    this.initiatePDC = false;
                    this.invalidateSSL = false;
                    this.pdcHeaderFound = false;
                    String sid = null;
                    if (doingPDC && (sid = req.getSessionID()) != null) {
                        if (EProxy.isNetletEnabled) {
                            try {
                                SSOTokenManager manager = SSOTokenManager.getInstance();
                                SSOToken token = SSOUtil.getSSOToken(sid);
                                manager.validateToken(token);
                                String pdcCertInfo = token.getProperty(PDC_CERT_INFO);
                                if (pdcCertInfo == null) {
                                    X509Certificate clientCert = this.getActualSocket().getStatus().getPeerCertificate();
                                    byte[] certbyte = clientCert.getEncoded();
                                    String xxb64Cert = JSSUtil.getDefaultDecoder().getEncodedStr(certbyte);
                                    String digest = JSSUtil.getDefaultDecoder().digest(xxb64Cert);
                                    token.setProperty(PDC_CERT_INFO, digest);
                                }
                            }
                            catch (Exception ssoEx) {
                                GWDebug.debug.error("Unable to encode the pdc cert info");
                            }
                        }
                        if (sid.startsWith(PDC_COOKIE_HEADER)) {
                            this.removePDCCookie(req);
                            this.pdcHeaderFound = true;
                        }
                    }
                    if (req == null) break block101;
                    if (GWDebug.debug.messageEnabled()) {
                        GWDebug.debug.message("Session: processNextRequest checking for " + req.getURI() + "\nobject: " + req.getObject());
                    }
                    if ((indexOfPsScript = (myUri = req.getObject()).indexOf("psScriptReferrer=")) != -1) {
                        req.modifyURI();
                    }
                    if (GWLogManager.loggingEnabled) {
                        GWLogManager.write("RProxy", GWLocale.getPFString("session1", new Object[]{this._logId, new String(GWLogManager.getUserId(req.getSessionID())), req.getURI()}));
                    }
                    if (ServiceIdentifier.isGateway()) {
                        this.addCustomHeaders(req);
                    }
                    if (req.getGatewayScheme().equals(notificationURL)) {
                        rep = this.processNotificationRequest(req);
                        if (rep == null) {
                            this.setStillActive(false);
                            return;
                        }
                    } else if (req.getGatewayScheme().equals("statistics")) {
                        rep = this.processStatisticsRequest(req);
                    } else if (req.getObject().length() == 0 && req.getProtocol() != null) {
                        GWDebug.debug.message(" ************* missing object");
                        rep = this.processMissingObjectRequest(req);
                    } else {
                        try {
                            if (req.getProtocol() == null) {
                                GWDebug.debug.message(" ************* missing protocol");
                                rep = this.processMissingProtocolRequest(req);
                                GWDebug.debug.message(" ************* GOT RESPONSE");
                            } else if (doingPDC && req.getObject().startsWith(_platformloginURL)) {
                                if (this.pdcHeaderFound || sid == null) {
                                    this.initiatePDC = true;
                                }
                                if (!this.hostFound(req.getURI())) {
                                    rep = this.processProtocolRequest(req);
                                } else if (this.initiatePDC) {
                                    rep = this.processMissingProtocolRequest(req);
                                } else if (doingPDC && this.pdcHeaderFound) {
                                    this.invalidateSSL = true;
                                    rep = new RedirectResponse(this.loginURL(req, _platformloginURL));
                                } else {
                                    rep = this.processProtocolRequest(req);
                                }
                            } else {
                                GWDebug.debug.message(" ************* process protocol");
                                rep = this.processProtocolRequest(req);
                            }
                        }
                        catch (Exception ex) {
                            if (GWDebug.debug.errorEnabled()) {
                                GWDebug.debug.error("Cannot process protocol request", ex);
                            }
                            String message = ex.toString();
                            String language = req.getRequestHeader("Accept-Language");
                            if (exceptionErrorMessage != null && exceptionErrorMessage.length() > 0) {
                                String userLocale = this.getUserLocale(req);
                                message = GWLocale.getPFString(exceptionErrorMessage, new Object[]{message}, userLocale);
                            }
                            rep = new ErrorResponse(message, null, language);
                        }
                        if (GWDebug.debug.messageEnabled()) {
                            GWDebug.debug.message("Session: Request:\n" + req + "Response\n" + rep);
                        }
                    }
                    if (GWLogManager.loggingEnabled) {
                        GWLogManager.write("RProxy", GWLocale.getPFString("session2", new Object[]{this._logId, new String(GWLogManager.getUserId(req.getSessionID())), new Integer(req.getSize())}));
                    }
                    if (server_traffic.messageEnabled()) {
                        server_traffic.message("--> Session: Request:\n" + req + "Response\n" + rep);
                    }
                    rep.setClientCaching();
                    boolean cont = true;
                    boolean hasBeenTranslated = false;
                    OutputStream out = null;
                    InputStream in = null;
                    if (rep instanceof HTTPResponse) {
                        ((HTTPResponse)rep).processSetCookieHeaders(req);
                    }
                    try {
                        int readbytes;
                        block104: {
                            int ready;
                            block103: {
                                String contentLength;
                                boolean needsTranslation = false;
                                if (req.isURIModified()) {
                                    req.restoreURI();
                                }
                                rep_code = rep.getStatusCode();
                                if (ServiceIdentifier.isGateway() && needtoRewrite && rep_code != null && !rep_code.startsWith("1") && !rep_code.startsWith("204") && !rep_code.startsWith("304")) {
                                    if (GWDebug.debug.messageEnabled()) {
                                        GWDebug.debug.message("NEED TO TRANSLATE");
                                    }
                                    needsTranslation = true;
                                }
                                if (!needsTranslation) {
                                    if (GWDebug.debug.warningEnabled()) {
                                        GWDebug.debug.warning(" ************* No Translator available");
                                    }
                                    contentLength = rep.getResponseHeader("Content-length");
                                    in = rep.getContentStream();
                                    if (contentLength == null) {
                                        this.thisreqKeepAlive = false;
                                    }
                                } else {
                                    if (GWDebug.debug.messageEnabled()) {
                                        GWDebug.debug.message(" ************* Got Translator");
                                    }
                                    in = SRAPAdapter.rewrite(req, rep);
                                    if (GWDebug.debug.messageEnabled()) {
                                        GWDebug.debug.message(" ************* Translated !!! in = " + in);
                                    }
                                    if (in != null) {
                                        hasBeenTranslated = true;
                                        rep.setContentLength(in.available());
                                    } else {
                                        in = rep.getContentStream();
                                        contentLength = rep.getResponseHeader("Content-length");
                                        if (contentLength == null) {
                                            this.thisreqKeepAlive = false;
                                        }
                                        if (GWDebug.debug.messageEnabled()) {
                                            GWDebug.debug.message("Not rewritten , so in = " + in);
                                        }
                                    }
                                }
                                if (this.thisreqKeepAlive) {
                                    rep.setConnectionAlive(" timeout=" + timeoutseconds + ",max=" + (this.MAX_PER_SESS - this.this_req));
                                } else {
                                    rep.setConnectionClose();
                                    this.setStillActive(false);
                                }
                                if (ServiceIdentifier.isGateway() && needtoRewrite) {
                                    if (GWDebug.debug.messageEnabled()) {
                                        GWDebug.debug.message("TRANSLATE NOW");
                                    }
                                    this.translateHeader(rep, req);
                                }
                                if (browser_traffic.messageEnabled()) {
                                    browser_traffic.message("Response sent back to Browser:\n" + rep);
                                }
                                out = this._theSocket.getOutputStream();
                                byte[] headerBytes = rep.getHeaderBytes();
                                _numBytesSent += headerBytes.length;
                                responseLength += headerBytes.length;
                                out.write(headerBytes);
                                out.flush();
                                if (rep_code == null || rep_code.startsWith("1") || rep_code.startsWith("204") || rep_code.startsWith("304")) break block101;
                                readbytes = 0;
                                if (hasBeenTranslated) break block103;
                                HTTPRequest hreq = (HTTPRequest)req;
                                String method = hreq.getMethod();
                                if (method == null || method.equals("HEAD")) break block104;
                                readbytes = Session.writeContent(out, rep, this);
                                if (!GWDebug.debug.messageEnabled()) break block104;
                                GWDebug.debug.message("Not rewritten for " + req.getURL() + " Bytes of content written as response : " + readbytes);
                                break block104;
                            }
                            byte[] b = new byte[2048];
                            while ((ready = in.read(b)) >= 0) {
                                if (ready <= 0) continue;
                                readbytes += ready;
                                out.write(b, 0, ready);
                                out.flush();
                            }
                        }
                        _numBytesSent += readbytes;
                        if (GWDebug.debug.messageEnabled()) {
                            GWDebug.debug.message(readbytes + " bytes of content written as response");
                        }
                        responseLength += readbytes;
                    }
                    catch (IOException ex) {
                        try {
                            out.flush();
                            if (in instanceof CSBufferedInputStream) {
                                ((CSBufferedInputStream)in).getSocket().close();
                            }
                        }
                        catch (Exception ex1) {
                            // empty catch block
                        }
                        if (GWDebug.debug.warningEnabled()) {
                            GWDebug.debug.warning("Session failed to respond to client", ex);
                        }
                        this.setStillActive(false);
                    }
                    catch (NullPointerException ex) {
                        this.setStillActive(false);
                        if (GWDebug.debug.warningEnabled()) {
                            GWDebug.debug.warning("Session failed to respond to client", ex);
                        }
                    }
                    finally {
                        try {
                            out.flush();
                        }
                        catch (Exception ex1) {}
                    }
                }
                loop = false;
            }
            if (isPerSessionLoggingEnabled) {
                String type = this._theSocket instanceof SRAPSocket ? (((SRAPSocket)this._theSocket).isSSLSocket() ? "https" : "http") : (this._theSocket instanceof SSLSocket ? "https" : "http");
                String fromAddress = this.actualClientSocket.getInetAddress().toString();
                String destHost = req.getHost();
                if (detailedRproxLog && req instanceof HTTPRequest) {
                    SSOToken token;
                    HTTPRequest httpreq = (HTTPRequest)req;
                    String method = httpreq.getMethod();
                    String requestedUrl = httpreq.getURL();
                    String sessidstr = null;
                    String tmpsidstr = httpreq.getSessionID();
                    if (tmpsidstr != null && (token = this.getUserSession(req, tmpsidstr)) != null) {
                        sessidstr = token.getTokenID().toString();
                    }
                    Integer requestContentLength = null;
                    if (method.trim().toLowerCase().equals("post")) {
                        String len = httpreq.getRequestHeader("Content-length");
                        len = len.substring(len.indexOf(58) + 1);
                        try {
                            requestContentLength = new Integer(Integer.parseInt(len));
                        }
                        catch (Exception ex) {}
                    } else {
                        requestContentLength = new Integer(0);
                    }
                    GWLogManager.write("RProxy", GWLocale.getPFString("RproxyPerRequestDetailedLogFormat", new Object[]{this._logId, new String(GWLogManager.getUserId(httpreq.getSessionID())), fromAddress, type, destHost, method, requestedUrl, requestContentLength, rep_code, new Integer(responseLength)}));
                } else {
                    GWLogManager.write("RProxy", GWLocale.getPFString("RproxyPerRequestLogFormat", new Object[]{this._logId, new String(GWLogManager.getUserId(req.getSessionID())), fromAddress, type, destHost}));
                }
            }
            if (doingPDC && this.invalidateSSL) {
                if (GWDebug.debug.messageEnabled()) {
                    GWDebug.debug.message("SESSION:  INVALIDATE SSL");
                }
                try {
                    this.getActualSocket().invalidateSession();
                }
                catch (SocketException se) {
                    if (!GWDebug.debug.errorEnabled()) break block102;
                    GWDebug.debug.error("Unable to invalidate SSL Session");
                }
            }
        }
        if (rep != null) {
            rep.closeSocket();
        }
        if (!this.thisreqKeepAlive) {
            this.setStillActive(false);
        }
    }

    private void processKeepAlive(long initialtime, Request req) {
        this.thisreqKeepAlive = processKeepAliveConnections;
        if (processKeepAliveConnections) {
            if (req != null) {
                ++this.this_req;
                this.nullTimeout = maxTimeOutSetting;
                if (req instanceof HTTPRequest) {
                    String keepAliveHeader;
                    HTTPRequest httpreq = (HTTPRequest)req;
                    this.thisreqKeepAlive = this.this_req >= this.MAX_PER_SESS ? false : ((keepAliveHeader = httpreq.getRequestHeader("Connection")) != null ? !(keepAliveHeader = keepAliveHeader.substring(keepAliveHeader.indexOf(58) + 1).trim().toLowerCase()).equals("close") : httpreq.getHTTPVersion().toUpperCase().compareTo("HTTP/1.1") >= 0);
                    httpreq.setRequestHeader("Connection", "Connection: close\r\n");
                    this._moreElements = true;
                    if (!this.thisreqKeepAlive) {
                        if (this.this_req < this.MAX_PER_SESS && this.this_req > 1) {
                            this.thisreqKeepAlive = true;
                            this._moreElements = true;
                        } else {
                            this._moreElements = false;
                        }
                    }
                } else if (this.this_req < this.MAX_PER_SESS && this.this_req > 1) {
                    this.thisreqKeepAlive = true;
                    this._moreElements = true;
                } else {
                    this.thisreqKeepAlive = false;
                    this._moreElements = false;
                }
            } else {
                long timediff = System.currentTimeMillis() - initialtime;
                if (timediff < this.nullTimeout && timediff >= (long)(this.readTimeout / 2)) {
                    this._moreElements = true;
                    this.nullTimeout -= timediff;
                    boolean diffed = false;
                    try {
                        Thread.currentThread();
                        Thread.sleep(50L);
                    }
                    catch (Exception e) {
                        diffed = true;
                        this.nullTimeout -= System.currentTimeMillis() - timediff;
                    }
                    if (!diffed) {
                        this.nullTimeout -= 50L;
                    }
                } else {
                    this.thisreqKeepAlive = false;
                    this._moreElements = false;
                }
            }
        } else if (req != null) {
            HTTPRequest httpreq = (HTTPRequest)req;
            httpreq.setRequestHeader("Connection", "Connection: close\r\n");
        }
        if (this.this_req > 1 && GWDebug.debug.messageEnabled()) {
            GWDebug.debug.message("Reusing the socket for : " + this.this_req);
        }
    }

    private void translateHeader(Response rep, Request req) {
        boolean isExternal = req.getGatewayScheme().equals("external");
        if (rep instanceof RedirectResponse && !((RedirectResponse)rep).needTranslation()) {
            return;
        }
        String location = rep.getResponseHeader("Location:");
        if (location != null) {
            String result = SRAPTranslatorHelper.translateHeaderURL(location, rep, req, location.toLowerCase().startsWith("location:"), isExternal);
            if (GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message("Translated from [" + location + "] to [" + result + "]");
            }
            rep.setLocation(result);
        }
        if (!(rep instanceof HTTPResponse)) {
            return;
        }
        String clocation = rep.getResponseHeader("Content-Location:");
        if (clocation != null) {
            String cresult = SRAPTranslatorHelper.translateHeaderURL(clocation, rep, req, clocation.toLowerCase().startsWith("content-location:"), isExternal);
            if (GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message("Translated from [" + clocation + "] to [" + cresult + "]");
            }
            ((HTTPResponse)rep).setContentLocation(cresult);
        }
        if (rep instanceof HTTPResponse) {
            this.translateWebDAVHeaders(req, (HTTPResponse)rep, isExternal);
        }
    }

    protected void translateWebDAVHeaders(Request req, HTTPResponse resp, boolean isExternal) {
        this.translateSpecificHeader("Destination", req, resp, isExternal);
        this.translateSpecificHeader("Status-URI", req, resp, isExternal);
    }

    protected void translateSpecificHeader(String headerName, Request req, HTTPResponse resp, boolean isExternal) {
        List toTranslateList = resp.getHeaderAttributeList(headerName);
        Iterator iter = toTranslateList.iterator();
        LinkedList<String> translatedList = new LinkedList<String>();
        resp.removeHeader(headerName);
        while (iter.hasNext()) {
            String header = iter.next().toString();
            String result = SRAPTranslatorHelper.translateHeaderURL(header, resp, req, true, isExternal);
            if (GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message(headerName + " Translated from [" + header + "] to [" + result + "]");
            }
            translatedList.add(result);
        }
        if (translatedList.size() != 0) {
            resp.setHeader(headerName, translatedList);
        }
    }

    private boolean rewriteRequest(Request req) {
        boolean isRoutedThroughProxylet = this.routedThroughProxylet(req);
        boolean isRequestForProxylet = this.currentRequestForProxylet(req);
        return !isRoutedThroughProxylet && !isRequestForProxylet;
    }

    private boolean routedThroughProxylet(Request req) {
        if (GWDebug.debug.messageEnabled()) {
            GWDebug.debug.message("BEGIN comingThroughProxylet");
        }
        String pheader = req.getRequestHeader(proxyletHeaderKey);
        if (GWDebug.debug.messageEnabled()) {
            GWDebug.debug.message("PS-Proxylet is " + pheader);
        }
        if (pheader == null) {
            return false;
        }
        if (pheader.indexOf("RT-Proxylet=true") != -1) {
            return true;
        }
        if (GWDebug.debug.messageEnabled()) {
            GWDebug.debug.message("END comingThroughProxylet");
        }
        return false;
    }

    private boolean currentRequestForProxylet(Request req) {
        if (GWDebug.debug.messageEnabled()) {
            GWDebug.debug.message("BEGIN isRequestForProxylet" + req.getObject());
        }
        if (req.getObject().indexOf("/proxylet") != -1) {
            return true;
        }
        if (GWDebug.debug.messageEnabled()) {
            GWDebug.debug.message("END isRequestForProxylet");
        }
        return false;
    }

    private Response processMissingObjectRequest(Request req) {
        if (GWDebug.debug.messageEnabled()) {
            GWDebug.debug.message("Session: Redirecting-> " + req.getURL());
        }
        String gwscheme = req.getGatewayScheme();
        StringBuffer redirectURL = new StringBuffer(100);
        redirectURL.append(this._gwprotocol).append("://");
        if (this._gwport.equals("443") && this._gwprotocol.equals("https") || this._gwport.equals("80") && this._gwprotocol.equals("http")) {
            redirectURL.append(req.getGatewayHost()).append("/");
        } else {
            redirectURL.append(req.getGatewayHost()).append(":").append(this._gwport).append("/");
        }
        if (gwscheme.length() > 0) {
            redirectURL.append(gwscheme).append("/");
        }
        redirectURL.append(req.getURL()).append("/");
        return new RedirectResponse(redirectURL.toString(), false);
    }

    private Response processNotificationRequest(Request req) {
        Object rep;
        block3: {
            rep = null;
            try {
                DataOutputStream dos = new DataOutputStream(this._theSocket.getOutputStream());
                GatewayServletResponse gsrep = new GatewayServletResponse(dos);
                PLLNotificationServlet notify = new PLLNotificationServlet();
                notify.doPost((HttpServletRequest)req, (HttpServletResponse)gsrep);
                rep = null;
            }
            catch (Exception ex) {
                if (GWDebug.debug.errorEnabled()) {
                    GWDebug.debug.error("Exception in processing notification request: " + ex);
                }
                String language = req.getRequestHeader("Accept-Language");
                String msg = "Session: Unable to process notification";
                if (notificationErrorMessage == null || notificationErrorMessage.length() <= 0) break block3;
                String userLocale = this.getUserLocale(req);
                msg = GWLocale.getPFString(notificationErrorMessage, new Object[]{msg}, userLocale);
            }
        }
        return rep;
    }

    private Response processStatisticsRequest(Request req) {
        StringBuffer message = new StringBuffer(50);
        if (!this.isUserSessionValid(req)) {
            return new RedirectResponse(this.loginURL(req, _platformloginURL));
        }
        message.append("<html>");
        String uri = req.getURI();
        String params = uri.startsWith("/statistics/") && uri.length() > 12 ? uri.substring(12) : "req&read&sent";
        if (params.equals("reset")) {
            _numRequests = 0;
            _numBytesRead = 0;
            HTTPRetriever.numBytesRead = 0;
            _numBytesSent = 0;
            message.append("<p>Reset is ok.</p></html>");
            return new StatisticsResponse(message.toString());
        }
        StringTokenizer st = new StringTokenizer(params, "&");
        while (st.hasMoreTokens()) {
            String param = st.nextToken();
            if (param.equals("req")) {
                message.append("<p>Number of Requests: ").append(_numRequests).append("</p>");
                continue;
            }
            if (param.equals("read")) {
                message.append("<p>Number of Bytes Read: ").append(_numBytesRead + HTTPRetriever.numBytesRead).append("</p>");
                continue;
            }
            if (!param.equals("sent")) continue;
            message.append("<p>Number of Bytes Sent: ").append(_numBytesSent).append("</p>");
        }
        message.append("</html>");
        return new StatisticsResponse(message.toString());
    }

    private Response processMissingProtocolRequest(Request req) {
        if (req.getGatewayScheme() != null && req.getGatewayScheme().equalsIgnoreCase("favicon.ico") && (req.getURL() == null || req.getURL().trim().length() == 0)) {
            HeaderResponse rep;
            if (GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message("favicon.ico match !");
            }
            if (faviconLocation != null) {
                if (GWDebug.debug.messageEnabled()) {
                    GWDebug.debug.message("Redirecting to : " + faviconLocation);
                }
                rep = new RedirectResponse(faviconLocation, true);
            } else {
                if (GWDebug.debug.messageEnabled()) {
                    GWDebug.debug.message("Returning Not Found message");
                }
                rep = new FileNotFoundResponse();
            }
            return rep;
        }
        if (this.isIgnoreURI(req.getURI())) {
            GWDebug.debug.error("Returning Not Found Message");
            FileNotFoundResponse rep = new FileNotFoundResponse();
            return rep;
        }
        String gwhost = req.getGatewayHost();
        String fqdnhost = this.getFQDN(gwhost);
        if (fqdnhost == null) {
            String message = gwhost;
            String language = req.getRequestHeader("Accept-Language");
            if (invalidGatewayHostNameErrorMessage != null && invalidGatewayHostNameErrorMessage.length() > 0) {
                String userLocale = this.getUserLocale(req);
                message = GWLocale.getPFString(invalidGatewayHostNameErrorMessage, new Object[]{message}, userLocale);
            } else {
                message = message + " is not a valid gateway host name.";
            }
            return new ErrorResponse(message, null, language);
        }
        if (!gwhost.equalsIgnoreCase(fqdnhost)) {
            if (this._gwport.equals("443") && this._gwprotocol.equals("https") || this._gwport.equals("80") && this._gwprotocol.equals("http")) {
                return new RedirectResponse(this._gwprotocol + "://" + fqdnhost + req.getURI(), false);
            }
            return new RedirectResponse(this._gwprotocol + "://" + fqdnhost + ":" + this._gwport + req.getURI(), false);
        }
        if (!doingPDC) {
            if (GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message("Session: not doing PDC");
            }
            return new RedirectResponse(this.loginURL(req, _platformloginURL));
        }
        boolean doingCert = false;
        String tmpurl = req.getURL();
        if (tmpurl != null && tmpurl.trim().toLowerCase().indexOf("service=gatewaypdc") != -1) {
            doingCert = true;
        }
        if (this.pdcHeaderFound && !doingCert) {
            this.invalidateSSL = true;
            return new RedirectResponse(this.loginURL(req, _platformloginURL));
        }
        if (GWDebug.debug.messageEnabled()) {
            GWDebug.debug.message("Session: doing PDC");
        }
        if (this._gwport.equals("443") && this._gwprotocol.equals("https") || this._gwport.equals("80") && this._gwprotocol.equals("http")) {
            return this.doPDC(gwhost, req);
        }
        return this.doPDC(gwhost + ":" + this._gwport, req);
    }

    private Response processProtocolRequest(Request req) {
        SSOToken token = null;
        boolean setCookieFlagExist = false;
        if (ServiceIdentifier.isGateway()) {
            if (this.isNonAuthenticatedURL(req)) {
                if (req.getURL().endsWith(_platformloginURL) && doingPDC && this.pdcHeaderFound) {
                    this.invalidateSSL = true;
                }
                if (doingPDC) {
                    setCookieFlagExist = true;
                }
            } else {
                String sidstr = req.getSessionID();
                if (sidstr == null) {
                    if (GWLogManager.loggingEnabled) {
                        GWLogManager.write("RProxy", GWLocale.getPFString("session4", new Object[]{this._logId}));
                    }
                    return new RedirectResponse(this.loginURL(req, _platformloginURL));
                }
                try {
                    SSOTokenManager manager = SSOTokenManager.getInstance();
                    token = SSOUtil.getSSOToken(sidstr);
                    manager.validateToken(token);
                }
                catch (SSOException ssoEx) {
                    if (GWDebug.debug.warningEnabled()) {
                        GWDebug.debug.warning("Error creating SSOToken ", ssoEx);
                    }
                    if (doingPDC) {
                        return this.doPDC(req.getGatewayHost(), req);
                    }
                    return new RedirectResponse(this.loginURL(req, _platformloginURL));
                }
                catch (Exception e) {
                    if (GWDebug.debug.warningEnabled()) {
                        GWDebug.debug.warning("Error creating SSOToken ", e);
                    }
                    if (doingPDC) {
                        return this.doPDC(req.getGatewayHost(), req);
                    }
                    return new RedirectResponse(this.loginURL(req, _platformloginURL));
                }
                SSOToken sess = token;
                if (doingPDC) {
                    setCookieFlagExist = true;
                }
                try {
                    if (GWLogManager.loggingEnabled) {
                        GWLogManager.write("RProxy", GWLocale.getPFString("session3", new Object[]{this._logId, new String(GWLogManager.getUserId(req.getSessionID())), token.getIPAddress().toString()}));
                    }
                }
                catch (SSOException ex) {
                    // empty catch block
                }
                if (!this.isAccessControlAllowed(req, sidstr)) {
                    Response rep = this.handleRedirectRequest(req, req.getHost());
                    if (rep != null) {
                        return rep;
                    }
                    String message = "Access Denied";
                    String language = req.getRequestHeader("Accept-Language");
                    if (accessDeniedErrorMessage != null && accessDeniedErrorMessage.length() > 0) {
                        String userLocale = this.getUserLocale(sidstr);
                        message = GWLocale.getPFString(accessDeniedErrorMessage, new Object[]{message}, userLocale);
                    }
                    return new ErrorResponse(message, token, language);
                }
            }
        }
        String oldHost = req.getHost();
        String oldPort = req.getPort();
        String oldProtocol = req.getProtocol();
        String oldObject = req.getObject();
        Retriever retr = null;
        if (_useHTTPProxy) {
            URL url;
            block47: {
                String hphost = this.getProxyHost(req);
                if (GWDebug.debug.messageEnabled()) {
                    GWDebug.debug.message("GW using Rewriter Proxy :" + hphost);
                }
                url = null;
                try {
                    url = new URL(hphost);
                }
                catch (MalformedURLException mae) {
                    if (!GWDebug.debug.errorEnabled()) break block47;
                    GWDebug.debug.error("Malformed Rewriter Proxy URL :" + hphost);
                }
            }
            req.setHost(url.getHost());
            if (url.getPort() != -1) {
                req.setPort(Integer.toString(url.getPort()));
            } else {
                req.setPort("10443");
            }
            req.setProtocol(url.getProtocol());
            req.setObject("/" + req.getURL());
            retr = RetrievalFactory.getRetriever(_hpprot);
            if (req instanceof HTTPRequest) {
                ((HTTPRequest)req).populateWebProxyInfo();
            }
        } else {
            retr = RetrievalFactory.getRetriever(req.getProtocol());
            if (GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message("Session: HTTP not in HTTPS mode");
            }
        }
        Response rep = this.retrieveResponse(req, oldHost, retr, token);
        if (_useHTTPProxy) {
            req.setHost(oldHost);
            req.setPort(oldPort);
            req.setProtocol(oldProtocol);
            req.setObject(oldObject);
        }
        String rep_code = rep.getStatusCode();
        if (doingPDC && req.getObject().startsWith(_platformlogoutURL)) {
            this.addPDCCookie(req, rep);
            setCookieFlagExist = false;
        } else if (doingPDC && setCookieFlagExist && rep instanceof HTTPResponse) {
            int indx;
            String s;
            String iplanetCookie = null;
            List cookieList = ((HTTPResponse)rep).getHeaderAttributeList("Set-Cookie");
            if (cookieList != null && cookieList.size() > 0) {
                Iterator it = cookieList.iterator();
                while (it.hasNext()) {
                    SSOToken ssoToken;
                    block48: {
                        String sidstr;
                        String temp;
                        iplanetCookie = (String)it.next();
                        int bindx = iplanetCookie.indexOf(sessionCookieName);
                        int eindx = iplanetCookie.indexOf(61, bindx);
                        if (bindx > 1 && !(temp = iplanetCookie.substring(bindx + sessionCookieLen, eindx)).trim().equals("")) {
                            bindx = -1;
                        }
                        if (iplanetCookie == null || bindx == -1 || (sidstr = req.getSessionID()) == null) continue;
                        ssoToken = null;
                        try {
                            ssoToken = SSOUtil.getSSOToken(sidstr);
                        }
                        catch (SSOException se) {
                            if (GWDebug.debug.errorEnabled()) {
                                GWDebug.debug.error("**** ssoToken = null ****", se);
                            }
                        }
                        catch (Exception e) {
                            if (!GWDebug.debug.errorEnabled()) break block48;
                            GWDebug.debug.error("**** ssoToken = null ****", e);
                        }
                    }
                    if (ssoToken != null) continue;
                    return rep;
                }
            } else if (rep_code.startsWith("302") && (s = rep.getResponseHeader("Location")) != null && (indx = s.indexOf(":")) != -1) {
                if ((s = s.substring(indx + 1, s.length()).trim()).toUpperCase().startsWith(_platformloginURL.toUpperCase())) {
                    if (this.hostFound(req.getURI())) {
                        this.addPDCCookie(req, rep);
                    }
                } else {
                    String rest;
                    int end;
                    int start = s.indexOf("://");
                    if (start != -1 && (end = s.indexOf(47, start + 3)) != -1 && (rest = s.substring(0, end)).toUpperCase().startsWith(_platformloginURL.toUpperCase()) && this.hostFound(req.getURI())) {
                        this.addPDCCookie(req, rep);
                    }
                }
            }
        }
        return rep;
    }

    private boolean isNonAuthenticatedURLImpl(String requestURL) {
        int numElements = nonAuthPathList.size();
        for (int i = 0; i < numElements; ++i) {
            String elem = (String)nonAuthPathList.get(i);
            if (!requestURL.startsWith(elem)) continue;
            return true;
        }
        return false;
    }

    private boolean isNonAuthenticatedURL(Request req) {
        if (req.getProtocol() == null || req.getHost() == null) {
            return false;
        }
        String host = req.getProtocol().toLowerCase() + "://" + req.getHost().toLowerCase() + ":" + req.getPort();
        String requestURL = null;
        if (host == null) {
            return false;
        }
        String path = req.getObject();
        if (path == null || path.trim().length() == 0) {
            path = "/";
        }
        if (serverList.contains(host) && this.isNonAuthenticatedURLImpl(requestURL = path)) {
            return true;
        }
        requestURL = host + path;
        return this.isNonAuthenticatedURLImpl(requestURL);
    }

    private SSOToken getUserSession(Request req, String sid) {
        SSOToken s = null;
        try {
            SSOTokenManager ssoTokenManager = SSOTokenManager.getInstance();
            s = SSOUtil.getSSOToken(sid);
            if (!ssoTokenManager.isValidToken(s)) {
                if (GWDebug.debug.messageEnabled()) {
                    GWDebug.debug.message("Session: state is not VALID");
                }
                if (GWLogManager.loggingEnabled) {
                    GWLogManager.write("RProxy", GWLocale.getPFString("session5", new Object[]{this._logId, sid}));
                }
                return null;
            }
        }
        catch (Exception e) {
            if (GWDebug.debug.errorEnabled()) {
                GWDebug.debug.error("Failed to get session", e);
            }
            return null;
        }
        return s;
    }

    private boolean wildcardMatch(String str1, String str2) {
        int beginIndex1 = 0;
        int endIndex1 = 0;
        int beginIndex2 = 0;
        int endIndex2 = 0;
        int strlen1 = str1.length();
        int strlen2 = str2.length();
        String substr = null;
        if (str1 == null || str2 == null) {
            return false;
        }
        endIndex2 = str2.indexOf(42, beginIndex2);
        if (endIndex2 != -1) {
            substr = str2.substring(beginIndex2, endIndex2);
            if (endIndex2 > beginIndex2) {
                if ((beginIndex1 = str1.indexOf(substr, beginIndex1)) == -1) {
                    return false;
                }
                if (beginIndex1 != beginIndex2) {
                    return false;
                }
            }
            beginIndex1 += endIndex2 - beginIndex2;
            if (endIndex2 >= strlen2 - 1) {
                return true;
            }
            beginIndex2 = endIndex2 + 1;
        } else {
            beginIndex1 = str1.indexOf(str2);
            if (beginIndex1 == -1) {
                return false;
            }
            return beginIndex1 == beginIndex2;
        }
        while ((endIndex2 = str2.indexOf(42, beginIndex2)) != -1) {
            substr = str2.substring(beginIndex2, endIndex2);
            if (endIndex2 > beginIndex2 && (beginIndex1 = str1.indexOf(substr, beginIndex1)) == -1) {
                return false;
            }
            beginIndex1 += endIndex2 - beginIndex2;
            if (endIndex2 >= strlen2 - 1) {
                return true;
            }
            beginIndex2 = endIndex2 + 1;
        }
        substr = str2.substring(beginIndex2, strlen2);
        endIndex1 = str1.lastIndexOf(substr, strlen1 - 1);
        if (endIndex1 == -1) {
            return false;
        }
        return beginIndex1 <= endIndex1;
    }

    private boolean isAccessControlAllowed(Request req, String sessid) {
        boolean allowed = false;
        try {
            UserProfile prof = new UserProfile(sessid);
            boolean matchFound = false;
            if (prof.getString("sunPortalGatewayAllowedAuthLevelResult", "true").equalsIgnoreCase("false")) {
                return false;
            }
            List list = prof.getStringList("sunportalgatewayaccessdenylist");
            Iterator iter = list.iterator();
            String requrl = req.getURL();
            while (iter.hasNext()) {
                String denyString = iter.next().toString();
                if (denyString.equals("*")) {
                    allowed = false;
                    matchFound = true;
                    break;
                }
                if (!this.wildcardMatch(requrl, denyString)) continue;
                allowed = false;
                matchFound = true;
                break;
            }
            if (!matchFound) {
                list = prof.getStringList("sunportalgatewayaccessallowlist");
                iter = list.iterator();
                while (iter.hasNext()) {
                    String allowString = iter.next().toString();
                    if (allowString.equals("*")) {
                        allowed = true;
                        matchFound = true;
                        break;
                    }
                    if (!this.wildcardMatch(requrl, allowString)) continue;
                    allowed = true;
                    matchFound = true;
                    break;
                }
            }
            if (!matchFound) {
                allowed = false;
            }
            if (!allowed) {
                if (GWDebug.debug.warningEnabled()) {
                    GWDebug.debug.warning("Session: request is not allowed");
                }
                if (GWLogManager.loggingEnabled) {
                    GWLogManager.write("RProxy", GWLocale.getPFString("session8", new Object[]{this._logId, req.getURL(), new String(GWLogManager.getUserId(req.getSessionID()))}));
                }
            }
        }
        catch (Exception e) {
            if (GWDebug.debug.errorEnabled()) {
                GWDebug.debug.error("Session: failed to get URLPrivList", e);
            }
            allowed = false;
        }
        return allowed;
    }

    Response handleRedirectRequest(Request req, String destinationHost) {
        if (req.getGatewayScheme().equals("redirect")) {
            String cliUrl = req.getURL();
            if (!DomainWebProxyConfig.containHost(destinationHost)) {
                return new RedirectResponse(cliUrl, false);
            }
        }
        return null;
    }

    Response retrieveResponse(Request req, String destinationHost, Retriever retr, SSOToken token) {
        String statusText;
        Response rep;
        String acceptEncoding = req.getRequestHeader("Accept-Encoding");
        if (acceptEncoding != null) {
            req.setRequestHeader("Accept-Encoding", "");
        }
        if ((rep = this.handleRedirectRequest(req, destinationHost)) != null) {
            return rep;
        }
        rep = retr.getResponse(req, destinationHost, this._logId);
        if (rep == null) {
            if (GWDebug.debug.warningEnabled()) {
                GWDebug.debug.warning("Session: Unable to connect to host:  " + req.getHost());
            }
            if (req.getGatewayScheme().equals("redirect")) {
                if (req.getUseProxy()) {
                    String message = req.getProxyHost() + ":" + req.getProxyPort();
                    if (webProxErrorMessage != null && webProxErrorMessage.length() > 0) {
                        String userLocale = this.getUserLocale(token);
                        message = GWLocale.getPFString(webProxErrorMessage, new Object[]{message}, userLocale);
                    } else {
                        message = "Session: Unable to connect to web prox host: " + message + ".";
                    }
                    String language = req.getRequestHeader("Accept-Language");
                    rep = new ErrorResponse(message, token, language);
                } else {
                    rep = new RedirectResponse(req.getURL(), false);
                }
            } else if (ServiceIdentifier.isGateway()) {
                String message = req.getHost();
                if (hostConnectErrorMessage != null && hostConnectErrorMessage.length() > 0) {
                    String userLocale = this.getUserLocale(token);
                    message = GWLocale.getPFString(hostConnectErrorMessage, new Object[]{message}, userLocale);
                } else {
                    message = "Session: Unable to connect to host:  " + message + ".";
                }
                String language = req.getRequestHeader("Accept-Language");
                rep = new ErrorResponse(message, token, language);
            } else {
                String message = "Session: Unable to connect to host:  " + req.getHost() + ".";
                if (hostConnectErrorMessage != null && hostConnectErrorMessage.length() > 0) {
                    String userLocale = this.getUserLocale(token);
                    message = GWLocale.getPFString(hostConnectErrorMessage, new Object[]{message}, userLocale);
                }
                String language = req.getRequestHeader("Accept-Language");
                rep = new ErrorResponse(message, UNKNOWN_HOST, token, language);
            }
        } else if (ServiceIdentifier.isGateway() && (statusText = rep.getStatusText()) != null && statusText.equals(UNKNOWN_HOST)) {
            if (req.getGatewayScheme().equals("redirect")) {
                BufferedInputStream in = null;
                in = rep.getContentStream();
                try {
                    if (in instanceof CSBufferedInputStream) {
                        ((CSBufferedInputStream)in).getSocket().close();
                    }
                }
                catch (Exception ex1) {
                    // empty catch block
                }
                rep = new RedirectResponse(req.getURL(), false);
            } else {
                rep.setStatusText("Bad Gateway");
            }
        }
        return rep;
    }

    private String getProxyHost(Request req) {
        String sid = req.getSessionID();
        String server = null;
        SSOToken validToken = null;
        try {
            SSOTokenManager ssoTokenManager = SSOTokenManager.getInstance();
            validToken = SSOUtil.getSSOToken(sid);
            if (ssoTokenManager.isValidToken(validToken)) {
                server = validToken.getProperty(REWRITER_PROXY);
                if (server != null) {
                    if (RewriterProxyRouter.isRewriterProxyAlive(server)) {
                        return server;
                    }
                    server = RewriterProxyRouter.getRewriterProxyAlive();
                    if (server == null) {
                        return RewriterProxyRouter.getServer();
                    }
                    validToken.setProperty(REWRITER_PROXY, server);
                    return server;
                }
                server = RewriterProxyRouter.getRewriterProxyAlive();
                if (server == null) {
                    return RewriterProxyRouter.getServer();
                }
                validToken.setProperty(REWRITER_PROXY, server);
                return server;
            }
            server = RewriterProxyRouter.getRewriterProxyAlive();
            if (server == null) {
                return RewriterProxyRouter.getServer();
            }
            return server;
        }
        catch (Exception soe) {
            server = RewriterProxyRouter.getRewriterProxyAlive();
            if (server == null) {
                return RewriterProxyRouter.getServer();
            }
            return server;
        }
    }

    private String loginURL(Request req, String loginURLObject) {
        String sid = req.getSessionID();
        String server = ServersList.getInstance().getServeraLive();
        String _gw = req.getGatewayHost();
        String _uri = req.getURI();
        String org = this.getDefaultOrg(req.getGatewayHost());
        String gotoParam = null;
        boolean addGotoParam = false;
        if (req.getProtocol() != null) {
            addGotoParam = true;
            gotoParam = req.getURL();
            if (gotoParam == null) {
                addGotoParam = false;
            }
        } else if (_uri.length() > 1) {
            int indx = _uri.toLowerCase().indexOf("org=");
            if (indx != -1) {
                int indx1 = _uri.indexOf(38, indx += 4);
                if (indx1 == -1) {
                    indx1 = _uri.length();
                }
                if ((org = _uri.substring(indx, indx1)).equalsIgnoreCase("statistics")) {
                    org = defaultOrg;
                }
            } else if (req.getProtocol() == null && !_uri.endsWith(_platformloginURL) && (org = (indx = _uri.toLowerCase().indexOf("&")) != -1 ? _uri.substring(1, indx) : _uri.substring(1)).equalsIgnoreCase("statistics")) {
                org = defaultOrg;
            }
        }
        String _param = null;
        if (addGotoParam && gotoParam != null && gotoParam.indexOf("goto=") != -1) {
            String dummyGotoParam = gotoParam.trim().toLowerCase();
            Iterator iter = expandedSessionServersList.iterator();
            while (iter.hasNext()) {
                String tmpServer = (String)iter.next();
                if (tmpServer == null) continue;
                if (!dummyGotoParam.startsWith(tmpServer) || dummyGotoParam.indexOf(loginURLObject.toLowerCase()) == -1) break;
                addGotoParam = false;
                break;
            }
        }
        try {
            int indx;
            if (org.indexOf(61) != -1) {
                org = URLEncoder.encode(org);
            }
            if ((indx = _uri.toLowerCase().indexOf("&")) != -1) {
                org = org + _uri.substring(indx);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (addGotoParam) {
            try {
                gotoParam = URLEncoder.encode(gotoParam);
            }
            catch (Exception ex) {
                // empty catch block
            }
            _param = "gw=" + _gw + "&org=" + org + "&goto=" + gotoParam;
        } else {
            _param = "gw=" + _gw + "&org=" + org;
        }
        if (doingPDC) {
            _param = _param + "&service=gatewaypdc";
        }
        return server + loginURLObject + "?" + _param;
    }

    public void close() {
        try {
            this._theSocket.getOutputStream().flush();
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (this._theSocket != null) {
            try {
                this._theSocket.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            this._theSocket = null;
        }
        if (processKeepAliveConnections && this.actualClientSocket != null) {
            try {
                Thread.currentThread();
                Thread.sleep(100L);
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                this.actualClientSocket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.actualClientSocket = null;
        }
    }

    private static void setVirtualHostname() {
        virtualHost.add(rphost);
        String s = SystemProperties.get("gateway.virtualhost", null);
        if (s == null) {
            return;
        }
        StringTokenizer tokens = new StringTokenizer(s);
        while (tokens.hasMoreTokens()) {
            s = tokens.nextToken().trim();
            virtualHost.add(s.toLowerCase());
            virtualHostActual.add(s);
        }
    }

    private static void setIgnoreURIList() {
        String uriList = SystemProperties.get("gateway.ignoreURIList");
        if (uriList != null) {
            StringTokenizer strTok = new StringTokenizer(uriList, ",");
            while (strTok.hasMoreTokens()) {
                ignoreURIList.add(strTok.nextToken().trim());
            }
        }
    }

    private boolean isIgnoreURI(String s) {
        for (int i = 0; i < ignoreURIList.size(); ++i) {
            if (!s.startsWith((String)ignoreURIList.get(i))) continue;
            return true;
        }
        return false;
    }

    protected String getDefaultOrg(String gwhost) {
        if (gwhost == null || gwhost.trim().length() == 0) {
            return defaultOrg;
        }
        String org = (String)virtualHostOrgMapping.get(gwhost.toLowerCase());
        return org == null ? defaultOrg : org;
    }

    private static void populateVirtualHostDefaultOrgMapping() {
        Iterator iter = virtualHostActual.iterator();
        virtualHostOrgMapping = new HashMap();
        while (iter.hasNext()) {
            String vhost = iter.next().toString().trim();
            String virtualHostOrgMappingStr = SystemProperties.get(vhost + ".defaultOrg");
            if (virtualHostOrgMappingStr == null || virtualHostOrgMappingStr.trim().length() <= 0) continue;
            virtualHostOrgMapping.put(vhost.toLowerCase(), virtualHostOrgMappingStr.trim());
        }
    }

    private String getFQDN(String name) {
        int numHosts = virtualHost.size();
        for (int i = 0; i < numHosts; ++i) {
            String host = (String)virtualHost.get(i);
            if (!host.regionMatches(true, 0, name, 0, name.length())) continue;
            return host;
        }
        return null;
    }

    private String getUserLocale(Request req) {
        if (req == null) {
            return defaultLocale;
        }
        return this.getUserLocale(req.getSessionID());
    }

    private String getUserLocale(SSOToken token) {
        if (token == null) {
            return defaultLocale;
        }
        return this.getUserLocale(token.getTokenID().toString());
    }

    private String getUserLocale(String sessid) {
        try {
            UserProfile prof = new UserProfile(sessid);
            return prof.getString("preferredlocale", "en_US");
        }
        catch (Exception ex) {
            return defaultLocale;
        }
    }

    private Response doPDC(String _rpName, Request req) {
        Response rep;
        block28: {
            rep = null;
            if (GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message("Session: now doingPDC");
            }
            String gwLabel = "gw=";
            byte[] gwLableByte = gwLabel.getBytes();
            String gwContentEn = URLEncoder.encode(_rpName);
            byte[] gwContentByte = gwContentEn.getBytes();
            String clntLabel = "&client=";
            byte[] clntLabelByte = clntLabel.getBytes();
            String clntContentEnc = "127.0.0.1";
            byte[] clntContentByte = clntContentEnc.getBytes();
            String certLabel = "&Login.Token0=";
            byte[] certLabelByte = certLabel.getBytes();
            String testLabel = "&testxyz=";
            byte[] testLabelByte = testLabel.getBytes();
            String testContentStr = "justatest";
            String testContentEnc = URLEncoder.encode(testContentStr);
            byte[] testContentByte = testContentEnc.getBytes();
            if (GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message("Session: ABOUT TO DO CERT LOGIN");
            }
            X509Certificate clientCert = null;
            Base64 _base64 = new Base64();
            String b64Cert = null;
            byte[] certparam = null;
            SSLSocket sslsock = this.getActualSocket();
            try {
                int i;
                byte[] byteb64Cert;
                block27: {
                    if (GWDebug.debug.messageEnabled()) {
                        GWDebug.debug.message("Session: prepare the cert to send over to the server.");
                    }
                    try {
                        clientCert = sslsock.getStatus().getPeerCertificate();
                    }
                    catch (SocketException se) {
                        if (GWDebug.debug.errorEnabled()) {
                            GWDebug.debug.error("Unable to get peer certificate");
                        }
                        return null;
                    }
                    byte[] certbyte = clientCert.getEncoded();
                    byte[] xxb64Cert = Base64.encode(certbyte);
                    String strb64Cert = new String(xxb64Cert);
                    b64Cert = URLEncoder.encode(strb64Cert);
                    byteb64Cert = b64Cert.getBytes();
                    try {
                        FileOutputStream fout = new FileOutputStream("/tmp/base64cert.certbyte");
                        DataOutputStream out = new DataOutputStream(fout);
                        for (int lindex = 0; lindex < xxb64Cert.length; ++lindex) {
                            out.writeByte(xxb64Cert[lindex]);
                        }
                        out.close();
                    }
                    catch (IOException ex3) {
                        if (!GWDebug.debug.errorEnabled()) break block27;
                        GWDebug.debug.error("Session: see file /tmp/base64cert");
                    }
                }
                certparam = new byte[gwLableByte.length + gwContentByte.length + clntLabelByte.length + clntContentByte.length + certLabelByte.length + testLabelByte.length + testContentByte.length + byteb64Cert.length + 200];
                if (GWDebug.debug.messageEnabled()) {
                    GWDebug.debug.message("Session: certparam.length=" + certparam.length);
                    GWDebug.debug.message("Session: b64Cert.length=" + b64Cert.length());
                }
                int j = 0;
                for (i = 0; i < gwLableByte.length; ++i) {
                    certparam[i] = gwLableByte[i];
                }
                j = gwLableByte.length;
                for (i = 0; i < gwContentByte.length; ++i) {
                    certparam[j] = gwContentByte[i];
                    ++j;
                }
                for (i = 0; i < clntLabelByte.length; ++i) {
                    certparam[j] = clntLabelByte[i];
                    ++j;
                }
                for (i = 0; i < clntContentByte.length; ++i) {
                    certparam[j] = clntContentByte[i];
                    ++j;
                }
                for (i = 0; i < certLabelByte.length; ++i) {
                    certparam[j] = certLabelByte[i];
                    ++j;
                }
                for (i = 0; i < byteb64Cert.length; ++i) {
                    certparam[j] = byteb64Cert[i];
                    ++j;
                }
                for (i = 0; i < testLabelByte.length; ++i) {
                    certparam[j] = testLabelByte[i];
                    ++j;
                }
                for (i = 0; i < testContentByte.length; ++i) {
                    certparam[j] = testContentByte[i];
                    ++j;
                }
                if (GWDebug.debug.messageEnabled()) {
                    GWDebug.debug.message("Session: certificate version: getSubjectDN " + clientCert.getSubjectDN());
                }
                Retriever retr = null;
                HTTPRequest tmpreq = new HTTPRequest(this._gwprotocol, this.port);
                if (req.getObject().startsWith(_platformloginURL)) {
                    HTTPRequest blkreq = null;
                    String _tmpurl = req.getURL().trim();
                    int indx = _tmpurl.toLowerCase().indexOf("org=");
                    if (indx != -1) {
                        int indx1 = _tmpurl.indexOf(38, indx += 4);
                        if (indx1 == -1) {
                            indx1 = _tmpurl.length();
                        }
                        if ((_tmpurl = _tmpurl.substring(indx, indx1)).startsWith("/")) {
                            _tmpurl = _tmpurl.substring(1);
                        }
                        blkreq = new HTTPRequest(_tmpurl);
                    } else {
                        blkreq = new HTTPRequest();
                    }
                    blkreq.setHost(req.getHost());
                    blkreq.setPort(req.getPort());
                    blkreq.setGatewayHost(req.getGatewayHost());
                    tmpreq.addHeaderLine("POST  /" + this.loginURL(blkreq, _platformloginURL) + " " + ((HTTPRequest)req).getHTTPVersion() + "\r\n");
                } else {
                    tmpreq.addHeaderLine("POST  /" + this.loginURL(req, _platformloginURL) + " " + ((HTTPRequest)req).getHTTPVersion() + "\r\n");
                }
                tmpreq.addHeaderLine("Content-Type: application/x-www-form-urlencoded\r\n");
                tmpreq.addHeaderLine("Content-Length: " + certparam.length + "\r\n");
                retr = RetrievalFactory.getRetriever(tmpreq.getProtocol());
                rep = retr.getResponse2(tmpreq, tmpreq.getHost(), this._logId, certparam);
                req.setHost(tmpreq.getHost());
                req.setPort(tmpreq.getPort());
                req.setProtocol(tmpreq.getProtocol());
                req.setObject(tmpreq.getObject());
                req.setURL(tmpreq.getURL());
            }
            catch (CertificateEncodingException ex2) {
                if (!GWDebug.debug.errorEnabled()) break block28;
                GWDebug.debug.error("Session: CertificateEncodingException");
            }
        }
        return rep;
    }

    private void removePDCCookie(Request req) {
        String cookie = req.getRequestHeader("Cookie");
        StringBuffer sb = new StringBuffer();
        int index = cookie.indexOf(sessionCookieName);
        index = cookie.indexOf(61, index) + 1;
        String rest = cookie.substring(index).trim();
        sb.append(cookie.substring(0, index));
        sb.append(rest.substring(6));
        req.setRequestHeader("Cookie", sb.toString());
    }

    private void addPDCCookie(Request req, Response res) {
        if (!(res instanceof HTTPResponse)) {
            return;
        }
        String cookie = null;
        List cookieList = ((HTTPResponse)res).getHeaderAttributeList("Set-Cookie");
        if (cookieList != null && cookieList.size() > 0) {
            ((HTTPResponse)res).removeResponseHeader("Set-Cookie");
            Iterator it = cookieList.iterator();
            while (it.hasNext()) {
                cookie = (String)it.next();
                StringBuffer sb = new StringBuffer();
                int index = cookie.indexOf(sessionCookieName);
                if (index != -1) {
                    String rest = cookie.substring(cookie.indexOf(61, index) + 1).trim();
                    sb.append(cookie.substring(0, index));
                    sb.append(sessionCookieName);
                    sb.append("=");
                    sb.append(PDC_COOKIE_HEADER);
                    sb.append(rest);
                    ((HTTPResponse)res).appendResponseHeader("Set-Cookie", sb.toString());
                    continue;
                }
                ((HTTPResponse)res).appendResponseHeader("Set-Cookie", cookie);
            }
        } else {
            cookie = req.getRequestHeader("Cookie");
            if (cookie != null) {
                StringBuffer sb = new StringBuffer();
                int index = cookie.indexOf(sessionCookieName);
                if (index != -1) {
                    int end = cookie.indexOf(59, index);
                    end = end == -1 ? cookie.length() : end;
                    String rest = cookie.substring(cookie.indexOf(61, index) + 1, end).trim();
                    sb.append("Set-Cookie: ");
                    sb.append(sessionCookieName);
                    sb.append("=");
                    sb.append(PDC_COOKIE_HEADER);
                    sb.append(rest);
                    sb.append(";path = /;");
                    if (gwDomain != null) {
                        sb.append(" domain =");
                        sb.append(gwDomain);
                        sb.append(";");
                    }
                    res.setResponseHeader("Set-Cookie", sb.toString());
                } else {
                    sb.append("Set-Cookie: ");
                    sb.append(sessionCookieName);
                    sb.append("=");
                    sb.append(PDC_COOKIE_HEADER);
                    sb.append(";path = /;");
                    if (gwDomain != null) {
                        sb.append(" domain =");
                        sb.append(gwDomain);
                        sb.append(";");
                    }
                    res.setResponseHeader("Set-Cookie", sb.toString());
                }
            } else {
                StringBuffer sb = new StringBuffer();
                sb.append("Set-Cookie: ");
                sb.append(sessionCookieName);
                sb.append("=");
                sb.append(PDC_COOKIE_HEADER);
                sb.append(";path = /;");
                if (gwDomain != null) {
                    sb.append(" domain =");
                    sb.append(gwDomain);
                    sb.append(";");
                }
                res.setResponseHeader("Set-Cookie", sb.toString());
            }
        }
    }

    private boolean hostFound(String reqUri) {
        Iterator it = serverList.iterator();
        while (it.hasNext()) {
            String fullhost = it.next().toString().toLowerCase();
            String hostname = null;
            int lastColonIndex = -1;
            if (fullhost.startsWith("http:")) {
                lastColonIndex = fullhost.lastIndexOf(58);
                hostname = 4 == lastColonIndex ? fullhost.substring(7) : fullhost.substring(7, lastColonIndex);
            } else if (fullhost.startsWith("https:")) {
                lastColonIndex = fullhost.lastIndexOf(58);
                hostname = 5 == lastColonIndex ? fullhost.substring(8) : fullhost.substring(8, lastColonIndex);
            } else if (GWDebug.debug.errorEnabled()) {
                GWDebug.debug.error("Server list entry is not in the right format: " + fullhost);
            }
            String reqUriSub = reqUri.substring(reqUri.indexOf(58) + 3).toLowerCase();
            if (hostname == null) {
                return false;
            }
            if (!reqUriSub.startsWith(hostname)) continue;
            return true;
        }
        return false;
    }

    private boolean isUserSessionValid(Request req) {
        String tmpsidstr = req.getSessionID();
        if (tmpsidstr == null || tmpsidstr.equals("null") || tmpsidstr.trim().length() == 0) {
            return false;
        }
        return this.getUserSession(req, tmpsidstr) != null;
    }

    SSLSocket getActualSocket() {
        if (this._theSocket instanceof SRAPSocket) {
            SRAPSocket sock = (SRAPSocket)this._theSocket;
            return (SSLSocket)sock.getActualSocket();
        }
        return (SSLSocket)this._theSocket;
    }

    static {
        _hpprot = "https";
        srapGateway_certificateEnabledList_lc = GatewayProfile.getLowerCaseStringList("CertificateEnabledList");
        virtualHost = new ArrayList();
        virtualHostActual = new ArrayList();
        nonAuthPathList = GatewayProfile.getLowerCaseURLList("NonAuthenticatedURLPath");
        _numRequests = 0;
        _numBytesRead = 0;
        _numBytesSent = 0;
        processKeepAliveConnections = GatewayProfile.getBoolean("EProxyDoKeepAlive", true) && ServiceIdentifier.isGateway();
        timeoutseconds = GatewayProfile.getInt("EProxyKeepAliveConnectionTimeout", 50);
        GRACE_PERIOD = GatewayProfile.getInt("EProxyKeepAliveConnectionGraceTimeout", 20);
        maxTimeOutSetting = (long)(timeoutseconds + GRACE_PERIOD) * 1000L;
        defDomain = GatewayProfile.getString("DefaultDomainAndSubdomains", "");
        sessionCookieName = com.iplanet.am.util.SystemProperties.get((String)"com.iplanet.am.cookie.name", (String)"iPlanetDirectoryPro");
        sessionCookieLen = sessionCookieName.length();
        defaultOrg = com.iplanet.am.util.SystemProperties.get((String)"com.iplanet.am.defaultOrg", (String)defDomain);
        gwDomain = null;
        serverList = GatewayProfile.getLowerCaseStringList("PortalServerList");
        ignoreURIList = new ArrayList();
        notificationURL = System.getProperty("gateway.notification.url", "notification");
        isPerSessionLoggingEnabled = GatewayProfile.getBoolean("EProxyPerSessionLogging", false) && ServiceIdentifier.isGateway();
        detailedRproxLog = GatewayProfile.getBoolean("EProxyDetailedPerSessionLogging", false);
        defaultLocale = GatewayProfile.getString("locale", "en_US");
        server_traffic = GWDebug.createDebugLog("Gateway_to_from_server");
        server_traffic.setDebug();
        browser_traffic = GWDebug.createDebugLog("Gateway_to_from_browser");
        browser_traffic.setDebug();
        rphost = SystemProperties.get("gateway.host", null);
        Session.setVirtualHostname();
        Session.populateVirtualHostDefaultOrgMapping();
        Session.setIgnoreURIList();
        _useHTTPProxy = GatewayProfile.getBoolean("UseHTTPProxy", false) && ServiceIdentifier.isGateway();
        _hpport = GatewayProfile.getString("HTTPProxyPort", "10443");
        _platformloginURL = PlatformProfile.getString("login-url", "");
        _platformlogoutURL = PlatformProfile.getString("logout-url", "");
        List platformServers = PlatformProfile.getStringList("server-list");
        Iterator serversIt = platformServers.iterator();
        while (serversIt.hasNext()) {
            String isURL = (String)serversIt.next();
            int pipeIndex = isURL.indexOf("|");
            if (pipeIndex <= -1) continue;
            isURL = isURL.substring(0, pipeIndex);
            nonAuthPathList.add(isURL + _platformloginURL);
            nonAuthPathList.add(isURL + _platformlogoutURL);
        }
        nonAuthPathList.add(_platformloginURL);
        nonAuthPathList.add(_platformlogoutURL);
        int index = rphost.indexOf(46);
        gwDomain = index != -1 ? rphost.substring(index) : null;
        expandedSessionServersList = null;
        expandedSessionServersList = new LinkedList();
        Set sessionServers = ServersList.getAllSessionServersSet();
        URL tmpUrl = null;
        String tmpStr = null;
        Iterator iter = sessionServers.iterator();
        while (iter.hasNext()) {
            try {
                tmpStr = iter.next().toString();
                tmpUrl = new URL(tmpStr);
                expandedSessionServersList.add(tmpUrl.getProtocol() + "://" + tmpUrl.getHost() + ":" + tmpUrl.getPort());
                if ((!tmpUrl.getProtocol().equalsIgnoreCase("http") || tmpUrl.getPort() != 80) && (!tmpUrl.getProtocol().equalsIgnoreCase("https") || tmpUrl.getPort() != 443)) continue;
                expandedSessionServersList.add(tmpUrl.getProtocol() + "://" + tmpUrl.getHost());
            }
            catch (Exception ex) {
                if (!GWDebug.debug.messageEnabled()) continue;
                GWDebug.debug.message("Exception while parsing entry " + tmpStr, ex);
            }
        }
        clientIPHeaderKey = "PS-GW-ClientIP";
        gatewayURLInfoHeaderKey = "PS-GW-URL";
        gatewayInstanceHeaderKey = "PS-GW-Instance";
        gatewayRWURLInfoHeaderKey = "PS-GW-Rewriting-URL";
        faviconLocation = "";
        faviconLocation = SystemProperties.get("gateway.favicon", "");
        if (faviconLocation != null && faviconLocation.trim().length() == 0) {
            faviconLocation = null;
        }
    }
}

