/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.admin.model;

import com.iplanet.am.console.base.model.AMAttrSchemaComparator;
import com.iplanet.am.console.base.model.AMConsoleException;
import com.iplanet.am.console.base.model.AMDisplayTypeConverter;
import com.iplanet.am.console.base.model.AMResBundleCacher;
import com.iplanet.am.console.user.model.UMUserProfileModelImpl;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMObject;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import com.sun.portal.netlet.admin.NetletAdminModelManager;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;

public class NetletAdminUserProfileModelImpl
extends UMUserProfileModelImpl {
    private HttpServletRequest req = null;
    private SSOToken ssoToken = null;
    private ServiceSchemaManager schemaMgr = null;
    private ServiceSchema schema = null;
    private Set dynAttrNames = null;
    private List attrNames = null;
    private Map netletUserAttrs = null;
    private int currentRow = -1;
    public static final String ANY_OPTION_SEPARATOR = "|";

    public NetletAdminUserProfileModelImpl(HttpServletRequest req, Map map) {
        super(req, map);
        this.resBundle = AMResBundleCacher.getBundle((String)"srapnetletadminmsgs", (Locale)this.getUserLocale());
        this.req = req;
    }

    public void initModel(String userDN) {
        this.userDN = userDN;
        if (userDN == null || userDN.trim().length() == 0) {
            return;
        }
        try {
            int size;
            SSOTokenManager ssoTokenManager = SSOTokenManager.getInstance();
            this.ssoToken = ssoTokenManager.createSSOToken(this.req);
            AMStoreConnection amConn = new AMStoreConnection(this.ssoToken);
            this.curUser = amConn.getUser(userDN);
            this.schemaMgr = new ServiceSchemaManager(this.ssoToken, "srapNetletService", "1.0");
            this.schema = this.schemaMgr.getSchema(SchemaType.USER);
            this.attrNames = this.getUserAttrNames();
            ServiceSchema dynSchema = this.schemaMgr.getSchema(SchemaType.DYNAMIC);
            this.dynAttrNames = dynSchema.getAttributeSchemaNames();
            int n = size = this.attrNames == null ? 0 : this.attrNames.size();
            if (size > 0) {
                this.netletUserAttrs = new HashMap();
                Iterator iter = this.attrNames.iterator();
                while (iter.hasNext()) {
                    String attrName = (String)iter.next();
                    Set attrValue = this.curUser.getAttribute(attrName);
                    this.netletUserAttrs.put(attrName, attrValue);
                }
                this.setAttributeValues(this.curUser.getAttributes());
            }
        }
        catch (Exception ex) {
            NetletAdminModelManager.debugMessage((String)"NetletAdminUserProfileModelImpl - Unable to initialize model : ", (Throwable)ex);
        }
    }

    public int getSize() {
        return this.attrNames == null ? 0 : this.attrNames.size();
    }

    public boolean setCurrentRow(int currRow) {
        if (this.netletUserAttrs == null) {
            return false;
        }
        this.currentRow = currRow;
        return currRow < this.netletUserAttrs.size();
    }

    public String getAttrName() {
        return this.attrNames == null ? null : (String)this.attrNames.get(this.currentRow);
    }

    public String getAttrLabel(String attrName) {
        String i18nKey;
        if (this.schema == null || attrName == null || attrName.trim().length() == 0) {
            return attrName;
        }
        AttributeSchema attrSchema = this.schema.getAttributeSchema(attrName);
        String l10name = i18nKey = attrSchema.getI18NKey();
        if (this.schemaMgr != null) {
            l10name = this.getL10NAttributeName(this.schemaMgr, i18nKey);
        }
        return l10name;
    }

    public String getAttrLabel() {
        return this.getAttrLabel(this.getAttrName());
    }

    public int getAttrType() {
        if (this.schema == null) {
            return AMDisplayTypeConverter.DEFAULT_TYPE;
        }
        String attrLabel = this.getAttrName();
        AttributeSchema attrSchema = this.schema.getAttributeSchema(attrLabel);
        int type = AMDisplayTypeConverter.getDisplayType((AttributeSchema)attrSchema);
        return type;
    }

    public int getAttrSyntax() {
        int syntax = AMDisplayTypeConverter.DEFAULT_SYNTAX;
        if (this.schema == null) {
            return syntax;
        }
        String attrLabel = this.getAttrName();
        AttributeSchema attrSchema = this.schema.getAttributeSchema(attrLabel);
        syntax = AMDisplayTypeConverter.getDisplaySyntax((AttributeSchema)attrSchema);
        return syntax;
    }

    public boolean isReadOnly(String attrName) {
        AttributeSchema attrSchema = this.schema.getAttributeSchema(attrName);
        String any = attrSchema.getAny();
        Set displayOptions = this.getDisplayOptions(any);
        if (displayOptions.isEmpty() || displayOptions.contains("display")) {
            return false;
        }
        return !this.isAdministrator() || !displayOptions.contains("adminDisplay");
    }

    public boolean isReadOnly() {
        return this.isReadOnly(this.getAttrName());
    }

    public Set getAttributeValue(String attrName) {
        if (this.curUser == null) {
            return null;
        }
        Set attrValue = null;
        try {
            attrValue = this.curUser.getAttribute(attrName);
        }
        catch (Exception ex) {
            NetletAdminModelManager.debugError((String)("NetletAdminUserProfileModelImpl: Unable to get value of " + attrName + ex));
        }
        return attrValue;
    }

    public Set getAttrValues(String attrName) {
        return this.netletUserAttrs == null ? null : (Set)this.netletUserAttrs.get(attrName);
    }

    public Set getAttrValues() {
        return this.getAttrValues(this.getAttrName());
    }

    public String getAttrStringValue(String attrName, String defaultValue) {
        Set set = this.getAttributeValue(attrName);
        if (null == set) {
            return defaultValue;
        }
        Iterator it = set.iterator();
        return it.hasNext() ? (String)it.next() : defaultValue;
    }

    public String getAttrTrueValue() {
        String trueValue = "true";
        if (this.schema == null) {
            return trueValue;
        }
        String attrLabel = this.getAttrName();
        AttributeSchema attrSchema = this.schema.getAttributeSchema(attrLabel);
        trueValue = attrSchema.getTrueValue();
        return trueValue;
    }

    public String getAttrFalseValue() {
        String falseValue = "false";
        if (this.schema == null) {
            return falseValue;
        }
        String attrLabel = this.getAttrName();
        AttributeSchema attrSchema = this.schema.getAttributeSchema(attrLabel);
        falseValue = attrSchema.getFalseValue();
        return falseValue;
    }

    public String[] getAttrChoices() {
        if (this.schema == null) {
            return null;
        }
        String attrLabel = this.getAttrName();
        AttributeSchema attrSchema = this.schema.getAttributeSchema(attrLabel);
        String[] values = attrSchema.getChoiceValues();
        return values;
    }

    public Set getNetletRules() {
        return this.netletUserAttrs == null ? null : (Set)this.netletUserAttrs.get("sunPortalNetletRules");
    }

    public int getNetletRulesIndex() {
        return this.attrNames == null ? -1 : this.attrNames.indexOf("sunPortalNetletRules");
    }

    public Set getNetletCipherList() {
        return this.netletUserAttrs == null ? null : (Set)this.netletUserAttrs.get("sunPortalNetletCipherList");
    }

    public int getNetletCipherListIndex() {
        return this.attrNames == null ? -1 : this.attrNames.indexOf("sunPortalNetletCipherList");
    }

    public int getNetletRulesCount() {
        Set s = this.getNetletRules();
        return s == null ? 0 : s.size();
    }

    public String getServiceDescription() {
        return this.getLocalizedSvcName("srapNetletService");
    }

    public boolean store(Map newMap) {
        if (this.curUser == null) {
            return false;
        }
        HashMap<String, Set> attrMap = new HashMap<String, Set>(1);
        Set attrNames = newMap.keySet();
        Iterator iter = attrNames.iterator();
        String attrName = null;
        while (iter.hasNext()) {
            try {
                attrName = (String)iter.next();
                Set newValue = (Set)newMap.get(attrName);
                attrMap.clear();
                attrMap.put(attrName, newValue);
                this.curUser.setAttributes(attrMap);
                this.curUser.store();
            }
            catch (Exception ex) {
                NetletAdminModelManager.debugError((String)(ex + " - " + attrName));
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeAttributes(Map userOnlyAttrs, Map customizedAttrs, Set inheritedAttrs) throws AMConsoleException {
        Set attrValues;
        String attrName;
        ArrayList<String> errorList = null;
        HashMap<String, Set> attrs = new HashMap<String, Set>(userOnlyAttrs.size());
        Set namesSet = userOnlyAttrs.keySet();
        Iterator<Object> iter = namesSet.iterator();
        while (iter.hasNext()) {
            attrName = (String)iter.next();
            attrValues = (Set)userOnlyAttrs.get(attrName);
            if (attrValues == null) continue;
            attrs.put(attrName, attrValues);
        }
        try {
            if (!attrs.isEmpty()) {
                this.writeProfile((AMObject)this.curUser, attrs, false);
            }
        }
        catch (AMConsoleException ace) {
            errorList = ace.getErrors();
        }
        catch (SSOException ssoe) {
            NetletAdminModelManager.debugError((String)("NetletAdminUserProfileModelImpl: Invalid SSOToken -> " + (Object)((Object)ssoe)));
            return;
        }
        attrs = new HashMap(customizedAttrs.size());
        namesSet = customizedAttrs.keySet();
        iter = namesSet.iterator();
        while (iter.hasNext()) {
            attrName = (String)iter.next();
            attrValues = (Set)customizedAttrs.get(attrName);
            if (attrValues == null) continue;
            attrs.put(attrName, attrValues);
        }
        try {
            if (!attrs.isEmpty()) {
                this.writeProfile((AMObject)this.curUser, attrs, true);
            }
        }
        catch (AMConsoleException ace) {
            errorList = ace.getErrors();
        }
        catch (SSOException ssoe) {
            NetletAdminModelManager.debugError((String)("NetletAdminUserProfileModelImpl: Invalid SSOToken -> " + (Object)((Object)ssoe)));
            return;
        }
        if (!inheritedAttrs.isEmpty()) {
            if (errorList == null) {
                errorList = new ArrayList<String>(inheritedAttrs.size());
            }
            HashSet<String> attr = new HashSet<String>(1);
            iter = inheritedAttrs.iterator();
            while (iter.hasNext()) {
                String name = (String)iter.next();
                attr.add(name);
                try {
                    this.curUser.removeAttributes(attr);
                    this.logger.doLog("attribute.remove", name);
                }
                catch (AMException ame) {
                    if (debug.warningEnabled()) {
                        debug.warning("error removing attribute " + name, (Throwable)ame);
                    }
                    errorList.add(name + "-" + ame.getMessage());
                }
                catch (SSOException ssoe) {
                    NetletAdminModelManager.debugError((String)("NetletAdminUserProfileModelImpl: Invalid SSOToken -> " + (Object)((Object)ssoe)));
                    return;
                }
                finally {
                    attr.clear();
                }
            }
        }
        if (errorList != null && !errorList.isEmpty()) {
            throw new AMConsoleException(errorList);
        }
    }

    private List getUserAttrNames() {
        List attrNames = this.getAttrSchema(SchemaType.USER);
        List displayableAttrNames = this.getDisplayableAttrNames(attrNames);
        return displayableAttrNames;
    }

    private List getAttrSchema(SchemaType schemaType) {
        List sortedAttrNames = null;
        Set attrNames = this.schema.getAttributeSchemas();
        sortedAttrNames = this.sortAttrSchema(attrNames);
        return sortedAttrNames;
    }

    public List getDisplayableAttrNames(List attrNames) {
        LinkedList<String> newAttrNames = new LinkedList<String>();
        Iterator iter = attrNames.iterator();
        while (iter.hasNext()) {
            String any;
            Set displayOptions;
            AttributeSchema attrSchema = (AttributeSchema)iter.next();
            String attrName = attrSchema.getName();
            String i18nKey = attrSchema.getI18NKey();
            if (i18nKey == null || i18nKey.trim().length() == 0 || !(displayOptions = this.getDisplayOptions(any = attrSchema.getAny())).isEmpty() && !displayOptions.contains("display") && !displayOptions.contains("readOnly") && !displayOptions.contains("userReadOnly") && (!this.isAdministrator() || !displayOptions.contains("adminDisplay"))) continue;
            newAttrNames.add(attrName);
        }
        return newAttrNames;
    }

    private Set getDisplayOptions(String anyOptions) {
        if (anyOptions == null || anyOptions.length() == 0) {
            return Collections.EMPTY_SET;
        }
        StringTokenizer optionTokenizer = new StringTokenizer(anyOptions, ANY_OPTION_SEPARATOR);
        HashSet<String> options = new HashSet<String>(optionTokenizer.countTokens());
        while (optionTokenizer.hasMoreTokens()) {
            options.add(optionTokenizer.nextToken());
        }
        return options;
    }

    private List sortAttrSchema(Set unordered) {
        Collator collator = Collator.getInstance(this.getUserLocale());
        AMAttrSchemaComparator c = new AMAttrSchemaComparator(collator);
        ArrayList ordered = new ArrayList(unordered);
        Collections.sort(ordered, c);
        return ordered;
    }

    public String getUserID() {
        if (this.userDN != null && this.userDN.trim().length() != 0) {
            try {
                return this.userDN.substring(this.userDN.indexOf(61) + 1, this.userDN.indexOf(44));
            }
            catch (Exception ex) {
                NetletAdminModelManager.debugError((String)("NetletAdminUserProfileModelImpl: Unable to get userID -> " + ex));
            }
        }
        return null;
    }

    public String getAttributeStatus(String attrName) {
        if (this.dynAttrNames.contains(attrName)) {
            return this.getSkipValue();
        }
        return null;
    }
}

