/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.eproxy;

import com.sun.portal.netlet.eproxy.StreamCopier;
import com.sun.portal.rproxy.configservlet.client.GatewayProfile;
import com.sun.portal.rproxy.connectionhandler.HTTPRequest;
import com.sun.portal.util.GWDebug;
import com.sun.portal.util.ServiceIdentifier;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import sun.net.www.protocol.http.HttpURLConnection;

public class ProxyletSession
implements Runnable {
    protected InputStream nonsslin;
    protected OutputStream nonsslout;
    protected Socket nonsslsocket;
    protected Integer logId;
    protected String endhost;
    protected int endport;
    protected Socket connection;
    protected static boolean _useProxy = GatewayProfile.getBoolean("UseProxy", false) && ServiceIdentifier.isGateway();
    protected HTTPRequest req = null;

    public ProxyletSession() {
    }

    public ProxyletSession(Socket nonsslsocket, Integer logId, String host, int port, Socket sslsocket) {
        try {
            this.nonsslsocket = nonsslsocket;
            this.nonsslin = nonsslsocket.getInputStream();
            this.nonsslout = nonsslsocket.getOutputStream();
            this.endhost = host;
            this.endport = port;
            this.connection = sslsocket;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        ProxyletSession proxyletSession;
        Socket tunnel = null;
        InputStream in = null;
        OutputStream out = null;
        Object conn = null;
        String proxyhost = null;
        int proxyport = -1;
        try {
            if (_useProxy) {
                HTTPRequest proxyDomain = new HTTPRequest("https://" + this.endhost + ":" + this.endport);
                proxyDomain.populateWebProxyInfo();
                proxyport = proxyDomain.getProxyPort();
                proxyhost = proxyDomain.getProxyHost();
            }
            try {
                byte[] _temp1;
                String _temp;
                OutputStream sslGOut = this.connection.getOutputStream();
                if (proxyhost != null) {
                    tunnel = this.createTunnelSocket(proxyhost, proxyport, this.endhost, this.endport);
                    _temp = "HTTP/1.0 200 Connection established \r\n\r\n";
                    _temp1 = _temp.getBytes();
                    sslGOut.write(_temp1);
                    sslGOut.flush();
                } else {
                    tunnel = new Socket(this.endhost, this.endport);
                    _temp = "HTTP/1.0 200 Connection established \r\n\r\n";
                    _temp1 = _temp.getBytes();
                    sslGOut.write(_temp1);
                    sslGOut.flush();
                }
            }
            catch (Exception e) {
                if (GWDebug.debug.errorEnabled()) {
                    GWDebug.debug.error("PROXYLET could not create tunnel " + e.getMessage());
                }
                e.printStackTrace();
                this.nonsslout.write("HTTP/1.0 400 Failed to establish connection with endhost through proxy\r\n\r\n".getBytes());
                this.nonsslout.flush();
                Object var15_13 = null;
                ProxyletSession proxyletSession2 = this;
                synchronized (proxyletSession2) {
                    try {
                        in.close();
                        out.close();
                        tunnel.close();
                        this.nonsslin.close();
                        this.nonsslout.close();
                        this.nonsslsocket.close();
                        if (this.connection != null) {
                            this.connection.close();
                        }
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                }
                return;
            }
            try {
                tunnel.setTcpNoDelay(true);
                tunnel.setKeepAlive(true);
            }
            catch (Exception e) {
                // empty catch block
            }
            in = tunnel.getInputStream();
            out = tunnel.getOutputStream();
            StreamCopier copyOut = new StreamCopier(this.nonsslin, out, "proxylet -> real server");
            StreamCopier copyIn = new StreamCopier(in, this.nonsslout, "proxylet<- real server");
            tunnel.setSoLinger(true, 240);
            StreamCopier streamCopier = copyIn;
            synchronized (streamCopier) {
                StreamCopier streamCopier2 = copyOut;
                synchronized (streamCopier2) {
                    while (copyIn.isCopying() && copyOut.isCopying()) {
                        try {
                            copyIn.wait(1000L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        try {
                            copyOut.wait(1000L);
                        }
                        catch (InterruptedException e) {}
                    }
                }
            }
            Object var15_14 = null;
            proxyletSession = this;
        }
        catch (Throwable throwable) {
            Object var15_16 = null;
            ProxyletSession proxyletSession3 = this;
            synchronized (proxyletSession3) {
                try {
                    in.close();
                    out.close();
                    tunnel.close();
                    this.nonsslin.close();
                    this.nonsslout.close();
                    this.nonsslsocket.close();
                    if (this.connection != null) {
                        this.connection.close();
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
            }
            throw throwable;
        }
        synchronized (proxyletSession) {
            try {
                in.close();
                out.close();
                tunnel.close();
                this.nonsslin.close();
                this.nonsslout.close();
                this.nonsslsocket.close();
                if (this.connection != null) {
                    this.connection.close();
                }
            }
            catch (Exception e2) {
                // empty catch block
            }
        }
        {
            catch (Exception e) {
                if (GWDebug.debug.errorEnabled()) {
                    GWDebug.debug.error("Error in processing proxylet connection " + e.getMessage());
                }
                Object var15_15 = null;
                ProxyletSession proxyletSession4 = this;
                synchronized (proxyletSession4) {
                    try {
                        in.close();
                        out.close();
                        tunnel.close();
                        this.nonsslin.close();
                        this.nonsslout.close();
                        this.nonsslsocket.close();
                        if (this.connection != null) {
                            this.connection.close();
                        }
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public Socket createTunnelSocket(String proxyhost, int proxyport, String endhost, int endport) throws IOException {
        byte[] b;
        boolean replyLen = false;
        Socket tunnel = new Socket(proxyhost, proxyport);
        if (endport == -1) {
            endport = 443;
        }
        OutputStream out = tunnel.getOutputStream();
        String msg = null;
        msg = "CONNECT " + endhost + ":" + endport + " HTTP/1.0\n" + "User-Agent: " + HttpURLConnection.userAgent + "\r\n\r\n";
        try {
            b = msg.getBytes("ASCII7");
        }
        catch (UnsupportedEncodingException ignored) {
            b = msg.getBytes();
        }
        out.write(b);
        out.flush();
        InputStream in = tunnel.getInputStream();
        boolean error = false;
        byte[] reply = this.readInputStream(in);
        String replyStr = new String(reply);
        if (!replyStr.startsWith("HTTP/1.0 200")) {
            throw new IOException("Unable to tunnel through " + this.req.getProxyHost() + ":" + this.req.getProxyPort() + ".  Proxy returns \"" + replyStr + "\"");
        }
        return tunnel;
    }

    private byte[] readInputStream(InputStream in) throws IOException {
        byte[] reply = new byte[200];
        int replyLen = 0;
        int newlinesSeen = 0;
        boolean headerDone = false;
        while (newlinesSeen < 2) {
            int i = in.read();
            if (i < 0) {
                throw new IOException("Unexpected EOF from proxy");
            }
            if (i == 10) {
                headerDone = true;
                ++newlinesSeen;
                continue;
            }
            if (i == 13) continue;
            newlinesSeen = 0;
            if (headerDone || replyLen >= reply.length) continue;
            reply[replyLen++] = (byte)i;
        }
        return reply;
    }

    public static void main(String[] args) {
        ProxyletSession p = new ProxyletSession();
        System.out.println("useproxy = " + _useProxy);
    }
}

