/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ssoadapter.config;

import com.sun.ssoadapter.config.ClientAwareAppContext;
import com.sun.ssoadapter.config.ClientAwareUserContext;
import com.sun.ssoadapter.config.ConfigContext;
import com.sun.ssoadapter.config.SAALException;
import com.sun.ssoadapter.config.SessionListener;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import javax.servlet.http.HttpServletRequest;

public class PSClientAwareContextFactory
implements SessionListener {
    private static Map facHashMap = new HashMap();
    private static final String CONFIG_CONTEXT_CLASSNAME = "com.sun.ssoadapter.config.PropertiesConfigContext";
    private HashMap caUserContexts = new HashMap();
    private ConfigContext config = null;
    private ClientAwareAppContext caAppContext = null;
    private String thisClassName = this.getClass().getName();
    private static final String authlessSUID = "ssoadapter.authless.suid";
    private String caAppContextClassName = null;
    private String caUserContextClassName = null;
    private String caAuthlessUserContextClassName = null;
    private boolean clearCacheUsingNotification = false;

    protected PSClientAwareContextFactory() {
    }

    private void init(String configContextClassName) throws SAALException {
        try {
            this.config = (ConfigContext)Class.forName(configContextClassName).newInstance();
        }
        catch (Exception cnfe) {
            throw new SAALException(this.thisClassName + ": Could not create ConfigContext class: " + configContextClassName + ": " + cnfe);
        }
        this.config.init();
        this.caAppContextClassName = this.config.getClientAwareAppContextClassName();
        if (this.caAppContextClassName == null) {
            throw new MissingResourceException("Could not get Appcontext class name from config file", "ConfigContext", "clientAwareAppContextClassName");
        }
        this.caUserContextClassName = this.config.getClientAwareUserContextClassName();
        if (this.caUserContextClassName == null) {
            throw new MissingResourceException(this.thisClassName + ": Could not get UserContext class name from config file", "ConfigContext", "clientAwareUserContextClassName");
        }
        this.caAuthlessUserContextClassName = this.config.getClientAwareAuthlessUserContextClassName();
        if (this.caAuthlessUserContextClassName == null) {
            throw new MissingResourceException(this.thisClassName + ": Could not get AuthlessUserContext class name from config file", "ConfigContext", "clientAwareAuthlessUserContextClassName");
        }
        this.clearCacheUsingNotification = this.config.clearCacheUsingNotification();
    }

    public static PSClientAwareContextFactory getInstance() throws SAALException {
        return PSClientAwareContextFactory.getInstance(CONFIG_CONTEXT_CLASSNAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PSClientAwareContextFactory getInstance(String configContextClassName) throws SAALException {
        PSClientAwareContextFactory mapFac = null;
        Map map = facHashMap;
        synchronized (map) {
            mapFac = (PSClientAwareContextFactory)facHashMap.get(configContextClassName);
            if (mapFac == null) {
                mapFac = new PSClientAwareContextFactory();
                mapFac.init(configContextClassName);
                facHashMap.put(configContextClassName, mapFac);
            }
        }
        return mapFac;
    }

    public synchronized ClientAwareAppContext getClientAwareAppContext() throws SAALException {
        if (this.caAppContext == null) {
            ClientAwareAppContext appCntxt = null;
            try {
                appCntxt = (ClientAwareAppContext)Class.forName(this.caAppContextClassName).newInstance();
            }
            catch (Exception cnfe) {
                throw new SAALException(this.thisClassName + ": Could not create AppContext class: " + this.caAppContextClassName + ":: " + cnfe);
            }
            appCntxt.init(this);
            this.caAppContext = appCntxt;
        }
        return this.caAppContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientAwareUserContext getClientAwareUserContext(HttpServletRequest req) throws IllegalStateException, SAALException {
        String sid;
        ClientAwareUserContext userContext = null;
        String contextClassName = this.caUserContextClassName;
        boolean isValidSession = true;
        if (this.caAppContext == null) {
            this.caAppContext = this.getClientAwareAppContext();
        }
        if ((sid = this.caAppContext.getSessionID(req)) == null) {
            sid = (String)req.getAttribute(authlessSUID);
            if (this.caAppContext.isAuthlessEnabled() && this.caAppContext.isAuthorizedAuthlessUID(sid)) {
                contextClassName = this.caAuthlessUserContextClassName;
                isValidSession = false;
            } else {
                throw new IllegalStateException("Session Invalid:");
            }
        }
        HashMap hashMap = this.caUserContexts;
        synchronized (hashMap) {
            userContext = (ClientAwareUserContext)this.caUserContexts.get(sid);
            if (userContext == null) {
                try {
                    userContext = (ClientAwareUserContext)Class.forName(contextClassName).newInstance();
                }
                catch (Exception cnfe) {
                    throw new SAALException(this.thisClassName + ": Could not create UserContext class: " + contextClassName + ":: " + cnfe);
                }
                userContext.init(req, this.caAppContext);
                this.caUserContexts.put(sid, userContext);
                if (isValidSession) {
                    this.caAppContext.addSessionListener(req);
                }
            }
        }
        return userContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionDestroyed(String sid) {
        HashMap hashMap = this.caUserContexts;
        synchronized (hashMap) {
            this.caUserContexts.remove(sid);
        }
    }

    public boolean clearCacheUsingNotification() {
        return this.clearCacheUsingNotification;
    }
}

