/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.rewriter.util.http;

import com.sun.portal.rproxy.rewriter.util.http.HTTPData;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.mozilla.intl.chardet.nsDetector;
import org.mozilla.intl.chardet.nsICharsetDetectionObserver;

public class CharsetDetector {
    private static boolean charsetDetect = true;
    private String languageHint = System.getProperty("file.encoding");
    private boolean found = false;
    private String encoding;
    private static ArrayList chinese = new ArrayList();
    private static ArrayList japanese = new ArrayList();
    private static ArrayList korean = new ArrayList();

    public static boolean charsetDetectEnabled() {
        return charsetDetect;
    }

    public int getLanguageHint() {
        return this.getLanguageHint(this.languageHint);
    }

    public int getLanguageHint(String languageHint) {
        int hint = 0;
        if (chinese.contains(languageHint)) {
            hint = 2;
        } else if (korean.contains(languageHint)) {
            hint = 5;
        } else if (japanese.contains(languageHint)) {
            hint = 1;
        }
        return hint;
    }

    public String detectCharset(HTTPData aHTTPData) {
        int lang = this.getLanguageHint();
        nsDetector det = new nsDetector(lang);
        det.Init(new nsICharsetDetectionObserver(){

            public void Notify(String charset) {
                CharsetDetector.this.found = true;
                CharsetDetector.this.encoding = charset;
            }
        });
        try {
            int len;
            BufferedInputStream bis = new BufferedInputStream(new ByteArrayInputStream(aHTTPData.getContentBytes()));
            byte[] buf = new byte[1024];
            boolean done = false;
            boolean isAscii = true;
            while ((len = bis.read(buf, 0, buf.length)) != -1) {
                if (isAscii) {
                    isAscii = det.isAscii(buf, len);
                }
                if (isAscii || done) continue;
                done = det.DoIt(buf, len, false);
            }
            det.DataEnd();
            if (isAscii) {
                this.found = true;
                this.encoding = "ASCII";
            }
            if (!this.found) {
                det.getProbableCharsets();
                String[] probableEncoding = det.getProbableCharsets();
                if (probableEncoding.length > 0 && !this.encoding.equalsIgnoreCase(probableEncoding[0])) {
                    this.encoding = new String(probableEncoding[0]);
                }
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return this.encoding;
    }

    static {
        chinese.add("GB2312");
        chinese.add("GB18030");
        chinese.add("Big5");
        chinese.add("ISO-2022-CN");
        chinese.add("HZ-GB-2312");
        chinese.add("x-euc-tw");
        korean.add("EUC-KR");
        korean.add("ISO-2022-KR");
        japanese.add("Shift_JIS");
        japanese.add("EUC-JP");
        japanese.add("ISO-2022-JP");
    }
}

