/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.wireless.taglibs.ab;

import com.sun.addressbook.Element;
import com.sun.addressbook.Entry;
import com.sun.addressbook.Group;
import com.sun.portal.wireless.taglibs.ab.ABBaseCommandTag;
import com.sun.portal.wireless.taglibs.ab.ABContext;
import com.sun.portal.wireless.taglibs.ab.ContactDB;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.jsp.JspException;

public class ABFetchTag
extends ABBaseCommandTag {
    private Entry searchEntry = new Entry();
    private String sb = null;
    private String sd = null;
    private String any = null;
    private boolean exact = false;
    private String groupid = null;
    private String collection = null;

    public String getSb() {
        return this.sb;
    }

    public String getSd() {
        return this.sd;
    }

    public String getFn() {
        return this.searchEntry.getFn();
    }

    public String getLn() {
        return this.searchEntry.getLn();
    }

    public String getEm() {
        return this.searchEntry.getEm();
    }

    public String getBp() {
        return this.searchEntry.getBp();
    }

    public String getHp() {
        return this.searchEntry.getHp();
    }

    public String getFp() {
        return this.searchEntry.getFp();
    }

    public String getMp() {
        return this.searchEntry.getMp();
    }

    public String getPp() {
        return this.searchEntry.getPp();
    }

    public String getCn() {
        return this.searchEntry.getCn();
    }

    public String getAny() {
        return this.any;
    }

    public String getElementtype() {
        if (this.searchEntry.getElementType() == 1) {
            return "contact";
        }
        if (this.searchEntry.getElementType() == 2) {
            return "group";
        }
        if (this.searchEntry.getElementType() == 3) {
            return "all";
        }
        return "contact";
    }

    public String getGroupid() {
        return this.groupid;
    }

    public String getCollection() {
        return this.collection;
    }

    public String getExact() {
        return String.valueOf(this.exact);
    }

    public void setSb(String sb) {
        this.sb = this.evalAttribute(sb);
    }

    public void setSd(String sd) {
        this.sd = this.evalAttribute(sd);
    }

    private String getContainsSearchStr(String searchStr) {
        String fullSearchStr = this.evalAttribute(searchStr);
        if (fullSearchStr == null || fullSearchStr.equals("")) {
            fullSearchStr = "*";
        }
        return fullSearchStr;
    }

    public void setFn(String fn) {
        this.searchEntry.setFn(this.getContainsSearchStr(fn));
    }

    public void setLn(String ln) {
        this.searchEntry.setLn(this.getContainsSearchStr(ln));
    }

    public void setEm(String em) {
        this.searchEntry.setEm(this.getContainsSearchStr(em));
    }

    public void setBp(String bp) {
        this.searchEntry.setBp(this.getContainsSearchStr(bp));
    }

    public void setHp(String hp) {
        this.searchEntry.setHp(this.getContainsSearchStr(hp));
    }

    public void setFp(String fp) {
        this.searchEntry.setFp(this.getContainsSearchStr(fp));
    }

    public void setMp(String mp) {
        this.searchEntry.setMp(this.getContainsSearchStr(mp));
    }

    public void setPp(String pp) {
        this.searchEntry.setPp(this.getContainsSearchStr(pp));
    }

    public void setCn(String cn) {
        this.searchEntry.setCn(this.getContainsSearchStr(cn));
    }

    public void setAny(String any) {
        this.any = this.evalAttribute(any);
    }

    public void setElementtype(String elementtype) {
        if (this.evalAttribute(elementtype).equals("contact")) {
            this.searchEntry.setElementType(1);
        } else if (this.evalAttribute(elementtype).equals("group")) {
            this.searchEntry.setElementType(2);
        } else if (this.evalAttribute(elementtype).equals("all")) {
            this.searchEntry.setElementType(3);
        } else {
            this.searchEntry.setElementType(1);
        }
    }

    public void setGroupid(String groupid) {
        this.groupid = this.evalAttribute(groupid);
    }

    public void setCollection(String collection) {
        this.collection = this.evalAttribute(collection);
    }

    public void setExact(String exact) {
        this.exact = Boolean.valueOf(exact);
    }

    public boolean execute() throws JspException {
        ContactDB contactDB = this.getContactDB();
        Group group = null;
        if (this.sb == null) {
            this.sb = this.abContext.getSortBy();
        }
        if (this.sd == null) {
            this.sd = this.abContext.getSortOrder();
        }
        if (this.groupid != null) {
            Element tmp = this.abContext.getEntry(Integer.parseInt(this.groupid));
            if (tmp.getElementType() != 2) {
                String msg = "ABFetchTag.execute(): Group id pointing to invalid element from collection";
                ABContext.warningLog(msg);
                this.getABContext().setErrorCode("AB_005");
                return false;
            }
            group = (Group)tmp;
        }
        if (this.getFn() == null && this.getLn() == null && this.getEm() == null && this.getBp() == null && this.getHp() == null && this.getMp() == null && this.getFp() == null && this.getPp() == null && this.getCn() == null && this.any == null) {
            this.setAny("*");
        }
        List elements = null;
        if (this.any != null) {
            if (this.any.equals("")) {
                this.setAny("*");
                ABContext.warningLog("ABFetchTag: Found empty 'any' and set it to '*'");
            }
            if (this.any.indexOf("*") != -1) {
                this.exact = true;
            }
            if (this.collection == null) {
                this.collection = "entries";
            }
            if (this.collection.equals("contacts")) {
                ArrayList list = new ArrayList();
                elements = contactDB.getContacts(group, list);
            } else {
                elements = contactDB.searchABook(this.searchEntry, group, this.any, this.sb, this.sd, this.exact);
            }
        } else {
            ABContext.log("ABFetchTag.execute(): any is null ");
            if (this.collection.equals("contacts")) {
                ArrayList list = new ArrayList();
                elements = contactDB.getContacts(group, list);
            } else {
                elements = contactDB.searchABook(this.searchEntry, group, null, this.sb, this.sd, this.exact);
            }
        }
        if (elements == null) {
            ABContext.warningLog("ABFetchTag: Search address book returned null");
            this.getABContext().setErrorCode("");
            return false;
        }
        if (this.collection.equals("groupmembers")) {
            this.abContext.setGroupmembers(elements);
            this.abContext.setNumGroupmembers(elements.size());
        } else if (this.collection.equals("memberchoices")) {
            this.abContext.setMemberchoices(elements);
            this.abContext.setNumMemberchoices(elements.size());
        } else if (this.collection.equals("contacts")) {
            this.abContext.setContacts(elements);
            this.abContext.setNumContacts(elements.size());
        } else {
            this.abContext.setEntries(elements);
            this.abContext.setNumEntries(elements.size());
        }
        return true;
    }

    public void release() {
        super.release();
        this.searchEntry = null;
        this.any = null;
        this.sd = null;
        this.sb = null;
    }
}

