function $CONVERT_EXPRESSION$( aURI )
{
    var requestNetworkURI = '$INSERT_PAGE_NETWORK_URI$';
    var requestBaseURI = '$INSERT_PAGE_BASE_URI$';

    if( aURI == null ||
	'string' != ( typeof aURI ) )
    {
	return aURI;
    }

    var splitArray = psSplit( aURI );

    if( splitArray[1].length == 0 ||
        splitArray[1].indexOf( '#' ) == 0 )
    {
	return aURI;
    }

    if( psGetProtocol( splitArray[1] ).length != 0 )
    {
	var lURIObject = new URIObject( splitArray[1] );

	//absolute URL
	if( lURIObject.defaultPort.length == 0 )
	{
	    //protocol is other than 'http' or 'https'
	    return aURI;
	}
	else
	{
	    lURI = lURIObject.normalizedURI;
	}
    }
    else
    {
	//check if this starts with '/'
	if ( splitArray[1].charAt( 0 ) == '/' )
	{
	    lURI = requestNetworkURI + splitArray[1];
	}
	else
	{
	    //check if this is relative path
	    if ( ( splitArray[1].charAt( 0 ) == '.' ) ||
		 ( splitArray[1].charAt( splitArray[1].length - 1 ) == '.' ) )
	    {
	       lURI = requestBaseURI + splitArray[1];
	    }
	    else
	    {
		//this mean that URI does not start with . or / but like dir/abc.html
		lURI = requestBaseURI + splitArray[1];
	    }
	}
    }

    return splitArray[0] + lURI + splitArray[2];
}//$CONVERT_EXPRESSION$()