/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.iabs.iabsapi;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PStoreException
extends Exception {
    public static final int NO_ERROR = 0;
    public static final int CANT_OPEN_PS = 1;
    public static final int INVALID_ENTRY = 2;
    public static final int INVALID_XML = 3;
    public static final int NO_SUCH_ENTRYID = 4;
    public static final int INVALID_FILTER = 5;
    public static final int INVALID_PARAMETER = 6;
    public static final int TOO_MANY_PSEARCH = 7;
    public static final int DB_ERROR = 8;
    public static final int XML_ERROR = 9;
    public static final int REMOTE_BOOK_NOT_ALLOWED = 10;
    public static final int LOOP_DETECTED = 11;
    public static final int NOT_A_GROUP = 12;
    public static final int CANT_ADD_MEMBER_TO_ITSELF = 13;
    public static final int WILDCARD_NOT_ALLOWED = 14;
    public static final int NOT_ON_PAGE_BOUNDARY = 15;
    public static final int NO_WRITE = 16;
    public static final int QUOTA_EXCEEDED = 17;
    public static final int QUOTA_WARNING = 18;
    public static final int DUPLICATE_ENTRY = 19;
    public static final int UNKNOWN_REASON = 20;
    public static final int CLIENT_TIMEOUT = 21;
    public static final int INVALID_EMAIL_ADDRESS = 22;
    public static final int SESSION_NOT_ESTABLISHED = 23;
    public static final int DEFAULT_PSROOT_ERROR = 24;
    public static final int WABP_VERSION_MISSING = 25;
    public static final int XML_NOT_IN_ORDER = 26;
    public static final int ENTRYID_ALREADY_EXISTS = 27;
    public static final int PARAMETER_REQUIRED = 28;
    private static final int LAST_ERROR = 29;
    public static final String ELT_PSTOREEXCEPTION = "PStoreException";
    public static final String ATTR_REASON = "reason";
    public static final String ATTR_DETAILS = "details";
    private int _reason = 0;
    private String _details = "";
    private String _extra = "";
    static String[] _messageTable = new String[]{" Success", " Can't open Personal Store", " Invalid entry", " Invalid XML", " No such entryID", " The filter provided is invalid", " The parameter provided is invalid", " Too many opened paged searches", " Database error", " Error creating or manipulating XML document", "The operation takes only local books as parameters", "addGroupMember op. failed because of a loop in the group structure", "The entry is not a group", "A group/book cant be added as a member of itself", "Wilcard search not allowed on this book", "First entry not on a page boundary", "No write operation allowed on this book", "Quota exceeded", " Quota warning", " Entry already exist", " Unknown reason", " Client timeout exeeded", " Invalid email address", " Session is not established, either you haven't logged in or authentication failed due to invalid credentials.", " Unable to get default psRoot", "WABP version not configured", "XML data is not according xlate", "Entry ID already exists", "Parameter is required"};

    public PStoreException(int n) {
        super(_messageTable[n >= 0 && n <= 29 ? n : 20]);
        this._reason = n < 0 || n > 29 ? 20 : n;
    }

    public PStoreException(int n, String string) {
        super(_messageTable[n >= 0 && n <= 29 ? n : 20] + " : " + string);
        this._reason = n < 0 || n > 29 ? 20 : n;
        if (string != null) {
            this._details = string;
        }
    }

    public PStoreException(int n, String string, String string2) {
        super(_messageTable[n >= 0 && n <= 29 ? n : 20] + " : " + string);
        this._reason = n < 0 || n > 29 ? 20 : n;
        if (string != null) {
            this._details = string;
        }
        if (string2 != null) {
            this._extra = string2;
        }
    }

    public int getReason() {
        return this._reason;
    }

    public static String getDetailsForReason(int n) {
        if (n < 0 || n > 29) {
            return _messageTable[20];
        }
        return _messageTable[n];
    }

    public String getDetails() {
        return this._details;
    }

    public String getExtraDetails() {
        return this._extra;
    }

    public static Element exceptionToElement(PStoreException pStoreException, Document document) {
        Element element = document.createElement(ELT_PSTOREEXCEPTION);
        element.setAttribute(ATTR_REASON, Integer.toString(pStoreException.getReason()));
        element.setAttribute(ATTR_DETAILS, pStoreException.getDetails());
        return element;
    }

    public static PStoreException elementToException(Element element) {
        int n = 20;
        String string = "no details";
        if (!ELT_PSTOREEXCEPTION.equals(element.getTagName())) {
            return null;
        }
        string = element.getAttribute(ATTR_DETAILS);
        String string2 = element.getAttribute(ATTR_REASON);
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            string = "Illegal reason: " + string2 + string;
        }
        return new PStoreException(n, string);
    }
}

