/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.wireless.taglibs.base;

import com.iplanet.am.util.AMClientDetector;
import com.iplanet.am.util.Locale;
import com.iplanet.services.cdm.Client;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenEvent;
import com.iplanet.sso.SSOTokenID;
import com.iplanet.sso.SSOTokenListener;
import com.iplanet.sso.SSOTokenManager;
import com.sun.portal.wireless.taglibs.base.ContextCache;
import com.sun.ssoadapter.SSOAdapter;
import com.sun.ssoadapter.SSOAdapterFactory;
import com.sun.ssoadapter.config.ClientAwareUserContext;
import com.sun.ssoadapter.config.PSClientAwareContextFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;

public class Context
implements SSOTokenListener {
    protected SSOToken session = null;
    private java.util.Locale userLocale = Locale.getLocale((String)"en_US");
    private String userLocaleString = null;
    protected String charSetString = null;
    private String userLangString = null;
    private String userCountryString = null;
    private String userVariantString = null;
    protected TimeZone timezone = null;
    protected String errorCode = null;
    private String clientType = null;
    private Map serviceMap = null;
    private PSClientAwareContextFactory contextFactory = null;
    private ClientAwareUserContext userContext = null;
    protected SSOAdapter ssoAdapter = null;
    protected Context parentContext = null;

    public void init(HttpServletRequest request, SSOToken session, String serviceName, SSOAdapter ssoAdapter) throws Exception {
        this.serviceMap = new HashMap();
        this.serviceMap.put("serviceName", serviceName);
        this.contextInit(request, session, ssoAdapter);
    }

    public void init(HttpServletRequest request, SSOToken session, SSOAdapter ssoAdapter) throws Exception {
        this.contextInit(request, session, ssoAdapter);
    }

    private void contextInit(HttpServletRequest request, SSOToken session, SSOAdapter ssoAdapter) throws Exception {
        StringTokenizer localeTokens;
        this.session = session;
        session.addSSOTokenListener((SSOTokenListener)this);
        this.ssoAdapter = ssoAdapter;
        this.contextFactory = PSClientAwareContextFactory.getInstance();
        this.userContext = this.contextFactory.getClientAwareUserContext(request);
        AMClientDetector mapCD = new AMClientDetector();
        this.clientType = mapCD.getClientType(request);
        this.userLocaleString = "en_US";
        if (session != null) {
            this.userLocaleString = session.getProperty("Locale");
        }
        this.userLangString = (localeTokens = new StringTokenizer(this.userLocaleString, "_")).hasMoreTokens() ? localeTokens.nextToken() : "";
        this.userCountryString = localeTokens.hasMoreTokens() ? localeTokens.nextToken() : "";
        this.userVariantString = localeTokens.hasMoreTokens() ? localeTokens.nextToken() : "";
        this.userLocale = new java.util.Locale(this.userLangString, this.userCountryString, this.userVariantString);
        this.loadTimeZone();
    }

    public void setParentContext(Context context) {
        this.parentContext = context;
    }

    public Context getParentContext() {
        return this.parentContext;
    }

    public static Context getContext(PageContext pageContext, String contextClassName, String contextCacheClassName, String contextType) throws Exception {
        Context context = (Context)pageContext.getAttribute(contextType);
        if (context != null && Class.forName(contextClassName).isInstance(context)) {
            context.reloadUserPreferences();
            return context;
        }
        String configNameKey = contextType + "configName";
        String configName = (String)pageContext.getAttribute(configNameKey);
        HttpServletRequest request = (HttpServletRequest)pageContext.getRequest();
        SSOToken session = (SSOToken)pageContext.getAttribute("ps.session", 2);
        if (session == null) {
            SSOTokenManager tokenManager = SSOTokenManager.getInstance();
            session = tokenManager.createSSOToken(request);
            pageContext.setAttribute("ps.session", (Object)session, 2);
        }
        Class<?> contextCacheClass = Class.forName(contextCacheClassName);
        Class[] argClassArray = new Class[]{Class.forName("java.lang.String")};
        Method getInstanceMethod = contextCacheClass.getMethod("getInstance", argClassArray);
        Object[] objArray = new Object[]{contextCacheClassName};
        ContextCache contextCache = (ContextCache)getInstanceMethod.invoke(null, objArray);
        context = contextCache.get(session, configName);
        Context parentContext = null;
        if (context != null) {
            if (Class.forName(contextClassName).isInstance(context)) {
                pageContext.setAttribute(contextType, (Object)context);
                return context;
            }
            parentContext = context;
        }
        if (configName == null && parentContext != null) {
            configName = parentContext.getConfigName();
        }
        context = (Context)Class.forName(contextClassName).newInstance();
        context.setParentContext(parentContext);
        SSOAdapter ssoAdapter = (SSOAdapter)pageContext.getAttribute(contextType + "ssoAdapter");
        if (ssoAdapter == null) {
            try {
                SSOAdapterFactory ssoFactory = SSOAdapterFactory.getInstance();
                ssoAdapter = ssoFactory.getSSOAdapter(configName, request, null, null, "mapInstance");
            }
            catch (Exception ee) {
                ssoAdapter = null;
            }
        }
        context.init(request, session, ssoAdapter);
        contextCache.put(context, configName);
        pageContext.setAttribute(contextType, (Object)context);
        return context;
    }

    public void reloadUserPreferences() {
        this.loadTimeZone();
    }

    public String getAttributeString(String name) {
        return this.getAttributeString(name, null);
    }

    public String getAttributeString(String name, String value) {
        try {
            String ret = this.userContext.getStringAttribute(this.serviceMap, name);
            return ret == null ? value : ret;
        }
        catch (Exception e) {
            return value;
        }
    }

    public Set getAttributeSet(String name) {
        try {
            return this.userContext.getAttribute(this.serviceMap, name);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public SSOToken getSession() {
        return this.session;
    }

    public SSOTokenID getSessionID() {
        return this.session != null ? this.session.getTokenID() : null;
    }

    public java.util.Locale getLocale() {
        return this.userLocale;
    }

    public TimeZone getTimeZone() {
        return this.timezone;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public void ssoTokenChanged(SSOTokenEvent evt) {
    }

    public SSOAdapter getSSOAdapter() {
        return this.ssoAdapter;
    }

    public String getClientType() {
        return this.clientType;
    }

    public String getUserLocaleString() {
        return this.userLocaleString;
    }

    public java.util.Locale getUserLocale() {
        if (this.userLocale == null) {
            try {
                this.userLocale = new java.util.Locale(this.userLangString, this.userCountryString, this.userVariantString);
            }
            catch (Exception e) {
                this.userLocale = new java.util.Locale("en", "US");
            }
        }
        return this.userLocale;
    }

    public String getCharset() {
        if (this.charSetString != null) {
            return this.charSetString;
        }
        try {
            Client clientObj = Client.getInstance((String)this.getClientType());
            this.charSetString = clientObj.getCharset(this.getUserLocale());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.charSetString;
    }

    public String getContentType() {
        String contentType = null;
        try {
            Client clientObj = Client.getInstance((String)this.getClientType());
            contentType = clientObj.getProperty("contentType");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return contentType;
    }

    public String getConfigName() {
        return this.ssoAdapter.getName();
    }

    public static void reset(PageContext pageContext, String contextClassName, String contextCacheClassName, String contextType) {
        Context context = (Context)pageContext.getAttribute(contextType);
        if (context != null) {
            pageContext.removeAttribute(contextType);
        }
        String configNameKey = contextType + "configName";
        String configName = (String)pageContext.getAttribute(configNameKey);
        HttpServletRequest request = (HttpServletRequest)pageContext.getRequest();
        SSOToken session = (SSOToken)pageContext.getAttribute("ps.session", 2);
        if (session == null) {
            try {
                SSOTokenManager tokenManager = SSOTokenManager.getInstance();
                session = tokenManager.createSSOToken(request);
                pageContext.setAttribute("ps.session", (Object)session, 2);
            }
            catch (SSOException ssoe) {
                // empty catch block
            }
        }
        try {
            Class<?> contextCacheClass = Class.forName(contextCacheClassName);
            Class[] argClassArray = new Class[]{Class.forName("java.lang.String")};
            Method getInstanceMethod = contextCacheClass.getMethod("getInstance", argClassArray);
            Object[] objArray = new Object[]{contextCacheClassName};
            ContextCache contextCache = (ContextCache)getInstanceMethod.invoke(null, objArray);
            if (contextCache != null && (context = contextCache.get(session, configName)) != null) {
                contextCache.remove(context, configName);
            }
        }
        catch (ClassNotFoundException cnfe) {
        }
        catch (NoSuchMethodException nsme) {
        }
        catch (IllegalAccessException iae) {
        }
        catch (InvocationTargetException ite) {
            // empty catch block
        }
        SSOAdapter ssoAdapter = (SSOAdapter)pageContext.getAttribute(contextType + "ssoAdapter");
        if (ssoAdapter != null) {
            ssoAdapter.closeConnection();
            pageContext.removeAttribute(contextType + "ssoAdapter");
        }
    }

    public void loadTimeZone() {
        String tz = this.getAttributeString("preferredtimezone");
        this.timezone = tz != null ? TimeZone.getTimeZone(tz) : TimeZone.getDefault();
    }

    public void closeConnection() {
    }
}

