/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portlet.impl;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class PortletResource {
    private ResourceBundle _bundle = null;

    PortletResource(ResourceBundle bundle) {
        this._bundle = bundle;
    }

    public String getTitle() {
        return this.getStringProperty("javax.portlet.title");
    }

    public String getShortTitle() {
        return this.getStringProperty("javax.portlet.short-title");
    }

    public List getKeywords() {
        return this.getListProperty("javax.portlet.keywords");
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this._bundle != null) {
            String newLine = System.getProperty("line.separator");
            Enumeration<String> enumeration = this._bundle.getKeys();
            while (enumeration.hasMoreElements()) {
                String key = enumeration.nextElement();
                sb.append(key).append("=").append(this._bundle.getString(key)).append(newLine);
            }
        }
        return sb.toString();
    }

    private String getStringProperty(String key) {
        String retval = null;
        if (this._bundle != null) {
            retval = this._bundle.getString(key);
        }
        return retval;
    }

    private List getListProperty(String key) {
        ArrayList<String> retval = new ArrayList<String>();
        String strValue = this.getStringProperty(key);
        if (strValue != null) {
            StringTokenizer st = new StringTokenizer(strValue, ",", false);
            while (st.hasMoreTokens()) {
                String keyword = st.nextToken().trim();
                retval.add(keyword);
            }
        }
        return retval;
    }
}

