/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers.mailcheck;

import com.sun.identity.security.DecryptAction;
import com.sun.portal.desktop.util.I18n;
import com.sun.portal.desktop.util.Integers;
import com.sun.portal.desktop.util.Password;
import com.sun.portal.desktop.util.Target;
import com.sun.portal.providers.ProfileProviderAdapter;
import com.sun.portal.providers.ProviderException;
import com.sun.portal.providers.context.ProviderContextException;
import java.net.URL;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.mail.AuthenticationFailedException;
import javax.mail.Folder;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class MailCheckProvider
extends ProfileProviderAdapter {
    private ResourceBundle bundle = null;
    private static final String IMAP_SERVER_NAME = "IMAPServerName";
    private static final String IMAP_USER_ID = "IMAPUserId";
    private static final String IMAP_PASSWORD = "IMAPPassword";
    private String UnreadMessages = "";

    public void init(String n, HttpServletRequest req) throws ProviderException {
        super.init(n, req);
    }

    public StringBuffer getContent(HttpServletRequest req, HttpServletResponse res) throws ProviderException {
        StringBuffer content = new StringBuffer();
        Hashtable<String, Object> tagTable = new Hashtable<String, Object>();
        String server = "";
        String user = "";
        String pass = "";
        ArrayList userApps = null;
        ArrayList targets = null;
        boolean configParameters = this.getBooleanProperty("defaultConfigParameters");
        if (configParameters) {
            server = this.getStringAttribute("sunPortalNetmailIMAPServerName");
            user = this.getStringAttribute("sunPortalNetmailIMAPUserid");
            String encrypted = this.getStringAttribute("sunPortalNetmailIMAPPassword");
            pass = encrypted == null || encrypted.length() == 0 ? encrypted : (String)AccessController.doPrivileged(new DecryptAction(encrypted));
        } else {
            server = this.getStringProperty(IMAP_SERVER_NAME);
            user = this.getStringProperty(IMAP_USER_ID);
            String encoded = this.getStringProperty(IMAP_PASSWORD);
            pass = encoded == null || encoded.length() == 0 ? encoded : Password.decode((String)encoded);
        }
        if (this.getProviderContext().isDebugMessageEnabled()) {
            this.getProviderContext().debugMessage("MailCheckProvider.getContent(): server=" + server);
            this.getProviderContext().debugMessage("MailCheckProvider.getContent(): user=" + user);
            this.getProviderContext().debugMessage("MailCheckProvider.getContent(): pass=" + pass);
        }
        tagTable = this.getMailStatus(server, user, pass);
        Integer status = Integers.get((int)4);
        if (tagTable.isEmpty()) {
            tagTable = new Hashtable<String, Object>();
            tagTable.put("Status", status);
        } else {
            status = (Integer)tagTable.get("Status");
        }
        String color = null;
        String msg = null;
        String serverNotSet = null;
        String userNotSet = null;
        String passwordNotSet = null;
        boolean emptyCheck = false;
        if (this.bundle == null) {
            this.bundle = this.getResourceBundle();
        }
        switch (status) {
            case 0: {
                color = this.bundle.getString("okColor");
                msg = this.bundle.getString("alive");
                break;
            }
            case 1: {
                color = this.bundle.getString("errorColor");
                msg = this.bundle.getString("notResponding");
                break;
            }
            case 2: {
                color = this.bundle.getString("warningColor");
                msg = this.bundle.getString("invalidUsernamePassword");
                break;
            }
            case 3: {
                color = this.bundle.getString("warningColor");
                tagTable.put("mailStatColor", color);
                StringBuffer mailCheckErrorMessages = new StringBuffer();
                mailCheckErrorMessages.append("<TABLE WIDTH=\"100%\">\n");
                serverNotSet = (String)tagTable.get("serverNotSet");
                if (serverNotSet != null) {
                    mailCheckErrorMessages.append("<TR><TD><FONT FACE=\"[tag:fontFace1]\" COLOR=\"[tag:mailStatColor]\" SIZE=\"-1\">\n");
                    mailCheckErrorMessages.append(serverNotSet);
                    mailCheckErrorMessages.append("</FONT></TD></TR>\n");
                }
                if ((userNotSet = (String)tagTable.get("userNotSet")) != null) {
                    mailCheckErrorMessages.append("<TR><TD><FONT FACE=\"[tag:fontFace1]\" COLOR=\"[tag:mailStatColor]\" SIZE=\"-1\">\n");
                    mailCheckErrorMessages.append(userNotSet);
                    mailCheckErrorMessages.append("</FONT></TD></TR>\n");
                }
                if ((passwordNotSet = (String)tagTable.get("passwordNotSet")) != null) {
                    mailCheckErrorMessages.append("<TR><TD><FONT FACE=\"[tag:fontFace1]\" COLOR=\"[tag:mailStatColor]\" SIZE=\"-1\">\n");
                    mailCheckErrorMessages.append(passwordNotSet);
                    mailCheckErrorMessages.append("</FONT></TD></TR>\n");
                }
                mailCheckErrorMessages.append("</TABLE>");
                tagTable.put("mailCheckErrorMessages", mailCheckErrorMessages.toString());
                emptyCheck = true;
                break;
            }
            default: {
                color = this.bundle.getString("errorColor");
                msg = this.bundle.getString("MailCheckProvider");
            }
        }
        if (!emptyCheck) {
            tagTable.put("mailStatColor", color);
            StringBuffer mailCheckContents = new StringBuffer();
            mailCheckContents.append("<TABLE WIDTH=\"100%\">\n");
            mailCheckContents.append("<TR><TD><FONT FACE=\"[tag:fontFace1]\" COLOR=\"[tag:mailStatColor]\" SIZE=\"-1\">\n");
            mailCheckContents.append(msg);
            mailCheckContents.append("</FONT></TD></TR>\n");
            if (status == 0) {
                mailCheckContents.append("<TR><TD><FONT FACE=\"[tag:fontFace1]\" COLOR=\"\" SIZE=\"-1\">\n");
                mailCheckContents.append(this.UnreadMessages);
                mailCheckContents.append("</FONT></TD></TR>\n");
                if (configParameters) {
                    try {
                        userApps = new ArrayList(this.getProviderContext().getCollectionProperty(this.getName(), "userApps", true).values());
                        targets = new ArrayList(this.getProviderContext().getCollectionProperty(this.getName(), "targets", true).values());
                    }
                    catch (ProviderContextException pce) {
                        throw new ProviderException("MailCheckProvider.getContent(): Error getting app properties", pce);
                    }
                    StringBuffer link_content = new StringBuffer();
                    if (userApps.size() >= 1) {
                        link_content.append("<TABLE CELLPADDING=1 CELLSPACING=0 WIDTH=\"100%\"><TR><TD><FONT FACE=\"[tag:fontFace1]\" SIZE=\"+0\">\n");
                    }
                    for (int i = 0; i < targets.size(); ++i) {
                        String targ = (String)targets.get(i);
                        Target target = new Target(targ);
                        StringTokenizer tok = new StringTokenizer(target.getValue(), "^");
                        String url = (String)tok.nextElement();
                        StringBuffer onClick = new StringBuffer();
                        if (tok.hasMoreElements()) {
                            onClick.append((String)tok.nextElement());
                        }
                        if (!userApps.contains(target.getName())) continue;
                        StringBuffer windowName = new StringBuffer();
                        StringTokenizer tokens = new StringTokenizer(target.getName(), " (),=+#[]@<>$%./!");
                        while (tokens.hasMoreTokens()) {
                            windowName.append(tokens.nextToken());
                            if (!tokens.hasMoreElements()) continue;
                            windowName.append("_");
                        }
                        StringBuffer winTarget = new StringBuffer().append(" TARGET=\"").append(windowName.toString()).append("\"");
                        if (onClick == null) {
                            onClick.append("openAppURL('").append(url).append("', '").append(windowName).append("'); return false;");
                        }
                        StringBuffer theHref = new StringBuffer().append("<A HREF=\"").append(url).append("\"").append(winTarget.toString()).append(" onClick=\"").append(onClick).append("\">").append(target.getName()).append("</A><BR>");
                        String appBG = this.bundle.getString("appBackground");
                        link_content.append("<TR><TD BGCOLOR=\"").append(appBG).append("\">").append("<FONT FACE=\"[tag:fontFace1]\" ").append("SIZE=\"-1\">").append(theHref.toString()).append("</FONT></TD></TR>");
                    }
                    if (userApps.size() >= 1) {
                        link_content.append("</TABLE>");
                    }
                    tagTable.put("apps", link_content.toString());
                    tagTable.put("fontFace1", this.getStringProperty("fontFace1"));
                    mailCheckContents.append("<TR><TD><FONT FACE=\"[tag:fontFace1]\" COLOR=\"[tag:mailStatColor]\" SIZE=\"-1\">\n");
                    mailCheckContents.append(link_content.toString());
                    mailCheckContents.append("</FONT></TD></TR>\n");
                }
            }
            mailCheckContents.append("</TABLE>");
            tagTable.put("mailCheckContents", mailCheckContents.toString());
        }
        content = this.getTemplate("display.template", tagTable);
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Hashtable getMailStatus(String mailsrvr, String user, String password) throws ProviderException {
        Hashtable<String, Object> passMailStatus = new Hashtable<String, Object>();
        passMailStatus.put("mailStatColor", "");
        passMailStatus.put("mailCount", "");
        String mbox = "INBOX";
        if (this.bundle == null) {
            this.bundle = this.getResourceBundle();
        }
        String mailCountMessage = this.bundle.getString("unreadMessages");
        Session session = null;
        Store store = null;
        boolean checkEmpty = false;
        if (mailsrvr == null || mailsrvr.length() == 0) {
            passMailStatus.put("serverNotSet", this.bundle.getString("serverNotSet"));
            checkEmpty = true;
        }
        if (user == null || user.length() == 0) {
            passMailStatus.put("userNotSet", this.bundle.getString("userNotSet"));
            checkEmpty = true;
        }
        if (password == null || password.length() == 0) {
            passMailStatus.put("passwordNotSet", this.bundle.getString("passwordNotSet"));
            checkEmpty = true;
        }
        if (checkEmpty) {
            Integer stat = Integers.get((int)3);
            passMailStatus.put("Status", stat);
            return passMailStatus;
        }
        try {
            try {
                Properties props = System.getProperties();
                props.put("mail.host", mailsrvr);
                props.put("mail.user", user);
                session = Session.getInstance((Properties)props, null);
                store = session.getStore("imap");
                store.connect(mailsrvr, user, password);
                Folder folder = store.getFolder(mbox);
                int totalUnreadMessages = folder.getUnreadMessageCount();
                String unreadPattern = this.bundle.getString("unreadMessages");
                this.UnreadMessages = I18n.format((String)unreadPattern, (Integer)Integers.get((int)totalUnreadMessages), (Locale)this.getProviderContext().getLocale());
                Integer stat = Integers.get((int)0);
                passMailStatus.put("Status", stat);
                store.close();
                Hashtable<String, Object> hashtable = passMailStatus;
                Object var17_21 = null;
            }
            catch (AuthenticationFailedException a) {
                Integer stat = Integers.get((int)2);
                passMailStatus.put("Status", stat);
                if (this.getProviderContext().isDebugMessageEnabled()) {
                    this.getProviderContext().debugMessage("MailCheckProvider.getMailStatus()", a);
                }
                Object var17_22 = null;
                try {
                    if (store == null) return passMailStatus;
                    store.close();
                    return passMailStatus;
                }
                catch (MessagingException me2) {
                    this.getProviderContext().debugError("MailCheckProvider.getMailStatus()", me2);
                    throw new ProviderException("error closing mail store", me2);
                }
            }
            catch (MessagingException me) {
                Integer stat = Integers.get((int)1);
                passMailStatus.put("Status", stat);
                if (this.getProviderContext().isDebugMessageEnabled()) {
                    this.getProviderContext().debugMessage("MailCheckProvider.getMailStatus()", me);
                }
                Object var17_23 = null;
                try {}
                catch (MessagingException me2) {
                    this.getProviderContext().debugError("MailCheckProvider.getMailStatus()", me2);
                    throw new ProviderException("error closing mail store", me2);
                }
                if (store == null) return passMailStatus;
                store.close();
                return passMailStatus;
            }
        }
        catch (Throwable throwable) {
            Object var17_24 = null;
            try {}
            catch (MessagingException me2) {
                this.getProviderContext().debugError("MailCheckProvider.getMailStatus()", me2);
                throw new ProviderException("error closing mail store", me2);
            }
            if (store == null) return passMailStatus;
            store.close();
            return passMailStatus;
        }
        try {}
        catch (MessagingException me2) {
            this.getProviderContext().debugError("MailCheckProvider.getMailStatus()", me2);
            throw new ProviderException("error closing mail store", me2);
        }
        if (store == null) return passMailStatus;
        store.close();
        return passMailStatus;
    }

    public StringBuffer getEdit(HttpServletRequest req, HttpServletResponse res) throws ProviderException {
        StringBuffer content = new StringBuffer();
        Hashtable<String, String> tagTable = new Hashtable<String, String>();
        tagTable.put("fontFace1", this.getStringProperty("fontFace1"));
        tagTable.put(IMAP_SERVER_NAME, this.getStringProperty(IMAP_SERVER_NAME));
        tagTable.put(IMAP_USER_ID, this.getStringProperty(IMAP_USER_ID));
        tagTable.put(IMAP_PASSWORD, this.getStringProperty(IMAP_PASSWORD));
        content = this.getTemplate("edit.template", tagTable);
        return content;
    }

    public URL processEdit(HttpServletRequest req, HttpServletResponse res) throws ProviderException {
        String pass;
        String user;
        this.getProviderContext().contentChanged(this.getName());
        String server = req.getParameter(IMAP_SERVER_NAME);
        if (server == null) {
            server = "";
        }
        if ((user = req.getParameter(IMAP_USER_ID)) == null) {
            user = "";
        }
        if ((pass = req.getParameter(IMAP_PASSWORD)) == null) {
            pass = "";
        }
        if (!server.equals(this.getStringProperty(IMAP_SERVER_NAME))) {
            this.setStringProperty(IMAP_SERVER_NAME, server);
        }
        if (!user.equals(this.getStringProperty(IMAP_USER_ID))) {
            this.setStringProperty(IMAP_USER_ID, user);
        }
        if (!pass.equals(this.getStringProperty(IMAP_PASSWORD))) {
            if (pass.length() == 0) {
                this.setStringProperty(IMAP_PASSWORD, pass);
            } else {
                this.setStringProperty(IMAP_PASSWORD, Password.encode((String)pass));
            }
        }
        return null;
    }
}

