/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers.context;

import com.sun.portal.providers.context.PropertiesFilter;
import com.sun.portal.providers.context.PropertiesFilterException;
import com.sun.portal.providers.context.PropertiesFilterFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;

public class LocalePropertiesFilter
extends PropertiesFilter {
    public String getCondition() {
        return "locale";
    }

    public boolean match(String condition, String value) {
        return condition.toLowerCase().equals("locale") && this.getValue().equals(value);
    }

    public static List getLocalePropertiesFilters(Locale locale, boolean required) throws PropertiesFilterException {
        if (locale == null) {
            return null;
        }
        String localeString = locale.toString();
        if (localeString == null) {
            return null;
        }
        ArrayList<PropertiesFilter> pflist = new ArrayList<PropertiesFilter>();
        StringTokenizer tokenizer = new StringTokenizer(localeString, "_");
        while (tokenizer.hasMoreTokens()) {
            PropertiesFilter pf = PropertiesFilterFactory.get("com.sun.portal.providers.context.LocalePropertiesFilter", tokenizer.nextToken(), required);
            pflist.add(pf);
        }
        return pflist;
    }

    public static Locale getLocale(List pflist) throws PropertiesFilterException {
        String lang = "";
        String country = "";
        String variant = "";
        Iterator i = pflist.iterator();
        PropertiesFilter pf = (PropertiesFilter)i.next();
        while (!(pf instanceof LocalePropertiesFilter)) {
            if (pf.isRequired()) {
                return null;
            }
            if (i.hasNext()) {
                pf = (PropertiesFilter)i.next();
                continue;
            }
            return null;
        }
        lang = pf.getValue();
        if (i.hasNext()) {
            pf = (PropertiesFilter)i.next();
            if (pf instanceof LocalePropertiesFilter) {
                country = pf.getValue();
            } else if (pf.isRequired()) {
                return null;
            }
        }
        if (i.hasNext()) {
            pf = (PropertiesFilter)i.next();
            if (pf instanceof LocalePropertiesFilter) {
                variant = pf.getValue();
            } else if (pf.isRequired()) {
                return null;
            }
        }
        return new Locale(lang, country, variant);
    }
}

