/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.util;

import com.sun.portal.desktop.DesktopException;
import com.sun.portal.desktop.util.I18n;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class ParameterMap
extends HashMap {
    public ParameterMap(Map p) {
        super(p);
    }

    public ParameterMap(String charset, HttpServletRequest req) throws DesktopException {
        this(charset, req, false);
    }

    public ParameterMap(String charset, HttpServletRequest req, boolean readFromParameters) throws DesktopException {
        Hashtable<String, String[]> data = null;
        if (readFromParameters) {
            Enumeration e = req.getParameterNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                String[] val = new String[]{req.getParameter(name)};
                this.put(name, val);
            }
        } else if (req.getMethod().equalsIgnoreCase("POST") || req.getMethod().equalsIgnoreCase("GET")) {
            data = new Hashtable<String, String[]>();
            Enumeration enumReq = req.getParameterNames();
            while (enumReq.hasMoreElements()) {
                String key = (String)enumReq.nextElement();
                String[] val = req.getParameterValues(key);
                data.put(key, val);
            }
        }
        if (data != null) {
            this.putAll(data);
            this.decodeParams(charset);
        }
    }

    private void decodeParams(String charset) {
        Iterator i = this.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            Object o = this.get(key);
            if (!(o instanceof String[])) continue;
            String[] vals = (String[])o;
            for (int j = 0; j < vals.length; ++j) {
                vals[j] = I18n.decodeCharset(vals[j], charset);
            }
        }
    }

    public String getString(String key) {
        String[] array = (String[])this.get(key);
        if (array == null || array.length == 0) {
            return null;
        }
        String val = array[0];
        return val;
    }

    public int getInt(String key) throws NumberFormatException {
        String[] array = (String[])this.get(key);
        if (array == null || array.length == 0) {
            throw new NumberFormatException("null parameter");
        }
        return Integer.parseInt(array[0]);
    }

    public boolean getBoolean(String key) {
        String[] array = (String[])this.get(key);
        if (array == null || array.length == 0) {
            return false;
        }
        boolean val = Boolean.valueOf(array[0]);
        return val;
    }

    public String[] getArray(String key) {
        String[] val = (String[])this.get(key);
        return val;
    }

    public String[] putArray(String key, String[] val) {
        String[] old = this.getArray(key);
        this.put(key, val);
        return old;
    }

    public String putString(String key, String val) {
        String old = this.getString(key);
        String[] arrayVal = new String[]{val};
        this.putArray(key, arrayVal);
        return old;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("{ ");
        Iterator i = this.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            String[] val = this.getArray(key);
            s.append("[ ");
            for (int j = 0; j < val.length; ++j) {
                s.append(key).append("=").append(I18n.print(val[j])).append(" ");
            }
            s.append("] ");
        }
        s.append("}");
        return s.toString();
    }
}

