/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.util;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.security.AccessController;
import sun.security.action.GetPropertyAction;

public class NSPrintWriter
extends PrintWriter {
    protected Writer out;
    private boolean autoFlush = false;
    private boolean trouble = false;
    private String lineSeparator;

    public NSPrintWriter(Writer out) {
        this(out, false);
    }

    public NSPrintWriter(Writer out, boolean autoFlush) {
        super(out);
        this.out = out;
        this.autoFlush = autoFlush;
        this.lineSeparator = AccessController.doPrivileged(new GetPropertyAction("line.separator"));
    }

    public NSPrintWriter(OutputStream out) {
        this(out, false);
    }

    public NSPrintWriter(OutputStream out, boolean autoFlush) {
        this(new BufferedWriter(new OutputStreamWriter(out)), autoFlush);
    }

    private void ensureOpen() throws IOException {
        if (this.out == null) {
            throw new IOException("Stream closed");
        }
    }

    public void flush() {
        try {
            this.ensureOpen();
            this.out.flush();
        }
        catch (IOException x) {
            this.trouble = true;
        }
    }

    public void close() {
        try {
            if (this.out == null) {
                return;
            }
            this.out.close();
            this.out = null;
        }
        catch (IOException x) {
            this.trouble = true;
        }
    }

    public boolean checkError() {
        if (this.out != null) {
            this.flush();
        }
        return this.trouble;
    }

    protected void setError() {
        this.trouble = true;
    }

    public void write(int c) {
        try {
            this.ensureOpen();
            this.out.write(c);
        }
        catch (InterruptedIOException x) {
            Thread.currentThread().interrupt();
        }
        catch (IOException x) {
            this.trouble = true;
        }
    }

    public void write(char[] buf, int off, int len) {
        try {
            this.ensureOpen();
            this.out.write(buf, off, len);
        }
        catch (InterruptedIOException x) {
            Thread.currentThread().interrupt();
        }
        catch (IOException x) {
            this.trouble = true;
        }
    }

    public void write(char[] buf) {
        this.write(buf, 0, buf.length);
    }

    public void write(String s, int off, int len) {
        try {
            this.ensureOpen();
            this.out.write(s, off, len);
        }
        catch (InterruptedIOException x) {
            Thread.currentThread().interrupt();
        }
        catch (IOException x) {
            this.trouble = true;
        }
    }

    public void write(String s) {
        this.write(s, 0, s.length());
    }

    private void newLine() {
        try {
            this.ensureOpen();
            this.out.write(this.lineSeparator);
            if (this.autoFlush) {
                this.out.flush();
            }
        }
        catch (InterruptedIOException x) {
            Thread.currentThread().interrupt();
        }
        catch (IOException x) {
            this.trouble = true;
        }
    }

    public void print(boolean b) {
        this.write(b ? "true" : "false");
    }

    public void print(char c) {
        this.write(String.valueOf(c));
    }

    public void print(int i) {
        this.write(String.valueOf(i));
    }

    public void print(long l) {
        this.write(String.valueOf(l));
    }

    public void print(float f) {
        this.write(String.valueOf(f));
    }

    public void print(double d) {
        this.write(String.valueOf(d));
    }

    public void print(char[] s) {
        this.write(s);
    }

    public void print(String s) {
        if (s == null) {
            s = "null";
        }
        this.write(s);
    }

    public void print(Object obj) {
        this.write(String.valueOf(obj));
    }

    public void println() {
        this.newLine();
    }

    public void println(boolean x) {
        this.print(x);
        this.println();
    }

    public void println(char x) {
        this.print(x);
        this.println();
    }

    public void println(int x) {
        this.print(x);
        this.println();
    }

    public void println(long x) {
        this.print(x);
        this.println();
    }

    public void println(float x) {
        this.print(x);
        this.println();
    }

    public void println(double x) {
        this.print(x);
        this.println();
    }

    public void println(char[] x) {
        this.print(x);
        this.println();
    }

    public void println(String x) {
        this.print(x);
        this.println();
    }

    public void println(Object x) {
        this.print(x);
        this.println();
    }
}

