/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.template;

import com.sun.portal.desktop.DesktopError;
import com.sun.portal.desktop.DesktopRequestThreadLocalizer;
import com.sun.portal.desktop.context.DesktopAppContext;
import com.sun.portal.desktop.context.DesktopAppContextThreadLocalizer;
import com.sun.portal.desktop.template.ParsedTagArray;
import com.sun.portal.desktop.template.ParsedTagElement;
import com.sun.portal.desktop.util.NSStringBuffer;
import com.sun.portal.providers.context.ContainerProviderContext;
import com.sun.portal.providers.context.ProviderContextException;
import java.util.Hashtable;
import javax.servlet.http.HttpServletRequest;

public class TagSwapper {
    private static DesktopAppContext dac = null;

    public static StringBuffer doSwap(StringBuffer inBuffer, Hashtable aTagTable, String sContent, String channel, ContainerProviderContext pc) {
        if (inBuffer == null) {
            return inBuffer;
        }
        ParsedTagArray pta = new ParsedTagArray(inBuffer);
        return TagSwapper.doSwapFromParsedTagArray(pta, pc, channel, sContent, aTagTable);
    }

    private static String getPropertyValue(String channel, ContainerProviderContext pc, String key) {
        if (!pc.existsChannel(channel)) {
            return null;
        }
        try {
            if (!pc.existsStringProperty(channel, key)) {
                return null;
            }
            String value = pc.getStringProperty(channel, key);
            return value;
        }
        catch (ProviderContextException pce) {
            pc.debugError("TagSwapper.getPropertyValue(): channel " + channel + " key " + key, pce);
            return null;
        }
    }

    private static String getAttributeValue(ContainerProviderContext pc, String key) {
        String value = pc.getStringAttribute(key);
        return value;
    }

    public static StringBuffer doSwapFromParsedTagArray(ParsedTagArray pta, ContainerProviderContext pc, String channel, String sContent, Hashtable aTagTable) {
        if (pta == null) {
            return null;
        }
        if (aTagTable == null) {
            return pta.getTemplateSB();
        }
        StringBuffer outBuffer = new StringBuffer(pta.getStaticLength() + pta.getNumberTags() * 100);
        int numpte = pta.size();
        if (numpte == 0) {
            return outBuffer;
        }
        String dtURL = null;
        for (int i = 0; i < numpte; ++i) {
            ParsedTagElement pte = pta.get(i);
            String key = pte.getKey();
            TagSwapper.doTags(pc, channel, sContent, aTagTable, pte, key, outBuffer, dtURL);
        }
        return outBuffer;
    }

    private static void doTags(ContainerProviderContext pc, String channel, String sContent, Hashtable aTagTable, ParsedTagElement pte, String key, StringBuffer outBuffer, String dtURL) {
        switch (pte.getType()) {
            case 0: {
                outBuffer.append(key);
                break;
            }
            case 1: {
                Object value = aTagTable.get(key);
                if (value == null && pte.getDefault() != null) {
                    ParsedTagElement dElement = pte.getDefault();
                    TagSwapper.doTags(pc, channel, sContent, aTagTable, dElement, dElement.getKey(), outBuffer, dtURL);
                }
                if (value == null && pc != null) {
                    value = TagSwapper.getPropertyValue(channel, pc, key);
                }
                if (value == null && pc != null) {
                    value = TagSwapper.getAttributeValue(pc, key);
                }
                if (value != null) {
                    String valueStr = value.toString();
                    if (value instanceof NSStringBuffer) {
                        outBuffer.append(valueStr);
                        break;
                    }
                    StringBuffer tagValue = new StringBuffer(valueStr);
                    outBuffer.append(TagSwapper.doSwapFromParsedTagArray(new ParsedTagArray(tagValue), pc, channel, sContent, aTagTable));
                    break;
                }
                if (!pc.isDebugWarningEnabled()) break;
                pc.debugWarning("TagSwapper.doSwapFromParsedTagArray(): tag value unavailable: " + key);
                break;
            }
            case 2: {
                String encodedURL = null;
                encodedURL = pc != null ? pc.encodeURL(key) : key;
                outBuffer.append(encodedURL);
                break;
            }
            case 3: {
                outBuffer.append(sContent);
                outBuffer.append(key);
                break;
            }
            case 4: {
                if (dtURL == null) {
                    HttpServletRequest req = DesktopRequestThreadLocalizer.getRequest();
                    dtURL = pc != null ? pc.getDesktopURL(req) : dac.getDesktopURL(req);
                }
                outBuffer.append(dtURL);
                break;
            }
            default: {
                throw new DesktopError("TagSwapper.doSwapFromParsedTagArray(): invalid ParsedTagElement type");
            }
        }
    }

    static {
        dac = DesktopAppContextThreadLocalizer.get();
    }
}

