/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.dp.xml;

import com.sun.portal.desktop.PerfThreadLocalizer;
import com.sun.portal.desktop.context.DPContext;
import com.sun.portal.desktop.dp.DPBoolean;
import com.sun.portal.desktop.dp.DPChannel;
import com.sun.portal.desktop.dp.DPCollection;
import com.sun.portal.desktop.dp.DPConditionalProperties;
import com.sun.portal.desktop.dp.DPError;
import com.sun.portal.desktop.dp.DPInteger;
import com.sun.portal.desktop.dp.DPLocale;
import com.sun.portal.desktop.dp.DPProperties;
import com.sun.portal.desktop.dp.DPProperty;
import com.sun.portal.desktop.dp.DPPropertyHolder;
import com.sun.portal.desktop.dp.DPProvider;
import com.sun.portal.desktop.dp.DPRoot;
import com.sun.portal.desktop.dp.DPString;
import com.sun.portal.desktop.dp.xml.RankedDPProperty;
import com.sun.portal.desktop.dp.xml.XMLDPCollection;
import com.sun.portal.desktop.dp.xml.XMLDPConditionalProperties;
import com.sun.portal.desktop.dp.xml.XMLDPFactory;
import com.sun.portal.desktop.dp.xml.XMLDPLocale;
import com.sun.portal.desktop.dp.xml.XMLDPObject;
import com.sun.portal.desktop.dp.xml.XMLDPProperty;
import com.sun.portal.desktop.dp.xml.XMLDPTags;
import com.sun.portal.providers.context.LocalePropertiesFilter;
import com.sun.portal.providers.context.PropertiesFilter;
import com.sun.portal.providers.context.PropertiesFilterException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLDPProperties
extends XMLDPCollection
implements DPProperties,
XMLDPTags {
    private Element holderElement = null;

    XMLDPProperties(DPContext dpc, DPRoot r, Document d) {
        super(dpc, r, XMLDPProperties.createElement(dpc, d));
    }

    XMLDPProperties(DPContext dpc, DPRoot r, Element e) {
        super(dpc, r, e);
    }

    public DPProperty getParentProperty() {
        return null;
    }

    Element getPropertyHolderElement() {
        if (this.holderElement == null) {
            Element e = this.getElement();
            while (e.getTagName().equals("ConditionalProperties")) {
                e = (Element)e.getParentNode();
            }
            Node parentNode = e.getParentNode();
            if (parentNode == null) {
                throw new DPError("XMLDPProperties.getPropertyHolderElement(): could not get parent node");
            }
            if (parentNode.getNodeType() != 1) {
                throw new DPError("XMLDPProperties.getPropertyHolderElement(): parent node was not an element");
            }
            this.holderElement = (Element)parentNode;
        }
        return this.holderElement;
    }

    protected DPPropertyHolder getPropertyHolderFromThis() {
        Element holderElement = this.getPropertyHolderElement();
        DPPropertyHolder holder = (DPPropertyHolder)this.getObject(holderElement);
        if (holder == null) {
            holder = XMLDPFactory.getInstance().getPropertyHolder(this.getContext(), this.getRoot(), holderElement);
            this.putObject(holder);
        }
        return holder;
    }

    protected DPPropertyHolder getPropertyHolder() {
        DPPropertyHolder holder = this.getPropertyHolderFromThis();
        if (holder == null || !holder.isMerged()) {
            Iterator i = this.getMergers().iterator();
            while (i.hasNext()) {
                DPProperties dpp = (DPProperties)i.next();
                DPPropertyHolder dpph = ((XMLDPProperties)dpp).getPropertyHolderFromThis();
                holder.addMerger(dpph);
            }
        }
        return holder;
    }

    public short getType() {
        return 7;
    }

    public String getTag() {
        return "Properties";
    }

    public DPProperty add(DPProperty dpp, List pflist) {
        return this.add(dpp, true, true, false, pflist);
    }

    DPProperty add(DPProperty dpp, boolean copy, boolean deep, boolean dummy, List pflist) {
        if (pflist == null || pflist.size() == 0) {
            return this.add(dpp, copy, deep, dummy);
        }
        PropertiesFilter pf = (PropertiesFilter)pflist.get(0);
        String condition = null;
        String conditionValue = null;
        try {
            condition = pf.getCondition();
            conditionValue = pf.getValue();
        }
        catch (PropertiesFilterException pfe) {
            throw new DPError("XMLDPProperties.add(): cannot access pf=" + pf, pfe);
        }
        DPConditionalProperties dptp = this.getConditionalPropertiesFromThis(condition, conditionValue);
        if (dptp == null) {
            dptp = XMLDPFactory.getInstance().createConditionalProperties(this.getContext(), this.getRoot(), this.getDocument(), condition, conditionValue);
            dptp = (DPConditionalProperties)this.add(dptp, false, false, dummy);
        }
        return ((XMLDPConditionalProperties)dptp).add(dpp, copy, deep, dummy, pflist.subList(1, pflist.size()));
    }

    public DPProperty get(String key) {
        return this.get(key, null, true, true);
    }

    public DPProperty get(String key, boolean scoped) {
        return this.get(key, null, true, scoped);
    }

    public DPProperty get(String key, List pflist, boolean exact) {
        return this.get(key, pflist, exact, true);
    }

    public DPProperty get(String key, List pflist, boolean exact, boolean scoped) {
        DPProperties dpProperties;
        boolean filtered;
        DPProperty dpp = null;
        boolean bl = filtered = pflist != null && pflist.size() > 0;
        if (filtered) {
            int j = PerfThreadLocalizer.mark();
            dpp = this.getConditional(key, pflist, exact);
            PerfThreadLocalizer.add(j, "XMLDPProperties.get(): getConditional():");
            if (dpp != null) {
                return dpp;
            }
            if (!exact) {
                Locale locale = null;
                try {
                    locale = LocalePropertiesFilter.getLocale(pflist);
                }
                catch (PropertiesFilterException pfe) {
                    throw new DPError("XMLDPProperties.get(): cannot get locale.  pflist=" + pflist);
                }
                if (locale != null) {
                    int i = PerfThreadLocalizer.mark();
                    DPLocale dpLocale = this.getLocale(locale, exact);
                    PerfThreadLocalizer.add(i, "XMLDPProperties.get(): getLocale():");
                    if (dpLocale != null && (dpp = dpLocale.get(key)) != null) {
                        return dpp;
                    }
                }
            }
        }
        if (!(filtered && exact || (dpp = super.get(key)) == null)) {
            return dpp;
        }
        if (!scoped) {
            return null;
        }
        DPPropertyHolder dpph = this.getPropertyHolder();
        if (!(dpph instanceof DPChannel)) {
            return null;
        }
        DPChannel dpc = (DPChannel)dpph;
        DPProvider dpProvider = dpc.getProvider();
        if (dpProvider != null && (dpp = (dpProperties = dpProvider.getProperties()).get(key, pflist, exact)) != null) {
            return dpp;
        }
        DPPropertyHolder parentDPPH = dpph.getParentPropertyHolder();
        if (parentDPPH == null) {
            return null;
        }
        dpp = parentDPPH.getProperties().get(key, pflist, exact);
        return dpp;
    }

    public void set(String key, Object val, List pflist) {
        DPProperty oldProperty = this.get(key, pflist, false);
        if (oldProperty == null) {
            throw new DPError("XMLDPProperties.set(): property does not exist name=" + key + ", pflist=" + pflist);
        }
        DPProperty newProperty = null;
        if (!oldProperty.isPropagate()) {
            newProperty = oldProperty;
            newProperty.setPropagate(false);
        } else if (!this.isPropertyFromThis(oldProperty)) {
            DPProperties dpp = oldProperty.getProperties();
            List pflistMatched = ((XMLDPProperties)dpp).getMatchedPropertiesFilters(key, pflist);
            newProperty = this.add(oldProperty, pflistMatched);
        } else {
            newProperty = oldProperty;
        }
        newProperty.setValue(val);
    }

    List getMatchedPropertiesFilters(String key, List pflist) {
        RankedDPProperty rdp = this.getBestRanked(key, pflist, false, 0, null);
        List pflistMatched = null;
        pflistMatched = pflist != null && pflist.size() > 0 ? pflist.subList(0, rdp.rank) : pflist;
        return pflistMatched;
    }

    public DPProperty getConditional(String key, List pflist, boolean exact) {
        RankedDPProperty rdp = this.getBestRanked(key, pflist, exact, 0, null);
        return rdp.dpProperty;
    }

    private RankedDPProperty getBestRanked(String key, List pflist, boolean exact, int rank, DPProperty defDPProperty) {
        if (pflist == null || pflist.size() == 0) {
            DPProperty dpp = super.get(key);
            return new RankedDPProperty(dpp, rank);
        }
        DPProperty dpp = null;
        if (!exact) {
            dpp = defDPProperty;
        }
        PropertiesFilter pf = (PropertiesFilter)pflist.get(0);
        List matches = this.matchConditionalProperties(pf);
        List newpflist = pflist.subList(1, pflist.size());
        int bestRank = rank;
        if (matches != null && matches.size() > 0) {
            Iterator i = matches.iterator();
            while (i.hasNext()) {
                DPProperties dpps = (DPProperties)i.next();
                RankedDPProperty nrdp = ((XMLDPProperties)dpps).getBestRanked(key, newpflist, exact, rank + 1, ((XMLDPProperties)dpps).get(key, false));
                if (nrdp.dpProperty == null || nrdp.rank <= bestRank) continue;
                dpp = nrdp.dpProperty;
                bestRank = nrdp.rank;
            }
        } else if (!exact && !pf.isRequired() && newpflist.size() > 0) {
            return this.getBestRanked(key, newpflist, exact, rank, dpp);
        }
        return new RankedDPProperty(dpp, bestRank);
    }

    public List matchConditionalProperties(PropertiesFilter pf) {
        DPConditionalProperties dpConditionalProperties;
        List matches = this.matchConditionalPropertiesFromThis(pf);
        Iterator i = this.getMergers().iterator();
        while (i.hasNext()) {
            DPProperties mdpp = (DPProperties)i.next();
            List matchesFromMerger = ((XMLDPProperties)mdpp).matchConditionalPropertiesFromThis(pf);
            Iterator j = matchesFromMerger.iterator();
            while (j.hasNext()) {
                String conditionValue;
                String condition;
                DPConditionalProperties dpConditionalProperties2;
                DPConditionalProperties dpp = (DPConditionalProperties)j.next();
                if (dpp == null || (dpConditionalProperties2 = this.getConditionalPropertiesFromThis(condition = dpp.getCondition(), conditionValue = dpp.getConditionValue())) != null) continue;
                DPConditionalProperties dptp = (DPConditionalProperties)((XMLDPConditionalProperties)dpp).createDummy(this.getRoot());
                dpConditionalProperties2 = (DPConditionalProperties)this.add(dptp, false, false, true);
                matches.add(dpConditionalProperties2);
            }
        }
        ListIterator m = matches.listIterator();
        while (m.hasNext()) {
            dpConditionalProperties = (DPConditionalProperties)m.next();
            if (dpConditionalProperties.isMerged()) continue;
            Iterator j = this.getMergers().iterator();
            while (j.hasNext()) {
                String conditionValue;
                String condition;
                DPConditionalProperties mmdpp;
                DPProperties ndpp = (DPProperties)j.next();
                if (ndpp == null || (mmdpp = ((XMLDPProperties)ndpp).getConditionalPropertiesFromThis(condition = dpConditionalProperties.getCondition(), conditionValue = dpConditionalProperties.getConditionValue())) == null) continue;
                if (!dpConditionalProperties.isMergeLocked() && mmdpp.isLocked() && mmdpp.isRemove()) {
                    m.remove();
                    continue;
                }
                dpConditionalProperties.addMerger(mmdpp);
            }
        }
        ListIterator li = matches.listIterator();
        while (li.hasNext()) {
            dpConditionalProperties = (DPConditionalProperties)li.next();
            if (dpConditionalProperties.isMergeLocked() || !dpConditionalProperties.isRemove()) continue;
            li.remove();
        }
        return matches;
    }

    List matchConditionalPropertiesElements(PropertiesFilter pf) {
        ArrayList<Element> matches = new ArrayList<Element>();
        Set names = this.propertiesTable.keySet();
        Iterator i = names.iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            if (!XMLDPProperties.isConditionalPropertiesName(name)) continue;
            Element e = (Element)this.propertiesTable.get(name);
            String condition = e.getAttribute("condition");
            String conditionValue = e.getAttribute("value");
            boolean matched = false;
            try {
                matched = pf.match(condition, conditionValue);
            }
            catch (PropertiesFilterException pfe) {
                throw new DPError("XMLDPProperties.matchConditionalPropertiesElements(): ", pfe);
            }
            if (!matched) continue;
            matches.add(e);
        }
        return matches;
    }

    protected List matchConditionalPropertiesFromThis(PropertiesFilter pf) {
        List matchElements = this.matchConditionalPropertiesElements(pf);
        ArrayList<DPConditionalProperties> matches = new ArrayList<DPConditionalProperties>();
        Iterator i = matchElements.iterator();
        while (i.hasNext()) {
            Element e = (Element)i.next();
            DPConditionalProperties dpp = null;
            if (e == null) continue;
            dpp = (DPConditionalProperties)this.getObject(e);
            if (dpp == null) {
                dpp = XMLDPFactory.getInstance().getConditionalProperties(this.getContext(), this.getRoot(), e);
                this.putObject(dpp);
            }
            matches.add(dpp);
        }
        return matches;
    }

    Element getConditionalPropertiesElement(String condition, String conditionValue) {
        Element propertiesElement = (Element)this.propertiesTable.get(XMLDPProperties.getConditionalPropertiesName(condition, conditionValue));
        return propertiesElement;
    }

    protected DPConditionalProperties getConditionalPropertiesFromThis(String condition, String conditionValue) {
        Element e = this.getConditionalPropertiesElement(condition, conditionValue);
        DPConditionalProperties dpp = null;
        if (e != null && (dpp = (DPConditionalProperties)this.getObject(e)) == null) {
            dpp = XMLDPFactory.getInstance().getConditionalProperties(this.getContext(), this.getRoot(), e);
            this.putObject(dpp);
        }
        return dpp;
    }

    public DPConditionalProperties getConditionalProperties(String condition, String value) {
        boolean replace = false;
        DPConditionalProperties dpCondProp = this.getConditionalPropertiesFromThis(condition, value);
        if (dpCondProp == null || !dpCondProp.isMerged()) {
            Iterator i = this.getMergers().iterator();
            while (i.hasNext()) {
                DPProperties dpp = (DPProperties)i.next();
                DPConditionalProperties dpcp = ((XMLDPProperties)dpp).getConditionalPropertiesFromThis(condition, value);
                if (dpcp == null) continue;
                if (dpCondProp != null) {
                    if (dpcp.getType() != dpCondProp.getType()) {
                        throw new DPError("XMLDPProperties.get(): conflicting types found for condition = " + condition + " and value = " + value);
                    }
                } else {
                    DPConditionalProperties ddpcp = (DPConditionalProperties)((XMLDPConditionalProperties)dpcp).createDummy(this.getRoot());
                    dpCondProp = (DPConditionalProperties)this.add(ddpcp, false, false, true);
                    if (!dpcp.isLocked() && dpCondProp.isDummy() && dpcp.isReplace()) {
                        replace = true;
                    }
                }
                if (!dpCondProp.isMergeLocked() && dpcp.isLocked() && dpcp.isRemove()) {
                    dpCondProp = null;
                    break;
                }
                dpCondProp.addMerger(dpcp);
            }
        }
        if (dpCondProp != null && !dpCondProp.isMergeLocked() && dpCondProp.isRemove()) {
            dpCondProp = null;
        }
        if (replace) {
            dpCondProp = null;
        }
        return dpCondProp;
    }

    public DPLocale getLocale(Locale locale, boolean exact) {
        if (locale == null) {
            return null;
        }
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        return this.getLocale(language, country, variant, exact);
    }

    public DPLocale getLocale(String language, String country, String variant, boolean exact) {
        boolean replace = false;
        DPLocale dpLocale = null;
        while (dpLocale == null && language != null) {
            dpLocale = this.getLocaleFromThis(language, country, variant, true);
            if (dpLocale == null || !dpLocale.isMerged()) {
                Iterator i = this.getMergers().iterator();
                while (i.hasNext()) {
                    DPProperties dpp = (DPProperties)i.next();
                    DPLocale dplc = ((XMLDPProperties)dpp).getLocaleFromThis(language, country, variant, true);
                    if (dplc == null) continue;
                    if (dpLocale == null) {
                        DPLocale ddpl = (DPLocale)((XMLDPLocale)dplc).createDummy(this.getRoot());
                        dpLocale = (DPLocale)this.add(ddpl, false, false, true);
                        if (!dplc.isLocked() && dpLocale.isDummy() && this.isReplace()) {
                            replace = true;
                        }
                    }
                    if (!dpLocale.isMergeLocked() && dplc.isLocked() && dplc.isRemove()) {
                        dpLocale = null;
                        break;
                    }
                    dpLocale.addMerger(dplc);
                }
                if (dpLocale != null && !dpLocale.isMergeLocked() && dpLocale.isRemove()) {
                    dpLocale = null;
                }
            }
            if (exact) {
                language = null;
                continue;
            }
            if (variant != null) {
                variant = null;
                continue;
            }
            if (country != null) {
                country = null;
                continue;
            }
            if (language == null) continue;
            language = null;
        }
        if (replace) {
            dpLocale = null;
        }
        return dpLocale;
    }

    protected DPLocale getLocaleFromThis(String language, String country, String variant, boolean exact) {
        Element e = this.getLocaleElement(language, country, variant, exact);
        DPLocale dpl = null;
        if (e != null && (dpl = (DPLocale)this.getObject(e)) == null) {
            dpl = new XMLDPLocale(this.getContext(), this.getRoot(), e);
            this.putObject(dpl);
        }
        return dpl;
    }

    Element getLocaleElement(String language, String country, String variant, boolean exact) {
        Element localeElement = null;
        localeElement = this.getLocaleElement(language, country, variant);
        if (localeElement != null) {
            return localeElement;
        }
        if (exact) {
            return localeElement;
        }
        if (variant != null && variant.length() > 0 && (localeElement = this.getLocaleElement(language, country, null)) != null) {
            return localeElement;
        }
        if (country != null && country.length() > 0 && (localeElement = this.getLocaleElement(language, null, null)) != null) {
            return localeElement;
        }
        return null;
    }

    static boolean isEmptyString(String s) {
        return s == null || s.length() == 0;
    }

    Element getLocaleElement(String language, String country, String variant) {
        String localeName = XMLDPProperties.getLocaleName(language, country, variant);
        Element localeElement = (Element)this.propertiesTable.get(localeName);
        return localeElement;
    }

    public Set getNames() {
        return this.getNames(true);
    }

    public Set getNames(boolean scoped) {
        DPPropertyHolder owner;
        Set providerNames;
        Set names = super.getNames();
        if (!scoped) {
            return names;
        }
        DPPropertyHolder dpph = this.getPropertyHolder();
        if (!(dpph instanceof DPChannel)) {
            this.message("XMLDPProperties.getNames():owner not a channel, returning names");
            return names;
        }
        this.message("XMLDPProperties.getNames():owner was a channel, getting provider");
        DPChannel dpc = (DPChannel)dpph;
        DPProvider dpp = dpc.getProvider();
        if (dpp != null && (providerNames = dpp.getProperties().getNames()) != null) {
            names.addAll(providerNames);
        }
        if ((owner = this.getPropertyHolder()) == null) {
            throw new DPError("XMLDPProperties.getNames(): no owner for properties");
        }
        DPPropertyHolder ownerParent = owner.getParentPropertyHolder();
        if (ownerParent == null) {
            return names;
        }
        Set ownerNames = ownerParent.getProperties().getNames();
        if (ownerNames != null) {
            names.addAll(ownerNames);
        }
        return names;
    }

    public DPString getString(String key, List pflist, boolean exact) {
        DPProperty dpp = this.get(key, pflist, exact);
        if (dpp == null) {
            return null;
        }
        if (dpp.getType() != 1) {
            return null;
        }
        return (DPString)dpp;
    }

    public DPString getString(String key) {
        return this.getString(key, null, true);
    }

    public void setString(String key, String val) {
        this.setString(key, val, null);
    }

    boolean isPropertyFromThis(DPProperty dpp) {
        DPProperties dppp = dpp.getProperties();
        return dppp == this;
    }

    public void setString(String key, String val, List pflist) {
        DPString oldString = this.getString(key, pflist, false);
        if (oldString == null) {
            throw new DPError("XMLDPProperties.setString(): property does not exist name=" + key + ", pflist=" + pflist);
        }
        DPString newString = null;
        if (!oldString.isPropagate()) {
            newString = oldString;
            newString.setPropagate(false);
        } else if (!this.isPropertyFromThis(oldString)) {
            DPProperties dpp = oldString.getProperties();
            List pflistMatched = ((XMLDPProperties)dpp).getMatchedPropertiesFilters(key, pflist);
            newString = (DPString)this.add(oldString, pflistMatched);
        } else {
            newString = oldString;
        }
        newString.setStringValue(val);
    }

    public DPInteger getInteger(String key) {
        return this.getInteger(key, null, true);
    }

    public DPInteger getInteger(String key, List pflist, boolean exact) {
        DPProperty dpp = this.get(key, pflist, exact);
        if (dpp == null) {
            return null;
        }
        if (dpp.getType() != 3) {
            return null;
        }
        return (DPInteger)dpp;
    }

    public void setInteger(String key, int val) {
        this.setInteger(key, val, null);
    }

    public void setInteger(String key, int val, List pflist) {
        DPInteger oldInt = this.getInteger(key, pflist, false);
        if (oldInt == null) {
            throw new DPError("XMLDPProperties.setInteger(): property does not exist name=" + key);
        }
        DPInteger newInt = null;
        if (!oldInt.isPropagate()) {
            newInt = oldInt;
            newInt.setPropagate(false);
        } else if (!this.isPropertyFromThis(oldInt)) {
            DPProperties dpp = oldInt.getProperties();
            List pflistMatched = ((XMLDPProperties)dpp).getMatchedPropertiesFilters(key, pflist);
            newInt = (DPInteger)this.add(oldInt, pflistMatched);
        } else {
            newInt = oldInt;
        }
        newInt.setIntValue(val);
    }

    public DPBoolean getBoolean(String key) {
        return this.getBoolean(key, null, true);
    }

    public DPBoolean getBoolean(String key, List pflist, boolean exact) {
        DPProperty dpp = this.get(key, pflist, exact);
        if (dpp == null) {
            return null;
        }
        if (dpp.getType() != 4) {
            return null;
        }
        return (DPBoolean)dpp;
    }

    public void setBoolean(String key, boolean val) {
        this.setBoolean(key, val, null);
    }

    public void setBoolean(String key, boolean val, List pflist) {
        DPBoolean oldBool = this.getBoolean(key, pflist, false);
        if (oldBool == null) {
            throw new DPError("XMLDPProperties.setBoolean(): property does not exist name=" + key);
        }
        DPBoolean newBool = null;
        if (!this.isPropertyFromThis(oldBool)) {
            DPProperties dpp = oldBool.getProperties();
            List pflistMatched = ((XMLDPProperties)dpp).getMatchedPropertiesFilters(key, pflist);
            newBool = (DPBoolean)this.add(oldBool, pflistMatched);
        } else {
            newBool = oldBool;
        }
        newBool.setBooleanValue(val);
    }

    public DPCollection getCollection(String key) {
        return this.getCollection(key, null, true);
    }

    public DPCollection getCollection(String key, List pflist, boolean exact) {
        DPProperty dpp = this.get(key, pflist, exact);
        if (dpp == null) {
            return null;
        }
        if (dpp.getType() != 14) {
            return null;
        }
        return (DPCollection)dpp;
    }

    public DPCollection setCollection(String key, Map val) {
        return this.setCollection(key, val, null);
    }

    public DPCollection setCollection(String key, Map val, List pflist) {
        DPCollection oldColl = this.getCollection(key, pflist, false);
        if (oldColl == null) {
            throw new DPError("XMLDPProperties.setCollection(): property does not exist name=" + key);
        }
        DPCollection newColl = null;
        if (!oldColl.isPropagate()) {
            newColl = oldColl;
            newColl.setPropagate(false);
        } else if (!this.isPropertyFromThis(oldColl)) {
            DPProperties dpp = oldColl.getProperties();
            List pflistMatched = ((XMLDPProperties)dpp).getMatchedPropertiesFilters(key, pflist);
            this.add(oldColl, true, false, false, pflistMatched);
            newColl = this.getCollection(key, pflist, false);
        } else {
            newColl = oldColl;
        }
        newColl.setCollectionValue(val);
        return newColl;
    }

    public DPCollection setCollection(String key, List val) {
        return this.setCollection(key, val, null);
    }

    public DPCollection setCollection(String key, List val, List pflist) {
        DPCollection oldColl = this.getCollection(key, pflist, false);
        if (oldColl == null) {
            throw new DPError("XMLDPProperties.setCollection(): property does not exist name=" + key);
        }
        DPCollection newColl = null;
        if (!oldColl.isPropagate()) {
            newColl = oldColl;
            newColl.setPropagate(false);
        } else if (!this.isPropertyFromThis(oldColl)) {
            DPProperties dpp = oldColl.getProperties();
            List pflistMatched = ((XMLDPProperties)dpp).getMatchedPropertiesFilters(key, pflist);
            this.add(oldColl, true, false, false, pflistMatched);
            newColl = this.getCollection(key, pflist, false);
        } else {
            newColl = oldColl;
        }
        newColl.setCollectionValue(val);
        return newColl;
    }

    protected Element getMergedElement() {
        Map map = this.getCollectionValue();
        Element e = XMLDPProperties.createElement(this.getContext(), this.getRoot(), this.getDocument(), map);
        return e;
    }

    static Element createElement(DPContext dpc, Document d) {
        Element e = XMLDPObject.createElement(dpc, d, "Properties");
        XMLDPProperties.setDefaultsElement(e);
        return e;
    }

    private static Element createElement(DPContext dpc, DPRoot r, Document d, Map m) {
        Element e = XMLDPProperties.createElement(dpc, d);
        XMLDPFactory factory = XMLDPFactory.getInstance();
        Iterator i = m.keySet().iterator();
        while (i.hasNext()) {
            Iterator j;
            String name = (String)i.next();
            Object o = m.get(name);
            Element newElement = null;
            if (XMLDPProperties.isConditionalPropertiesName(name)) {
                j = XMLDPProperties.parseConditionalPropertiesName(name).iterator();
                String condition = (String)j.next();
                String conditionValue = (String)j.next();
                DPConditionalProperties dptp = factory.createConditionalProperties(dpc, r, d, condition, conditionValue, (Map)o);
                XMLDPConditionalProperties xmlDPTP = (XMLDPConditionalProperties)dptp;
                newElement = xmlDPTP.getElement();
            } else if (XMLDPProperties.isLocaleName(name)) {
                j = XMLDPProperties.parseLocaleName(name).iterator();
                String lang = (String)j.next();
                String country = (String)j.next();
                String variant = (String)j.next();
                DPLocale dpl = factory.createLocale(dpc, r, d, lang, country, variant, (Map)o);
                XMLDPLocale xmlDPL = (XMLDPLocale)dpl;
                newElement = xmlDPL.getElement();
            } else {
                DPProperty dpp = XMLDPFactory.getInstance().createProperty(dpc, r, d, name, o);
                XMLDPProperty xmlDPP = (XMLDPProperty)dpp;
                newElement = xmlDPP.getElement();
            }
            e.appendChild(newElement);
        }
        XMLDPProperties.setDefaultsElement(e);
        return e;
    }

    public void toXML(StringBuffer b, int indent) {
        if (this.isDummy()) {
            return;
        }
        this.indentBuffer(b, indent);
        this.appendStartTag(b);
        this.appendMergeAttr(b);
        this.appendLockAttr(b);
        this.appendAdvancedAttr(b);
        this.appendPropagateAttr(b);
        b.append(">\n");
        this.appendChildProperty(b, indent);
        this.indentBuffer(b, indent);
        this.appendEndTag(b);
    }
}

