/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.rewriter.services;

import com.sun.portal.rewriter.util.Constants;
import com.sun.portal.rewriter.util.StringHelper;
import com.sun.portal.rewriter.util.collections.ListMap;
import com.sun.portal.rewriter.util.re.Pattern;
import com.sun.portal.rproxy.rewriter.services.SRAPContext;
import com.sun.portal.rproxy.rewriter.services.URI2RuleSetMap;
import java.util.HashMap;
import java.util.List;

public final class SRAPProcessedProfile {
    private static SRAPContext srapContext;
    private static URI2RuleSetMap uri2RulesetMAP;
    private static ListMap mime2ParserMAP;
    private static ListMap uri2ParserMAP;
    private static Pattern[] not2RewriteURIPatterns;
    private static Pattern[] not2ObscureURIPatterns;
    private static String httpsPort;
    private static String httpPort;

    public static void init(SRAPContext aSRAPContext) {
        srapContext = aSRAPContext;
        uri2RulesetMAP = SRAPProcessedProfile.initURI2RuleSetMap(aSRAPContext.readURI2RuleSetMappings());
        mime2ParserMAP = SRAPProcessedProfile.initMIME2ParserMap(aSRAPContext.readMIME2ParserMappings());
        uri2ParserMAP = SRAPProcessedProfile.initURI2ParserMap(aSRAPContext.readURI2ParserMappings());
        not2RewriteURIPatterns = SRAPProcessedProfile.initURIPatterns(aSRAPContext.readNot2RewriteURIList());
        not2ObscureURIPatterns = SRAPProcessedProfile.initURIPatterns(aSRAPContext.readNot2ObscureURIList());
        httpPort = aSRAPContext.getHTTPPort() == 80 ? "" : ":" + aSRAPContext.getHTTPPort();
        httpsPort = aSRAPContext.getHTTPSPort() == 443 ? "" : ":" + aSRAPContext.getHTTPSPort();
    }

    public static String getInstanceName() {
        return srapContext.getProfileName();
    }

    public static URI2RuleSetMap getURI2RuleSetMap() {
        return uri2RulesetMAP;
    }

    public static ListMap getMIME2ParserMap() {
        return mime2ParserMAP;
    }

    public static boolean isMIMEGuessingEnabled() {
        return srapContext.isMIMEGuessingEnabled();
    }

    public static ListMap getURI2ParserMAP() {
        return uri2ParserMAP;
    }

    public static Pattern[] getNot2RewriteURIPatterns() {
        return not2RewriteURIPatterns;
    }

    public static boolean isObscureURIs() {
        return srapContext.isURLObfuscationEnabled();
    }

    public static String getObfuscatorSeed() {
        return srapContext.readObfuscatorSeed();
    }

    public static Pattern[] getNot2ObscureURIPatterns() {
        return not2ObscureURIPatterns;
    }

    public static boolean isUseConsistantProtocol4Gateway() {
        return srapContext.isUseConsistantProtocol4Gateway();
    }

    private static URI2RuleSetMap initURI2RuleSetMap(List aRuleSetMap) {
        return new URI2RuleSetMap(aRuleSetMap);
    }

    private static ListMap initMIME2ParserMap(List aMappingInfo) {
        return SRAPProcessedProfile.parserMapHelper(aMappingInfo, new CustomProcess(){

            public Object processKey(Object aObject) {
                return aObject.toString().toLowerCase();
            }
        });
    }

    private static ListMap initURI2ParserMap(List aMappingInfo) {
        return SRAPProcessedProfile.parserMapHelper(aMappingInfo, new CustomProcess(){

            public Object processKey(Object aObject) {
                return new Pattern(aObject.toString(), true);
            }
        });
    }

    private static Pattern[] initURIPatterns(List aList) {
        return Pattern.convert2Patterns((String[])aList.toArray(Constants.EMPTY_STRING_ARRAY), (boolean)true);
    }

    private static ListMap parserMapHelper(List aMappingInfo, CustomProcess aCustomProcess) {
        HashMap<String, String> supportedContentTypes = new HashMap<String, String>();
        supportedContentTypes.put("html", "text/html");
        supportedContentTypes.put("javascript", "application/x-javascript");
        supportedContentTypes.put("java_script", "application/x-javascript");
        supportedContentTypes.put("xml", "text/xml");
        supportedContentTypes.put("css", "text/css");
        ListMap lMap = new ListMap();
        for (int j = 0; j < aMappingInfo.size(); ++j) {
            String line = StringHelper.normalize((String)((String)aMappingInfo.get(j))).toString();
            String[] splited = StringHelper.tokenize((String)line, (String)"=");
            if (splited.length == 2) {
                String key = splited[0].trim();
                Object parserMIME = supportedContentTypes.get(key.toLowerCase());
                if (parserMIME != null) {
                    String[] values = StringHelper.tokenize((String)splited[1], (String)";:|");
                    for (int i = 0; i < values.length; ++i) {
                        String value = values[i].trim();
                        if (value.length() == 0) continue;
                        lMap.put(aCustomProcess.processKey(value), parserMIME);
                    }
                    continue;
                }
                System.out.println("No Rewriter Available for key:" + key);
                continue;
            }
            System.out.println("Illegal List Content:" + line);
        }
        return lMap;
    }

    public static String getHTTPPort() {
        return httpPort;
    }

    public static String getHTTPSPort() {
        return httpsPort;
    }

    static {
        not2RewriteURIPatterns = Pattern.EMPTY_PATTERN_ARRAY;
        not2ObscureURIPatterns = Pattern.EMPTY_PATTERN_ARRAY;
    }

    private static interface CustomProcess {
        public Object processKey(Object var1);
    }
}

