/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.rewriter;

import com.sun.portal.rewriter.Rewriter;
import com.sun.portal.rewriter.RewriterPool;
import com.sun.portal.rewriter.Translator;
import com.sun.portal.rewriter.rom.InvalidXMLException;
import com.sun.portal.rewriter.services.DataServiceException;
import com.sun.portal.rewriter.util.Constants;
import com.sun.portal.rewriter.util.Debug;
import com.sun.portal.rewriter.util.uri.PageSpec;
import com.sun.portal.rewriter.util.xml.Document;
import com.sun.portal.rproxy.configservlet.client.GatewayProfile;
import com.sun.portal.rproxy.configservlet.client.UserProfile;
import com.sun.portal.rproxy.connectionhandler.ErrorResponse;
import com.sun.portal.rproxy.connectionhandler.Request;
import com.sun.portal.rproxy.connectionhandler.Response;
import com.sun.portal.rproxy.rewriter.SRAPAdapterHelper;
import com.sun.portal.rproxy.rewriter.SRAPTranslatorBuilder;
import com.sun.portal.rproxy.rewriter.util.SRAPConfigManager;
import com.sun.portal.rproxy.rewriter.util.http.ContentInfo;
import com.sun.portal.rproxy.rewriter.util.http.HTTPData;
import com.sun.portal.util.GWLocale;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

public final class SRAPAdapter {
    private static final String UN_SUPPORTED_ENCODING_EXCEPTION_LOCALE_KEY = "UnSupportedEncodingWarningMessage";
    private static final String INVALID_XML_EXCEPTION_LOCALE_KEY = "InvalidRuleSetWarningMessage";
    private static final String DATASERVICE_EXCEPTION_LOCALE_KEY = "DataServiceErrorMessage";
    private static String NULL_RULESET = "null_ruleset";
    public static final RewriterPool rewriterPool = RewriterPool.getDefault();
    private static final String[] messages = new String[]{"No Parser available for this MIME", "No Ruleset Mapped for this URI", "Invalid Encoding"};

    public static InputStream rewrite(Request aRequest, Response aResponse) throws IOException {
        HTTPData lHTTPData = null;
        String lRuleSet4URI = null;
        try {
            PageSpec bPageSpec = new PageSpec(aRequest.getURL());
            lHTTPData = new HTTPData(bPageSpec, aResponse);
            ContentInfo lContentInfo = lHTTPData.getContentInfo();
            SRAPAdapterHelper.updateMIME(bPageSpec, lContentInfo);
            String lParserMIME = SRAPConfigManager.selectParser4MIME(lContentInfo.getMIME());
            lRuleSet4URI = SRAPConfigManager.selectRuleSet4URI(bPageSpec);
            if (lParserMIME == null || lRuleSet4URI == null || NULL_RULESET.equals(lRuleSet4URI)) {
                SRAPAdapter.recordUnTouchedPage(lHTTPData, lParserMIME == null ? messages[0] : messages[1]);
                if (lHTTPData.isStreamRead()) {
                    return new ByteArrayInputStream(lHTTPData.getContentBytes());
                }
                return null;
            }
            if (lContentInfo.isInvalidEncoding() && lParserMIME.equalsIgnoreCase("text/xml")) {
                lContentInfo.setEncoding(Document.parseEncoding((String)lHTTPData.getRawEncodedString()));
            }
            return SRAPAdapter.rewriteContent(lHTTPData, lParserMIME, lRuleSet4URI, lContentInfo, aRequest);
        }
        catch (UnsupportedEncodingException usException) {
            SRAPAdapter.recordUnTouchedPage(lHTTPData, messages[2]);
            return SRAPAdapter.handleException(aResponse, aRequest, UN_SUPPORTED_ENCODING_EXCEPTION_LOCALE_KEY, new Object[]{lHTTPData.getContentInfo().getEncoding()}, usException);
        }
        catch (InvalidXMLException ixException) {
            ixException.printStackTrace();
            return SRAPAdapter.handleException(aResponse, aRequest, INVALID_XML_EXCEPTION_LOCALE_KEY, new Object[]{lRuleSet4URI}, (Exception)((Object)ixException));
        }
        catch (DataServiceException dsException) {
            return SRAPAdapter.handleException(aResponse, aRequest, DATASERVICE_EXCEPTION_LOCALE_KEY, new Object[]{""}, (Exception)((Object)dsException));
        }
    }

    private static InputStream rewriteContent(HTTPData aHTTPData, String aParserMIME, String aRuleSet4URI, ContentInfo aContentInfo, Request aRequest) throws InvalidXMLException, IOException {
        PageSpec lPageSpec = new PageSpec(aRequest.getURL(), aContentInfo.getMIME(), aContentInfo.getEncoding());
        Translator bSRAPTranslator = SRAPTranslatorBuilder.create(aRequest, lPageSpec);
        Rewriter lRewriter = rewriterPool.getRewriter(aRuleSet4URI, aParserMIME);
        String lResult = lRewriter.rewrite(aHTTPData.getPageContent(), bSRAPTranslator);
        if (!bSRAPTranslator.getLookAheadInfo().isContentChanged()) {
            return new ByteArrayInputStream(aHTTPData.getContentBytes());
        }
        if (Constants.SYSTEM_ENCODING == aContentInfo.getEncoding()) {
            return new ByteArrayInputStream(lResult.getBytes());
        }
        return new ByteArrayInputStream(lResult.getBytes(aContentInfo.getEncoding()));
    }

    private static void recordUnTouchedPage(HTTPData aHTTPData, String aCause) {
        if (Debug.isWarningEnabled() && aHTTPData != null) {
            String warningMessage = "\n(WARNING)" + aHTTPData.getPageSpec() + "\n\t\tIS NOT BEING REWRITTEN..\n\n" + aHTTPData.getContentInfo() + "Cause: " + aCause + "\n";
            Debug.recordUnaffectedPageWarning((String)warningMessage);
        }
    }

    private static final InputStream handleException(Response aResp, Request aReq, String aLocaleKey, Object[] aLocaleParams, Exception e) {
        if (Debug.isWarningEnabled()) {
            Debug.recordOriginalPageWarning((String)aLocaleKey, (Exception)e);
        }
        String lSessionID = aReq.getSessionID();
        String lUserLocale = SRAPAdapter.getUserLocale(lSessionID);
        String lMessage = GWLocale.getPFString(aLocaleKey, aLocaleParams, lUserLocale);
        return new ErrorResponse(lMessage, null, aReq.getRequestHeader("Accept-Language")).getContentStream();
    }

    private static final String getUserLocale(String aSessionID) {
        try {
            UserProfile prof = new UserProfile(aSessionID);
            return prof.getString("preferredlocale", "en_US");
        }
        catch (Exception ex) {
            return GatewayProfile.getString("locale", "en_US");
        }
    }
}

