/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.eproxy;

import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.portal.netlet.eproxy.SessionRequest;
import com.sun.portal.util.GWDebug;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class Redirect {
    private String dstHost;
    private int dstPort = 0;
    private String dstPortList;
    private boolean found = false;

    public Redirect(int port, SessionRequest sessReq) {
        try {
            SSOTokenManager manager = SSOTokenManager.getInstance();
            SSOToken token = manager.createSSOToken(sessReq.getSessionID());
            manager.refreshSession(token);
            String val = token.getProperty(Integer.toString(port));
            if (val == null || val.compareTo("") == 0) {
                this.found = false;
                return;
            }
            this.found = true;
            this.parseRedirect(val);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getDstPort() {
        return this.dstPort;
    }

    public String getDstHost() {
        return this.dstHost;
    }

    public boolean doRedirect() {
        return this.found;
    }

    private void parseRedirect(String val) {
        block7: {
            StringTokenizer parser = new StringTokenizer(val, "^");
            try {
                while (parser.hasMoreTokens()) {
                    if (this.dstHost == null) {
                        this.dstHost = parser.nextToken();
                    }
                    if (this.dstPort != 0) continue;
                    this.dstPortList = parser.nextToken();
                    this.dstPort = Integer.parseInt(this.dstPortList);
                }
            }
            catch (NoSuchElementException e) {
                if (GWDebug.debug.errorEnabled()) {
                    GWDebug.debug.error("Redirect: error reading target host/port");
                }
            }
            catch (NumberFormatException e) {
                if (!GWDebug.debug.errorEnabled()) break block7;
                GWDebug.debug.error("Redirect: error parsing target port");
            }
        }
        if (GWDebug.debug.debugEnabled() && GWDebug.debug.messageEnabled()) {
            GWDebug.debug.message("Redirect: parsed = " + this.dstHost + " " + this.dstPortList);
        }
    }

    public String getDstPortList() {
        return this.dstPortList;
    }
}

