/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.eproxy;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.portal.netlet.econnection.ESessionMsg;
import com.sun.portal.netlet.eproxy.EProxy;
import com.sun.portal.netlet.eproxy.ESession;
import com.sun.portal.netlet.eproxy.ProxyConnection;
import com.sun.portal.netlet.eproxy.ProxyletSession;
import com.sun.portal.perf.rproxy.PerfContextObject;
import com.sun.portal.perf.rproxy.SocketCount;
import com.sun.portal.rproxy.configservlet.client.GatewayProfile;
import com.sun.portal.rproxy.server.RequestProcessor;
import com.sun.portal.rproxy.server.ServerSocketFactory;
import com.sun.portal.util.GWDebug;
import com.sun.portal.util.GWLogManager;
import com.sun.portal.util.GWThreadPool;
import com.sun.portal.util.LogInfoContainer;
import com.sun.portal.util.ServiceIdentifier;
import com.sun.portal.util.SystemProperties;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.URLDecoder;

public class RProxyConnection
extends ProxyConnection {
    private boolean secureConnection;
    private int port = 0;
    private RequestProcessor requestProcessor;
    static boolean useAcceleratorSupport = false;
    private static final String TIMEOUT = "RProxyPortTimeout";
    private static final int DEFAULT_TIMEOUT = 60000;
    private static final int timeout;

    public static void startHttps(final int port) {
        Runnable r = new Runnable(){

            public void run() {
                block2: {
                    RProxyConnection rpconn = new RProxyConnection(true, port);
                    try {
                        rpconn.start();
                    }
                    catch (SocketException e) {
                        if (!GWDebug.debug.errorEnabled()) break block2;
                        GWDebug.debug.error("RProxyConnection:startHttps(int) cannot start : " + e);
                    }
                }
            }
        };
        Thread thread = new Thread(r);
        thread.start();
    }

    public static void startHttps(final int exposedPort, final int port) {
        Runnable r = new Runnable(){

            public void run() {
                block2: {
                    RProxyConnection rpconn = new RProxyConnection(true, exposedPort, port);
                    try {
                        rpconn.start();
                    }
                    catch (SocketException e) {
                        if (!GWDebug.debug.errorEnabled()) break block2;
                        GWDebug.debug.error("RProxyConnection:startHttps(int,int) cannot start : " + e);
                    }
                }
            }
        };
        Thread thread = new Thread(r);
        thread.start();
    }

    public static void startHttp(final int port) {
        Runnable r = new Runnable(){

            public void run() {
                block2: {
                    RProxyConnection rpconn = new RProxyConnection(false, port);
                    try {
                        rpconn.start();
                    }
                    catch (SocketException e) {
                        if (!GWDebug.debug.errorEnabled()) break block2;
                        GWDebug.debug.error("RProxyConnection:startHttp(int) cannot start : " + e);
                    }
                }
            }
        };
        Thread thread = new Thread(r);
        thread.start();
    }

    private RProxyConnection(boolean secureConnection, int port) {
        super("RProxyHTTPSThread", "epc1");
        this.secureConnection = secureConnection;
        this.port = port;
        this.requestProcessor = this.secureConnection ? new RequestProcessor("https", port) : new RequestProcessor("http", port);
    }

    private RProxyConnection(boolean secureConnection, int exposedPort, int port) {
        super("RProxyHTTPSThread", "epc1");
        this.secureConnection = secureConnection;
        this.port = port;
        this.requestProcessor = this.secureConnection ? new RequestProcessor("https", exposedPort) : new RequestProcessor("http", exposedPort);
    }

    protected ServerSocket makeServerSocket() throws SocketException {
        if (this.secureConnection && useAcceleratorSupport && ServiceIdentifier.isGateway()) {
            return ServerSocketFactory.createSRAPServerSocket(this.port);
        }
        return this.secureConnection ? ServerSocketFactory.createSSLSocketServer(this.port) : ServerSocketFactory.createSRAPServerSocket(this.port);
    }

    private int isNetletTraffic(Socket inconnection) {
        ESessionMsg emsg;
        block15: {
            InputStream in = null;
            try {
                in = inconnection.getInputStream();
            }
            catch (IOException e) {
                if (GWDebug.debug.errorEnabled()) {
                    GWDebug.debug.error("RProxyConnection cannot open input stream on " + inconnection, e);
                }
                try {
                    inconnection.close();
                    if (PerfContextObject.ENABLE_PERF) {
                        SocketCount.decrementPlainSockets();
                    }
                }
                catch (Exception e1) {
                    // empty catch block
                }
                return -1;
            }
            emsg = new ESessionMsg();
            try {
                in.mark(512);
            }
            catch (Exception e) {
                if (GWDebug.debug.errorEnabled()) {
                    GWDebug.debug.error("Cannot mark " + inconnection, e);
                }
                try {
                    inconnection.close();
                    if (PerfContextObject.ENABLE_PERF) {
                        SocketCount.decrementPlainSockets();
                    }
                }
                catch (Exception e1) {
                    // empty catch block
                }
                emsg = null;
                return -1;
            }
            int result = emsg.readMsg(new DataInputStream(in));
            if (result == 0 || result == 1) {
                emsg = null;
                return result;
            }
            try {
                in.reset();
            }
            catch (Exception e) {
                if (!GWDebug.debug.errorEnabled()) break block15;
                GWDebug.debug.error("Cannot reset " + inconnection, e);
            }
        }
        emsg = null;
        return -1;
    }

    protected void process(Socket connection, Integer logId) {
        try {
            GWThreadPool.run(new RProxyThread(connection, logId));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static {
        String strUseAcceleratorSupport = SystemProperties.get("gateway.enable.accelerator", "false");
        if (strUseAcceleratorSupport != null) {
            useAcceleratorSupport = strUseAcceleratorSupport.trim().equalsIgnoreCase("true");
        }
        timeout = GatewayProfile.getInt(TIMEOUT, 60000);
    }

    class RProxyThread
    implements Runnable {
        private Socket connection;
        private Integer logId;

        public RProxyThread(Socket _connection, Integer _logId) {
            this.connection = _connection;
            this.logId = _logId;
        }

        public void run() {
            String unqID;
            Object tmp_1;
            int initialTimeout;
            Socket nonsslsocket;
            boolean checkProxylet;
            boolean checkNetlet;
            block33: {
                block32: {
                    checkNetlet = false;
                    checkProxylet = false;
                    nonsslsocket = null;
                    GWLogManager.logIdMap.put(new Integer(this.connection.getPort()), new LogInfoContainer(this.logId, this.connection));
                    initialTimeout = 0;
                    try {
                        initialTimeout = this.connection.getSoTimeout();
                    }
                    catch (Exception ex) {
                        if (!GWDebug.debug.errorEnabled()) break block32;
                        GWDebug.debug.error("RProxy caught exception while setting getSoTimeout() : ", ex);
                    }
                }
                try {
                    this.connection.setSoTimeout(timeout);
                }
                catch (Exception ex) {
                    if (!GWDebug.debug.errorEnabled()) break block33;
                    GWDebug.debug.error("RProxy caught exception while setting setSoTimeout() : ", ex);
                }
            }
            if (ServiceIdentifier.isGateway()) {
                checkNetlet = EProxy.isNetletEnabled;
            } else if (ServiceIdentifier.isNetletProxy()) {
                checkNetlet = true;
            }
            checkProxylet = EProxy.isProxyletEnabled;
            int result = RProxyConnection.this.isNetletTraffic(this.connection);
            boolean isNetletTraffic = false;
            boolean isEnd2EndSSLRequest = false;
            if (result == 0) {
                isNetletTraffic = true;
            } else if (result == 1) {
                isEnd2EndSSLRequest = true;
            }
            if (checkProxylet && (tmp_1 = GWLogManager.logIdMap.get(unqID = this.connection.getPort() + "_" + "A")) != null) {
                LogInfoContainer info = (LogInfoContainer)tmp_1;
                nonsslsocket = info.getClientSocket();
            }
            if (checkNetlet && isNetletTraffic) {
                block34: {
                    GWDebug.debug.message("RPRoxy received netlet request. Starting netlet session...");
                    try {
                        this.connection.setSoTimeout(initialTimeout);
                    }
                    catch (Exception ex) {
                        if (!GWDebug.debug.errorEnabled()) break block34;
                        GWDebug.debug.error("isNetletTraffic caught exception while setting setSoTimeout() : ", ex);
                    }
                }
                ESession es = new ESession(this.connection, this.logId);
                try {
                    GWThreadPool.run(es);
                }
                catch (InterruptedException e) {
                    if (GWDebug.debug.errorEnabled()) {
                        GWDebug.debug.error("Cannot run ESession", e);
                    }
                    try {
                        this.connection.close();
                        if (PerfContextObject.ENABLE_PERF) {
                            SocketCount.decrementPlainSockets();
                        }
                    }
                    catch (Exception e1) {
                        // empty catch block
                    }
                    return;
                }
            }
            if (checkProxylet && isEnd2EndSSLRequest) {
                block35: {
                    GWDebug.debug.message("Proxylet Traffic...");
                    try {
                        this.connection.setSoTimeout(initialTimeout);
                    }
                    catch (Exception ex) {
                        if (!GWDebug.debug.errorEnabled()) break block35;
                        GWDebug.debug.error("isProxyletTraffic caught exception while setting setSoTimeout() : ", ex);
                    }
                }
                String req = null;
                String host = null;
                int port = 443;
                try {
                    BufferedReader r = new BufferedReader(new InputStreamReader(this.connection.getInputStream()));
                    req = r.readLine();
                    req = req.substring(req.indexOf(" "), req.length());
                    req = req.trim();
                    host = req.substring(0, req.indexOf(":"));
                    port = Integer.parseInt(req.substring(req.indexOf(":") + 1, req.length()));
                    String cookie = r.readLine();
                    SSOToken token = null;
                    try {
                        token = SSOTokenManager.getInstance().createSSOToken(cookie);
                    }
                    catch (SSOException ssoe) {
                        try {
                            token = SSOTokenManager.getInstance().createSSOToken(URLDecoder.decode(cookie));
                        }
                        catch (SSOException ssoe2) {
                            System.out.println("Unable to create SSOToken ");
                            return;
                        }
                    }
                }
                catch (IOException e) {
                    return;
                }
                ProxyletSession es = new ProxyletSession(nonsslsocket, this.logId, host, port, this.connection);
                Thread _t = new Thread(es);
                _t.start();
            } else if (!ServiceIdentifier.isNetletProxy()) {
                RProxyConnection.this.requestProcessor.processRequestInGWTheadPool(this.connection, this.logId);
            } else {
                RProxyConnection.this.closeSocket(this.connection);
            }
        }

        private String readRequest(InputStream in) throws IOException {
            byte[] reply = new byte[100];
            int replyLen = 0;
            int newlinesSeen = 0;
            boolean headerDone = false;
            boolean error = false;
            while (newlinesSeen < 2) {
                int i = in.read();
                if (i < 0) {
                    throw new IOException("Unexpected EOF from proxy");
                }
                if (i == 10) {
                    headerDone = true;
                    ++newlinesSeen;
                    continue;
                }
                if (i == 13) continue;
                newlinesSeen = 0;
                if (headerDone || replyLen >= reply.length) continue;
                reply[replyLen++] = (byte)i;
            }
            reply[replyLen++] = 0;
            return new String(reply);
        }
    }
}

