/*
 * Decompiled with CFR 0.152.
 */
package com.sun.addressbook;

import com.sun.addressbook.ABStoreException;

public abstract class ABSearchTerm {
    public static final int NO_OP = -1;
    public static final int NOT = 0;
    public static final int OR = 1;
    public static final int AND = 2;
    protected String name = null;
    protected String value = null;
    protected boolean exact = true;
    protected boolean not = false;
    protected ABSearchTerm[] terms = null;
    protected int op = -1;

    public ABSearchTerm(String name, String value, boolean exact) {
        this.name = name;
        this.value = value;
        this.exact = exact;
        this.terms = null;
    }

    public ABSearchTerm(ABSearchTerm term, int op) throws ABStoreException {
        if (op != 0) {
            String msg = "ABSearchTerm: Invalid operator - " + op + ". Operator can only be NOT";
            throw new ABStoreException(msg);
        }
        ABSearchTerm[] terms = new ABSearchTerm[]{term};
        this.terms = terms;
        this.op = op;
    }

    public ABSearchTerm(ABSearchTerm[] terms, int op) throws ABStoreException {
        if (op != 2 && op != 1) {
            String msg = "ABSearchTerm: Invalid operator - " + op + ". Operator can only be AND/OR";
            throw new ABStoreException(msg);
        }
        if (terms.length < 2) {
            String msg = "ABSearchTerm: Number of search Terms in array to be AND/ORed wrong - " + terms.length;
            throw new ABStoreException(msg);
        }
        this.terms = terms;
        this.op = op;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public ABSearchTerm[] getTerms() {
        return this.terms;
    }

    public int getOp() {
        return this.op;
    }

    public boolean isExact() {
        return this.exact;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setExact(boolean exact) {
        this.exact = exact;
    }

    public void setNot(boolean not) {
        this.not = not;
    }

    public void setOp(int op) {
        this.op = op;
    }

    public abstract Object compute() throws ABStoreException;
}

