/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.util;

import com.sun.portal.rproxy.configservlet.client.GatewayProfile;
import com.sun.portal.util.GWDebug;
import com.sun.portal.util.SystemProperties;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.ssl.SSLCertificateApprovalCallback;

public class ServerCertApprovalCallback
implements SSLCertificateApprovalCallback {
    private String reqHost = null;
    private static ServerCertApprovalCallback theInstance = null;
    static boolean trustAllServerCerts = false;
    protected static List srapGateway_trustedSSLDomainList = new ArrayList();

    private ServerCertApprovalCallback() {
    }

    public ServerCertApprovalCallback(String host) {
        if (host != null) {
            this.reqHost = host.toLowerCase();
        }
    }

    public static ServerCertApprovalCallback getInstance() {
        if (theInstance == null) {
            theInstance = new ServerCertApprovalCallback();
        }
        return theInstance;
    }

    public boolean approve(X509Certificate cert, SSLCertificateApprovalCallback.ValidityStatus status) {
        if (GWDebug.debug.messageEnabled()) {
            GWDebug.debug.message("ServerCertApprovalCallback: SubjectDN = " + cert.getSubjectDN().getName());
        }
        Enumeration errors = status.getReasons();
        String certHost = ServerCertApprovalCallback.getCertHost(cert.getSubjectDN().getName());
        if (this.reqHost == null) {
            int numReasons = 0;
            while (errors.hasMoreElements()) {
                SSLCertificateApprovalCallback.ValidityItem item = (SSLCertificateApprovalCallback.ValidityItem)errors.nextElement();
                int reason = item.getReason();
                if (GWDebug.debug.errorEnabled()) {
                    GWDebug.debug.error("ServerCertApprovalCallback: reason " + reason);
                }
                if (reason == -8172 || reason == -8171 || reason == -8156 || reason == -8179) {
                    if (trustAllServerCerts) continue;
                    ++numReasons;
                    continue;
                }
                if (reason == -12276) {
                    if (ServerCertApprovalCallback.isTrustedDomain(certHost)) continue;
                    ++numReasons;
                    continue;
                }
                ++numReasons;
            }
            return numReasons == 0;
        }
        boolean trust = true;
        while (errors.hasMoreElements()) {
            SSLCertificateApprovalCallback.ValidityItem item = (SSLCertificateApprovalCallback.ValidityItem)errors.nextElement();
            int reason = item.getReason();
            if (GWDebug.debug.errorEnabled()) {
                GWDebug.debug.error("ServerCertApprovalCallback: reason " + reason);
            }
            if (reason == -8172 || reason == -8171 || reason == -8156 || reason == -8179) {
                if (trustAllServerCerts) continue;
                trust = false;
                continue;
            }
            if (reason != -12276) {
                trust = false;
                continue;
            }
            if (ServerCertApprovalCallback.isTrustedDomain(certHost) || certHost.equalsIgnoreCase(this.reqHost)) continue;
            trust = false;
        }
        return trust;
    }

    private static boolean isTrustedDomain(String host) {
        host = host.toLowerCase();
        if (srapGateway_trustedSSLDomainList == null || srapGateway_trustedSSLDomainList.size() < 1) {
            return false;
        }
        if (srapGateway_trustedSSLDomainList.contains(host)) {
            return true;
        }
        Iterator it = srapGateway_trustedSSLDomainList.iterator();
        while (it.hasNext()) {
            String next = it.next().toString().trim();
            int indx = next.indexOf("*");
            if (indx == -1 || !(indx == 0 ? host.endsWith(next.substring(1, next.length())) : host.startsWith(next.substring(0, indx)) && host.endsWith(next.substring(indx + 1, next.length())))) continue;
            return true;
        }
        return false;
    }

    private static String getCertHost(String subjectDN) {
        StringTokenizer st = new StringTokenizer(subjectDN, ",");
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim().toLowerCase();
            if (!token.startsWith("cn=")) continue;
            return token.substring(3);
        }
        return "";
    }

    static {
        String tmp = SystemProperties.get("gateway.trust_all_server_certs");
        trustAllServerCerts = tmp != null && tmp.equals("true");
        Iterator it = GatewayProfile.getStringList("TrustedSSLDomainList").iterator();
        while (it.hasNext()) {
            srapGateway_trustedSSLDomainList.add(it.next().toString().toLowerCase());
        }
    }
}

