/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.server;

import com.sun.portal.rproxy.configservlet.client.GatewayProfile;
import com.sun.portal.rproxy.connectionhandler.HTTPSession;
import com.sun.portal.rproxy.connectionhandler.Session;
import com.sun.portal.util.GWDebug;
import com.sun.portal.util.GWThreadPool;
import java.io.IOException;
import java.net.Socket;

public class RequestProcessor {
    private static final String TIMEOUT = "RProxyPortTimeout";
    private static final int DEFAULT_TIMEOUT = 60000;
    private final String protocol;
    private final int port;
    private static final int timeout = GatewayProfile.getInt("RProxyPortTimeout", 60000);

    public RequestProcessor(String protocol, int port) {
        this.protocol = protocol;
        this.port = port;
    }

    public void processRequestInGWTheadPool(Socket socket, Integer logId) {
        this.processRequestInGWTheadPool(socket, logId, null);
    }

    public void processRequestInGWTheadPool(final Socket socket, Integer logId, String ipAddr) {
        Session session = null;
        try {
            socket.setSoTimeout(timeout);
            final Session tempSession = session = new HTTPSession(socket, ipAddr, this.protocol, this.port);
            Runnable r = new Runnable(){
                private Session session;
                {
                    this.session = tempSession;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    block7: {
                        try {
                            while (this.session != null && this.session.isStillActive()) {
                                this.session.processNextRequest();
                            }
                            Object var2_1 = null;
                            if (this.session == null) break block7;
                            this.session.close();
                            this.session = null;
                        }
                        catch (Throwable throwable) {
                            Object var2_2 = null;
                            if (this.session != null) {
                                this.session.close();
                                this.session = null;
                                try {
                                    socket.close();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                            throw throwable;
                        }
                        try {
                            socket.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            };
            GWThreadPool.run(r);
        }
        catch (Exception e) {
            if (GWDebug.debug.errorEnabled()) {
                GWDebug.debug.error("RProxy caught exception", e);
            }
            if (session != null) {
                session.close();
            }
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
            session = null;
        }
    }
}

