/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.configservlet.server;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;

class Operation {
    public static final int INVALID = -1;
    public static final int LESS_THAN = 1;
    public static final int GREATER_THAN = 2;
    public static final int RANGE = 3;
    public static final int EXACT_VALUE = 4;
    public static final int MATCH_ALL = 5;
    public static final String LESS_THAN_STR = "<";
    public static final String GREATER_THAN_STR = ">";
    public static final String RANGE_STR = ",";
    public static final String MATCH_ALL_STR = "*";
    private static final LinkedList operators = new LinkedList();
    private static final HashMap operatorsMap = new HashMap();
    private static final HashMap unaryMap = new HashMap();
    private int operator = -1;
    private int leftOperand = -1;
    private int rightOperand = -1;
    private boolean unary = false;
    private int unaryOperand = -1;
    private String expr = "";

    public Operation(String str) {
        if (str != null) {
            this.expr = str = str.trim();
            Iterator iter = operators.iterator();
            int operation = -1;
            String stringOperation = null;
            int index = -1;
            while (iter.hasNext()) {
                stringOperation = iter.next().toString();
                index = str.indexOf(stringOperation);
                if (index == -1) continue;
                operation = (Integer)operatorsMap.get(stringOperation);
                break;
            }
            this.operator = operation;
            if (operation != -1) {
                this.unary = (Boolean)unaryMap.get(stringOperation);
                if (this.unary) {
                    str = str.substring(index + 1).trim();
                    try {
                        this.unaryOperand = Integer.parseInt(str);
                    }
                    catch (NumberFormatException nfEx) {}
                } else {
                    StringTokenizer stk = new StringTokenizer(str, stringOperation);
                    if (stk.countTokens() == 2) {
                        try {
                            this.leftOperand = Integer.parseInt(stk.nextToken().trim());
                            this.rightOperand = Integer.parseInt(stk.nextToken().trim());
                        }
                        catch (NumberFormatException nfEx) {}
                    } else {
                        this.operator = -1;
                    }
                }
            } else if (this.expr.equals(MATCH_ALL_STR)) {
                this.operator = 5;
            } else {
                try {
                    this.unaryOperand = Integer.parseInt(str);
                    this.operator = 4;
                }
                catch (NumberFormatException nfEx) {
                    // empty catch block
                }
            }
        }
    }

    public boolean isValid() {
        return -1 != this.getOperator();
    }

    public int getOperator() {
        return this.operator;
    }

    public int getLeftOperand() {
        return this.leftOperand;
    }

    public int getRightOperand() {
        return this.rightOperand;
    }

    public boolean isUnary() {
        return this.unary;
    }

    public int getUnaryOperand() {
        return this.unaryOperand;
    }

    public boolean evaluate(int value) {
        if (this.isValid()) {
            switch (this.getOperator()) {
                case 1: {
                    if (value >= this.unaryOperand) break;
                    return true;
                }
                case 2: {
                    if (value <= this.unaryOperand) break;
                    return true;
                }
                case 4: {
                    if (value != this.unaryOperand) break;
                    return true;
                }
                case 5: {
                    return true;
                }
                case 3: {
                    if (value < this.leftOperand || value > this.rightOperand) break;
                    return true;
                }
            }
        }
        return false;
    }

    static {
        operators.add(LESS_THAN_STR);
        operators.add(GREATER_THAN_STR);
        operators.add(RANGE_STR);
        operatorsMap.put(LESS_THAN_STR, new Integer(1));
        operatorsMap.put(GREATER_THAN_STR, new Integer(2));
        operatorsMap.put(RANGE_STR, new Integer(3));
        unaryMap.put(LESS_THAN_STR, new Boolean(true));
        unaryMap.put(GREATER_THAN_STR, new Boolean(true));
        unaryMap.put(RANGE_STR, new Boolean(false));
    }
}

