/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.configservlet.server;

import com.iplanet.am.util.AMClientDetector;
import com.iplanet.services.cdm.Client;
import com.iplanet.services.cdm.ClientException;
import com.sun.portal.rproxy.configservlet.DummyHTTPServletRequest;
import com.sun.portal.rproxy.configservlet.Request;
import com.sun.portal.rproxy.configservlet.Response;
import com.sun.portal.rproxy.configservlet.ServiceHandler;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.rmi.RemoteException;
import java.util.Hashtable;
import javax.servlet.http.HttpServletRequest;

public class CdmHandler
implements ServiceHandler {
    private static CdmHandler instance = new CdmHandler();
    private Hashtable table = new Hashtable();
    private static final String scrlf = "\r\n";
    static final boolean doDebug = true;
    static PrintWriter log = null;

    private static void writeLog(String message) {
        try {
            log.write(message);
            log.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private CdmHandler() {
    }

    public static CdmHandler getInstance() {
        return instance;
    }

    public Response handleRequest(Request request) throws RemoteException {
        String result;
        Client client;
        String userAgent = request.getRequestObject().toString();
        CdmHandler.writeLog("Request for : " + userAgent + "\n");
        if (!userAgent.endsWith(scrlf)) {
            userAgent = userAgent + scrlf;
        }
        if ((client = (Client)this.table.get(userAgent)) == null) {
            CdmHandler.writeLog(userAgent + " not in cache.\n");
            AMClientDetector amCD = new AMClientDetector();
            result = "autodetect";
            if (amCD.detectionEnabled().equalsIgnoreCase("true")) {
                DummyHTTPServletRequest dmReq = new DummyHTTPServletRequest();
                dmReq.addHeaderLine("GET / HTTP/1.0 \r\n");
                dmReq.addHeaderLine("User-Agent : " + userAgent);
                dmReq.addHeaderLine(scrlf);
                String clientType = amCD.getClientType((HttpServletRequest)dmReq);
                try {
                    client = Client.getInstance((String)clientType);
                    this.table.put(userAgent, client);
                    String str = client.getProperty("cookieSupport");
                    if (str != null) {
                        CdmHandler.writeLog(userAgent + " cookieSupport : " + str + ".\n");
                        result = str.trim();
                    }
                }
                catch (ClientException ce) {
                    result = "autodetect";
                }
            } else {
                result = "autodetect";
            }
        } else {
            String str = client.getProperty("cookieSupport");
            result = str != null ? str.trim() : "autodetect";
        }
        CdmHandler.writeLog(userAgent + " support : " + result + ".\n");
        return new Response(request.getServiceName(), request.getRequestType(), result);
    }

    static {
        try {
            log = new PrintWriter(new FileWriter("/tmp/cdm.servlet.out"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

