/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.wireless.providers.rendering;

import com.aligo.engine.Content;
import com.aligo.portal.wireless.services.rendering.RenderingEngine;
import com.aligo.portal.wireless.services.rendering.RenderingEngineFactory;
import com.aligo.portal.wireless.services.rendering.RenderingException;
import com.aligo.util.Cache;
import com.iplanet.am.util.Debug;
import com.iplanet.services.cdm.Client;
import com.iplanet.services.cdm.ClientsManager;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.mobile.responsebuffer.ResponseBufferEntry;
import com.sun.mobile.responsebuffer.ResponseBufferService;
import com.sun.mobile.responsebuffer.StaleResponseBufferDataException;
import com.sun.portal.providers.ProviderException;
import com.sun.portal.providers.containers.ContainerProvider;
import com.sun.portal.providers.context.ContainerProviderContext;
import com.sun.portal.providers.context.ProviderContextException;
import com.sun.portal.wireless.providers.containers.rendering.RenderingContainerProvider;
import java.io.File;
import java.util.Hashtable;
import javax.servlet.http.HttpServletRequest;

public class RenderingUtil {
    protected static Debug debug = Debug.getInstance((String)"desktop.debug");

    public static StringBuffer renderContent(HttpServletRequest request, ContainerProviderContext cpc, String name, StringBuffer sb) throws ProviderException {
        String parent = cpc.getParentContainerName(name);
        cpc.debugMessage((Object)("RenderingUtil.renderContent: before rendering in channel " + name + "[" + cpc.getParentContainerName(name) + "] = " + sb));
        if (parent != null) {
            ContainerProvider cp = (ContainerProvider)cpc.getProvider(request, null, parent);
            if (cp instanceof RenderingContainerProvider) {
                return sb;
            }
            if (cpc.getClientPath().startsWith("/aml") || cpc.getClientPath().startsWith("aml")) {
                return sb;
            }
            return RenderingUtil.doRender(request, cpc, name, sb, false, true);
        }
        return RenderingUtil.doRender(request, cpc, name, sb, true, false);
    }

    public static StringBuffer renderEditContent(HttpServletRequest request, ContainerProviderContext cpc, String name, StringBuffer sb) throws ProviderException {
        cpc.debugMessage((Object)("RenderingUtil.renderEditContent: before rendering in channel " + name + " = " + sb));
        String parent = request.getParameter("provider");
        Boolean tmp = (Boolean)request.getAttribute(parent + ".shouldRender");
        boolean shouldRender = true;
        if (tmp != null) {
            shouldRender = tmp;
        }
        tmp = (Boolean)request.getAttribute(name + ".isTopLevel");
        boolean isTopLevel = false;
        if (tmp != null) {
            isTopLevel = tmp;
        }
        cpc.debugMessage((Object)("Rendering.renderEditContent: Channel[" + name + "] is topLevel? = " + isTopLevel + ", shouldRender =" + shouldRender));
        if (isTopLevel) {
            return RenderingUtil.doRender(request, cpc, name, sb, true, false);
        }
        if (!shouldRender) {
            return sb;
        }
        return RenderingUtil.doRender(request, cpc, name, sb, false, true);
    }

    public static StringBuffer doRender(HttpServletRequest request, ContainerProviderContext cpc, String name, StringBuffer sb, boolean cache, boolean fragment) throws ProviderException {
        String clientType = null;
        Client client = null;
        SSOToken ssotoken = null;
        try {
            clientType = cpc.getClientType();
            client = ClientsManager.getInstance((String)clientType);
        }
        catch (Exception ce) {
            cpc.debugWarning((Object)"RenderingUtil.doRender: Unable to retrieve client property");
            clientType = "genericHTML";
        }
        if (clientType == null) {
            clientType = "genericHTML";
        }
        try {
            ssotoken = SSOTokenManager.getInstance().createSSOToken(request);
        }
        catch (SSOException ssoe) {
            cpc.debugMessage((Object)("RenderingUtil.doRender(): " + ssoe.getMessage() + ", Bypassing response buffer service"));
            ssotoken = null;
            cache = false;
        }
        ResponseBufferEntry entry = null;
        if (ssotoken != null) {
            StringBuffer request_url = new StringBuffer(request.getRequestURI());
            if (request.getQueryString() != null) {
                request_url = request_url.append("?");
                request_url = request_url.append(request.getQueryString());
            }
            ResponseBufferService service = ResponseBufferService.getInstance();
            try {
                entry = service.createEntry(ssotoken, request_url.toString(), request);
            }
            catch (SSOException ssoe) {
                cpc.debugError((Object)"RenderingUtil.doRender(): ", (Throwable)ssoe);
                return sb;
            }
        }
        Cache entry_cache = null;
        try {
            if (entry != null) {
                entry_cache = entry.getCache();
            }
        }
        catch (StaleResponseBufferDataException srbde) {
            entry_cache = null;
        }
        RenderingEngine engine = RenderingEngineFactory.getInstance().getEngine(entry_cache, name);
        String renderedContent = null;
        try {
            cpc.debugMessage((Object)("RenderingUtil.doRender: Calling rendering engine with cache = " + cache + ", fragment = " + fragment));
            Content xformedContent = engine.renderContent(sb.toString(), client, cache, false, fragment);
            if (xformedContent != null) {
                renderedContent = xformedContent.getContents();
            }
            cpc.debugMessage((Object)("RenderingUtil.doRender: after rendering = " + renderedContent));
        }
        catch (RenderingException re) {
            throw new ProviderException(re.getMessage());
        }
        return new StringBuffer(renderedContent);
    }

    public static StringBuffer getTemplate(ContainerProviderContext cpc, String name, String file) throws ProviderContextException {
        String filepath = cpc.getClientPath();
        if (!filepath.startsWith("/aml") && !filepath.startsWith("aml")) {
            filepath = "/aml/" + filepath;
        }
        return cpc.getTemplate(cpc.getDesktopType(), cpc.getLocale().toString(), name, filepath, file, cpc.getConfigProperty("templateBaseDir"));
    }

    public static StringBuffer getTemplate(ContainerProviderContext cpc, String name, String file, Hashtable table) throws ProviderContextException {
        String filepath = cpc.getClientPath();
        if (!filepath.startsWith("/aml") && !filepath.startsWith("aml")) {
            filepath = "/aml/" + filepath;
        }
        return cpc.getTemplate(cpc.getDesktopType(), cpc.getLocale().toString(), name, filepath, file, table, cpc.getConfigProperty("templateBaseDir"));
    }

    public static File getTemplateMostSpecificPath(ContainerProviderContext cpc, String name, String file) throws ProviderContextException {
        String filepath = cpc.getClientPath();
        if (!filepath.startsWith("/aml") && !filepath.startsWith("aml")) {
            filepath = "/aml/" + filepath;
        }
        return cpc.getTemplateMostSpecificPath(cpc.getDesktopType(), cpc.getLocale().toString(), name, filepath, file, cpc.getConfigProperty("templateBaseDir"));
    }

    public static File getTemplatePath(ContainerProviderContext cpc, String name, String file) throws ProviderContextException {
        String filepath = cpc.getClientPath();
        if (!filepath.startsWith("/aml") && !filepath.startsWith("aml")) {
            filepath = "/aml/" + filepath;
        }
        return cpc.getTemplatePath(cpc.getDesktopType(), cpc.getLocale().toString(), name, filepath, file, cpc.getConfigProperty("templateBaseDir"));
    }
}

