/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.wireless.providers.containers.jsp.rendering.single;

import com.sun.portal.providers.ProviderException;
import com.sun.portal.providers.containers.jsp.single.JSPSingleContainerProvider;
import com.sun.portal.providers.context.ContainerProviderContext;
import com.sun.portal.providers.context.ProviderContext;
import com.sun.portal.providers.context.ProviderContextException;
import com.sun.portal.wireless.providers.containers.rendering.RenderingContainerProvider;
import com.sun.portal.wireless.providers.rendering.RenderingUtil;
import java.io.File;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JSPSingleRenderingContainerProvider
extends JSPSingleContainerProvider
implements RenderingContainerProvider {
    public static final String ERROR_CHANNEL = "errorChannel";
    private ResourceBundle bundle = null;

    public void init(String name, HttpServletRequest req) throws ProviderException {
        super.init(name, req);
        if (this.bundle == null) {
            this.bundle = this.getResourceBundle();
        }
    }

    public StringBuffer getContent(HttpServletRequest req, HttpServletResponse res) throws ProviderException {
        StringBuffer sb = null;
        try {
            sb = super.getContent(req, res);
            sb = this.renderContent(req, sb);
        }
        catch (Throwable t) {
            this.getProviderContext().debugError((Object)(this.getClass().getName() + ".getContent(): "), t);
            return this.handleException(req, res);
        }
        return sb;
    }

    public StringBuffer getEdit(HttpServletRequest req, HttpServletResponse res) throws ProviderException {
        req.setAttribute(this.getName() + ".shouldRender", (Object)Boolean.FALSE);
        req.setAttribute(this.getName() + ".isTopLevel", (Object)Boolean.FALSE);
        StringBuffer sb = null;
        try {
            sb = super.getEdit(req, res);
            sb = this.renderContent(req, sb);
        }
        catch (Throwable t) {
            this.getProviderContext().debugError((Object)(this.getClass().getName() + ".getEdit(): "), t);
            return this.handleException(req, res);
        }
        return sb;
    }

    protected StringBuffer handleException(HttpServletRequest req, HttpServletResponse res) {
        StringBuffer sb = null;
        ContainerProviderContext cpc = (ContainerProviderContext)this.getProviderContext();
        String defErrMsg = this.getClass().getName() + ".handleException(): Error while reading error page." + " Defaulting to base error page";
        String defErrPg = null;
        try {
            defErrPg = this.bundle.getString("defaultError");
        }
        catch (MissingResourceException mre) {
            defErrPg = "";
        }
        if (defErrPg == null) {
            defErrPg = "";
        }
        try {
            String errorCh = this.getStringProperty(ERROR_CHANNEL);
            if (errorCh != null && errorCh.length() != 0) {
                sb = cpc.getContent(req, res, null, errorCh);
            } else {
                cpc.debugError((Object)defErrMsg);
                sb = new StringBuffer(defErrPg);
                sb = RenderingUtil.doRender(req, cpc, this.getName(), sb, true, false);
            }
        }
        catch (Throwable t) {
            cpc.debugError((Object)defErrMsg, t);
            sb = new StringBuffer(defErrPg);
            try {
                sb = RenderingUtil.doRender(req, cpc, this.getName(), sb, true, false);
            }
            catch (Throwable t1) {
                cpc.debugError((Object)"JSPSingleRenderingContainerProvider.handleException Error while rendering Error page. Returning  original string buffer ", t1);
                return sb;
            }
        }
        return sb;
    }

    protected StringBuffer renderContent(HttpServletRequest req, StringBuffer sb) throws ProviderException {
        ContainerProviderContext cpc = (ContainerProviderContext)this.getProviderContext();
        return RenderingUtil.renderContent(req, cpc, this.getName(), sb);
    }

    protected StringBuffer renderEditContent(HttpServletRequest req, StringBuffer sb) throws ProviderException {
        ContainerProviderContext cpc = (ContainerProviderContext)this.getProviderContext();
        req.setAttribute(this.getName() + ".shouldRender", (Object)Boolean.TRUE);
        req.setAttribute(this.getName() + ".isTopLevel", (Object)Boolean.TRUE);
        return RenderingUtil.renderEditContent(req, cpc, this.getName(), sb);
    }

    protected File getMostSpecificJSPPath(ProviderContext pc, String name, String file) throws ProviderException {
        File jspPath = null;
        try {
            jspPath = RenderingUtil.getTemplateMostSpecificPath((ContainerProviderContext)pc, name, file);
        }
        catch (ProviderContextException e) {
            throw new ProviderException(e.getMessage());
        }
        return jspPath;
    }

    public File getExistingJSPPath(ProviderContext pc, String name, String file) throws ProviderException {
        File jspPath = null;
        try {
            jspPath = RenderingUtil.getTemplatePath((ContainerProviderContext)pc, name, file);
        }
        catch (ProviderContextException e) {
            throw new ProviderException(e.getMessage());
        }
        return jspPath;
    }
}

