/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.wireless.providers.containers.jsp.rendering;

import com.sun.portal.providers.Provider;
import com.sun.portal.providers.ProviderException;
import com.sun.portal.providers.context.ContainerProviderContext;
import com.sun.portal.providers.context.ProviderContext;
import com.sun.portal.providers.context.ProviderContextException;
import com.sun.portal.wireless.providers.containers.jsp.WirelessJSPContainerProviderAdapter;
import com.sun.portal.wireless.providers.containers.rendering.RenderingContainerProvider;
import com.sun.portal.wireless.providers.containers.util.ChannelOrder;
import com.sun.portal.wireless.providers.rendering.JSPRenderingProvider;
import com.sun.portal.wireless.providers.rendering.RenderingUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JSPRenderingContainerProvider
extends WirelessJSPContainerProviderAdapter
implements RenderingContainerProvider {
    public static final String PARALLEL_CHANNELS_INIT = "parallelChannelsInit";
    public static final String ERROR_CHANNEL = "errorChannel";
    public static final String WRAPPING_PROVIDER = "RenderingWrappingProvider";
    public static final String WRAPPING_STRING = "_Wrapped_";
    public static final String WRAPPED_CHANNEL_PROPERTY = "wrappedChannel";
    public static final String WRAPPED_CHANNELS = "_WrappedChannels";
    private ResourceBundle bundle = null;
    private List minimizedChannelsList = null;

    public void init(String name, HttpServletRequest httpReq) throws ProviderException {
        super.init(name, httpReq);
        if (this.bundle == null) {
            this.bundle = this.getResourceBundle();
        }
        ContainerProviderContext cpc = this.getContainerProviderContext();
        boolean isParallel = false;
        try {
            isParallel = cpc.getBooleanProperty(this.getName(), PARALLEL_CHANNELS_INIT);
        }
        catch (ProviderContextException e) {
            throw new ProviderException("JSPRenderingContainerProvider.init(): ", (Throwable)e);
        }
        if (isParallel) {
            cpc.initProviders(httpReq, name, this.getSelectedChannels(), 0);
        }
    }

    public StringBuffer getContent(HttpServletRequest req, HttpServletResponse res) throws ProviderException {
        StringBuffer sb = null;
        try {
            sb = super.getContent(req, res);
            sb = this.renderContent(req, sb);
        }
        catch (Throwable e) {
            this.getProviderContext().debugError((Object)"JSPRenderingContainerProviderAdapter.getContent(): ", e);
            return this.handleException(req, res);
        }
        return sb;
    }

    public StringBuffer getEdit(HttpServletRequest req, HttpServletResponse res) throws ProviderException {
        StringBuffer sb = null;
        try {
            sb = super.getEdit(req, res);
        }
        catch (Throwable e) {
            this.getProviderContext().debugError((Object)"JSPRenderingContainerProviderAdapter.getContent(): ", e);
            return this.handleException(req, res);
        }
        return this.renderEditContent(req, sb);
    }

    protected StringBuffer handleException(HttpServletRequest req, HttpServletResponse res) {
        StringBuffer sb = null;
        ContainerProviderContext cpc = (ContainerProviderContext)this.getProviderContext();
        String defErrMsg = "JSPRenderingContainerProvider.handleException(): Error while reading error page. Defaulting to base error page";
        String defErrPg = null;
        try {
            defErrPg = this.bundle.getString("defaultError");
        }
        catch (MissingResourceException mre) {
            defErrPg = "";
        }
        if (defErrPg == null) {
            defErrPg = "";
        }
        try {
            String errorCh = this.getStringProperty(ERROR_CHANNEL);
            if (errorCh != null && errorCh.length() != 0) {
                sb = cpc.getContent(req, res, null, errorCh);
            } else {
                cpc.debugError((Object)defErrMsg);
                sb = new StringBuffer(defErrPg);
                sb = RenderingUtil.doRender(req, cpc, this.getName(), sb, true, false);
            }
        }
        catch (Throwable t) {
            cpc.debugError((Object)defErrMsg, t);
            sb = new StringBuffer(defErrPg);
            try {
                sb = RenderingUtil.doRender(req, cpc, this.getName(), sb, true, false);
            }
            catch (Throwable t1) {
                cpc.debugError((Object)"JSPRenderingContainerProvider.handleException Error while rendering Error page.", t1);
                return sb;
            }
        }
        return sb;
    }

    protected StringBuffer renderContent(HttpServletRequest req, StringBuffer sb) throws ProviderException {
        ContainerProviderContext cpc = this.getContainerProviderContext();
        return RenderingUtil.renderContent(req, cpc, this.getName(), sb);
    }

    protected StringBuffer renderEditContent(HttpServletRequest req, StringBuffer sb) throws ProviderException {
        ContainerProviderContext cpc = this.getContainerProviderContext();
        return RenderingUtil.renderEditContent(req, cpc, this.getName(), sb);
    }

    protected File getMostSpecificJSPPath(ProviderContext pc, String name, String file) throws ProviderException {
        File jspPath = null;
        try {
            jspPath = RenderingUtil.getTemplateMostSpecificPath((ContainerProviderContext)pc, name, file);
        }
        catch (ProviderContextException e) {
            pc.debugError((Object)"JSPRenderingContainerProvider.getMostSpecificJSPPath():", (Throwable)e);
        }
        return jspPath;
    }

    protected File getExistingJSPPath(ProviderContext pc, String name, String file) throws ProviderException {
        File jspPath = null;
        try {
            jspPath = RenderingUtil.getTemplatePath((ContainerProviderContext)pc, name, file);
        }
        catch (ProviderContextException e) {
            pc.debugError((Object)"JSPRenderingContainerProvider.getExistingJSPPath(): ", (Throwable)e);
        }
        return jspPath;
    }

    public List getWrappedOrderedSelectedChannels(HttpServletRequest req, boolean onlyMovable) throws ProviderException {
        ContainerProviderContext cpc = this.getContainerProviderContext();
        List selectedChannels = this.getSelectedChannels();
        if (selectedChannels == null) {
            selectedChannels = new ArrayList();
        }
        if (selectedChannels.size() > 0) {
            selectedChannels = ChannelOrder.order(selectedChannels, (String)this.getName(), (ContainerProviderContext)cpc, (boolean)onlyMovable);
        }
        String channel = null;
        ArrayList<String> newChannelList = new ArrayList<String>();
        for (int i = 0; i < selectedChannels.size(); ++i) {
            channel = (String)selectedChannels.get(i);
            Provider p = cpc.getProvider(req, this.getName(), channel);
            if (cpc.existsChannel(channel)) {
                if (!p.isPresentable(req)) continue;
                if (cpc.isAuthless(req)) {
                    newChannelList.add(channel);
                    continue;
                }
                if (p instanceof JSPRenderingProvider || p instanceof RenderingContainerProvider) {
                    newChannelList.add(channel);
                    continue;
                }
                String wrappedChannel = this.wrapChannel(channel);
                if (wrappedChannel == null) continue;
                newChannelList.add(wrappedChannel);
                continue;
            }
            if (cpc.isAuthless(req)) continue;
            try {
                cpc.removeChannel(channel);
                Map map = null;
                List wrappedChannels = null;
                if (!cpc.existsCollectionProperty(this.getName(), WRAPPED_CHANNELS) || (map = cpc.getCollectionProperty(this.getName(), WRAPPED_CHANNELS)) == null) continue;
                wrappedChannels = (List)map.values();
                wrappedChannels.remove(channel);
                cpc.debugMessage((Object)(this.getClass().getName() + ".getWrappedOrderedSelectedChannels():" + " Deleted wrapped channel " + channel));
                cpc.setCollectionProperty(this.getName(), WRAPPED_CHANNELS, wrappedChannels);
                continue;
            }
            catch (ProviderContextException pce) {
                cpc.debugError((Object)(this.getClass().getName() + ".getWrappedOrderedSelectedChannels():" + " Unable to delete wrapped Channel"), (Throwable)pce);
            }
        }
        this.minimizedChannelsList = newChannelList;
        return newChannelList;
    }

    public List getWrappedOrderedSelectedChannels(HttpServletRequest req) throws ProviderException {
        this.minimizedChannelsList = this.getWrappedOrderedSelectedChannels(req, false);
        return this.minimizedChannelsList;
    }

    public String getMaximizedChannel(HttpServletRequest request) throws ProviderException {
        String maximizedChannel = null;
        String maximizedChannelParam = request.getParameter("m");
        if (maximizedChannelParam != null) {
            List userChannels = !this.getProviderContext().isAuthless(request) && this.minimizedChannelsList != null ? this.minimizedChannelsList : this.getWrappedOrderedSelectedChannels(request);
            try {
                maximizedChannel = (String)userChannels.get(Integer.parseInt(maximizedChannelParam));
            }
            catch (Exception e) {
                throw new ProviderException(this.getClass().getName() + ".getMaximizedChannel(): ", (Throwable)e);
            }
        }
        return maximizedChannel;
    }

    public void cleanUpWrappedChannels(ContainerProviderContext cpc) {
        Map map = null;
        List wrappedChannels = null;
        try {
            if (cpc.existsCollectionProperty(this.getName(), WRAPPED_CHANNELS)) {
                map = cpc.getCollectionProperty(this.getName(), WRAPPED_CHANNELS);
            }
        }
        catch (ProviderContextException pce) {
            cpc.debugError((Object)(this.getClass().getName() + ".cleanUpWrappedChannels(): " + " Unable to read property " + WRAPPED_CHANNELS), (Throwable)pce);
        }
        if (map != null) {
            wrappedChannels = (List)map.values();
            String channel = null;
            for (int i = 0; i < wrappedChannels.size(); ++i) {
                channel = (String)wrappedChannels.get(i);
                if (!cpc.existsChannel(channel)) continue;
                String wrapped_ch_prop = null;
                try {
                    wrapped_ch_prop = cpc.getStringProperty(channel, WRAPPED_CHANNEL_PROPERTY);
                }
                catch (ProviderContextException pce) {
                    cpc.debugMessage((Object)(this.getClass().getName() + ".cleanUpWrappedChannels(): " + channel + " - Unable to get property " + WRAPPED_CHANNEL_PROPERTY));
                }
                if (cpc.existsChannel(wrapped_ch_prop)) continue;
                try {
                    cpc.removeChannel(channel);
                    wrappedChannels.remove(channel);
                    cpc.debugMessage((Object)(this.getClass().getName() + ".cleanUpWrappedChannels(): Deleted " + " wrapped channel " + channel));
                    continue;
                }
                catch (ProviderContextException pce) {
                    cpc.debugError((Object)(this.getClass().getName() + ".cleanUpWrappedChannels(): " + " Unable to delete wrapped Channel"), (Throwable)pce);
                }
            }
            try {
                cpc.setCollectionProperty(this.getName(), WRAPPED_CHANNELS, wrappedChannels);
            }
            catch (ProviderContextException pce) {
                cpc.debugError((Object)(this.getClass().getName() + ".cleanUpWrappedChannels(): " + " Unable to write wrappedChannesl to DP"), (Throwable)pce);
            }
        }
    }

    private String wrapChannel(String channel) {
        ContainerProviderContext cpc = (ContainerProviderContext)this.getProviderContext();
        int idx = 0;
        String wrappedChannel = WRAPPING_STRING + channel;
        if (cpc.existsChannel(wrappedChannel)) {
            String wrapped_ch_prop = null;
            try {
                wrapped_ch_prop = cpc.getStringProperty(wrappedChannel, WRAPPED_CHANNEL_PROPERTY);
            }
            catch (ProviderContextException pce) {
                cpc.debugMessage((Object)(this.getClass().getName() + ".wrapchannel(): " + wrappedChannel + " - Unable to get property " + WRAPPED_CHANNEL_PROPERTY));
            }
            if (wrapped_ch_prop != null && wrapped_ch_prop.equals(channel)) {
                return wrappedChannel;
            }
            String tmp = wrappedChannel + String.valueOf(++idx);
            while (cpc.existsChannel(tmp)) {
                try {
                    wrapped_ch_prop = cpc.getStringProperty(tmp, WRAPPED_CHANNEL_PROPERTY);
                }
                catch (ProviderContextException pce) {
                    cpc.debugMessage((Object)(this.getClass().getName() + ".wrapchannel(): " + tmp + " - Unable to get property " + WRAPPED_CHANNEL_PROPERTY));
                }
                if (wrapped_ch_prop != null && wrapped_ch_prop.equals(channel)) {
                    return tmp;
                }
                tmp = wrappedChannel + String.valueOf(++idx);
            }
            try {
                cpc.createChannel(tmp, WRAPPING_PROVIDER);
                if (cpc.existsCollectionProperty(this.getName(), WRAPPED_CHANNELS)) {
                    Map m = cpc.getCollectionProperty(this.getName(), WRAPPED_CHANNELS);
                    ArrayList wrappedChannels = new ArrayList(m.values());
                    wrappedChannels.add(tmp);
                    cpc.setCollectionProperty(this.getName(), WRAPPED_CHANNELS, wrappedChannels);
                }
                cpc.debugMessage((Object)(this.getClass().getName() + ".wrapChannel() :Created wrapped channel" + tmp));
            }
            catch (ProviderContextException pce) {
                cpc.debugError((Object)(this.getClass().getName() + ".wrapChannel(): " + " Unable to create wrapped Channel"), (Throwable)pce);
                return null;
            }
            try {
                cpc.setStringProperty(tmp, WRAPPED_CHANNEL_PROPERTY, channel);
            }
            catch (ProviderContextException pce) {
                cpc.debugError((Object)(this.getClass().getName() + ".wrapChannel(): " + "Unable to set properties in the wrapped " + "Channel"));
                return null;
            }
            return tmp;
        }
        try {
            cpc.createChannel(wrappedChannel, WRAPPING_PROVIDER);
            if (cpc.existsCollectionProperty(this.getName(), WRAPPED_CHANNELS)) {
                Map m = cpc.getCollectionProperty(this.getName(), WRAPPED_CHANNELS);
                ArrayList wrappedChannels = new ArrayList(m.values());
                wrappedChannels.add(wrappedChannel);
                cpc.setCollectionProperty(this.getName(), WRAPPED_CHANNELS, wrappedChannels);
            }
            cpc.debugMessage((Object)(this.getClass().getName() + ".wrapChannel(): Created wrapped channel " + wrappedChannel));
        }
        catch (ProviderContextException pce) {
            cpc.debugError((Object)(this.getClass().getName() + ".wrapChannel(): " + " Unable to create wrapped Channel"), (Throwable)pce);
            return null;
        }
        try {
            cpc.setStringProperty(wrappedChannel, WRAPPED_CHANNEL_PROPERTY, channel);
        }
        catch (ProviderContextException pce) {
            cpc.debugError((Object)(this.getClass().getName() + ".wrapChannel(): " + "Unable to set properties in the wrapped " + "Channel"));
            return null;
        }
        return wrappedChannel;
    }
}

