/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netmail.protocol;

import com.sun.portal.netmail.protocol.Account;
import com.sun.portal.netmail.protocol.AddressBook;
import com.sun.portal.netmail.protocol.Controller;
import com.sun.portal.netmail.protocol.Folder;
import com.sun.portal.netmail.protocol.Outbox;
import com.sun.portal.netmail.protocol.PersonalAddressBook;
import com.sun.portal.netmail.protocol.Preferences;
import com.sun.portal.netmail.protocol.Requestor;
import java.io.Serializable;

public class Session
implements Serializable,
Requestor {
    public Account primaryAccount;
    private static String sessionClass;
    public int problemCode = 0;
    public Preferences prefs;
    private boolean havePrefsFromServer = false;
    public Outbox outbox;
    public static final int PROFILESAVEFAILED = 3;
    public PersonalAddressBook pab;
    public AddressBook[] addressBooks;
    public static final int LOGINFAILED = 1;
    public static final int WRONGUSER = 2;
    private static String newSessionId;
    public String sessionId = newSessionId;
    public static final int OK = 0;

    public static void setContext(String string) {
        newSessionId = sessionClass + "&context=" + string;
    }

    public void reconnect(Controller controller) {
        controller.getRequest().startOp((Requestor)this, 1, new Serializable[]{this.prefs, this.pab});
        this.primaryAccount.reconnect(controller);
        this.outbox.sendAllMessages(controller);
    }

    static {
        newSessionId = sessionClass = "newAppletSession";
    }

    public void saveProfile(Controller controller) {
        if (this.havePrefsFromServer) {
            Serializable[] serializableArray = new Serializable[]{this.prefs, this.pab};
            controller.getRequest().startOp((Requestor)this, 2, serializableArray);
        }
    }

    public void disconnect(Controller controller) {
        Folder folder;
        if (this.prefs.autopurge && (folder = this.primaryAccount.getFolder("INBOX")) != null) {
            folder.expunge(controller);
        }
        controller.getRequest().startOp((Requestor)this, 3, new Serializable[]{this.prefs});
    }

    public void init(Controller controller) {
        controller.getRequest().startOp((Requestor)this, 0, (Serializable[])null);
        this.outbox.sendAllMessages(controller);
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public boolean isConnected() {
        return !this.sessionId.equals(newSessionId);
    }

    public void forceDisconnect() {
        this.sessionId = newSessionId;
    }

    public Session() {
        this.prefs = new Preferences();
        this.pab = new PersonalAddressBook();
        this.primaryAccount = new Account(0);
        this.addressBooks = new AddressBook[0];
        this.outbox = new Outbox();
    }

    public void opCompleted(Controller controller, int n, Serializable[] serializableArray, Serializable[] serializableArray2) {
        switch (n) {
            case 0: {
                Session session = (Session)serializableArray2[0];
                this.problemCode = session.problemCode;
                this.sessionId = newSessionId;
                this.prefs = session.prefs;
                this.pab = session.pab;
                this.havePrefsFromServer = true;
                this.addressBooks = session.addressBooks;
                switch (session.problemCode) {
                    case 0: {
                        this.sessionId = session.sessionId;
                        this.primaryAccount = session.primaryAccount;
                    }
                }
                controller.sessionUpdated(this);
                break;
            }
            case 1: {
                Session session = (Session)serializableArray2[0];
                if (session.problemCode == 0 || session.problemCode == 3) {
                    this.sessionId = session.sessionId;
                    this.addressBooks = session.addressBooks;
                    this.addressBooks[0] = this.pab;
                }
                this.problemCode = session.problemCode;
                controller.sessionUpdated(this);
                break;
            }
            case 2: {
                Boolean bl = (Boolean)serializableArray2[0];
                controller.profileSaved(bl);
                break;
            }
            case 3: {
                this.sessionId = newSessionId;
                controller.sessionUpdated(this);
            }
        }
    }
}

