/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.wireless.taglibs.cal;

import com.sun.comclient.calendar.DateTime;
import com.sun.comclient.calendar.VTodo;
import com.sun.portal.wireless.taglibs.base.Util;
import com.sun.portal.wireless.taglibs.cal.SchedulingBean;

public class TaskBean
extends SchedulingBean
implements Comparable {
    private VTodo theTask;
    private boolean isDueTime = false;

    public TaskBean(VTodo task) {
        super(task);
        this.theTask = task;
    }

    public VTodo getTask() {
        return this.theTask;
    }

    public DateTime getDueDate() throws Exception {
        return this.theTask.getDueTime();
    }

    public boolean isValidDueDate() throws Exception {
        if (this.theTask.getDueTime() != null) {
            return true;
        }
        this.setDueTimeField("false");
        return false;
    }

    public boolean isDueTime() {
        return this.isDueTime;
    }

    public void setDueTimeField(String isdue) {
        this.isDueTime = isdue.equalsIgnoreCase("true");
    }

    public void setStatus(String status) throws Exception {
        if (status != null) {
            this.theTask.setStatus(status.trim());
        }
    }

    public String getDueTimeField() throws Exception {
        return this.theTask.getDueTime().toString();
    }

    public void setDueDate(DateTime dtDue) throws Exception {
        this.theTask.setStart(dtDue);
        this.theTask.setDueTime(dtDue);
    }

    public boolean isCompleted() {
        try {
            return this.theTask.isCompleted();
        }
        catch (Exception e) {
            return false;
        }
    }

    public String toString() {
        return this.theTask.toString();
    }

    public Object getID() throws Exception {
        return this.theTask.getID();
    }

    public boolean isOverDue() {
        boolean taskOverdue = false;
        DateTime dt = new DateTime();
        try {
            DateTime taskDT = this.theTask.getDueTime();
            if (taskDT == null) {
                return taskOverdue;
            }
            if (taskDT.before((Object)dt) && !this.isCompleted()) {
                taskOverdue = true;
            }
        }
        catch (Exception e) {
            Util.logError((String)"TaskBean.isOverDue(): ", (Throwable)e);
        }
        return taskOverdue;
    }

    public int compareTo(Object o) {
        int result = -1;
        try {
            if (o instanceof TaskBean) {
                TaskBean taskObj = (TaskBean)o;
                if (this.isValidDueDate() && taskObj.isValidDueDate()) {
                    result = this.getDueDate().before((Object)taskObj.getDueDate()) ? -1 : 1;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }
}

