/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.wireless.taglibs.cal;

import com.sun.comclient.calendar.CalendarComponent;
import com.sun.comclient.calendar.CalendarException;
import com.sun.comclient.calendar.DateTime;
import com.sun.comclient.calendar.ICalendar;
import com.sun.comclient.calendar.VEvent;
import com.sun.comclient.calendar.VTodo;
import com.sun.portal.wireless.taglibs.base.Util;
import com.sun.portal.wireless.taglibs.cal.CalCommandTag;
import com.sun.portal.wireless.taglibs.cal.CalContext;
import com.sun.portal.wireless.taglibs.cal.EventBean;
import com.sun.portal.wireless.taglibs.cal.TaskBean;
import java.util.TimeZone;
import java.util.TreeSet;
import javax.servlet.jsp.JspException;

public class FetchTag
extends CalCommandTag {
    private DateTime day;
    private DateTime start;
    private DateTime end;

    public String getDay() {
        return this.day.toString();
    }

    public void setDay(String name) throws Exception {
        if (this.pageContext.getAttribute(name) == null) {
            throw new Exception("Invalid object name in Day:Should be a DateTime ");
        }
        this.setDayDateTime((DateTime)this.pageContext.getAttribute(name));
    }

    private void setDayDateTime(DateTime day) {
        this.day = day;
    }

    public String getStart() {
        return this.start.toString();
    }

    public void setStart(String name) throws Exception {
        if (this.pageContext.getAttribute(name) == null) {
            throw new Exception("Invalid object name in start:Should be a DateTime ");
        }
        this.setStartDateTime((DateTime)this.pageContext.getAttribute(name));
    }

    private void setStartDateTime(DateTime start) {
        this.start = start;
    }

    public String getEnd() {
        return this.end.toString();
    }

    public void setEnd(String name) throws Exception {
        if (this.pageContext.getAttribute(name) == null) {
            throw new Exception("Invalid object name in end:Should be a DateTime ");
        }
        this.setEndDateTime((DateTime)this.pageContext.getAttribute(name));
    }

    private void setEndDateTime(DateTime end) {
        this.end = end;
    }

    public boolean execute() throws JspException {
        CalendarComponent[] compArr;
        CalContext context = this.getContext();
        ICalendar calendar = this.getCalendar();
        if (this.day == null && this.start == null) {
            TimeZone tz = context.getTimeZone();
            this.setDayDateTime(new DateTime(tz));
        }
        if (this.day != null) {
            try {
                compArr = calendar.fetchComponents(this.day, 3);
                context.setEvents(this.getEventBeans(compArr));
                context.setTasks(this.getTodoBeans(compArr));
            }
            catch (CalendarException ce) {
                Util.logError((String)("Fetch event Failed: " + this.day), (Throwable)ce);
                throw new JspException("Fetch event failed: " + (Object)((Object)ce));
            }
            return true;
        }
        if (this.start == null || this.end == null) {
            throw new JspException("FetchTag.execute() : Must specify both 'start' & 'end' attributes");
        }
        try {
            compArr = calendar.fetchComponents(this.start, this.end, 3);
            context.setEvents(this.getEventBeans(compArr));
            context.setTasks(this.getTodoBeans(compArr));
        }
        catch (CalendarException ce) {
            Util.logError((String)"FetchTag.execute(): Fetch Failed:", (Throwable)ce);
            throw new JspException("FetchTag.execute(): Fetch failed: " + (Object)((Object)ce));
        }
        return true;
    }

    private EventBean[] getEventBeans(CalendarComponent[] temp) throws JspException {
        TreeSet<EventBean> eventList = new TreeSet<EventBean>();
        CalContext context = this.getContext();
        for (int i = 0; i < temp.length; ++i) {
            if (!(temp[i] instanceof VEvent)) continue;
            eventList.add(context.toEventBean((VEvent)temp[i]));
        }
        EventBean[] events = new EventBean[eventList.size()];
        events = eventList.toArray(events);
        for (int j = 0; j < events.length - 1; ++j) {
            try {
                if (events[j].isAllDay()) continue;
                for (int k = j + 1; k < events.length && events[j].getEnd().after((Object)events[k].getStart()); ++k) {
                    events[j].setConflict(true);
                    events[k].setConflict(true);
                }
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return events;
    }

    private TaskBean[] getTodoBeans(CalendarComponent[] temp) throws JspException {
        TreeSet<TaskBean> taskList = new TreeSet<TaskBean>();
        CalContext context = this.getContext();
        TimeZone tz = this.getContext().getTimeZone();
        try {
            for (int i = 0; i < temp.length; ++i) {
                if (!(temp[i] instanceof VTodo)) continue;
                TaskBean taskBean = context.toTaskBean((VTodo)temp[i]);
                if (this.day != null) {
                    if (taskBean.getTask().getDueTime() != null) {
                        if (taskBean.getTask().getDueTime().getDay() == this.day.getDay() && taskBean.getTask().getDueTime().getMonth() == this.day.getMonth() && taskBean.getTask().getDueTime().getYear() == this.day.getYear()) {
                            taskList.add(taskBean);
                            continue;
                        }
                        if (!taskBean.getTask().getDueTime().before((Object)this.day) || !taskBean.isOverDue()) continue;
                        taskList.add(taskBean);
                        continue;
                    }
                    if (taskBean.isCompleted()) continue;
                    taskList.add(taskBean);
                    continue;
                }
                if (this.start == null || this.end == null) continue;
                if (taskBean.getTask().getDueTime() != null) {
                    if (this.start.before((Object)taskBean.getTask().getDueTime()) && this.end.after((Object)taskBean.getTask().getDueTime())) {
                        taskList.add(taskBean);
                        continue;
                    }
                    if (!taskBean.getTask().getDueTime().before((Object)this.start) || !taskBean.isOverDue()) continue;
                    taskList.add(taskBean);
                    continue;
                }
                if (taskBean.isCompleted()) continue;
                taskList.add(taskBean);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Util.logError((String)("FetchTag.getTodoBeans():" + e));
            throw new JspException("FetchTag.getTodoBeans():" + e);
        }
        TaskBean[] tasks = new TaskBean[taskList.size()];
        tasks = taskList.toArray(tasks);
        return tasks;
    }
}

