/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.wireless.taglibs.cal;

import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenEvent;
import com.sun.comclient.calendar.CalendarSession;
import com.sun.comclient.calendar.CalendarStore;
import com.sun.comclient.calendar.CalendarStoreException;
import com.sun.comclient.calendar.ICalendar;
import com.sun.comclient.calendar.VEvent;
import com.sun.comclient.calendar.VTodo;
import com.sun.portal.wireless.taglibs.base.Context;
import com.sun.portal.wireless.taglibs.cal.EventBean;
import com.sun.portal.wireless.taglibs.cal.TaskBean;
import com.sun.ssoadapter.SSOAdapter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;

public class CalContext
extends Context {
    public static final String CONTEXT_CLASS_NAME = "com.sun.portal.wireless.taglibs.cal.CalContext";
    public static final String CONTEXT_CACHE_CLASS_NAME = "com.sun.portal.wireless.taglibs.cal.CalContextCache";
    public static final String CONTEXT_TYPE = "calcontext";
    public static final String SSO_CONFIG_TYPE = "CALENDAR-TYPE";
    static final String CALSESSION = "_wps_calendar_session";
    private CalendarStore calStore = null;
    private CalendarSession calSession = null;
    private ICalendar currentCalendar = null;
    private String currentCalendarID = null;
    private EventBean[] events;
    private TaskBean[] tasks;

    public void init(HttpServletRequest request, SSOToken session, SSOAdapter ssoAdapter) throws Exception {
        super.init(request, session, "SunMobileAppCalendarService", ssoAdapter);
        this.calStore = (CalendarStore)ssoAdapter.getConnection();
        this.calSession = this.calStore.getSession();
        this.calSession.setTimeZone(this.getTimeZone());
        try {
            this.currentCalendar = this.calStore.openCalendar();
            this.currentCalendarID = this.currentCalendar.getCalID();
        }
        catch (CalendarStoreException cse) {
            throw new JspException("Opening default Calendar Failed:");
        }
    }

    public EventBean toEventBean(VEvent event) {
        EventBean eb = new EventBean(event);
        return eb;
    }

    public TaskBean toTaskBean(VTodo task) {
        return new TaskBean(task);
    }

    public static CalContext getContext(PageContext pageContext) throws Exception {
        return (CalContext)Context.getContext((PageContext)pageContext, (String)CONTEXT_CLASS_NAME, (String)CONTEXT_CACHE_CLASS_NAME, (String)CONTEXT_TYPE);
    }

    public void setCalendar(String calendarID) throws JspException {
        try {
            this.currentCalendar = this.calStore.openCalendar(calendarID);
            this.currentCalendarID = calendarID;
        }
        catch (CalendarStoreException cse) {
            throw new JspException("Opening Calendar Failed: " + calendarID);
        }
    }

    public ICalendar getCalendar() {
        return this.currentCalendar;
    }

    public CalendarStore getCalStore() {
        return this.calStore;
    }

    public String getCalendarID() {
        return this.currentCalendarID;
    }

    public EventBean[] getEvents() {
        return this.events;
    }

    public TaskBean[] getTasks() {
        return this.tasks;
    }

    public void setEvents(EventBean[] evnts) {
        this.events = evnts;
    }

    public void setTasks(TaskBean[] tsks) {
        this.tasks = tsks;
    }

    public EventBean getEvent(int index) {
        return this.events != null ? this.events[index] : null;
    }

    public TaskBean getTask(int index) {
        return this.tasks != null ? this.tasks[index] : null;
    }

    public int getEventCount() {
        return this.events != null ? this.events.length : 0;
    }

    public int getTaskCount() {
        return this.tasks != null ? this.tasks.length : 0;
    }

    public int getEventSize() {
        return this.getEventCount();
    }

    public boolean isEventsEmpty() {
        return this.getEventCount() == 0;
    }

    public boolean isTasksEmpty() {
        return this.getTaskCount() == 0;
    }

    public String getServiceURL() {
        return this.calStore.getServiceUrl().toString();
    }

    public String getSessionProperty(String name) {
        return this.calSession.getProperty(name);
    }

    public boolean isUserTheOwner() {
        return true;
    }

    public void ssoTokenChanged(SSOTokenEvent evt) {
        try {
            int evtType = evt.getType();
            if (evtType != 3) {
                if (evtType != 1) {
                    if (evtType != 2) {
                        return;
                    }
                }
            }
            if (this.calStore != null) {
                this.calStore.disconnect();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.ssoTokenChanged(evt);
    }

    public void closeConnection() {
        try {
            if (this.getSSOAdapter() != null) {
                this.calStore = (CalendarStore)this.getSSOAdapter().getConnection();
            }
            if (this.calStore != null) {
                this.calStore.disconnect();
            }
            super.closeConnection();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void reloadUserPreferences() {
        this.loadTimeZone();
        if (this.getSSOAdapter() != null) {
            this.calStore = (CalendarStore)this.getSSOAdapter().getConnection();
        }
        if (this.calStore != null) {
            this.calSession = this.calStore.getSession();
        }
        if (this.calSession != null) {
            this.calSession.setTimeZone(this.getTimeZone());
        }
    }
}

