/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ssoadapter.config;

import com.iplanet.am.util.Debug;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchema;
import com.sun.ssoadapter.config.DSAMEConnection;
import com.sun.ssoadapter.config.DSAMEConstants;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class DSAMEUtils
implements DSAMEConstants {
    private static Debug debug = DSAMEConnection.debug;
    private String thisClass = null;
    private static DSAMEUtils dsameUtils = null;
    private DSAMEConnection dsameConnection = null;
    private Hashtable schemaTable = new Hashtable();
    private Map currentlyLoading = new HashMap();

    private DSAMEUtils(DSAMEConnection conn) {
        this.dsameConnection = conn;
        this.thisClass = this.getClass().getName();
    }

    public static DSAMEUtils getInstance() {
        return dsameUtils;
    }

    public static synchronized DSAMEUtils getInstance(DSAMEConnection conn) {
        if (dsameUtils == null) {
            dsameUtils = new DSAMEUtils(conn);
        }
        return dsameUtils;
    }

    public int getAttributeScope(String serviceName, String attrName) {
        int scope;
        ServiceSchemaMap srvcSchema = this.getSchemaMap(serviceName);
        int n = scope = srvcSchema != null ? srvcSchema.getScope(attrName) : 3;
        if (debug.messageEnabled()) {
            debug.message(this.thisClass + ".getAttributeScope(): service = " + serviceName + ":: Attr = " + attrName + ":: Scope = " + DSAMEConstants.scopeArray[scope]);
        }
        return scope;
    }

    public int getAttributeType(String serviceName, String attrName) {
        int type;
        ServiceSchemaMap srvcSchema = this.getSchemaMap(serviceName);
        int n = type = srvcSchema != null ? srvcSchema.getType(attrName) : 3;
        if (debug.messageEnabled()) {
            debug.message(this.thisClass + ".getAttributeType(): service = " + serviceName + ":: Attr = " + attrName + ":: Type = " + type);
        }
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceSchemaMap getSchemaMap(String serviceName) {
        ServiceSchemaMap srvcSchema = null;
        if (serviceName == null) {
            return null;
        }
        srvcSchema = (ServiceSchemaMap)this.schemaTable.get(serviceName);
        if (srvcSchema != null) {
            if (debug.messageEnabled()) {
                debug.message("Got From SchemaCache: " + serviceName);
            }
            return srvcSchema;
        }
        Object loadIndicator = null;
        Object nowLoadingIndicator = new Object();
        Object object = this.currentlyLoading;
        synchronized (object) {
            srvcSchema = (ServiceSchemaMap)this.schemaTable.get(serviceName);
            if (srvcSchema != null) {
                if (debug.messageEnabled()) {
                    debug.message("(sync) Got From SchemaCache: " + serviceName);
                }
                return srvcSchema;
            }
            loadIndicator = this.currentlyLoading.get(serviceName);
            if (loadIndicator == null) {
                this.currentlyLoading.put(serviceName, nowLoadingIndicator);
                if (debug.messageEnabled()) {
                    debug.message("Adding to MonitorList: " + serviceName);
                }
            }
        }
        if (loadIndicator != null) {
            if (debug.messageEnabled()) {
                debug.message("Waiting for: " + serviceName);
            }
            object = loadIndicator;
            synchronized (object) {
                srvcSchema = (ServiceSchemaMap)this.schemaTable.get(serviceName);
            }
            if (debug.messageEnabled()) {
                debug.message("END Wait: " + serviceName);
            }
        } else {
            object = nowLoadingIndicator;
            synchronized (object) {
                block29: {
                    try {
                        srvcSchema = this.loadAttrsMap(serviceName);
                    }
                    catch (SMSException ame) {
                        if (debug.messageEnabled()) {
                            debug.message("Got SMSException for service: " + serviceName, (Throwable)ame);
                        }
                    }
                    catch (Exception e) {
                        if (!debug.messageEnabled()) break block29;
                        debug.message("Got Exception for service: " + serviceName, (Throwable)e);
                    }
                }
                Map map = this.currentlyLoading;
                synchronized (map) {
                    if (debug.messageEnabled()) {
                        debug.message("Loading done: " + serviceName);
                    }
                    if (srvcSchema != null) {
                        this.schemaTable.put(serviceName, srvcSchema);
                    }
                    this.currentlyLoading.remove(serviceName);
                }
            }
        }
        return srvcSchema;
    }

    private ServiceSchemaMap loadAttrsMap(String serviceName) throws SMSException {
        Set scopes;
        ServiceSchemaMap newMap = new ServiceSchemaMap(serviceName);
        if (debug.messageEnabled()) {
            debug.message(this.thisClass + ".loadAttrsMap():: " + serviceName);
            debug.message("****************************************");
        }
        if ((scopes = this.dsameConnection.getSchemaTypes(serviceName)) == null || scopes.size() <= 0) {
            if (debug.messageEnabled()) {
                debug.message(this.thisClass + ".loadAttrsMap() No scopes defined !!" + serviceName);
            }
            return newMap;
        }
        Iterator iter = scopes.iterator();
        while (iter.hasNext()) {
            SchemaType scope = (SchemaType)iter.next();
            ServiceSchema schema = this.dsameConnection.getSchema(serviceName, scope);
            Set attrSchemas = schema.getAttributeSchemas();
            if (attrSchemas == null && attrSchemas.size() <= 0) {
                if (!debug.messageEnabled()) continue;
                debug.message(this.thisClass + ".loadAttrsMap() Empty scope defn");
                continue;
            }
            String scopeStr = scope.toString();
            Iterator itr = attrSchemas.iterator();
            int ourScope = this.scopeToInt(scope);
            while (itr.hasNext()) {
                AttributeSchema attrSchema = (AttributeSchema)itr.next();
                AttrSchema aSchema = new AttrSchema();
                aSchema.attrName = attrSchema.getName();
                aSchema.type = this.typeToInt(attrSchema.getType());
                aSchema.scope = ourScope;
                debug.message("DSAMEUtils:loadAttrsMap() Adding to MAP :: " + scopeStr + " :: " + attrSchema.toString());
                newMap.add(aSchema.attrName, aSchema);
            }
        }
        if (debug.messageEnabled()) {
            debug.message(this.thisClass + ".loadAttrsMap() Done: " + serviceName);
            debug.message("****************************************");
        }
        return newMap;
    }

    private int scopeToInt(SchemaType scope) {
        int ourScope = 0;
        ourScope = scope.equals((Object)SchemaType.GLOBAL) ? 5 : (scope.equals((Object)SchemaType.ORGANIZATION) ? 6 : (scope.equals((Object)SchemaType.DYNAMIC) ? 8 : (scope.equals((Object)SchemaType.USER) ? 9 : (scope.equals((Object)SchemaType.POLICY) ? 10 : -1))));
        return ourScope;
    }

    private int typeToInt(AttributeSchema.Type type) {
        int retType = 0;
        retType = type.equals((Object)AttributeSchema.Type.SINGLE) ? 1 : (type.equals((Object)AttributeSchema.Type.SINGLE_CHOICE) ? 2 : (type.equals((Object)AttributeSchema.Type.LIST) ? 3 : (type.equals((Object)AttributeSchema.Type.MULTIPLE_CHOICE) ? 4 : (type.equals((Object)AttributeSchema.Type.SIGNATURE) ? 5 : (type.equals((Object)AttributeSchema.Type.VALIDATOR) ? 6 : -1)))));
        return retType;
    }

    public Set getClientValues(Set vals, String client, Map awareMap, boolean removeClientInfo) {
        HashSet<String> clientSet = null;
        HashSet<String> defaultSet = null;
        HashSet<String> otherClientSet = null;
        HashSet<String> notAwareSet = null;
        HashSet<String> retSet = null;
        client = client + "|";
        String[] newVals = new String[1];
        if (debug.messageEnabled()) {
            debug.message(this.thisClass + ".getClientValues():: Client: " + client + " :: RemoveClientInfo: " + removeClientInfo + " :: Orig Values: " + vals);
        }
        if (vals != null && vals.size() > 0) {
            Iterator iter = vals.iterator();
            while (iter.hasNext()) {
                String val = (String)iter.next();
                int type = this.checkClientInfo(client, val, newVals, removeClientInfo);
                if (type == 1) {
                    if (clientSet == null) {
                        clientSet = new HashSet<String>();
                    }
                    clientSet.add(newVals[0]);
                    continue;
                }
                if (type == 3) {
                    if (defaultSet == null) {
                        defaultSet = new HashSet();
                    }
                    defaultSet.add(newVals[0]);
                    continue;
                }
                if (type == 2) {
                    if (otherClientSet == null) {
                        otherClientSet = new HashSet<String>();
                    }
                    otherClientSet.add(newVals[0]);
                    continue;
                }
                if (notAwareSet == null) {
                    notAwareSet = new HashSet<String>();
                }
                notAwareSet.add(newVals[0]);
            }
        }
        if (clientSet != null) {
            retSet = clientSet;
        } else if (defaultSet != null) {
            retSet = defaultSet;
        } else if (otherClientSet == null) {
            retSet = vals;
        } else {
            if (notAwareSet != null) {
                debug.warning(this.thisClass + ".checkClientInfo():: " + "Mix of client-aware & not-aware properties: returning null");
            }
            retSet = null;
        }
        if (awareMap != null) {
            awareMap.put("originalSet", vals);
            awareMap.put("defaultSet", defaultSet);
            awareMap.put("clientSet", clientSet);
            awareMap.put("otherClientSet", otherClientSet);
            awareMap.put("notAwareSet", notAwareSet);
        }
        return retSet;
    }

    private int checkClientInfo(String client, String val, String[] newVals, boolean rmClientInfo) {
        int type = -1;
        int index = -1;
        if (debug.messageEnabled()) {
            debug.message(this.thisClass + ".checkClientInfo():: Client: " + client + " :: Value: " + val);
        }
        if (val == null) {
            return type;
        }
        if ((val = val.trim()).startsWith(client)) {
            type = 1;
            if (newVals != null) {
                newVals[0] = rmClientInfo ? val.substring(client.length()) : val;
            }
        } else if (val.startsWith("default|")) {
            type = 3;
            if (newVals != null) {
                newVals[0] = rmClientInfo ? val.substring("default|".length()) : val;
            }
        } else {
            index = val.indexOf("|");
            if (index != -1) {
                type = 2;
                if (newVals != null) {
                    newVals[0] = rmClientInfo ? val.substring(index + 1) : val;
                }
            } else {
                type = 4;
                if (newVals != null) {
                    newVals[0] = val;
                }
            }
        }
        if (debug.messageEnabled()) {
            String retStr = newVals[0] != null ? newVals[0] : val;
            debug.message(this.thisClass + ".checkClientInfo():: Type: " + DSAMEConstants.parseTypeArray[type] + " :: Return string: " + retStr);
        }
        return type;
    }

    public String getServiceName(Map map) {
        String name = (String)map.get("serviceName");
        if (name == null || name.trim().equals("")) {
            name = null;
        }
        return name;
    }

    public String getClientName(Map map) {
        String name = (String)map.get("clientType");
        if (name == null || name.trim().equals("")) {
            name = null;
        }
        return name;
    }

    public Set modifyValues(String clientType, Map awareMap, Set vals, boolean forceCA) {
        Set clientSet = (Set)awareMap.get("clientSet");
        Set defaultSet = (Set)awareMap.get("defaultSet");
        Set otherClientSet = (Set)awareMap.get("otherClientSet");
        Set notAwareSet = (Set)awareMap.get("notAwareSet");
        Set newVals = new HashSet();
        if (debug.messageEnabled()) {
            debug.message(this.thisClass + ":modifyValues() clientSet: " + clientSet + " ::DefaultSET: " + defaultSet + " :: otherSet = " + otherClientSet + " :: naSet: " + notAwareSet);
        }
        if (clientSet == null && defaultSet == null && otherClientSet == null) {
            if (debug.messageEnabled()) {
                debug.message(":modifyValues() No existing CA Values");
            }
            if (notAwareSet != null) {
                if (debug.messageEnabled()) {
                    debug.message(":modifyValues() found non-CA values");
                }
                if (forceCA) {
                    this.addAsDefault(newVals, "default|", notAwareSet);
                    this.addWithClientInfo(newVals, clientType, vals);
                } else {
                    newVals = vals;
                }
            } else {
                if (debug.messageEnabled()) {
                    debug.message(":modifyValues() no values");
                }
                if (forceCA) {
                    this.addWithClientInfo(newVals, clientType, vals);
                } else {
                    newVals.addAll(vals);
                }
            }
        } else {
            if (notAwareSet != null) {
                this.addAsDefault(newVals, "default|", notAwareSet);
            }
            if (debug.messageEnabled()) {
                debug.message(":modifyValues() found some CA values");
            }
            if (defaultSet != null) {
                newVals.addAll(defaultSet);
            }
            if (otherClientSet != null) {
                newVals.addAll(otherClientSet);
            }
            this.addWithClientInfo(newVals, clientType, vals);
        }
        return newVals;
    }

    private Set addAsDefault(Set newSet, String client, Set set) {
        if (set != null) {
            Iterator iter = set.iterator();
            while (iter.hasNext()) {
                String val = (String)iter.next();
                val = client + val;
                newSet.add(val);
            }
        }
        return newSet;
    }

    private Set addWithClientInfo(Set newSet, String client, Set vals) {
        if (vals != null) {
            Iterator iter = vals.iterator();
            while (iter.hasNext()) {
                String val = (String)iter.next();
                val = client + "|" + val;
                newSet.add(val);
            }
        }
        return newSet;
    }

    private class AttrSchema {
        public String attrName = null;
        public int scope;
        public int type;
        public String any;

        private AttrSchema() {
        }
    }

    private class ServiceSchemaMap {
        private HashMap attrsMap = new HashMap();
        private String serviceName = null;

        public ServiceSchemaMap(String srvcName) {
            this.serviceName = srvcName;
        }

        public int getScope(String attrName) {
            AttrSchema attr = (AttrSchema)this.attrsMap.get(attrName);
            int scope = attr == null ? 4 : attr.scope;
            return scope;
        }

        public int getType(String attrName) {
            AttrSchema attr = (AttrSchema)this.attrsMap.get(attrName);
            int type = attr == null ? 4 : attr.type;
            return type;
        }

        public void add(String attrName, AttrSchema attrSchema) {
            this.attrsMap.put(attrName, attrSchema);
        }
    }
}

