/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.rewriter;

import com.sun.portal.rewriter.util.Debug;
import com.sun.portal.rewriter.util.crypto.CryptoHelper;
import com.sun.portal.rewriter.util.uri.DecoratedURI;
import com.sun.portal.rproxy.connectionhandler.Request;
import com.sun.portal.rproxy.connectionhandler.Response;
import com.sun.portal.rproxy.rewriter.SRAPTranslatorBuilder;
import com.sun.portal.rproxy.rewriter.util.SRAPConfigManager;
import com.sun.portal.rproxy.rewriter.util.uri.SRAPGatewayURI;
import java.net.MalformedURLException;

public final class SRAPTranslatorHelper {
    public static String decodeOfuscatedURI(String aURI) {
        String lResult = aURI;
        if (SRAPConfigManager.isObscureURIs()) {
            lResult = CryptoHelper.decode((String)aURI);
        }
        try {
            lResult = new DecoratedURI(lResult).toExternalForm();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return lResult;
    }

    public static String prefixGateway(SRAPGatewayURI aGatewayURI, DecoratedURI aAbsoluteURI) {
        SRAPGatewayURI lGatewayURI = aGatewayURI.decideGatewayURI(aAbsoluteURI);
        if (lGatewayURI.isNetworkURIMatch(aAbsoluteURI)) {
            return aAbsoluteURI.toExternalForm();
        }
        String lGatewayURIString = lGatewayURI.toReverseProxyForm();
        String lAbsoluteURIString = aAbsoluteURI.toExternalForm();
        StringBuffer sb = new StringBuffer(lGatewayURIString.length() + lAbsoluteURIString.length() + 1);
        sb.append(lGatewayURIString).append("/");
        sb.append(lAbsoluteURIString);
        return sb.toString();
    }

    public static String translateHeaderURL(String aURI, Response aResp, Request aReq, boolean aParseHeader, boolean aIsAddScheme) {
        int i;
        String lURI = aURI;
        if (aParseHeader && (i = aURI.indexOf(58)) != -1 && i < aURI.length()) {
            lURI = aURI.substring(i + 1).trim();
        }
        return SRAPTranslatorHelper.addScheme(lURI, aReq);
    }

    private static final String addScheme(String aOrgURI, Request aRequest) {
        try {
            return SRAPTranslatorBuilder.create(aRequest, null).translate(aOrgURI);
        }
        catch (Exception e) {
            Debug.recordURIWarning((String)("Invalid URI in SRAPTranslatorHelper:BaseURI:" + aOrgURI + "GatewayURI:" + aRequest.getGatewayURL()), (Exception)e);
            return aOrgURI;
        }
    }
}

