/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.rewriter;

import com.sun.portal.rewriter.AbstractTranslator;
import com.sun.portal.rewriter.JSFunctionSpec;
import com.sun.portal.rewriter.util.uri.DecoratedURI;
import com.sun.portal.rewriter.util.uri.PageSpec;
import com.sun.portal.rproxy.rewriter.SRAPJSFunctionSpec;
import com.sun.portal.rproxy.rewriter.SRAPTranslatorHelper;
import com.sun.portal.rproxy.rewriter.util.SRAPConfigManager;
import com.sun.portal.rproxy.rewriter.util.uri.SRAPGatewayURI;

public class SRAPTranslator
extends AbstractTranslator {
    private JSFunctionSpec srapJSFunctionSpec;
    private SRAPGatewayURI gatewayURI;

    public SRAPTranslator(SRAPGatewayURI aGatewayURI, PageSpec aPageSpec) {
        super(aPageSpec);
        this.init(aGatewayURI);
    }

    private void init(SRAPGatewayURI aGatewayURI) {
        this.gatewayURI = aGatewayURI;
        this.srapJSFunctionSpec = new SRAPJSFunctionSpec(this.gatewayURI);
    }

    public JSFunctionSpec getJSFunctionSpec() {
        return this.srapJSFunctionSpec;
    }

    public String hook4Translate(DecoratedURI aAbsoluteURI, DecoratedURI aTranslatedURI) {
        if (!this.needs2Translate(aAbsoluteURI) || SRAPConfigManager.isNot2RewriteURI(aAbsoluteURI)) {
            return aAbsoluteURI.getInputString();
        }
        return SRAPTranslatorHelper.prefixGateway(this.gatewayURI, aTranslatedURI);
    }

    public SRAPGatewayURI getGatewayURI() {
        return this.gatewayURI;
    }

    private boolean needs2Translate(DecoratedURI aAbsoluteURI) {
        String lLowerCaseProtocol = aAbsoluteURI.getProtocol().toLowerCase();
        String lLowerCaseHost = aAbsoluteURI.getHost().toLowerCase();
        if (!lLowerCaseProtocol.equals("http") && !lLowerCaseProtocol.equals("https") || lLowerCaseHost.equals("localhost") || lLowerCaseHost.equals("127.0.0.1")) {
            return false;
        }
        if (SRAPConfigManager.isIntranet(lLowerCaseHost)) {
            return true;
        }
        return SRAPConfigManager.isRewriteSRCValue() && this.getLookAheadInfo().getTagContext().isSRC() && lLowerCaseProtocol.equals("http") && this.gatewayURI.getProtocol().equalsIgnoreCase("https");
    }
}

