/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.eproxy;

import com.sun.portal.netlet.econnection.ReaderWriter;
import com.sun.portal.netlet.econnection.ReaderWriterClear;
import com.sun.portal.netlet.econnection.ReaderWriterLock;
import com.sun.portal.netlet.eproxy.SConn;
import com.sun.portal.perf.rproxy.PerfContextObject;
import com.sun.portal.perf.rproxy.SocketCount;
import com.sun.portal.util.GWDebug;
import com.sun.portal.util.GWLogManager;
import com.sun.portal.util.GWThreadPool;
import com.sun.portal.util.LogInfoContainer;
import com.sun.portal.util.SystemProperties;
import java.net.Socket;
import org.mozilla.jss.ssl.SSLSocket;

public class RWGroupClear
extends ReaderWriterLock {
    private Socket fromClient;
    private Socket toServer;
    private ReaderWriterClear src_to_dst;
    private ReaderWriterClear dst_to_src;
    private boolean src_to_dst_clean;
    private boolean dst_to_src_clean;

    public RWGroupClear(Socket fromClient, int sslPort, Integer logId) {
        block10: {
            this.src_to_dst_clean = false;
            this.dst_to_src_clean = false;
            this.fromClient = fromClient;
            String bindAddress = SystemProperties.get("gateway.bindipaddress");
            if (bindAddress == null) {
                bindAddress = "127.0.0.1";
            }
            this.toServer = SConn.connect(sslPort, bindAddress);
            if (this.toServer == null) {
                if (GWDebug.debug.warningEnabled()) {
                    GWDebug.debug.warning("RWGroupClear cannot open connection to localhost:" + sslPort);
                }
                return;
            }
            String unqID = this.toServer.getLocalPort() + "_" + "A";
            if (GWLogManager.logIdMap.containsKey(unqID)) {
                GWLogManager.logIdMap.remove(unqID);
            }
            GWLogManager.logIdMap.put(unqID, new LogInfoContainer(logId, fromClient));
            if (GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message("RWGroupClear opened " + this.toServer);
            }
            if (GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message("RWGroupClear original non-ssl socket request mapped on port   " + this.toServer.getLocalPort());
                GWDebug.debug.message("non-ssl socket info " + fromClient);
            }
            try {
                this.src_to_dst = new ReaderWriterClear(this, fromClient.getInputStream(), this.toServer.getOutputStream(), logId, fromClient.getOutputStream());
                this.dst_to_src = new ReaderWriterClear(this, this.toServer.getInputStream(), fromClient.getOutputStream(), logId);
            }
            catch (Exception ex) {
                GWDebug.debug.error("RWGroupCrypt: Unable to create reader writers.", ex);
            }
            this.src_to_dst.useKeepAliveLogic();
            this.dst_to_src.useKeepAliveLogic();
            try {
                GWThreadPool.run(this.src_to_dst);
                GWThreadPool.run(this.dst_to_src);
            }
            catch (InterruptedException e) {
                if (!GWDebug.debug.errorEnabled()) break block10;
                GWDebug.debug.error("Could not start ReaderWriterClear tasks", e);
            }
        }
    }

    public synchronized void notifyFinished(ReaderWriter obj) {
        if (obj == this.src_to_dst) {
            if (this.dst_to_src.isAlive()) {
                this.dst_to_src.stop();
            }
        } else if (obj == this.dst_to_src && this.src_to_dst.isAlive()) {
            this.src_to_dst.stop();
        }
        this.cleanup();
        if (obj == this.src_to_dst) {
            this.src_to_dst_clean = true;
        } else if (obj == this.dst_to_src) {
            this.dst_to_src_clean = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        System.out.println("In cleanup routine...");
        if (this.fromClient != null) {
            try {
                this.fromClient.close();
                if (PerfContextObject.ENABLE_PERF) {
                    if (this.fromClient instanceof SSLSocket) {
                        SocketCount.decrementSSLSockets();
                    } else {
                        SocketCount.decrementPlainSockets();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.fromClient = null;
            }
        }
        if (this.toServer != null) {
            try {
                this.toServer.close();
                if (this.toServer instanceof SSLSocket) {
                    SocketCount.decrementSSLSockets();
                } else {
                    SocketCount.decrementPlainSockets();
                }
            }
            catch (Exception exception) {
            }
            finally {
                this.toServer = null;
            }
        }
    }

    public boolean isDone() {
        if (this.dst_to_src_clean && this.src_to_dst_clean) {
            this.dst_to_src = null;
            this.src_to_dst = null;
        }
        return this.dst_to_src_clean && this.src_to_dst_clean;
    }

    public long getLastActivityTime() {
        long ctime;
        long stime = this.src_to_dst.getLastActivityTime();
        if (stime > (ctime = this.dst_to_src.getLastActivityTime())) {
            return ctime;
        }
        return stime;
    }

    public synchronized void stopAll() {
        GWDebug.debug.message("WARNING STOPPING ALL SERVER");
        if (this.dst_to_src != null) {
            this.dst_to_src.stop();
        }
        if (this.src_to_dst != null) {
            this.src_to_dst.stop();
        }
        this.cleanup();
    }

    public int getAppletSrcPort() {
        return 0;
    }

    public long getStartTime() {
        return 0L;
    }
}

