/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers.userinfo.tag;

import com.sun.portal.providers.context.ProviderContext;
import com.sun.portal.providers.context.ProviderContextException;
import com.sun.portal.providers.userinfo.tag.ReadTag;
import com.sun.portal.providers.userinfo.tag.TagCastException;
import com.sun.portal.providers.userinfo.tag.TagException;
import com.sun.portal.providers.userinfo.tag.TagModule;
import com.sun.portal.providers.userinfo.tag.TagModuleElement;
import com.sun.portal.providers.userinfo.tag.UndefinedTagException;
import com.sun.portal.providers.userinfo.tag.WriteTag;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class TagModuleManager {
    private ProviderContext context = null;
    private Map modules = null;
    private Map tags = null;
    private String channel = null;

    public TagModuleManager(String string, ProviderContext providerContext, HttpServletRequest httpServletRequest) throws TagException {
        this.init(string, providerContext, httpServletRequest);
    }

    private void init(String string, ProviderContext providerContext, HttpServletRequest httpServletRequest) throws TagException {
        this.channel = string;
        if (providerContext == null) {
            throw new TagException("TagModuleManager.init(): provider context was null");
        }
        this.context = providerContext;
        this.tags = null;
        this.modules = new HashMap();
        Map map = null;
        try {
            this.tags = providerContext.getCollectionProperty(string, "tags");
            map = providerContext.getCollectionProperty(string, "tagModules");
        }
        catch (ProviderContextException providerContextException) {
            throw new TagException("TagModuleManager.init(): Failed to get properties");
        }
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            String string3 = (String)map.get(string2);
            if (providerContext.isDebugMessageEnabled()) {
                providerContext.debugMessage((Object)("TagModuleManager.init(): module=" + string2 + " moduleClass=" + string3));
            }
            try {
                TagModule tagModule = (TagModule)Class.forName(string3).newInstance();
                try {
                    tagModule.init(string, providerContext, httpServletRequest);
                }
                catch (TagException tagException) {
                    providerContext.debugError((Object)"TagModuleManager.init()", (Throwable)((Object)tagException));
                    continue;
                }
                this.modules.put(string2, tagModule);
                if (!providerContext.isDebugMessageEnabled()) continue;
                providerContext.debugMessage((Object)"TagModuleManager.init(): success");
            }
            catch (ClassNotFoundException classNotFoundException) {
                providerContext.debugError((Object)"TagModuleManager.init()", (Throwable)classNotFoundException);
            }
            catch (IllegalAccessException illegalAccessException) {
                providerContext.debugError((Object)"TagModuleManager.init()", (Throwable)illegalAccessException);
            }
            catch (InstantiationException instantiationException) {
                providerContext.debugError((Object)"TagModuleManager.init()", (Throwable)instantiationException);
            }
        }
    }

    public WriteTag getWriteTag(String string) throws TagException {
        String string2 = (String)this.tags.get(string);
        WriteTag writeTag = null;
        try {
            writeTag = (WriteTag)this.modules.get(string2);
        }
        catch (ClassCastException classCastException) {
            throw new TagCastException("error casting to write tag", classCastException);
        }
        if (writeTag == null) {
            throw new UndefinedTagException("undefined tag=" + string);
        }
        return writeTag;
    }

    public ReadTag getReadTag(String string) throws TagException {
        String string2 = (String)this.tags.get(string);
        ReadTag readTag = null;
        try {
            readTag = (ReadTag)this.modules.get(string2);
        }
        catch (ClassCastException classCastException) {
            throw new TagCastException("error casting to read tag", classCastException);
        }
        if (readTag == null) {
            throw new UndefinedTagException("no module defined for tag=" + string);
        }
        return readTag;
    }

    public Hashtable getTable() {
        Map map;
        Hashtable<String, TagModuleElement> hashtable;
        block8: {
            hashtable = new Hashtable<String, TagModuleElement>();
            map = null;
            try {
                if (this.context.getProviderVersion(this.channel) >= 2) {
                    map = this.context.getCollectionProperty(this.channel, "escapeTags");
                }
            }
            catch (ProviderContextException providerContextException) {
                if (!this.context.isDebugWarningEnabled()) break block8;
                this.context.debugWarning((Object)"TagModuleManager.getTable(): escapeTags collection was not read");
            }
        }
        Iterator iterator = this.tags.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            ReadTag readTag = null;
            try {
                readTag = this.getReadTag(string);
            }
            catch (TagCastException tagCastException) {
                if (!this.context.isDebugWarningEnabled()) continue;
                this.context.debugWarning((Object)("TagModuleManager.getTable(): was not read module for tag=" + string));
                continue;
            }
            catch (TagException tagException) {
                this.context.debugError((Object)"TagModuleManager.getTable()", (Throwable)((Object)tagException));
                continue;
            }
            if (readTag == null) {
                this.context.debugError((Object)("TagModuleManager.getTable(): couldn't get read module for tag=" + string));
                continue;
            }
            TagModuleElement tagModuleElement = null;
            tagModuleElement = map == null || !map.containsKey(string) ? new TagModuleElement(readTag, string, false, this.context) : new TagModuleElement(readTag, string, (Boolean)map.get(string), this.context);
            hashtable.put(string, tagModuleElement);
        }
        return hashtable;
    }
}

