/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers.userinfo;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.portal.desktop.context.ContextException;
import com.sun.portal.desktop.util.I18n;
import com.sun.portal.desktop.util.Integers;
import com.sun.portal.providers.InvalidEditFormDataException;
import com.sun.portal.providers.ProfileProviderAdapter;
import com.sun.portal.providers.ProviderException;
import com.sun.portal.providers.context.ProviderContext;
import com.sun.portal.providers.userinfo.OriginalPasswordDidntMatchException;
import com.sun.portal.providers.userinfo.PasswordException;
import com.sun.portal.providers.userinfo.PasswordTooShortException;
import com.sun.portal.providers.userinfo.PasswordsDontMatchException;
import com.sun.portal.providers.userinfo.tag.TagException;
import com.sun.portal.providers.userinfo.tag.TagModuleManager;
import com.sun.portal.providers.userinfo.tag.TagWrapperException;
import com.sun.portal.providers.userinfo.tag.UndefinedTagException;
import com.sun.portal.providers.userinfo.tag.WriteTag;
import com.sun.portal.providers.util.ProviderProperties;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class UserInfoProvider
extends ProfileProviderAdapter
implements ProviderProperties {
    private static final String contentTemplate = "content.template";
    private static final String editTemplate = "edit.template";
    private TagModuleManager moduleManager = null;
    private ResourceBundle bundle = null;
    private String editContainer = null;
    private String container = null;

    public void init(String string, HttpServletRequest httpServletRequest) throws ProviderException {
        super.init(string, httpServletRequest);
        try {
            this.moduleManager = new TagModuleManager(this.getName(), this.getProviderContext(), httpServletRequest);
        }
        catch (TagException tagException) {
            throw new ProviderException("UserInfoProvider.init(): couldn't get tag module manager", (Throwable)((Object)tagException));
        }
        if (this.moduleManager == null) {
            throw new ProviderException("UserInfoProvider.init(): tag module manager failed it init");
        }
    }

    public boolean isPresentable(HttpServletRequest httpServletRequest) {
        boolean bl;
        block3: {
            bl = false;
            try {
                if (this.getTemplatePath(contentTemplate) != null) {
                    bl = true;
                }
            }
            catch (ProviderException providerException) {
                ProviderContext providerContext = this.getProviderContext();
                if (!providerContext.isDebugWarningEnabled()) break block3;
                providerContext.debugWarning((Object)"UserInfoProvider.isPresentable() : ", (Throwable)providerException);
            }
        }
        return bl;
    }

    public StringBuffer getContent(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ProviderException {
        Hashtable hashtable = this.moduleManager.getTable();
        return this.getTemplate(contentTemplate, hashtable);
    }

    public boolean isEditable() throws ProviderException {
        boolean bl = false;
        if (this.getTemplatePath(editTemplate) != null && this.getBooleanProperty("isEditable")) {
            bl = true;
        }
        return bl;
    }

    public StringBuffer getEdit(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ProviderException {
        this.editContainer = httpServletRequest.getParameter("provider");
        this.container = httpServletRequest.getParameter("containerName");
        Hashtable hashtable = this.moduleManager.getTable();
        SSOTokenManager sSOTokenManager = null;
        SSOToken sSOToken = null;
        AMStoreConnection aMStoreConnection = null;
        AMUser aMUser = null;
        try {
            sSOTokenManager = SSOTokenManager.getInstance();
            if (sSOTokenManager == null) {
                throw new ProviderException("UserinfoProvider.getEdit(): Failed to getSSOTokenmanager.");
            }
            sSOToken = sSOTokenManager.createSSOToken(httpServletRequest);
            aMStoreConnection = new AMStoreConnection(sSOToken);
            aMUser = aMStoreConnection.getUser(sSOToken.getPrincipal().getName());
        }
        catch (SSOException sSOException) {
            throw new ProviderException("UserinfoProvider.getEdit():", (Throwable)sSOException);
        }
        Set set = null;
        try {
            set = aMUser.getAssignedServices();
        }
        catch (AMException aMException) {
            throw new ProviderException("UserinfoProvider.getEdit(): Failed to get service names.", (Throwable)aMException);
        }
        catch (SSOException sSOException) {
            throw new ProviderException("UserinfoProvider.getEdit():", (Throwable)sSOException);
        }
        if (set.contains(this.getStringProperty("netmailServiceName"))) {
            if (this.getProviderContext().isDebugMessageEnabled()) {
                this.getProviderContext().debugMessage((Object)"UserinfoProvider.getEdit(): NetMail service registered.");
            }
            hashtable.put("netmailSettings", this.getTemplate("netmailSettings.template"));
        } else {
            if (this.getProviderContext().isDebugWarningEnabled()) {
                this.getProviderContext().debugWarning((Object)"UserinfoProvider.getEdit(): NetMail service NOT registered.");
            }
            hashtable.put("netmailSettings", "");
        }
        String string = null;
        try {
            string = sSOToken.getAuthType();
            if (this.getProviderContext().isDebugMessageEnabled()) {
                this.getProviderContext().debugMessage((Object)("UserinfoProvider.getEdit(): authMethod=" + string));
            }
        }
        catch (SSOException sSOException) {
            this.getProviderContext().debugError((Object)"UserinfoProvider.getEdit(): couldn't get auth method");
            string = "<unknown>";
        }
        List list = this.getListProperty("authTypes");
        if (list.contains(string)) {
            if (this.getProviderContext().isDebugMessageEnabled()) {
                this.getProviderContext().debugMessage((Object)"UserinfoProvider.getEdit(): found handler");
            }
            hashtable.put("passwordHandler", this.getTemplate("passwordHandler-" + string + ".template"));
        } else {
            if (this.getProviderContext().isDebugWarningEnabled()) {
                this.getProviderContext().debugWarning((Object)"UserinfoProvider.getEdit(): handler NOT found!");
            }
            hashtable.put("passwordHandler", "");
        }
        String string2 = httpServletRequest.getParameter("error");
        if (string2 != null) {
            hashtable.put("errMessage", string2);
            hashtable.put("inlineError", this.getTemplate("inlineError.template"));
        } else {
            hashtable.put("errMessage", "");
            hashtable.put("inlineError", "");
        }
        return this.getTemplate(editTemplate, hashtable);
    }

    public URL processEdit(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ProviderException {
        URL uRL = null;
        boolean bl = true;
        String string = "";
        this.editContainer = httpServletRequest.getParameter("provider");
        this.container = httpServletRequest.getParameter("containerName");
        this.getProviderContext().allContentChanged();
        Object object = httpServletRequest.getParameterNames();
        while (object.hasMoreElements()) {
            Serializable serializable;
            Object object2;
            String string2 = (String)object.nextElement();
            String string3 = httpServletRequest.getParameter(string2);
            if (string3 == null) {
                string3 = "";
            }
            if (this.getProviderContext().isDebugMessageEnabled()) {
                this.getProviderContext().debugMessage((Object)("UserinfoProvider.processEdit(): tag=" + string2));
            }
            WriteTag writeTag = null;
            try {
                writeTag = this.moduleManager.getWriteTag(string2);
            }
            catch (UndefinedTagException undefinedTagException) {
                if (!this.getProviderContext().isDebugWarningEnabled()) continue;
                this.getProviderContext().debugWarning((Object)("UserinfoProvider.processEdit(): couldn't get module for tag=" + string2));
                continue;
            }
            catch (TagException tagException) {
                this.getProviderContext().debugError((Object)"UserinfoProvider.processEdit()", (Throwable)((Object)tagException));
                continue;
            }
            try {
                writeTag.set(string2, string3);
            }
            catch (PasswordTooShortException passwordTooShortException) {
                if (this.bundle == null) {
                    this.bundle = this.getResourceBundle();
                }
                object2 = this.bundle.getString("passwordTooShort");
                serializable = null;
                serializable = this.getProviderContext().getLocale();
                string = I18n.format((String)object2, (Integer)Integers.get((int)passwordTooShortException.getRequiredLength()), (Locale)serializable);
                bl = false;
            }
            catch (OriginalPasswordDidntMatchException originalPasswordDidntMatchException) {
                if (this.bundle == null) {
                    this.bundle = this.getResourceBundle();
                }
                string = this.bundle.getString("originalPasswordDidntMatch");
                bl = false;
            }
            catch (PasswordsDontMatchException passwordsDontMatchException) {
                if (this.bundle == null) {
                    this.bundle = this.getResourceBundle();
                }
                string = this.bundle.getString("passwordsDontMatch");
                bl = false;
            }
            catch (PasswordException passwordException) {
                if (!this.getProviderContext().isDebugMessageEnabled()) continue;
                this.getProviderContext().debugMessage((Object)"UserinfoProvider.processEdit()", (Throwable)((Object)passwordException));
            }
            catch (TagException tagException) {
                this.getProviderContext().debugError((Object)("UserinfoProvider.processEdit(): couldn't set tag " + string2 + " to " + string3));
                if (tagException instanceof TagWrapperException && (serializable = ((TagWrapperException)((Object)(object2 = (TagWrapperException)tagException))).getWrappedException()) instanceof ContextException) {
                    if (this.bundle == null) {
                        this.bundle = this.getResourceBundle();
                    }
                    string = this.bundle.getString("profileError");
                    throw new InvalidEditFormDataException(string);
                }
                string = "Could not set " + string2 + " to " + string3 + ".";
                throw new ProviderException(string, (Throwable)((Object)tagException));
            }
        }
        if (!bl) {
            object = new StringBuffer();
            ((StringBuffer)object).append(this.getProviderContext().getDesktopURL(httpServletRequest)).append("?action=edit&provider=").append(this.getProviderContext().encodeURLParameter(this.editContainer)).append("&targetprovider=").append(this.getProviderContext().encodeURLParameter(this.getName())).append("&containerName=").append(this.getProviderContext().encodeURLParameter(this.container)).append("&error=").append(this.getProviderContext().encodeURLParameter(string));
            try {
                uRL = new URL(((StringBuffer)object).toString());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return uRL;
    }
}

