/*
 * Decompiled with CFR 0.152.
 */
package ob.obbase;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;

public class OBBase
extends Panel
implements AdjustmentListener {
    protected Scrollbar vs;
    protected Scrollbar hs;
    protected int m_nVScrollbarWidth = 15;
    protected int m_nHScrollbarHeight = 15;
    protected transient Image offscreen = null;
    protected int m_nTopRow = 0;
    protected int m_nLeftCol = 0;
    protected boolean m_bAlwaysShowScrollbar = false;
    protected boolean m_bHideHScrollbar = false;
    protected boolean m_bHideVScrollbar = false;
    protected boolean m_bDoubleBuffering = true;
    protected transient String OSName;

    public OBBase() {
        this(false);
        this.setLayout(null);
    }

    public OBBase(boolean bAlwaysShowScrollbar) {
        this.m_bAlwaysShowScrollbar = bAlwaysShowScrollbar;
        this.vs = new Scrollbar(1);
        this.hs = new Scrollbar(0);
        this.vs.addAdjustmentListener(this);
        this.hs.addAdjustmentListener(this);
        this.setLayout(null);
        this.add(this.vs);
        this.add(this.hs);
        this.enableEvents(4L);
        this.enableEvents(16L);
        this.enableEvents(8L);
        this.enableEvents(256L);
        this.enableEvents(32L);
        this.OSName = System.getProperty("os.name");
    }

    public Scrollbar getVScrollbar() {
        return this.vs;
    }

    public Scrollbar getHScrollbar() {
        return this.hs;
    }

    public int getVScrollbarWidth() {
        return this.m_nVScrollbarWidth;
    }

    public int getHScrollbarHeight() {
        return this.m_nHScrollbarHeight;
    }

    public void setVScrollbarWidth(int width) {
        if (width > 0) {
            this.m_nVScrollbarWidth = width;
            this.doLayout();
        }
    }

    public void setHScrollbarHeight(int height) {
        if (height > 0) {
            this.m_nHScrollbarHeight = height;
            this.doLayout();
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
        if (e.getID() == 601) {
            if (e.getSource() instanceof Scrollbar && ((Scrollbar)e.getSource()).getOrientation() == 1) {
                int nValue = this.getVScrollbar().getValue();
                if (this.onTopRowChange(nValue)) {
                    this.m_nTopRow = nValue;
                    this.onTopRowChanged(nValue);
                }
            } else {
                int nValue = this.getHScrollbar().getValue();
                if (this.onLeftColChange(nValue)) {
                    this.m_nLeftCol = nValue;
                    this.onLeftColChanged(nValue);
                }
            }
        }
    }

    public void setBounds(int x, int y, int w, int h) {
        if (w <= 0 || h <= 0) {
            return;
        }
        super.setBounds(x, y, w, h);
        this.updateScrollbar();
    }

    public synchronized void doLayout() {
        Dimension d = this.getSize();
        int w = d.width;
        int h = d.height;
        Scrollbar vs = this.getVScrollbar();
        Scrollbar hs = this.getHScrollbar();
        if (this.m_bAlwaysShowScrollbar || this.getMaxTopRow() != 0 && !this.m_bHideVScrollbar) {
            hs.setBounds(this.getInsets().left, h - this.m_nHScrollbarHeight - this.getInsets().bottom, w - this.m_nVScrollbarWidth - this.getInsets().left - this.getInsets().right, this.m_nHScrollbarHeight);
        } else {
            hs.setBounds(this.getInsets().left, h - this.m_nHScrollbarHeight - this.getInsets().bottom, w - this.getInsets().left - this.getInsets().right, this.m_nHScrollbarHeight);
        }
        if (this.m_bAlwaysShowScrollbar || this.getMaxLeftCol() != 0 && !this.m_bHideHScrollbar) {
            vs.setBounds(w - this.m_nVScrollbarWidth - this.getInsets().right, this.getInsets().top, this.m_nVScrollbarWidth, h - this.m_nHScrollbarHeight - this.getInsets().top - this.getInsets().bottom);
        } else {
            vs.setBounds(w - this.m_nVScrollbarWidth - this.getInsets().right, this.getInsets().top, this.m_nVScrollbarWidth, h - this.getInsets().top - this.getInsets().bottom);
        }
        if (this.m_bAlwaysShowScrollbar || this.getMaxTopRow() != 0 && !this.m_bHideVScrollbar) {
            vs.setVisible(true);
        } else {
            vs.setVisible(false);
        }
        if (this.m_bAlwaysShowScrollbar || this.getMaxLeftCol() != 0 && !this.m_bHideHScrollbar) {
            hs.setVisible(true);
        } else {
            hs.setVisible(false);
        }
    }

    public void paint(Graphics g) {
        if (!this.isShowing()) {
            return;
        }
        if (this.m_bDoubleBuffering && this.validateImage()) {
            Dimension d = this.getSize();
            Rectangle r = g.getClipBounds();
            Graphics og = this.offscreen.getGraphics();
            if (r != null) {
                og.clipRect(r.x, r.y, r.width, r.height);
            }
            og.setFont(g.getFont());
            og.setColor(this.getBackground());
            og.fillRect(0, 0, d.width, d.height);
            og.setColor(g.getColor());
            this.draw(og);
            g.drawImage(this.offscreen, 0, 0, this);
            og.dispose();
        } else if (g != null && g.getClipBounds() != null) {
            this.draw(g);
        }
    }

    protected void draw(Graphics g) {
    }

    protected boolean validateImage() {
        try {
            Dimension d = this.getSize();
            if (this.offscreen == null || this.offscreen.getWidth(this) != d.width || this.offscreen.getHeight(this) != d.height) {
                if (d.width > 0 && d.height > 0) {
                    this.offscreen = this.createImage(d.width, d.height);
                } else {
                    return false;
                }
            }
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public void update(Graphics g, int x, int y, int w, int h) {
        g.clipRect(x, y, w, h);
        this.paint(g);
    }

    public void update() {
        Dimension d = this.getSize();
        int nHeight = d.height;
        int nWidth = d.width;
        Graphics g = this.getGraphics();
        if (g != null) {
            this.update(g, 0, 0, nWidth, nHeight);
            g.dispose();
        }
    }

    public void repaint() {
        Dimension d = this.getSize();
        int nHeight = d.height;
        int nWidth = d.width;
        Graphics g = this.getGraphics();
        if (g != null) {
            if (!this.m_bDoubleBuffering) {
                g.setColor(this.getBackground());
                g.fillRect(0, 0, d.width, d.height);
            }
            this.update(g, 0, 0, nWidth, nHeight);
            g.dispose();
        }
    }

    public void update(Graphics g) {
        if (this.m_bDoubleBuffering) {
            this.paint(g);
        } else {
            super.update(g);
        }
    }

    protected boolean onLeftColChange(int nNewLeftCol) {
        return true;
    }

    protected boolean onTopRowChange(int nNewTopRow) {
        return true;
    }

    protected void onTopRowChanged(int nNewTopRow) {
        this.repaint();
    }

    protected void onLeftColChanged(int nNewLeftCol) {
        this.repaint();
    }

    protected int getMaxTopRow() {
        return 0;
    }

    protected int getMaxLeftCol() {
        return 0;
    }

    protected void updateScrollbar() {
        int nPage;
        int nMaxTopRow = this.getMaxTopRow();
        int nMaxLeftCol = this.getMaxLeftCol();
        Scrollbar vs = this.getVScrollbar();
        Scrollbar hs = this.getHScrollbar();
        if (nMaxTopRow == 0) {
            this.m_nTopRow = 0;
            if (this.m_bAlwaysShowScrollbar && (this.OSName.equals("Windows NT") || this.OSName.equals("Windows 95"))) {
                vs.setEnabled(false);
            }
        } else {
            if (!vs.isEnabled()) {
                vs.setEnabled(true);
            }
            if ((nPage = nMaxTopRow / 10) < 5) {
                nPage = 5;
            }
            vs.setValues(vs.getValue(), 1, 0, nMaxTopRow);
            vs.setBlockIncrement(nPage);
            vs.setUnitIncrement(1);
        }
        if (nMaxLeftCol == 0) {
            this.m_nLeftCol = 0;
            if (this.m_bAlwaysShowScrollbar && (this.OSName.equals("Windows NT") || this.OSName.equals("Windows 95"))) {
                vs.setEnabled(false);
            }
        } else {
            if (!hs.isEnabled()) {
                hs.setEnabled(true);
            }
            if ((nPage = nMaxLeftCol / 10) < 5) {
                nPage = 5;
            }
            hs.setValues(hs.getValue(), 1, 0, nMaxLeftCol);
            hs.setBlockIncrement(nPage);
            hs.setUnitIncrement(1);
        }
        this.doLayout();
        if (this.isShowing()) {
            this.update();
        }
    }

    public void setAlwaysShowScrollbars(boolean bShowScrollbars) {
        this.m_bAlwaysShowScrollbar = bShowScrollbars;
    }

    public boolean getAlwaysShowScrollbars() {
        return this.m_bAlwaysShowScrollbar;
    }

    public void showHScrollbar() {
        this.m_bHideHScrollbar = false;
        this.getHScrollbar().setVisible(true);
    }

    public void showVScrollbar() {
        this.m_bHideVScrollbar = false;
        this.getVScrollbar().setVisible(true);
    }

    public void hideHScrollbar() {
        this.m_bHideHScrollbar = true;
        this.getHScrollbar().setVisible(false);
    }

    public void hideVScrollbar() {
        this.m_bHideVScrollbar = true;
        this.getVScrollbar().setVisible(false);
    }

    public void hideScrollbar() {
        this.m_bHideHScrollbar = true;
        this.m_bHideVScrollbar = true;
        this.hideVScrollbar();
        this.hideHScrollbar();
    }

    public void showScrollbar() {
        this.m_bHideHScrollbar = false;
        this.m_bHideVScrollbar = false;
        this.showVScrollbar();
        this.showHScrollbar();
    }

    public Dimension getPreferredSize() {
        Dimension d = this.getSize();
        if (d.width > 0 && d.height > 0) {
            return d;
        }
        return this.getMinimumSize();
    }

    public Dimension getMinimumSize() {
        return new Dimension(100, 80);
    }

    public void setDoubleBuffering(boolean bBuff) {
        this.m_bDoubleBuffering = bBuff;
    }

    public boolean isDoubleBuffering(boolean bBuff) {
        return this.m_bDoubleBuffering;
    }
}

