/*
 * Decompiled with CFR 0.152.
 */
package ob.listbox;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.SystemColor;
import java.util.Vector;
import ob.listbox.ListBox;
import ob.listbox.ListItem;

public class SortableListBox
extends ListBox {
    protected int m_nColumnSorted = 0;
    boolean m_bSort = true;
    boolean m_bHitHeader = true;
    int m_nOldOver = -1;
    boolean m_bRoveModeEnabled = false;
    Vector m_arrSortIntegers = new Vector();

    public SortableListBox(boolean bMultipleSelections) {
        super(bMultipleSelections);
    }

    public void setRoveMode(boolean bRove) {
        this.m_bRoveModeEnabled = bRove;
    }

    public boolean isRoveMode() {
        return this.m_bRoveModeEnabled;
    }

    public void setColumnIntegerSort(int nCol, boolean bIntSort) {
        if (bIntSort) {
            this.m_arrSortIntegers.addElement(new Integer(nCol));
            return;
        }
        if (this.m_arrSortIntegers.contains(new Integer(nCol))) {
            this.m_arrSortIntegers.removeElement(new Integer(nCol));
        }
    }

    public synchronized void addItem(String item) {
        this.addItem(item, -1, true);
    }

    public synchronized void addItem(String item, int iImage) {
        this.addItem(item, iImage, true);
    }

    public synchronized void addItem(String item, int iImage, boolean bSort) {
        super.addItem(item, iImage, false);
        if (bSort) {
            this.sort();
        }
    }

    public synchronized void addItem(Object o) {
        this.addItem(o, -1, true);
    }

    public synchronized void addItem(Object o, int iImage) {
        this.addItem(o, iImage, true);
    }

    public synchronized void addItem(Object o, int iImage, boolean bSort) {
        super.addItem(o, iImage, false);
        if (bSort) {
            this.sort();
        }
    }

    public synchronized void addItem(ListItem item, int iImage) {
        this.addItem(item, iImage, true);
    }

    public synchronized void addItem(ListItem item) {
        this.addItem(item, -1, true);
    }

    public synchronized void addItem(ListItem item, int iImage, boolean bSort) {
        super.addItem(item, iImage, false);
        if (bSort) {
            this.sort();
        }
    }

    public synchronized void addItem(String item, Font font) {
        this.addItem(item, font, -1, true);
    }

    public synchronized void addItem(String item, Font font, int iImage) {
        this.addItem(item, font, iImage, true);
    }

    public synchronized void addItem(String item, Font font, int iImage, boolean bSort) {
        super.addItem(item, font, iImage);
        if (bSort) {
            this.sort();
        }
    }

    public void setSort(boolean b) {
        this.m_bSort = b;
    }

    public void sort() {
        this.sort(0);
    }

    public void sort(int nCol) {
        if (!this.m_bSort || this.m_bMouseDrag) {
            return;
        }
        this.m_nColumnSorted = nCol;
        Vector presortList = new Vector();
        for (int i = 0; i < this.selected.length; ++i) {
            presortList.addElement(this.m_arrItems.elementAt(this.selected[i]));
        }
        if (this.m_arrSortIntegers.contains(new Integer(nCol))) {
            this.quicksortInteger(0, this.m_arrItems.size() - 1, nCol);
        } else {
            this.quicksort(0, this.m_arrItems.size() - 1, nCol);
        }
        this.selected = new int[0];
        for (int j = 0; j < presortList.size(); ++j) {
            this.select(this.getIndex((ListItem)presortList.elementAt(j)), false);
        }
        this.update();
    }

    public void quicksort(int low, int high, int nCol) {
        if (high > low) {
            int pivot = this.partition(low, high, nCol);
            this.quicksort(low, pivot, nCol);
            this.quicksort(pivot + 1, high, nCol);
        }
    }

    public void quicksortInteger(int low, int high, int nCol) {
        if (high > low) {
            int pivot = this.partitionIntegers(low, high, nCol);
            this.quicksortInteger(low, pivot, nCol);
            this.quicksortInteger(pivot + 1, high, nCol);
        }
    }

    protected int partition(int low, int high, int nCol) {
        String compStr = nCol == 0 ? ((ListItem)this.m_arrItems.elementAt(low)).getText() : ((ListItem)this.m_arrItems.elementAt(low)).getSubItem(nCol).getText();
        int i = low - 1;
        int j = high + 1;
        while (true) {
            if (nCol == 0) {
                while (((ListItem)this.m_arrItems.elementAt(--j)).getText().toUpperCase().compareTo(compStr.toUpperCase()) > 0 && j < this.m_arrItems.size()) {
                }
                while (((ListItem)this.m_arrItems.elementAt(++i)).getText().toUpperCase().compareTo(compStr.toUpperCase()) < 0 && i > 0) {
                }
            } else {
                while (((ListItem)this.m_arrItems.elementAt(--j)).getSubItem(nCol).getText().toUpperCase().compareTo(compStr.toUpperCase()) > 0 && j < this.m_arrItems.size()) {
                }
                while (((ListItem)this.m_arrItems.elementAt(++i)).getSubItem(nCol).getText().toUpperCase().compareTo(compStr.toUpperCase()) < 0 && i > 0) {
                }
            }
            if (i >= j) break;
            this.swap(i, j);
        }
        return j;
    }

    protected int partitionIntegers(int low, int high, int nCol) {
        int compStr = nCol == 0 ? Integer.parseInt(((ListItem)this.m_arrItems.elementAt(low)).getText()) : Integer.parseInt(((ListItem)this.m_arrItems.elementAt(low)).getSubItem(nCol).getText());
        int i = low - 1;
        int j = high + 1;
        while (true) {
            if (nCol == 0) {
                while (Integer.parseInt(((ListItem)this.m_arrItems.elementAt(--j)).getText()) > compStr && j < this.m_arrItems.size()) {
                }
                while (Integer.parseInt(((ListItem)this.m_arrItems.elementAt(++i)).getText()) < compStr && i > 0) {
                }
            } else {
                while (Integer.parseInt(((ListItem)this.m_arrItems.elementAt(--j)).getSubItem(nCol).getText()) > compStr && j < this.m_arrItems.size()) {
                }
                while (Integer.parseInt(((ListItem)this.m_arrItems.elementAt(++i)).getSubItem(nCol).getText()) < compStr && i > 0) {
                }
            }
            if (i >= j) break;
            this.swap(i, j);
        }
        return j;
    }

    protected void onHitColumnHeader(int nCol) {
        if (this.m_bHitHeader) {
            if (nCol == this.m_nColumnSorted) {
                this.reverse();
            } else {
                this.sort(nCol);
            }
        }
    }

    public void moveItems(Object[] items, int targetIndex) {
        super.moveItems(items, targetIndex);
        this.m_nColumnSorted = -1;
    }

    public void reverse() {
        if (this.m_bMouseDrag) {
            return;
        }
        for (int k = 0; k < this.selected.length; ++k) {
            int newIndex;
            int temp = this.selected[k];
            this.selected[k] = newIndex = this.m_arrItems.size() - temp - 1;
        }
        int j = this.m_arrItems.size() - 1;
        for (int i = 0; i < j; ++i, --j) {
            this.swap(i, j);
        }
        this.update();
        this.m_nColumnSorted = -1;
    }

    protected void onMoveOverItem(int x, int y) {
        if (!this.m_bRoveModeEnabled) {
            return;
        }
        this.m_bHitHeader = false;
        int overItem = this.getSelected(x, y);
        if (overItem > -1) {
            ListItem pItem = (ListItem)this.m_arrItems.elementAt(overItem);
            Graphics g = this.getGraphics();
            if (g == null) {
                return;
            }
            g.setXORMode(this.getBackground());
            g.setColor(SystemColor.textHighlight);
            if (overItem != this.m_nOldOver) {
                if (!this.isSelected(overItem)) {
                    g.fillRect(pItem.getTextBounds().x + 3, pItem.getTextBounds().y - this.getBounds().y + 1, this.getInsideRect().width - 5, pItem.getTextBounds().height - 1);
                }
                if (this.m_nOldOver != -1 && !this.isSelected(this.m_nOldOver)) {
                    ListItem tempItem = (ListItem)this.m_arrItems.elementAt(this.m_nOldOver);
                    g.fillRect(tempItem.getTextBounds().x + 3, tempItem.getTextBounds().y - this.getBounds().y + 1, this.getInsideRect().width - 5, tempItem.getTextBounds().height - 1);
                }
            }
            this.m_nOldOver = overItem;
        }
        this.m_bHitHeader = true;
    }

    public void draw(Graphics g) {
        super.draw(g);
        this.m_nOldOver = -1;
    }

    public void swap(int a, int b) {
        ListItem temp = (ListItem)this.m_arrItems.elementAt(a);
        this.m_arrItems.setElementAt((ListItem)this.m_arrItems.elementAt(b), a);
        this.m_arrItems.setElementAt(temp, b);
    }
}

