/*
 * Decompiled with CFR 0.152.
 */
package ob.listbox;

import java.awt.Font;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Vector;
import ob.listbox.ListSubItem;

public class ListItem
implements Serializable {
    protected Vector m_arrSubItems = new Vector();
    protected String m_pszText = "";
    protected int m_nImage = -1;
    protected int m_nCY = -1;
    protected Rectangle m_rcText = new Rectangle();
    protected Rectangle m_rcIcon = new Rectangle();
    protected Font m_fonFont = null;
    protected Object m_objData;
    protected boolean m_bIsSelected = false;
    protected boolean m_bIsDropHiLited = false;
    protected boolean m_bIsFocused = false;
    protected boolean m_bIsMarked = false;
    protected boolean m_bIsDisabled = false;

    public String getText() {
        return this.m_pszText;
    }

    public void setTextBounds(int x, int y, int width, int height) {
        this.m_rcText.setBounds(x, y, width, height);
    }

    public void setTextHeight(int h) {
        this.m_rcText.height = h;
    }

    public void setTextBounds(Rectangle r) {
        this.m_rcText = r;
    }

    public void setSubItems(Vector subItems) {
        this.m_arrSubItems = subItems;
    }

    public void setImageYPos(int newY) {
        this.m_rcIcon.y = newY;
    }

    public void setHeight(int nNewHeight) {
        this.m_nCY = nNewHeight;
    }

    public void setImage(int id) {
        this.m_nImage = id;
    }

    public int getImage() {
        return this.m_nImage;
    }

    public Rectangle getTextBounds() {
        return this.m_rcText;
    }

    public Rectangle getImageBounds() {
        return this.m_rcIcon;
    }

    public int getHeight() {
        return this.m_nCY;
    }

    public void setImageBounds(Rectangle img) {
        this.m_rcIcon = img;
    }

    public Font getFont() {
        return this.m_fonFont;
    }

    public void setFont(Font f) {
        this.m_fonFont = f;
    }

    public void copy(ListItem item) {
        this.m_arrSubItems = (Vector)item.m_arrSubItems.clone();
        this.m_pszText = new String(item.m_pszText);
        this.m_nImage = item.m_nImage;
        this.m_nCY = item.m_nCY;
        this.m_rcText = item.m_rcText;
        this.m_rcIcon = item.m_rcIcon;
        this.m_fonFont = item.m_fonFont;
        this.m_bIsSelected = item.m_bIsSelected;
        this.m_bIsDropHiLited = item.m_bIsDropHiLited;
        this.m_bIsFocused = item.m_bIsFocused;
        this.m_bIsMarked = item.m_bIsMarked;
        this.m_bIsDisabled = item.m_bIsDisabled;
    }

    public void setText(String s) {
        this.m_pszText = s;
    }

    public Object getItemData() {
        return this.m_objData;
    }

    public void setItemData(Object obj) {
        this.m_objData = obj;
    }

    public ListSubItem getSubItem(int iSubItem) {
        if (iSubItem - 1 < this.m_arrSubItems.size()) {
            return (ListSubItem)this.m_arrSubItems.elementAt(iSubItem - 1);
        }
        return null;
    }

    public boolean deleteSubItem(int iSubItem) {
        if (iSubItem - 1 < this.m_arrSubItems.size()) {
            this.m_arrSubItems.removeElementAt(iSubItem - 1);
            return true;
        }
        return false;
    }

    public void addSubItem(ListSubItem subItem) {
        this.m_arrSubItems.addElement(subItem);
    }

    public void addSubItem(String subitem) {
        ListSubItem sub = new ListSubItem(subitem);
        this.addSubItem(sub);
    }

    public void addSubItem() {
        ListSubItem sub = new ListSubItem();
        this.addSubItem(sub);
    }

    public int getSubItemCount() {
        return this.m_arrSubItems.size();
    }
}

