/*
 * Decompiled with CFR 0.152.
 */
package ob.listbox;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.ItemSelectable;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Vector;
import ob.listbox.Column;
import ob.listbox.ListItem;
import ob.obbase.OBBase;
import ob.text.ExpandableText;
import ob.text.Text;

public class ListBox
extends OBBase
implements ItemSelectable,
ActionListener {
    public static final int LVXC_UNINITIALIZED = -1;
    protected int m_nWidthGap = 11;
    protected int m_nRowSpace = 0;
    public static final int FMT_LEFT = 0;
    public static final int FMT_CENTER = 1;
    public static final int FMT_RIGHT = 2;
    public static final int NONE = 0;
    public static final int RESIZE = 1;
    public static final int DEFAULT_COL_WIDTH = 100;
    protected int DottedLineSpace = 1;
    protected int DottedLineFill = 1;
    protected Rectangle m_recPCRect = new Rectangle();
    protected Column m_colPCol = new Column();
    protected int m_lvi_iSubItem = 0;
    protected int m_lvi_iItem = 0;
    protected int m_PCheight = -1;
    protected String m_lvi_pszText = null;
    protected Color m_colGridLines = SystemColor.windowBorder;
    protected Color m_colText = SystemColor.textText;
    protected Color m_colHighlightText = SystemColor.textHighlightText;
    protected Color m_colHighlightTextBackground = SystemColor.textHighlight;
    protected int m_nStyleGridLines = 1;
    public static final int DOTTED = 0;
    public static final int SOLID = 1;
    protected String commandTopRowChanged = "Top_Row_Changed";
    protected String commandDoubleClicked = "Double_Clicked";
    protected String commandLeftColChanged = "Left_Col_Changed";
    protected String commandItemDeleted = "Item_Deleted";
    public static String commandDragDrop = "Drag_Drop";
    public static final int DRAGDROP = 3001;
    protected ItemListener itemListener;
    protected ActionListener actionListener;
    protected int[] selected = new int[0];
    protected int prev = -1;
    protected boolean m_bMouseDrag = false;
    protected boolean m_bHilightSubItems = true;
    public static Font defaultfont = new Font("TimesRoman", 0, 18);
    protected Vector m_arrColumns = new Vector();
    protected Vector m_arrItems = new Vector();
    protected int m_nSubItemCount = 0;
    protected int m_nTopRow = 0;
    protected Point m_ptViewportOrg = new Point(0, 0);
    protected int m_nItemsThisPage = 0;
    protected boolean m_bMultipleSelections = true;
    protected boolean m_bColumnHeader = false;
    protected int m_cyHeader = 0;
    protected boolean m_bColumnLines = false;
    protected boolean m_bItemLines = false;
    boolean m_bCaptured = false;
    protected boolean m_bEditModeAllowed = false;
    protected boolean m_bEditModeEnabled = false;
    protected boolean m_bOverlapEdit = false;
    protected int m_nColumnEdit = 0;
    protected ListItem m_itemCurrentEdit = new ListItem();
    protected ExpandableText m_textEditNode = null;
    protected Vector m_arrImages = null;
    protected Vector m_arrImageIDs = null;
    protected int m_nOldTargetIndex = -1;
    int m_nDraggingCurrent;
    int m_nDraggingBegin;
    int m_nDraggingState = 0;
    Rectangle m_rectDragging = new Rectangle();
    protected boolean m_bAutoWrap = true;
    private String OSName;
    protected boolean m_bDragModeEnabled = false;
    protected boolean m_bDragModeAllowed = true;
    protected boolean m_bDrawDragImage = true;
    protected int m_nXMouse = -100;
    protected int m_nYMouse = -100;
    protected Image m_imgDragPic = null;
    protected int m_dropTargetItem = -1;
    protected boolean m_bDragDropDrawn = false;
    protected boolean m_bAllowDelete = false;
    protected boolean m_bShowDotRect = true;
    protected boolean m_bHasFocus = false;
    transient boolean m_bSelectedItemChanged = false;

    public ListBox() {
        this(false);
        this.setLayout(null);
    }

    public ListBox(boolean multipleSelections) {
        super(false);
        Font font = this.getFont();
        FontMetrics fontMetrics = font != null ? this.getFontMetrics(font) : this.getFontMetrics(defaultfont);
        this.m_PCheight = fontMetrics.getHeight();
        this.m_bMultipleSelections = multipleSelections;
        this.m_bAlwaysShowScrollbar = false;
        this.setBackground(Color.white);
        this.insertColumn(0, "", 0, -1, 0, false);
        this.OSName = System.getProperty("os.name");
        this.m_textEditNode = new ExpandableText("");
        this.m_textEditNode.addActionListener(this);
        this.add(this.m_textEditNode);
        this.m_textEditNode.setVisible(false);
    }

    public void addNotify() {
        super.addNotify();
        if (this.m_arrColumns.size() == 1) {
            if (this.m_bAutoWrap) {
                ((Column)this.m_arrColumns.elementAt((int)0)).m_nCX = this.getInsideRect().width;
                this.reMeasureAllItems();
            } else {
                ((Column)this.m_arrColumns.elementAt((int)0)).m_nCX = this.getLogicalSize().x;
                if (this.getLogicalSize().x < this.getInsideRect().width) {
                    ((Column)this.m_arrColumns.elementAt((int)0)).m_nCX = this.getInsideRect().width;
                }
                this.reMeasureAllItems();
            }
        }
    }

    public Color getTextColor() {
        return this.m_colText;
    }

    public void setTextColor(Color color) {
        this.m_colText = color;
        this.repaint();
    }

    public boolean getMultipleSelections() {
        return this.m_bMultipleSelections;
    }

    public synchronized void replaceItem(Object newValue, int index) {
        this.deleteItem(index);
        this.addItem(newValue, index, false);
        this.update();
    }

    public synchronized Object[] getSelectedItems() {
        int[] sel = this.getSelectedIndexes();
        Object[] obj = new Object[sel.length];
        for (int i = 0; i < sel.length; ++i) {
            obj[i] = this.getItem(sel[i]);
        }
        return obj;
    }

    public Object[] getSelectedObjects() {
        return this.getSelectedItems();
    }

    public ListItem getItemAt(int index) {
        return (ListItem)this.m_arrItems.elementAt(index);
    }

    public synchronized void clear() {
        this.m_arrItems = new Vector();
        this.selected = new int[0];
        this.prev = -1;
        this.m_nTopRow = 0;
        this.updateScrollbar();
        this.update();
    }

    public synchronized void delItems(int start, int end) {
        this.deleteItems(start, end);
    }

    public synchronized void delItem(int nItem) {
        this.deleteItem(nItem);
    }

    public synchronized void deleteItems(int start, int end) {
        if (start < 0 || start >= this.countItems() || end < 0 || end >= this.countItems()) {
            return;
        }
        for (int i = end; i >= start; --i) {
            this.deleteItem(i);
        }
        this.updateScrollbar();
        this.update();
    }

    public synchronized boolean deleteItem(int nItem) {
        return this.deleteItem(nItem, 1);
    }

    public synchronized boolean deleteItem(int nItem, boolean bUpdate) {
        return this.deleteItem(nItem, 1, bUpdate);
    }

    public synchronized boolean deleteItem(int nItem, int cCount) {
        return this.deleteItem(nItem, cCount, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean deleteItem(int nItem, int cCount, boolean bUpdate) {
        boolean nIndex = false;
        int nLast = nItem + cCount - 1;
        if (nLast > this.m_arrItems.size() - 1) {
            nLast = this.m_arrItems.size() - 1;
        }
        if (nLast < 0) {
            return true;
        }
        Vector predeleteList = new Vector();
        for (int j = 0; j < this.selected.length; ++j) {
            predeleteList.addElement(this.m_arrItems.elementAt(this.selected[j]));
        }
        Vector j = this.m_arrItems;
        synchronized (j) {
            for (int i = nItem; i <= nLast; ++i) {
                ListItem pItem = (ListItem)this.m_arrItems.elementAt(i);
                if (this.isSelected(i)) {
                    this.deselect(i);
                }
                this.m_arrItems.removeElementAt(i);
                predeleteList.removeElement(pItem);
                --nLast;
                --i;
            }
        }
        for (int j2 = 0; j2 < predeleteList.size(); ++j2) {
            this.select(this.getIndex((ListItem)predeleteList.elementAt(j2)), false);
        }
        this.processActionEvent(new ActionEvent(this, 1001, this.commandItemDeleted));
        if (bUpdate) {
            this.updateScrollbar();
            this.update();
        }
        return true;
    }

    public synchronized void deselectAll() {
        this.deselectAll(true);
    }

    public synchronized void deselectAll(boolean bUpdate) {
        this.selected = new int[0];
        this.prev = -1;
        if (bUpdate) {
            this.update();
        }
    }

    public ListItem createNewItem() {
        ListItem pItem = new ListItem();
        return pItem;
    }

    public synchronized void addItem(String item, boolean bRepaint) {
        this.addItem(item, -1, bRepaint);
    }

    public synchronized void addItem(String item) {
        this.addItem(item, -1, true);
    }

    public synchronized void addItem(String item, int iImage, boolean bRepaint) {
        ListItem pItem = new ListItem();
        pItem.setText(item);
        pItem.setImage(iImage);
        this.m_arrItems.addElement(pItem);
        if (this.m_nSubItemCount > pItem.getSubItemCount() + 1) {
            for (int i = pItem.getSubItemCount(); i < this.m_nSubItemCount - 1; ++i) {
                ((ListItem)this.m_arrItems.elementAt(this.m_arrItems.size() - 1)).addSubItem();
            }
        }
        this.updateScrollbar();
        if (bRepaint) {
            this.update();
        }
    }

    public synchronized void addItem(Object o) {
        this.addItem(o, -1, true);
    }

    public synchronized void addItem(Object o, boolean bRepaint) {
        this.addItem(o, -1, bRepaint);
    }

    public synchronized void addItem(Object o, int iImage, boolean bRepaint) {
        if (o != null && o instanceof String) {
            this.addItem((String)o, iImage, bRepaint);
        } else if (o != null && o instanceof ListItem) {
            this.addItem((ListItem)o, iImage, bRepaint);
        }
    }

    public synchronized void addItem(ListItem item, boolean bRepaint) {
        this.addItem(item, -1, bRepaint);
    }

    public synchronized void addItem(ListItem item) {
        this.addItem(item, -1, true);
    }

    public synchronized void addItem(ListItem item, int iImage, boolean bRepaint) {
        item.setImage(iImage);
        this.m_arrItems.insertElementAt(item, this.m_arrItems.size());
        if (this.m_nSubItemCount > item.getSubItemCount() + 1) {
            for (int i = item.getSubItemCount(); i < this.m_nSubItemCount - 1; ++i) {
                ((ListItem)this.m_arrItems.elementAt(this.m_arrItems.size() - 1)).addSubItem();
            }
        }
        this.updateScrollbar();
        if (bRepaint) {
            this.update();
        }
    }

    public synchronized void insertItem(int nIndex, ListItem item) {
        block3: {
            block2: {
                this.m_arrItems.insertElementAt(item, nIndex);
                if (this.m_nSubItemCount <= item.getSubItemCount() + 1) break block2;
                for (int i = item.getSubItemCount(); i < this.m_nSubItemCount - 1; ++i) {
                    ((ListItem)this.m_arrItems.elementAt(nIndex)).addSubItem();
                }
                break block3;
            }
            if (this.m_nSubItemCount >= item.getSubItemCount() + 1) break block3;
            for (int i = this.m_nSubItemCount; i < item.getSubItemCount() + 1; ++i) {
                this.insertColumn(i, "", 0, -1, -1, true);
            }
        }
    }

    public synchronized void addItem(String item, Font font) {
        this.addItem(item, font, -1);
    }

    public synchronized void addItem(String item, Font font, int iImage) {
        ListItem pItem = new ListItem();
        pItem.setText(item);
        pItem.setFont(font);
        pItem.setImage(iImage);
        this.m_arrItems.addElement(pItem);
        if (this.m_nSubItemCount > pItem.getSubItemCount() + 1) {
            for (int i = pItem.getSubItemCount(); i < this.m_nSubItemCount - 1; ++i) {
                ((ListItem)this.m_arrItems.elementAt(this.m_arrItems.size() - 1)).addSubItem();
            }
        }
        this.updateScrollbar();
        this.update();
    }

    public synchronized void addSubItem(int item, String subitem) {
        this.addSubItem(item, subitem, true);
    }

    public synchronized void addSubItem(int item, String subitem, boolean bShowSubItem) {
        if (item <= this.m_arrItems.size() - 1) {
            ((ListItem)this.m_arrItems.elementAt(item)).addSubItem(subitem);
            if (bShowSubItem && this.m_arrColumns.size() - 1 < ((ListItem)this.m_arrItems.elementAt(item)).getSubItemCount()) {
                int nSubItems = ((ListItem)this.m_arrItems.elementAt(item)).getSubItemCount();
                for (int i = this.m_arrColumns.size() - 1; i < nSubItems; ++i) {
                    this.insertColumn(i, "", 0, -1, -1, false);
                }
            }
        }
    }

    public void modifySubItem(int item, int subitem, String newSubitem) {
        if (item <= this.m_arrItems.size() - 1 && subitem <= ((ListItem)this.m_arrItems.elementAt(item)).getSubItemCount()) {
            ((ListItem)this.m_arrItems.elementAt((int)item)).getSubItem((int)subitem).pszText = newSubitem;
        }
    }

    public int setImageList(Image image) {
        if (this.m_arrImages == null) {
            this.m_arrImages = new Vector();
            this.m_arrImageIDs = new Vector();
        }
        int imageID = this.m_arrImages.size();
        this.setImageList(image, imageID);
        return imageID;
    }

    public void setImageList(Image image, int imageID) {
        if (this.m_arrImages == null) {
            this.m_arrImages = new Vector();
            this.m_arrImageIDs = new Vector();
        }
        this.m_arrImages.addElement(image);
        this.m_arrImageIDs.addElement(new Integer(imageID));
    }

    public Image getImageList(int imageID) {
        int imageIndex = this.m_arrImageIDs.indexOf(new Integer(imageID));
        Image img = (Image)this.m_arrImages.elementAt(imageIndex);
        return img;
    }

    protected int getImageIndex(int imageID) {
        if (this.m_arrImageIDs == null) {
            return -1;
        }
        return this.m_arrImageIDs.indexOf(new Integer(imageID));
    }

    public int getItemImage(ListItem item) {
        return item.getImage();
    }

    public void setGridLineColor(Color c) {
        this.m_colGridLines = c;
    }

    public void setHighlightTextColor(Color c) {
        this.m_colHighlightText = c;
    }

    public Color getHighlightTextColor() {
        return this.m_colHighlightText;
    }

    public void setHighlightTextBgColor(Color c) {
        this.m_colHighlightTextBackground = c;
    }

    public Color getHighlightTextBgColor() {
        return this.m_colHighlightTextBackground;
    }

    public void setGridLines(boolean bDraw) {
        this.m_bColumnLines = bDraw;
        this.m_bItemLines = bDraw;
    }

    public void setColumnLines(boolean bDraw) {
        this.m_bColumnLines = bDraw;
    }

    public void setItemLines(boolean bDraw) {
        this.m_bItemLines = bDraw;
    }

    public void setGridLineStyle(int style) {
        this.m_nStyleGridLines = style == 0 ? 0 : 1;
    }

    public void setAutoWrap(boolean bWrap) {
        this.m_bAutoWrap = bWrap;
    }

    public boolean getAutoWrap() {
        return this.m_bAutoWrap;
    }

    public void setEditMode(boolean bAllowEdit) {
        this.m_bEditModeAllowed = bAllowEdit;
    }

    public void setOverlapEditMode(boolean bOverlap) {
        this.m_bOverlapEdit = bOverlap;
    }

    public boolean isOverlapEditMode() {
        return this.m_bOverlapEdit;
    }

    public void setDragDrop(boolean bAllowDrag) {
        this.m_bDragModeAllowed = bAllowDrag;
    }

    public void setDrawDragImage(boolean bShowImage) {
        this.m_bDrawDragImage = bShowImage;
    }

    public void setAllowDelete(boolean bAllowDelete) {
        this.m_bAllowDelete = bAllowDelete;
    }

    public void setLineSpacing(int nSpace) {
        this.m_nRowSpace = nSpace;
        this.reMeasureAllItems();
    }

    public int getLineSpacing() {
        return this.m_nRowSpace;
    }

    public void setDottedLineSpace(int nSpace) {
        this.DottedLineSpace = nSpace;
    }

    public int getDottedLineSpace() {
        return this.DottedLineSpace;
    }

    public void setDottedLineFill(int nFill) {
        this.DottedLineFill = nFill;
    }

    public int getDottedLineFill() {
        return this.DottedLineFill;
    }

    public void setShowDotRect(boolean bShowDotRect) {
        this.m_bShowDotRect = bShowDotRect;
    }

    public boolean isShowDotRect() {
        return this.m_bShowDotRect;
    }

    public void setHilightSubItems(boolean bHighlight) {
        this.m_bHilightSubItems = bHighlight;
    }

    public boolean getHilightSubItems() {
        return this.m_bHilightSubItems;
    }

    public Font getDefaultFont() {
        return defaultfont;
    }

    public void setDefaultFont(Font font) {
        defaultfont = font;
    }

    public void setColumnHeader(boolean bHeaders) {
        this.m_bColumnHeader = bHeaders;
        if (!bHeaders) {
            this.m_cyHeader = 0;
        } else {
            this.update();
        }
    }

    public boolean isColumnHeader() {
        return this.m_bColumnHeader;
    }

    public void setColumnHeaderHeight(int nHeight) {
        this.m_cyHeader = nHeight;
        this.update();
    }

    public int getColumnHeaderHeight() {
        return this.m_cyHeader;
    }

    public int countItems() {
        return this.getItemCount();
    }

    public int getItemCount() {
        return this.m_arrItems.size();
    }

    public void setTextIndent(int nIndent) {
        this.m_nWidthGap = nIndent;
    }

    public int getTextIndent() {
        return this.m_nWidthGap;
    }

    public void setTopIndent(int nIndent) {
    }

    public void setLeftIndent(int nIndent) {
    }

    public int getTopIndent() {
        return 0;
    }

    public int getLeftIndent() {
        return 0;
    }

    public boolean insertColumn(int nCol, Column pColNew, boolean bUpdate) {
        ListItem pItem = new ListItem();
        this.m_arrColumns.addElement(pColNew);
        int cSubItems = this.m_nSubItemCount;
        if (pColNew.m_iSubItem == -1 || pColNew.m_iSubItem > cSubItems) {
            pColNew.m_iSubItem = cSubItems;
            for (int nIndex = 0; nIndex < this.m_arrItems.size(); ++nIndex) {
                pItem = (ListItem)this.m_arrItems.elementAt(nIndex);
                if (pItem.getSubItemCount() >= pColNew.m_iSubItem) continue;
                ((ListItem)this.m_arrItems.elementAt(nIndex)).addSubItem();
            }
        }
        if (pColNew.m_nCX == -1) {
            ((Column)this.m_arrColumns.elementAt((int)(this.m_arrColumns.size() - 1))).m_nCX = 100;
        }
        this.reMeasureAllItems();
        if (bUpdate) {
            this.update();
        }
        ++this.m_nSubItemCount;
        return true;
    }

    public boolean insertColumn(int nCol, String strHeader, int fmt, int widthCol, int iSubItem, boolean bUpdate) {
        Column pCol = new Column();
        pCol.m_nCX = widthCol;
        pCol.m_strText = strHeader;
        pCol.m_nFmt = fmt;
        pCol.m_iSubItem = iSubItem;
        return this.insertColumn(nCol, pCol, bUpdate);
    }

    public Rectangle getInsideRect() {
        Rectangle lpRect = this.getBounds();
        if (this.isHeaderCtrlEnabled()) {
            lpRect.y += this.m_cyHeader;
            lpRect.height -= this.m_cyHeader;
        }
        if (this.vs != null) {
            lpRect.width -= this.m_nVScrollbarWidth - 1;
        }
        if (this.hs != null) {
            lpRect.height -= this.m_nHScrollbarHeight - 1;
        }
        return lpRect;
    }

    public boolean isHeaderCtrlEnabled() {
        return this.m_bColumnHeader;
    }

    public void setColumnWidth(int nCol, int nWidth) {
        if (nCol < this.m_arrColumns.size()) {
            ((Column)this.m_arrColumns.elementAt(nCol)).setWidth(nWidth);
            this.reMeasureAllItems();
            this.update();
        }
    }

    public void setMultipleSelections(boolean bMultipleSelections) {
        if (bMultipleSelections != this.m_bMultipleSelections) {
            this.m_bMultipleSelections = bMultipleSelections;
        }
    }

    public void reMeasureAllItems() {
        ListItem pItem = new ListItem();
        int c = this.m_arrItems.size();
        for (int i = 0; i < c; ++i) {
            ((ListItem)this.m_arrItems.elementAt((int)i)).m_nCY = -1;
            ((ListItem)this.m_arrItems.elementAt((int)i)).m_rcText.height = -1;
        }
        this.updateScrollbar();
    }

    protected int measureSubItem(Graphics g) {
        Rectangle rcItem = new Rectangle(0, 0, this.m_colPCol.m_nCX, 0);
        if (this.m_lvi_pszText != null) {
            Font font = ((ListItem)this.m_arrItems.elementAt(this.m_lvi_iItem)).getFont();
            FontMetrics fontMetrics = font != null ? this.getFontMetrics(font) : this.getFontMetrics(defaultfont);
            if (this.m_bAutoWrap && this.m_lvi_pszText != null) {
                Vector wrapLines = new Vector();
                wrapLines = this.m_lvi_iSubItem == 0 ? Text.wrapText(this.m_lvi_pszText, ((Column)this.m_arrColumns.elementAt((int)this.m_lvi_iSubItem)).m_nCX - this.m_nWidthGap * 2 - ((ListItem)this.m_arrItems.elementAt((int)this.m_lvi_iItem)).getImageBounds().width, true, fontMetrics) : Text.wrapText(this.m_lvi_pszText, ((Column)this.m_arrColumns.elementAt((int)this.m_lvi_iSubItem)).m_nCX - this.m_nWidthGap * 2, true, fontMetrics);
                rcItem.height = wrapLines.size() * fontMetrics.getHeight();
            } else {
                rcItem.height = fontMetrics.getHeight();
            }
            this.m_PCheight = rcItem.height;
            this.m_recPCRect.height = rcItem.height;
            ((ListItem)this.m_arrItems.elementAt((int)this.m_lvi_iItem)).m_rcText.height = rcItem.height;
            if (this.m_arrColumns.size() > 1) {
                rcItem.width = ((Column)this.m_arrColumns.elementAt((int)this.m_lvi_iSubItem)).m_nCX;
                ((ListItem)this.m_arrItems.elementAt((int)this.m_lvi_iItem)).m_rcText.width = ((Column)this.m_arrColumns.elementAt((int)this.m_lvi_iSubItem)).m_nCX;
            } else {
                ((ListItem)this.m_arrItems.elementAt((int)this.m_lvi_iItem)).m_rcText.width = fontMetrics.stringWidth(this.m_lvi_pszText) + 2 * this.m_nWidthGap;
                rcItem.width = fontMetrics.stringWidth(this.m_lvi_pszText) + 2 * this.m_nWidthGap;
                if (rcItem.width > ((Column)this.m_arrColumns.elementAt((int)0)).m_nCX && !this.m_bAutoWrap) {
                    ((Column)this.m_arrColumns.elementAt((int)0)).m_nCX = Math.max(rcItem.width, this.getInsideRect().width);
                }
            }
        }
        if (this.m_lvi_iSubItem == 0) {
            ((ListItem)this.m_arrItems.elementAt((int)this.m_lvi_iItem)).m_rcText = new Rectangle(rcItem);
            this.m_recPCRect = new Rectangle(rcItem);
        } else {
            ((ListItem)this.m_arrItems.elementAt((int)this.m_lvi_iItem)).getSubItem((int)this.m_lvi_iSubItem).rcText = new Rectangle(rcItem);
        }
        return this.m_PCheight;
    }

    protected int measureItem(Graphics g) {
        ListItem tempItem = new ListItem();
        tempItem = (ListItem)this.m_arrItems.elementAt(this.m_lvi_iItem);
        tempItem.m_nCY = 0;
        tempItem.m_rcText.height = 0;
        int cySubItem = 0;
        int cColumns = this.m_arrColumns.size();
        Image tempImage = null;
        int imageHeight = 0;
        int imageWidth = 0;
        for (int nCol = 0; nCol < cColumns; ++nCol) {
            this.m_colPCol = (Column)this.m_arrColumns.elementAt(nCol);
            this.m_lvi_iSubItem = this.m_colPCol.m_iSubItem;
            if (this.m_lvi_iSubItem == 0) {
                int nImageID = ((ListItem)this.m_arrItems.elementAt(this.m_lvi_iItem)).getImage();
                int nIndex = this.getImageIndex(nImageID);
                if (this.m_lvi_iSubItem == 0 && this.m_arrImages != null && this.m_arrImages.size() > 0 && nIndex != -1 && nIndex < this.m_arrImages.size()) {
                    tempImage = (Image)this.m_arrImages.elementAt(nIndex);
                    imageHeight = tempImage.getHeight(this);
                    imageWidth = tempImage.getWidth(this);
                }
                ((ListItem)this.m_arrItems.elementAt(this.m_lvi_iItem)).setImageBounds(new Rectangle(0, 0, imageWidth, imageHeight));
            }
            this.m_lvi_pszText = this.m_colPCol.m_iSubItem > 0 ? ((ListItem)this.m_arrItems.elementAt((int)this.m_lvi_iItem)).getSubItem((int)this.m_lvi_iSubItem).pszText : ((ListItem)this.m_arrItems.elementAt((int)this.m_lvi_iItem)).m_pszText;
            if (imageHeight > tempItem.m_nCY) {
                tempItem.m_nCY = imageHeight;
            }
            cySubItem = this.measureSubItem(g);
            tempItem.m_rcText.height = tempItem.m_nCY = Math.max(tempItem.m_nCY, cySubItem);
            ((ListItem)this.m_arrItems.elementAt((int)this.m_lvi_iItem)).m_nCY = tempItem.m_nCY;
        }
        this.m_PCheight = tempItem.m_nCY;
        this.m_recPCRect.height = tempItem.m_nCY;
        return this.m_PCheight;
    }

    public int measureItem(int nItem, Graphics g) {
        this.m_lvi_iItem = nItem;
        return this.measureItem(g);
    }

    protected int itemsThisPage(Graphics g) {
        ListItem pItem = new ListItem();
        Rectangle rcInside = this.getInsideRect();
        rcInside.y -= this.getBounds().y;
        int cyRange = 0;
        int cCount = 0;
        int i = this.m_nTopRow;
        while (i < this.m_arrItems.size()) {
            pItem = (ListItem)this.m_arrItems.elementAt(i);
            if (pItem.m_nCY == -1) {
                pItem.m_nCY = ((ListItem)this.m_arrItems.elementAt((int)i)).m_nCY = this.measureItem(i, g);
            }
            cyRange += pItem.m_nCY;
            FontMetrics fontmetrics = this.getFontMetrics(defaultfont);
            if (pItem.getFont() != null) {
                fontmetrics = this.getFontMetrics(pItem.getFont());
            }
            if ((cyRange += this.m_nRowSpace) > rcInside.height) break;
            ++i;
            ++cCount;
        }
        if (cyRange < rcInside.height && (i = this.m_nTopRow - 1) >= 0) {
            while (i >= 0) {
                pItem = (ListItem)this.m_arrItems.elementAt(i);
                if (pItem.m_nCY == -1) {
                    pItem.m_nCY = ((ListItem)this.m_arrItems.elementAt((int)i)).m_nCY = this.measureItem(i, g);
                }
                if ((cyRange += pItem.m_nCY) > rcInside.height) break;
                --i;
                ++cCount;
            }
        }
        this.m_nItemsThisPage = cCount;
        return cCount;
    }

    protected Point getLogicalSize() {
        Point szLog = new Point(0, 0);
        szLog.y = this.m_arrItems.size();
        if (this.m_arrColumns.size() > 1) {
            int c = this.m_arrColumns.size();
            for (int i = 0; i < c; ++i) {
                szLog.x += ((Column)this.m_arrColumns.elementAt((int)i)).m_nCX;
            }
            szLog.x = Math.max(szLog.x, this.getInsideRect().width);
        } else {
            Rectangle rcInside = new Rectangle();
            ListItem pItem = new ListItem();
            int c = this.m_arrItems.size();
            int cxTextMax = 0;
            int cyRange = 0;
            rcInside = this.getInsideRect();
            for (int i = this.m_nTopRow; i < c && cyRange < rcInside.height; cyRange += pItem.m_nCY, ++i) {
                pItem = (ListItem)this.m_arrItems.elementAt(i);
                if (pItem.m_nCY == -1) {
                    pItem.m_nCY = ((ListItem)this.m_arrItems.elementAt((int)i)).m_nCY = this.measureItem(i, this.getGraphics());
                }
                cxTextMax = !this.m_bAutoWrap ? Math.max(cxTextMax, pItem.m_rcText.x - this.getBounds().x + pItem.m_rcText.width + this.m_nWidthGap) : Math.max(this.getInsideRect().width, ((Column)this.m_arrColumns.elementAt((int)0)).m_nCX);
            }
            szLog.x = Math.max(cxTextMax, ((Column)this.m_arrColumns.elementAt(0)).getWidth());
        }
        return szLog;
    }

    public int getLastFullyVisibleItem() {
        int i;
        ListItem pItem = new ListItem();
        Rectangle rcInside = this.getInsideRect();
        int cyRange = 0;
        for (i = this.m_nTopRow; i < this.m_arrItems.size(); ++i) {
            pItem = (ListItem)this.m_arrItems.elementAt(i);
            if (pItem.m_nCY == -1) {
                this.measureItem(i, this.getGraphics());
            }
            if ((cyRange += pItem.m_nCY) > rcInside.height) break;
        }
        return i - 1;
    }

    public synchronized void doLayout() {
        Scrollbar vs = this.getVScrollbar();
        Scrollbar hs = this.getHScrollbar();
        Rectangle rectInside = this.getInsideRect();
        Rectangle bounds = this.getBounds();
        int w = bounds.width;
        int h = bounds.height;
        if (this.m_bAlwaysShowScrollbar || this.getMaxTopRow() != 0) {
            if (this.getMaxLeftCol() != 0 || this.m_bAlwaysShowScrollbar) {
                hs.setBounds(0, h - this.m_nHScrollbarHeight, w - this.m_nVScrollbarWidth, this.m_nHScrollbarHeight);
            } else {
                hs = null;
            }
        } else if (this.getMaxLeftCol() != 0 || this.m_bAlwaysShowScrollbar) {
            hs.setBounds(0, h - this.m_nHScrollbarHeight, w, this.m_nHScrollbarHeight);
        } else {
            hs = null;
        }
        if (this.m_bAlwaysShowScrollbar || this.getMaxLeftCol() != 0) {
            if (this.getMaxTopRow() > 0 || this.m_bAlwaysShowScrollbar) {
                vs.setBounds(w - this.m_nVScrollbarWidth, 0, this.m_nVScrollbarWidth, h - this.m_nHScrollbarHeight);
            } else {
                vs = null;
            }
        } else if (this.getMaxTopRow() > 0 || this.m_bAlwaysShowScrollbar) {
            vs.setBounds(w - this.m_nVScrollbarWidth, 0, this.m_nVScrollbarWidth, h);
        } else {
            vs = null;
        }
    }

    public void updateScrollbar() {
        Rectangle rcInside = new Rectangle();
        Point szLog = this.getLogicalSize();
        int cItemsThisPage = this.itemsThisPage(this.getGraphics());
        rcInside = this.getInsideRect();
        if (szLog.y > cItemsThisPage) {
            if (this.m_nTopRow > szLog.y - cItemsThisPage) {
                this.scrollVert(szLog.y - cItemsThisPage - this.m_nTopRow);
            }
            this.vs.setValues(this.m_nTopRow, cItemsThisPage, 0, this.m_arrItems.size());
            this.vs.setBlockIncrement(Math.max(cItemsThisPage, 1));
            this.showVScrollbar();
        } else {
            if (this.m_nTopRow > 0) {
                this.scrollVert(-this.m_nTopRow);
            }
            this.hideVScrollbar();
        }
        if (szLog.x > rcInside.width) {
            if (this.m_ptViewportOrg.x > szLog.x - rcInside.width) {
                this.scrollHorz(szLog.x - rcInside.width - this.m_ptViewportOrg.x);
            }
            this.hs.setValues(this.m_ptViewportOrg.x, rcInside.width, 0, szLog.x);
            this.hs.setBlockIncrement(Math.max(this.getInsideRect().width - 10, 10));
            this.hs.setUnitIncrement(10);
            this.showHScrollbar();
        } else {
            this.m_ptViewportOrg.x = 0;
            this.onLeftColChanged(this.m_ptViewportOrg.x);
            this.hideHScrollbar();
        }
        this.doLayout();
    }

    public void scrollVert(int nScrollItems) {
        this.scrollVert(nScrollItems, false);
    }

    public void scrollVert(int nScrollItems, boolean bFromBottom) {
        if (!bFromBottom) {
            int nFirst = this.m_nTopRow;
            int nLast = nFirst + nScrollItems;
            nLast = Math.max(nLast, 0);
            nScrollItems = (nLast = Math.min(nLast, this.m_arrItems.size() - 1)) - nFirst;
            if (nScrollItems != 0) {
                this.m_nTopRow += nScrollItems;
                this.update();
            }
        } else {
            int nFirst = this.getLastFullyVisibleItem();
            int nLast = nFirst + nScrollItems;
            int cyScroll = this.calcRangeHeight(nFirst, nLast, true);
            nScrollItems = this.calcItemsInRange(cyScroll, this.m_nTopRow, true);
            this.scrollVert(nScrollItems, false);
        }
    }

    public void scrollHorz(int nPixels) {
        Rectangle rcInside = this.getInsideRect();
        Point szLog = this.getLogicalSize();
        int xOrig = this.m_ptViewportOrg.x;
        this.m_ptViewportOrg.x -= nPixels;
        this.m_ptViewportOrg.x = Math.max(0, this.m_ptViewportOrg.x);
        this.m_ptViewportOrg.x = Math.min(szLog.x - rcInside.width, this.m_ptViewportOrg.x);
        this.onLeftColChanged(this.m_ptViewportOrg.x);
        nPixels = xOrig - this.m_ptViewportOrg.x;
        this.update();
        if (this.isHeaderCtrlEnabled()) {
            Rectangle rcClient = this.getBounds();
            Rectangle rcHeader = new Rectangle();
            rcHeader.y = rcClient.y;
            rcHeader.x = rcClient.x;
            rcHeader.width = rcClient.width;
            rcHeader.height = 0;
            this.update();
        }
        this.hs.setUnitIncrement(10);
        this.hs.setBlockIncrement(this.getInsideRect().width - 10);
        this.hs.setValue(this.m_ptViewportOrg.x);
    }

    protected int getMaxTopRow() {
        int i;
        Rectangle rcInside = this.getInsideRect();
        int nLastIndex = this.m_arrItems.size() - 1;
        ListItem pItem = new ListItem();
        int nTotalHeight = 0;
        for (i = nLastIndex; i >= 0; --i) {
            pItem = (ListItem)this.m_arrItems.elementAt(i);
            this.m_lvi_iItem = i;
            if ((nTotalHeight += this.measureItem(i, this.getGraphics())) > rcInside.height) break;
        }
        return Math.max(0, i + 1);
    }

    protected int getMaxLeftCol() {
        Rectangle rcInside = this.getInsideRect();
        Point szLog = this.getLogicalSize();
        return szLog.x - rcInside.width;
    }

    public void setColumnText(int nCol, String text) {
        ((Column)this.m_arrColumns.elementAt(nCol)).setText(text);
    }

    protected int getColumnHit(int xPos) {
        int col = 0;
        xPos += this.m_ptViewportOrg.x;
        for (int width = 0; width <= xPos && col < this.m_arrColumns.size(); width += ((Column)this.m_arrColumns.elementAt((int)col++)).m_nCX) {
        }
        return col < this.m_arrColumns.size() ? col - 1 : this.m_arrColumns.size() - 1;
    }

    protected int getPosFromCol(int nCol) {
        int xPos = 0 - this.m_ptViewportOrg.x;
        for (int i = 0; i < nCol + 1; ++i) {
            xPos += ((Column)this.m_arrColumns.elementAt((int)i)).m_nCX;
        }
        return xPos - 1;
    }

    public int calcItemsInRange(int cyRange, int nStartItem, boolean bDown) {
        ListItem pItem = new ListItem();
        int cy = 0;
        int nItems = 0;
        if (bDown) {
            for (int i = nStartItem; i < this.m_arrItems.size(); ++i) {
                pItem = (ListItem)this.m_arrItems.elementAt(i);
                ++nItems;
                if ((cy += pItem.m_nCY) < cyRange) {
                    continue;
                }
                break;
            }
        } else {
            for (int i = nStartItem; i >= 0; --i) {
                pItem = (ListItem)this.m_arrItems.elementAt(i);
                ++nItems;
                if ((cy += pItem.m_nCY) < cyRange) {
                    continue;
                }
                break;
            }
        }
        return nItems;
    }

    public int calcRangeHeight(int nFirst, int nLast, boolean bInclusive) {
        ListItem pItem = new ListItem();
        boolean bNeg = false;
        if (nFirst > nLast) {
            int nSwap = nFirst;
            nFirst = nLast;
            nLast = nSwap;
            bNeg = true;
        }
        int cyRange = 0;
        for (int i = nFirst; i < nLast || bInclusive && i <= nLast; ++i) {
            pItem = (ListItem)this.m_arrItems.elementAt(i);
            if (pItem.m_nCY == -1) {
                this.measureItem(i, this.getGraphics());
            }
            cyRange += pItem.m_nCY;
        }
        if (bNeg) {
            cyRange *= -1;
        }
        return cyRange;
    }

    public void drawItem(Graphics g) {
        Rectangle rcCell = new Rectangle();
        Rectangle rcRow = this.m_recPCRect;
        rcCell.y = rcRow.y;
        rcCell.height = rcRow.height;
        rcCell.x = rcRow.x;
        rcCell.width = 0;
        int cColumns = this.m_arrColumns.size();
        for (int nCol = 0; nCol < cColumns; ++nCol) {
            this.m_colPCol = (Column)this.m_arrColumns.elementAt(nCol);
            rcCell.width = cColumns > 1 ? this.m_colPCol.m_nCX : Math.max(this.m_colPCol.m_nCX, ((ListItem)this.m_arrItems.elementAt((int)this.m_lvi_iItem)).m_rcText.width);
            if (rcCell.intersects(rcRow)) {
                this.m_lvi_iSubItem = this.m_colPCol.m_iSubItem;
                this.m_lvi_pszText = this.m_lvi_iSubItem != 0 ? ((ListItem)this.m_arrItems.elementAt((int)this.m_lvi_iItem)).getSubItem((int)this.m_lvi_iSubItem).pszText : ((ListItem)this.m_arrItems.elementAt((int)this.m_lvi_iItem)).m_pszText;
                this.m_recPCRect = new Rectangle(rcCell);
                this.drawSubItem(g);
            }
            rcCell.x += rcCell.width;
            this.m_recPCRect.x = rcCell.x;
        }
        if (this.m_bItemLines) {
            this.drawItemLines(g, rcRow);
        }
    }

    public void drawSubItem(Graphics g) {
        Rectangle bounds = this.getBounds();
        if (this.m_lvi_pszText != null) {
            if (((ListItem)this.m_arrItems.elementAt(this.m_lvi_iItem)).getFont() != null) {
                g.setFont(((ListItem)this.m_arrItems.elementAt(this.m_lvi_iItem)).getFont());
            } else {
                g.setFont(defaultfont);
            }
            int xp = this.m_recPCRect.x;
            FontMetrics fm = g.getFontMetrics();
            int nTextHigh = fm.getHeight();
            if (!this.m_bAutoWrap) {
                int nTotalWidth;
                String str = "";
                int nImgWidth = 0;
                if (this.m_lvi_iSubItem == 0) {
                    nImgWidth = ((ListItem)this.m_arrItems.elementAt((int)this.m_lvi_iItem)).getImageBounds().width + this.m_nWidthGap;
                }
                if ((nTotalWidth = fm.stringWidth(this.m_lvi_pszText) + nImgWidth) > this.m_recPCRect.width - 2 * this.m_nWidthGap - (bounds.width - this.getInsideRect().width)) {
                    int nDotWidth = fm.stringWidth(".");
                    if (nImgWidth + this.m_nWidthGap + nDotWidth > this.m_recPCRect.width - (bounds.width - this.getInsideRect().width)) {
                        nTotalWidth = nImgWidth;
                        str = " ";
                    } else if (nImgWidth + this.m_nWidthGap + 2 * nDotWidth > this.m_recPCRect.width - (bounds.width - this.getInsideRect().width)) {
                        nTotalWidth = nImgWidth + this.m_nWidthGap + nDotWidth;
                        str = ".";
                    } else if (nImgWidth + this.m_nWidthGap + 3 * nDotWidth > this.m_recPCRect.width - (bounds.width - this.getInsideRect().width)) {
                        nTotalWidth = nImgWidth + this.m_nWidthGap + 2 * nDotWidth;
                        str = "..";
                    } else {
                        int j = 0;
                        for (j = 1; j < this.m_lvi_pszText.length() && (nTotalWidth = nImgWidth + 2 * this.m_nWidthGap + fm.stringWidth(this.m_lvi_pszText.substring(0, j - 1)) + 3 * nDotWidth) <= this.m_recPCRect.width; ++j) {
                        }
                        if (j - 2 < 0) {
                            j = 2;
                        }
                        str = this.m_lvi_pszText.substring(0, j - 2) + "...";
                        nTotalWidth = nImgWidth + this.m_nWidthGap + fm.stringWidth(str);
                    }
                }
                if (fm.stringWidth(this.m_lvi_pszText) + nImgWidth > this.m_recPCRect.width - 2 * this.m_nWidthGap) {
                    this.m_lvi_pszText = str;
                }
                if (!this.isSelected(this.m_lvi_iItem) || this.m_lvi_iSubItem != 0 && !this.m_bHilightSubItems) {
                    g.setColor(this.m_colText);
                } else if (this.m_bHasFocus) {
                    g.setColor(this.m_colHighlightTextBackground);
                    g.fillRect(this.m_recPCRect.x + 1, this.m_recPCRect.y - bounds.y + 1, this.m_recPCRect.width - 3, this.m_recPCRect.height - 1);
                    if (this.m_bShowDotRect) {
                        this.drawDottedRect(g, this.m_recPCRect.x, this.m_recPCRect.y - bounds.y, this.m_recPCRect.width - 1, this.m_recPCRect.height);
                    }
                    g.setColor(this.m_colHighlightText);
                } else {
                    g.setColor(this.m_colText);
                    this.drawDottedRect(g, this.m_recPCRect.x, this.m_recPCRect.y - bounds.y, this.m_recPCRect.width - 1, this.m_recPCRect.height);
                }
                int xPos = this.m_recPCRect.x;
                xPos = this.m_lvi_iSubItem == 0 ? (xPos += this.m_nWidthGap + ((ListItem)this.m_arrItems.elementAt((int)this.m_lvi_iItem)).getImageBounds().width) : (xPos += this.m_nWidthGap);
                int yPos = this.m_recPCRect.y + ((ListItem)this.m_arrItems.elementAt((int)this.m_lvi_iItem)).m_rcText.height - bounds.y - ((ListItem)this.m_arrItems.elementAt((int)this.m_lvi_iItem)).m_rcText.height / 4;
                int sLen = this.m_nWidthGap + fm.stringWidth(this.m_lvi_pszText);
                Column tempCol = (Column)this.m_arrColumns.elementAt(this.m_lvi_iSubItem);
                if (tempCol.m_nFmt == 1) {
                    if (sLen < tempCol.m_nCX) {
                        xPos = tempCol.m_nCX / 2 - (sLen - this.m_nWidthGap) / 2 + xPos - this.m_nWidthGap;
                    }
                } else if (tempCol.m_nFmt == 2 && sLen < tempCol.m_nCX) {
                    xPos = tempCol.m_nCX - (sLen - this.m_nWidthGap) + xPos - 2 * this.m_nWidthGap;
                }
                int nImageID = ((ListItem)this.m_arrItems.elementAt(this.m_lvi_iItem)).getImage();
                int nIndex = this.getImageIndex(nImageID);
                if (this.m_lvi_iSubItem == 0 && nIndex != -1 && this.m_arrImages != null && this.m_arrImages.size() > 0 && nIndex < this.m_arrImages.size()) {
                    Image img;
                    int tempxPos = this.m_recPCRect.x + this.m_nWidthGap;
                    int tempyPos = this.m_recPCRect.y - bounds.y;
                    int nTextHeight = ((ListItem)this.m_arrItems.elementAt((int)this.m_lvi_iItem)).getTextBounds().height;
                    int nImageHeight = ((ListItem)this.m_arrItems.elementAt((int)this.m_lvi_iItem)).getImageBounds().height;
                    if (nTextHeight > nImageHeight) {
                        tempyPos += (nTextHeight - nImageHeight) / 2;
                    }
                    if ((img = (Image)this.m_arrImages.elementAt(nIndex)) != null) {
                        g.drawImage(img, tempxPos, tempyPos, this);
                    }
                    xPos += this.m_nWidthGap;
                }
                g.drawString(this.m_lvi_pszText, xPos, yPos);
            } else {
                Vector nodeText = new Vector();
                nodeText = this.m_lvi_iSubItem == 0 ? Text.wrapText(this.m_lvi_pszText, ((Column)this.m_arrColumns.elementAt((int)this.m_lvi_iSubItem)).m_nCX - this.m_nWidthGap * 2 - ((ListItem)this.m_arrItems.elementAt((int)this.m_lvi_iItem)).getImageBounds().width, true, fm) : Text.wrapText(this.m_lvi_pszText, ((Column)this.m_arrColumns.elementAt((int)this.m_lvi_iSubItem)).m_nCX - this.m_nWidthGap * 2, true, fm);
                if (!this.isSelected(this.m_lvi_iItem) || this.m_lvi_iSubItem != 0 && !this.m_bHilightSubItems) {
                    g.setColor(this.m_colText);
                } else if (this.m_bHasFocus) {
                    g.setColor(this.m_colHighlightTextBackground);
                    g.fillRect(this.m_recPCRect.x + 1, this.m_recPCRect.y - bounds.y + 1, this.m_recPCRect.width - 3, this.m_recPCRect.height - 1);
                    if (this.m_bShowDotRect) {
                        this.drawDottedRect(g, this.m_recPCRect.x, this.m_recPCRect.y - bounds.y, this.m_recPCRect.width - 1, this.m_recPCRect.height);
                    }
                    g.setColor(this.m_colHighlightText);
                } else {
                    g.setColor(this.m_colText);
                    this.drawDottedRect(g, this.m_recPCRect.x, this.m_recPCRect.y - bounds.y, this.m_recPCRect.width - 1, this.m_recPCRect.height);
                }
                int tempY = this.m_recPCRect.y;
                int xPos = this.m_recPCRect.x + this.m_nWidthGap;
                int yPos = nTextHigh - bounds.y - nTextHigh / 4;
                int sLen = 0;
                Column tempCol = (Column)this.m_arrColumns.elementAt(this.m_lvi_iSubItem);
                int nImageID = ((ListItem)this.m_arrItems.elementAt(this.m_lvi_iItem)).getImage();
                int nIndex = this.getImageIndex(nImageID);
                if (this.m_lvi_iSubItem == 0 && nIndex != -1 && this.m_arrImages != null && this.m_arrImages.size() > 0 && nIndex < this.m_arrImages.size()) {
                    Image img;
                    int nImageHeight;
                    int tempxPos = this.m_recPCRect.x + this.m_nWidthGap;
                    int tempyPos = this.m_recPCRect.y - bounds.y;
                    int nTextHeight = fm.getHeight();
                    if (nTextHeight > (nImageHeight = ((ListItem)this.m_arrItems.elementAt((int)this.m_lvi_iItem)).getImageBounds().height)) {
                        tempyPos += (nTextHeight - nImageHeight) / 2;
                    }
                    if ((img = (Image)this.m_arrImages.elementAt(nIndex)) != null) {
                        g.drawImage(img, tempxPos, tempyPos, this);
                    }
                    xPos += this.m_nWidthGap;
                }
                for (int i = 0; i < nodeText.size(); ++i) {
                    xPos = this.m_recPCRect.x + this.m_nWidthGap;
                    if (this.m_lvi_iSubItem == 0) {
                        xPos += ((ListItem)this.m_arrItems.elementAt((int)this.m_lvi_iItem)).getImageBounds().width;
                    }
                    int imageID = ((ListItem)this.m_arrItems.elementAt(this.m_lvi_iItem)).getImage();
                    if (this.m_lvi_iSubItem == 0 && imageID != -1 && this.m_arrImages != null && this.m_arrImages.size() > 0 && imageID < this.m_arrImages.size()) {
                        xPos += this.m_nWidthGap;
                    }
                    sLen = this.m_nWidthGap + fm.stringWidth((String)nodeText.elementAt(i));
                    if (tempCol.m_nFmt == 1) {
                        if (sLen < tempCol.m_nCX) {
                            xPos = tempCol.m_nCX / 2 - (sLen - this.m_nWidthGap) / 2 + xPos - this.m_nWidthGap;
                        }
                    } else if (tempCol.m_nFmt == 2 && sLen < tempCol.m_nCX) {
                        xPos = tempCol.m_nCX - (sLen - this.m_nWidthGap) + xPos - 2 * this.m_nWidthGap;
                    }
                    g.drawString((String)nodeText.elementAt(i), xPos, tempY + yPos);
                    tempY = tempY + nTextHigh + this.m_nRowSpace;
                }
            }
        }
    }

    protected void drawDottedLine(Graphics g, int x1, int y1, int x2, int y2) {
        int length = Math.abs(x1 - x2);
        boolean xSame = false;
        if (length == 0) {
            length = Math.abs(y1 - y2);
            xSame = true;
        }
        for (int i = 0; i <= length; i += this.DottedLineSpace + this.DottedLineFill) {
            if (xSame) {
                if (y1 < y2) {
                    g.drawLine(x1, y1 + i, x1, y1 + i + this.DottedLineFill - 1);
                    continue;
                }
                g.drawLine(x1, y2 + i, x1, y2 + i + this.DottedLineFill - 1);
                continue;
            }
            if (x1 < x2) {
                g.drawLine(x1 + i, y1, x1 + i + this.DottedLineFill - 1, y1);
                continue;
            }
            g.drawLine(x2 + i, y1, x2 + i + this.DottedLineFill - 1, y1);
        }
    }

    protected void drawDottedRect(Graphics g, int x1, int y1, int width, int height) {
        this.drawDottedLine(g, x1 + 1, y1, x1 + width, y1);
        this.drawDottedLine(g, x1, y1, x1, y1 + height);
        this.drawDottedLine(g, x1 + width, y1, x1 + width, y1 + height);
        this.drawDottedLine(g, x1, y1 + height, x1 + width, y1 + height);
    }

    public void drawInvalidItems(Graphics g) {
        Rectangle rcRow = new Rectangle();
        int c = this.m_arrItems.size();
        Rectangle rcInside = this.getInsideRect();
        Point szLog = this.getLogicalSize();
        rcRow.y = rcInside.y;
        rcRow.y += 2;
        rcRow.x = -this.m_ptViewportOrg.x;
        rcRow.width = szLog.x;
        rcRow.height = 0;
        int cItemsThisPage = 0;
        this.m_lvi_iItem = this.m_nTopRow;
        while (this.m_lvi_iItem < c) {
            if (((ListItem)this.m_arrItems.elementAt((int)this.m_lvi_iItem)).m_nCY == -1) {
                ((ListItem)this.m_arrItems.elementAt((int)this.m_lvi_iItem)).m_nCY = this.measureItem(g);
            }
            rcRow.height += ((ListItem)this.m_arrItems.elementAt((int)this.m_lvi_iItem)).m_nCY;
            Rectangle temp = this.getBounds();
            temp.x = 0;
            temp.width *= 2;
            boolean bDraw = rcRow.intersects(temp);
            if (!bDraw) break;
            this.m_recPCRect = rcRow;
            ((ListItem)this.m_arrItems.elementAt((int)this.m_lvi_iItem)).m_rcText.y = rcRow.y;
            this.drawItem(g);
            rcRow.y += rcRow.height;
            rcRow.y += this.m_nRowSpace;
            rcRow.height = 0;
            if (rcRow.y > rcInside.height + rcInside.y) break;
            ++this.m_lvi_iItem;
            ++cItemsThisPage;
        }
        this.vs.setVisibleAmount(this.itemsThisPage(g));
        this.vs.setMaximum(this.m_arrItems.size());
        this.vs.setValue(this.m_nTopRow);
        this.vs.setBlockIncrement(Math.max(cItemsThisPage, 1));
        if (this.m_bColumnLines && this.m_arrColumns.size() > 1) {
            this.drawColumnLines(g);
        }
    }

    public void draw(Graphics g) {
        Rectangle bounds = this.getBounds();
        if (this.m_arrItems.size() == 0) {
            return;
        }
        if (this.m_nItemsThisPage == 0) {
            this.updateScrollbar();
        }
        Rectangle rectInside = this.getInsideRect();
        if (this.isHeaderCtrlEnabled()) {
            this.drawHeader(g);
        }
        if (this.m_nDraggingState == 0) {
            this.drawInvalidItems(g);
        }
        if (this.vs != null && this.vs.isShowing() && this.hs != null && this.hs.isShowing()) {
            rectInside = this.getInsideRect();
            Rectangle rectClient = bounds;
            Rectangle rectErase = new Rectangle();
            rectErase.x = rectClient.width - this.vs.getBounds().width;
            rectErase.width = rectClient.width - rectInside.width;
            rectErase.y = 0 + rectClient.height - this.hs.getBounds().height;
            rectErase.height = rectClient.height - rectInside.height;
            g.clearRect(rectErase.x, rectErase.y, rectErase.width, rectErase.height);
        }
        this.paintBorder(g, 0, 0, bounds.width, bounds.height, false);
    }

    public void drawColumnLines(Graphics g) {
        Rectangle bounds = this.getBounds();
        g.setColor(this.m_colGridLines);
        int xCoor = -this.m_ptViewportOrg.x;
        for (int i = 0; i < this.m_arrColumns.size(); ++i) {
            xCoor += ((Column)this.m_arrColumns.elementAt(i)).getWidth();
            if (this.m_nStyleGridLines == 0) {
                this.drawDottedLine(g, xCoor, this.m_cyHeader, xCoor, bounds.y + bounds.height);
                continue;
            }
            g.drawLine(xCoor, this.m_cyHeader, xCoor, bounds.y + bounds.height);
        }
    }

    public void drawItemLines(Graphics g, Rectangle rcRow) {
        Rectangle bounds = this.getBounds();
        g.setColor(this.m_colGridLines);
        if (this.m_nStyleGridLines == 0) {
            this.drawDottedLine(g, rcRow.x, rcRow.y + rcRow.height + this.m_nRowSpace / 2 - bounds.y, rcRow.x + rcRow.width, rcRow.y + rcRow.height + this.m_nRowSpace / 2 - bounds.y);
        } else {
            g.drawLine(rcRow.x, rcRow.y + rcRow.height + this.m_nRowSpace / 2 - bounds.y, rcRow.x + rcRow.width, rcRow.y + rcRow.height + this.m_nRowSpace / 2 - bounds.y);
        }
    }

    private void drawHeader(Graphics g) {
        Column pCol;
        int i;
        Rectangle rcHeader = new Rectangle();
        Rectangle rcClient = this.getBounds();
        Point szLog = this.getLogicalSize();
        rcHeader.y = 0;
        rcHeader.height = this.m_cyHeader - 1;
        rcHeader.x = -this.m_ptViewportOrg.x;
        rcHeader.width = Math.max(szLog.x, rcClient.width + 1);
        g.setColor(this.getBackground());
        g.fillRect(rcHeader.x - 2, rcHeader.y, rcHeader.width, rcHeader.height);
        g.setColor(SystemColor.control);
        g.fill3DRect(rcHeader.x - 2, rcHeader.y, rcHeader.width, rcHeader.height, true);
        this.paintBorder(g, rcHeader.x + 2, rcHeader.y + 2, rcHeader.width - 2, rcHeader.height - 2, true);
        if (this.m_arrColumns.size() > 1) {
            int nColCount = this.m_arrColumns.size();
            for (i = 0; i < nColCount; ++i) {
                pCol = (Column)this.m_arrColumns.elementAt(i);
                rcHeader.width = pCol.m_nCX;
                g.drawLine(rcHeader.x + rcHeader.width, rcHeader.y, rcHeader.x + rcHeader.width, rcHeader.y + rcHeader.height);
                rcHeader.x += rcHeader.width;
            }
        }
        rcHeader.x = -this.m_ptViewportOrg.x;
        for (i = 0; i < this.m_arrColumns.size(); ++i) {
            pCol = (Column)this.m_arrColumns.elementAt(i);
            rcHeader.width = pCol.m_nCX - 1;
            g.setFont(pCol.m_fonFont);
            String columnText = pCol.m_strText;
            FontMetrics fm = g.getFontMetrics(g.getFont());
            int nTotalWidth = fm.stringWidth(pCol.m_strText);
            String str = "";
            int nImgWidth = 0;
            if (nTotalWidth > pCol.m_nCX - this.m_nWidthGap) {
                int nDotWidth = fm.stringWidth(".");
                if (nImgWidth + this.m_nWidthGap + nDotWidth > pCol.m_nCX) {
                    nTotalWidth = nImgWidth;
                    str = " ";
                } else if (nImgWidth + this.m_nWidthGap + 2 * nDotWidth > pCol.m_nCX) {
                    nTotalWidth = nImgWidth + this.m_nWidthGap + nDotWidth;
                    str = ".";
                } else if (nImgWidth + this.m_nWidthGap + 3 * nDotWidth > pCol.m_nCX) {
                    nTotalWidth = nImgWidth + this.m_nWidthGap + nDotWidth;
                    str = "..";
                } else {
                    int j = 0;
                    for (j = 1; j < columnText.length() && (nTotalWidth = nImgWidth + this.m_nWidthGap * 2 + fm.stringWidth(columnText.substring(0, j - 1)) + 3 * nDotWidth) <= pCol.m_nCX; ++j) {
                    }
                    str = columnText.substring(0, j - 1) + "...";
                    nTotalWidth = nImgWidth + this.m_nWidthGap + fm.stringWidth(str);
                }
            }
            if (fm.stringWidth(pCol.m_strText) > pCol.m_nCX - this.m_nWidthGap) {
                columnText = str;
            }
            int xPos = rcHeader.x + this.m_nWidthGap;
            int yPos = rcHeader.y + rcHeader.height - rcHeader.height / 4;
            int sLen = this.m_nWidthGap + fm.stringWidth(columnText);
            if (pCol.m_nFmt == 1) {
                if (sLen < pCol.m_nCX) {
                    xPos = pCol.m_nCX / 2 - (sLen - this.m_nWidthGap) / 2 + xPos - this.m_nWidthGap;
                }
            } else if (pCol.m_nFmt == 2 && sLen < pCol.m_nCX) {
                xPos = pCol.m_nCX - (sLen - this.m_nWidthGap) + xPos - 2 * this.m_nWidthGap;
            }
            g.drawString(columnText, xPos, yPos);
            rcHeader.x = rcHeader.x + rcHeader.width + 1;
        }
    }

    private void paintBorder(Graphics g, int x, int y, int w, int h, boolean raised) {
        g.setColor(SystemColor.controlLtHighlight);
        if (raised) {
            g.drawLine(x, y, x + w, y);
            g.drawLine(x, y, x, y + h);
        } else {
            g.drawLine(x + 1, y + h - 1, x + w - 1, y + h - 1);
            g.drawLine(x + w - 1, y + 1, x + w - 1, y + h - 1);
        }
        g.setColor(SystemColor.controlHighlight);
        if (!raised) {
            g.drawLine(x + 1, y + h - 2, x + w - 2, y + h - 2);
            g.drawLine(x + w - 2, y + 1, x + w - 2, y + h - 2);
        }
        g.setColor(SystemColor.controlShadow);
        if (raised) {
            g.drawLine(x + 1, y + h - 1, x + w - 1, y + h - 1);
            g.drawLine(x + w - 1, y + 1, x + w - 1, y + h - 1);
        } else {
            g.drawLine(x, y, x + w - 1, y);
            g.drawLine(x, y, x, y + h - 1);
        }
        g.setColor(SystemColor.controlDkShadow);
        if (raised) {
            g.drawLine(x, y + h, x + w, y + h);
            g.drawLine(x + w, y, x + w, y + h);
        } else {
            g.drawLine(x + 1, y + 1, x + w - 2, y + 1);
            g.drawLine(x + 1, y + 1, x + 1, y + h - 2);
        }
    }

    public void drawFocusRect(Graphics g, int x, int y, int w, int h) {
        if (this.m_bHasFocus && this.getSelectedListItem() == null) {
            ListItem item = this.getItemAt(this.m_nTopRow);
            Rectangle r = item.getTextBounds();
            if (this.isColumnHeader()) {
                y += this.getColumnHeaderHeight();
            }
            this.drawDottedRect(g, x + 3, y + 3, w - 6, r.height);
        }
    }

    public Object getItem(int index) {
        return this.m_arrItems.elementAt(index);
    }

    public synchronized int getSelectedIndex() {
        int[] sel = this.getSelectedIndexes();
        return this.selected.length == 1 ? this.selected[0] : -1;
    }

    public synchronized int[] getSelectedIndexes() {
        return this.selected;
    }

    public void addItemListener(ItemListener l) {
        this.itemListener = AWTEventMulticaster.add(this.itemListener, l);
    }

    public void removeItemListener(ItemListener l) {
        this.itemListener = AWTEventMulticaster.remove(this.itemListener, l);
    }

    public void addActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, l);
    }

    public void removeActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, l);
    }

    protected void processActionEvent(ActionEvent e) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(e);
        }
    }

    protected void processItemEvent(ItemEvent e) {
        if (this.itemListener != null) {
            this.itemListener.itemStateChanged(e);
        }
    }

    protected boolean mouseMove(MouseEvent e, int x, int y) {
        int nCol = this.getColumnHit(x);
        int nColPos = this.getPosFromCol(nCol);
        if (y > 0 && y < this.m_cyHeader && Math.abs(x - nColPos) <= 3 && this.m_arrColumns.size() > 1) {
            this.m_nDraggingState = 1;
            this.m_nDraggingCurrent = nCol;
            this.m_nDraggingBegin = nColPos - ((Column)this.m_arrColumns.elementAt((int)this.m_nDraggingCurrent)).m_nCX;
            if (!this.m_bCaptured) {
                if (this.OSName.equals("Windows NT") || this.OSName.equals("Windows 95")) {
                    this.setCursor(Cursor.getPredefinedCursor(10));
                } else {
                    this.setCursor(Cursor.getPredefinedCursor(13));
                }
            }
            this.m_bCaptured = true;
        } else if (y > 0 && y < this.m_cyHeader && Math.abs(nColPos + ((Column)this.m_arrColumns.elementAt((int)nCol)).m_nCX - x) <= 3 && this.m_arrColumns.size() > 1) {
            this.m_nDraggingState = 1;
            this.m_nDraggingCurrent = nCol;
            this.m_nDraggingBegin = nColPos;
            if (!this.m_bCaptured) {
                if (this.OSName.equals("Windows NT") || this.OSName.equals("Windows 95")) {
                    this.setCursor(Cursor.getPredefinedCursor(10));
                } else {
                    this.setCursor(Cursor.getPredefinedCursor(13));
                }
            }
            this.m_bCaptured = true;
        } else {
            this.m_nDraggingState = 0;
            if (this.m_bCaptured) {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
            this.m_bCaptured = false;
            this.onMoveOverItem(x, y);
        }
        return true;
    }

    protected void onMoveOverItem(int x, int y) {
    }

    protected boolean mouseDrag(MouseEvent e, int x, int y) {
        this.m_bMouseDrag = true;
        this.m_bEditModeEnabled = false;
        if (this.m_nDraggingState == 1 && x - this.m_nDraggingBegin >= -3) {
            int nCol = this.getColumnHit(x);
            this.onMoveTracking(nCol, x);
            return true;
        }
        if (this.m_nDraggingState == 1 && x - this.m_nDraggingBegin < -3) {
            return true;
        }
        if (this.m_bDragModeEnabled) {
            this.m_bEditModeEnabled = false;
            Graphics g = this.getGraphics();
            if (this.m_bDragDropDrawn) {
                this.printDragItem(g);
            } else {
                this.m_bDragDropDrawn = true;
            }
            this.m_nXMouse = x;
            this.m_nYMouse = y;
            this.printDragItem(g);
            g.dispose();
        }
        return true;
    }

    public int getDropTargetItem() {
        return this.m_dropTargetItem;
    }

    public int getIndex(ListItem pItem) {
        return this.m_arrItems.indexOf(pItem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveItems(Object[] items, int targetIndex) {
        if (targetIndex == -1) {
            return;
        }
        for (int j = items.length - 1; j > -1; --j) {
            if (items[j] != this.m_arrItems.elementAt(targetIndex)) continue;
            return;
        }
        Vector premoveList = new Vector();
        for (int j = 0; j < this.selected.length; ++j) {
            premoveList.addElement(this.m_arrItems.elementAt(this.selected[j]));
        }
        this.deselectAll(false);
        Vector j = this.m_arrItems;
        synchronized (j) {
            for (int i = items.length - 1; i > -1; --i) {
                int nIndex = this.getIndex((ListItem)items[i]);
                if (nIndex > targetIndex) {
                    ++nIndex;
                }
                this.m_arrItems.insertElementAt(items[i], targetIndex);
                this.m_arrItems.removeElementAt(nIndex);
                targetIndex = this.getIndex((ListItem)items[i]);
            }
        }
        for (int k = 0; k < premoveList.size(); ++k) {
            this.select(this.getIndex((ListItem)premoveList.elementAt(k)), false);
        }
        this.update();
    }

    public void printDragItem(Graphics g) {
        g.setXORMode(this.getBackground());
        if (!this.m_bColumnHeader || this.m_nYMouse + 10 > this.m_cyHeader) {
            this.drawTargetHighLight(g);
            if (!this.m_bDrawDragImage) {
                return;
            }
            if (this.m_imgDragPic != null) {
                g.drawImage(this.m_imgDragPic, this.m_nXMouse + 10, this.m_nYMouse + 10, this);
            } else {
                g.setColor(Color.white);
                g.fillRect(this.m_nXMouse + 10, this.m_nYMouse + 10, 10, 10);
                g.setColor(Color.black);
                g.drawRect(this.m_nXMouse + 10, this.m_nYMouse + 10, 10, 10);
            }
        }
    }

    protected void drawTargetHighLight(Graphics g) {
        Rectangle bounds = this.getBounds();
        int index = this.getTarget(this.m_nXMouse, this.m_nYMouse);
        if (index == this.m_nOldTargetIndex) {
            return;
        }
        g.setColor(SystemColor.textHighlight);
        if (index >= 0 && !this.isSelected(index)) {
            g.setColor(Color.red);
            ListItem pItem = (ListItem)this.m_arrItems.elementAt(index);
            g.drawLine(0, pItem.getTextBounds().y - bounds.y, bounds.x + this.getInsideRect().width, pItem.getTextBounds().y - bounds.y);
        }
        if (this.m_nOldTargetIndex != -1 && !this.isSelected(this.m_nOldTargetIndex)) {
            g.setColor(Color.red);
            ListItem tempItem = (ListItem)this.m_arrItems.elementAt(this.m_nOldTargetIndex);
            g.drawLine(0, tempItem.getTextBounds().y - bounds.y, this.getInsideRect().width + bounds.x, tempItem.getTextBounds().y - bounds.y);
        }
        this.m_nOldTargetIndex = index;
    }

    public void setDragDropImage(Image image) {
        this.m_imgDragPic = image;
    }

    protected boolean mouseExit(MouseEvent e, int x, int y) {
        this.setCursor(Cursor.getPredefinedCursor(0));
        return true;
    }

    protected void onMoveTracking(int nCol, int x) {
        Rectangle rcInside = this.getBounds();
        int nListWidth = rcInside.width;
        int nListHeight = rcInside.height;
        Graphics g = this.getGraphics();
        g.setColor(Color.red);
        g.setXORMode(this.getBackground());
        g.fillRect(this.m_rectDragging.x, this.m_rectDragging.y, this.m_rectDragging.width, this.m_rectDragging.height);
        this.m_rectDragging = new Rectangle(x, this.m_cyHeader, 1, nListHeight);
        g.fillRect(this.m_rectDragging.x, this.m_rectDragging.y, this.m_rectDragging.width, this.m_rectDragging.height);
        ((Column)this.m_arrColumns.elementAt((int)this.m_nDraggingCurrent)).m_nCX = Math.max(x - this.m_nDraggingBegin, 20);
        g = this.getGraphics();
        Rectangle m_rectClip = new Rectangle(this.m_nDraggingBegin, 0, nListWidth - this.m_nDraggingBegin, this.m_cyHeader);
        g.clipRect(m_rectClip.x, m_rectClip.y, m_rectClip.width, m_rectClip.height);
        this.update(g);
    }

    protected boolean mouseUp(MouseEvent e, int x, int y) {
        if (this.m_bDragModeEnabled) {
            this.m_bEditModeEnabled = false;
            Graphics g = this.getGraphics();
            if (this.m_bDragDropDrawn) {
                this.printDragItem(g);
            }
            this.m_bDragModeEnabled = false;
            this.m_bDragDropDrawn = false;
            this.m_dropTargetItem = this.getTarget(x, y);
            this.onDropAction();
            this.processActionEvent(new ActionEvent(this, 3001, commandDragDrop));
        }
        if (!this.m_bHasFocus) {
            this.requestFocus();
        }
        if (this.m_nDraggingState == 1) {
            this.onEndTracking(this.m_nDraggingCurrent, x);
            this.m_bDragModeEnabled = false;
            this.m_bEditModeEnabled = false;
            this.m_bDragDropDrawn = false;
            this.m_bMouseDrag = false;
            return true;
        }
        if (this.m_bEditModeEnabled) {
            this.editItem();
            this.m_bDragModeEnabled = false;
            this.m_bMouseDrag = false;
        }
        if (this.m_bSelectedItemChanged) {
            this.processItemEvent(new ItemEvent(this, 701, this.getSelectedListItem(), 1));
        }
        this.m_bDragModeEnabled = false;
        this.m_bEditModeEnabled = false;
        this.m_nOldTargetIndex = -1;
        this.m_bMouseDrag = false;
        return true;
    }

    protected int getTarget(int x, int y) {
        return this.getSelected(x, y);
    }

    protected void onDropAction() {
    }

    protected void editItem() {
        this.m_bEditModeEnabled = false;
        this.m_bDragModeEnabled = false;
        Rectangle bounds = this.getBounds();
        this.m_itemCurrentEdit = this.getSelectedListItem();
        ListItem item = (ListItem)this.m_arrItems.elementAt(this.selected[this.selected.length - 1]);
        this.m_nColumnEdit = 0;
        int totalWidth = 0;
        if (this.m_nXMouse < ((Column)this.m_arrColumns.elementAt(0)).getWidth() - this.m_ptViewportOrg.x) {
            this.m_textEditNode.setText(this.m_itemCurrentEdit.getText());
        } else {
            int i;
            totalWidth = ((Column)this.m_arrColumns.elementAt(0)).getWidth() - this.m_ptViewportOrg.x;
            for (i = 1; i < this.m_arrColumns.size() && this.m_nXMouse >= (totalWidth += ((Column)this.m_arrColumns.elementAt(i)).getWidth()); ++i) {
            }
            this.m_nColumnEdit = i;
            this.m_textEditNode.setText(this.m_itemCurrentEdit.getSubItem(i).getText());
            totalWidth -= ((Column)this.m_arrColumns.elementAt(i)).getWidth();
        }
        this.m_textEditNode.setBorderStyle(3);
        this.m_textEditNode.setTextHIndent(1);
        this.m_textEditNode.setTextVIndent(2);
        this.m_textEditNode.selectAll();
        this.m_textEditNode.setBorderColor(Color.black);
        Font font = this.m_itemCurrentEdit.getFont();
        if (font == null) {
            font = defaultfont;
        }
        this.m_textEditNode.setFont(font);
        if (this.m_nColumnEdit == 0) {
            this.m_itemCurrentEdit.setText("");
        } else {
            this.m_itemCurrentEdit.getSubItem(this.m_nColumnEdit).setText("");
        }
        this.deselectAll();
        this.m_textEditNode.selectAll();
        this.m_textEditNode.setVisible(true);
        this.m_textEditNode.requestFocus();
        int temp = item.getImageBounds().width;
        if (temp != 0) {
            temp += this.m_nWidthGap;
        }
        if (this.m_bOverlapEdit) {
            this.m_textEditNode.setFixedWidth(0);
        } else {
            int nWidth = 0;
            nWidth = this.m_nColumnEdit == 0 ? ((Column)this.m_arrColumns.elementAt((int)this.m_nColumnEdit)).m_nCX - this.m_nWidthGap * 2 - item.getImageBounds().width : ((Column)this.m_arrColumns.elementAt((int)this.m_nColumnEdit)).m_nCX - this.m_nWidthGap * 2;
            this.m_textEditNode.setFixedWidth(nWidth);
        }
        if (this.m_nColumnEdit == 0) {
            this.m_textEditNode.setBounds(item.getTextBounds().x + this.m_nWidthGap - this.m_ptViewportOrg.x + temp, item.getTextBounds().y - bounds.y, item.getTextBounds().width, item.getTextBounds().height + this.m_nRowSpace + 1);
        } else {
            this.m_textEditNode.setBounds(this.m_nWidthGap + totalWidth, item.getTextBounds().y - bounds.y, item.getTextBounds().width, item.getTextBounds().height + this.m_nRowSpace + 1);
        }
        this.m_textEditNode.update();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.m_textEditNode && e.getActionCommand().equals(Text.endEditing)) {
            this.changeItemText();
        }
    }

    protected void processFocusEvent(FocusEvent e) {
        switch (e.getID()) {
            case 1004: {
                this.m_bHasFocus = true;
                this.update();
                break;
            }
            case 1005: {
                this.m_bHasFocus = false;
                this.update();
            }
        }
        super.processFocusEvent(e);
    }

    protected void onTopRowChanged(int nRow) {
        if (this.m_textEditNode != null && this.m_textEditNode.isShowing()) {
            this.changeItemText();
        }
        if (this.m_nTopRow != nRow) {
            this.m_nTopRow = nRow;
            this.update();
            this.processActionEvent(new ActionEvent(this, 1001, this.commandTopRowChanged));
        }
    }

    protected void onLeftColChanged(int nCol) {
        if (this.m_textEditNode != null && this.m_textEditNode.isShowing()) {
            this.changeItemText();
        }
        if (this.m_ptViewportOrg.x != nCol) {
            this.m_ptViewportOrg.x = nCol;
            this.update();
            this.processActionEvent(new ActionEvent(this, 1001, this.commandLeftColChanged));
        }
    }

    protected void changeItemText() {
        if (this.m_nColumnEdit == 0) {
            this.m_itemCurrentEdit.setText(this.m_textEditNode.getText());
        } else {
            this.m_itemCurrentEdit.getSubItem(this.m_nColumnEdit).setText(this.m_textEditNode.getText());
        }
        this.m_textEditNode.stop();
        this.m_textEditNode.setVisible(false);
        this.reMeasureAllItems();
        this.update();
    }

    public ListItem getSelectedListItem() {
        if (this.selected.length > 0 && this.selected[this.selected.length - 1] < this.m_arrItems.size()) {
            return (ListItem)this.m_arrItems.elementAt(this.selected[this.selected.length - 1]);
        }
        return null;
    }

    public String getSelectedItem() {
        if (this.selected.length > 0 && this.selected[this.selected.length - 1] < this.m_arrItems.size()) {
            ListItem item = (ListItem)this.m_arrItems.elementAt(this.selected[this.selected.length - 1]);
            return item.getText();
        }
        return null;
    }

    protected void onEndTracking(int nCol, int x) {
        this.m_nDraggingState = 0;
        this.setCursor(Cursor.getPredefinedCursor(0));
        ((Column)this.m_arrColumns.elementAt((int)nCol)).m_nCX = Math.max(x - this.m_nDraggingBegin, 20);
        if (this.getMaxTopRow() == 0) {
            this.m_nTopRow = 0;
        }
        if (this.getMaxLeftCol() == 0) {
            this.m_nLeftCol = 0;
        }
        this.reMeasureAllItems();
        this.update();
    }

    protected boolean mouseDown(MouseEvent e, int x, int y) {
        this.m_bSelectedItemChanged = false;
        if (this.m_bDragModeAllowed) {
            this.m_bDragModeEnabled = true;
        }
        this.m_bEditModeEnabled = false;
        this.m_nXMouse = x;
        this.m_nYMouse = y;
        if (this.m_nDraggingState == 0) {
            this.requestFocus();
        }
        if (e.isShiftDown()) {
            this.m_bDragModeEnabled = false;
            this.m_bEditModeEnabled = false;
            this.selected = new int[0];
            int index = this.getSelected(x, y);
            if (!this.m_bMultipleSelections) {
                if (index != -1) {
                    this.prev = index;
                    this.select(index, true);
                    this.m_bSelectedItemChanged = true;
                }
                return true;
            }
            if (index != -1) {
                int l;
                int f = index > this.prev ? this.prev : index;
                int n = l = index > this.prev ? index : this.prev;
                if (f == -1) {
                    f = index;
                }
                this.prev = index;
                for (int i = f; i <= l; ++i) {
                    this.select(i, false);
                }
                this.update();
                this.m_bSelectedItemChanged = true;
            }
            return true;
        }
        if (e.isControlDown()) {
            this.m_bEditModeEnabled = false;
            this.m_bDragModeEnabled = false;
            int index = this.getSelected(x, y);
            if (!this.m_bMultipleSelections) {
                if (index != -1) {
                    this.prev = index;
                    this.select(index, true);
                    this.m_bSelectedItemChanged = true;
                }
                return true;
            }
            if (this.isSelected(index)) {
                this.deselect(index);
                this.update();
                this.m_bSelectedItemChanged = true;
                this.m_bEditModeEnabled = false;
                return true;
            }
            if (index != -1) {
                this.prev = index;
                this.select(index, true);
                this.m_bSelectedItemChanged = true;
            }
            return true;
        }
        this.m_bEditModeEnabled = false;
        int index = this.getSelected(x, y);
        boolean bSelected = this.isSelected(index);
        this.deselectAll(false);
        if (this.m_nDraggingState == 0) {
            if (index == -1) {
                this.m_bDragModeEnabled = false;
            }
            if (index != -1) {
                if (bSelected) {
                    this.select(index, true);
                    if (!this.isRoot(index) && this.m_bEditModeAllowed) {
                        this.m_bEditModeEnabled = true;
                    }
                    this.m_nXMouse = x;
                    this.m_nYMouse = y;
                    Graphics g = this.getGraphics();
                    this.m_bDragDropDrawn = false;
                    g.dispose();
                    if (this.m_bDragModeAllowed) {
                        this.m_bDragModeEnabled = true;
                    }
                    if (e.getClickCount() == 2) {
                        if (this.m_bEditModeAllowed) {
                            this.m_bEditModeEnabled = false;
                        }
                        this.m_bDragModeEnabled = false;
                        this.doubleClickEvent(index);
                        this.processActionEvent(new ActionEvent(this, 1001, this.commandDoubleClicked));
                    }
                    if (e.getClickCount() != 2) {
                        this.m_bSelectedItemChanged = true;
                    }
                    return true;
                }
                this.selected = new int[0];
                this.prev = index;
                this.select(index, true);
                if (e.getClickCount() != 2) {
                    this.m_bSelectedItemChanged = true;
                }
                if (e.getClickCount() == 2) {
                    this.doubleClickEvent(index);
                    this.processActionEvent(new ActionEvent(this, 1001, this.commandDoubleClicked));
                }
            }
        }
        return true;
    }

    protected boolean isRoot(int index) {
        return false;
    }

    protected void doubleClickEvent(int itemHit) {
    }

    protected void processKeyEvent(KeyEvent e) {
        super.processKeyEvent(e);
        int key = e.getKeyCode();
        if (e.getID() == 401) {
            switch (key) {
                case 40: {
                    if (this.prev >= this.m_arrItems.size() - 1) break;
                    if (!this.m_bMultipleSelections || !e.isShiftDown()) {
                        this.selected = new int[0];
                    }
                    this.select(++this.prev, false, false);
                    this.scrollToView(this.prev, 1005);
                    this.update();
                    break;
                }
                case 38: {
                    if (this.prev <= 0) break;
                    if (!this.m_bMultipleSelections || !e.isShiftDown()) {
                        this.selected = new int[0];
                    }
                    this.select(--this.prev, false, false);
                    this.scrollToView(this.prev, 1004);
                    this.update();
                    break;
                }
                case 36: 
                case 37: {
                    this.selected = new int[0];
                    this.prev = 0;
                    this.select(this.prev, false, false);
                    this.scrollToView(this.prev, 1006);
                    this.hs.setValue(this.prev);
                    this.onLeftColChanged(this.prev);
                    this.update();
                    break;
                }
                case 35: 
                case 39: {
                    this.selected = new int[0];
                    this.prev = this.m_arrItems.size() - 1;
                    this.select(this.prev, false, false);
                    this.scrollToView(this.prev, 1007);
                    this.hs.setValue(this.prev);
                    this.onLeftColChanged(this.prev);
                    this.update();
                    break;
                }
                case 34: {
                    this.prev = this.m_nTopRow + this.itemsThisPage(this.getGraphics()) - 1;
                    if (this.isSelected(this.prev)) {
                        this.m_nTopRow = this.prev;
                        this.vs.setValue(this.prev);
                        this.onTopRowChanged(this.prev);
                        this.prev = this.m_nTopRow + this.itemsThisPage(this.getGraphics()) - 1;
                    }
                    this.selected = new int[0];
                    this.prev = Math.min(this.prev, this.m_arrItems.size() - 1);
                    this.select(this.prev, false, false);
                    this.update();
                    break;
                }
                case 33: {
                    if (this.isSelected(this.m_nTopRow)) {
                        this.m_nTopRow = Math.max(this.m_nTopRow - this.itemsThisPage(this.getGraphics()), 0);
                        this.vs.setValue(this.m_nTopRow);
                        this.onTopRowChanged(this.m_nTopRow);
                    }
                    this.selected = new int[0];
                    this.prev = this.m_nTopRow;
                    this.select(this.prev, false, false);
                    this.update();
                    break;
                }
                case 127: {
                    if (this.m_bAllowDelete && this.selected.length > 0) {
                        int[] sel = this.getSelectedIndexes();
                        for (int i = sel.length - 1; i >= 0; --i) {
                            if (i != 0) {
                                this.deleteItem(sel[i], false);
                                continue;
                            }
                            this.deleteItem(sel[i], true);
                        }
                    }
                    this.deselectAll();
                    break;
                }
                case 10: {
                    this.processItemEvent(new ItemEvent(this, 701, this.getSelectedListItem(), 1));
                    break;
                }
            }
        }
    }

    protected void processEvent(AWTEvent e) {
        switch (e.getID()) {
            case 501: {
                Point p = ((MouseEvent)e).getPoint();
                this.mouseDown((MouseEvent)e, p.x, p.y);
                break;
            }
            case 503: {
                Point p2 = ((MouseEvent)e).getPoint();
                this.mouseMove((MouseEvent)e, p2.x, p2.y);
                break;
            }
            case 506: {
                Point p3 = ((MouseEvent)e).getPoint();
                this.mouseDrag((MouseEvent)e, p3.x, p3.y);
                break;
            }
            case 502: {
                Point p4 = ((MouseEvent)e).getPoint();
                this.mouseUp((MouseEvent)e, p4.x, p4.y);
                break;
            }
        }
        super.processEvent(e);
    }

    public void scrollToView(int nRow, int nDirection) {
        int nValue;
        int nRowCount = this.m_arrItems.size();
        int nLastVisibleRow = this.getLastVisibleRow();
        Scrollbar scrV = this.getVScrollbar();
        if (nRow < this.m_nTopRow && nDirection == 1004) {
            nValue = nRow;
            if (nValue < scrV.getMinimum()) {
                nValue = scrV.getMinimum();
            }
            scrV.setValue(nValue);
            this.onTopRowChanged(nValue);
        } else if (nDirection == 1004) {
            this.update();
        }
        if (nRow > nLastVisibleRow && nDirection == 1005) {
            nValue = nRow;
            int nItemsThisPage = this.itemsThisPage(this.getGraphics());
            while (nRow > this.getLastVisibleRow()) {
                if ((nValue = nValue - this.itemsThisPage(this.getGraphics()) + 1) >= scrV.getMaximum() - 1) {
                    nValue = scrV.getMaximum() - 1;
                    scrV.setValue(nValue);
                    this.onTopRowChanged(nValue);
                    break;
                }
                nItemsThisPage = this.itemsThisPage(this.getGraphics());
                scrV.setValue(nValue);
                this.m_nTopRow = nValue;
                nValue += nItemsThisPage;
                nLastVisibleRow = this.getLastVisibleRow();
            }
            this.onTopRowChanged(nValue - nItemsThisPage);
        } else if (nDirection == 1005) {
            this.update();
        }
        if (nDirection == 1006) {
            nValue = scrV.getMinimum();
            scrV.setValue(nValue);
            this.onTopRowChanged(nValue);
        }
        if (nDirection == 1007) {
            nValue = this.getMaxTopRow() + 3;
            if (nValue >= scrV.getMaximum() - 1) {
                nValue = scrV.getMaximum() - 1;
            }
            scrV.setValue(++nValue);
            this.onTopRowChanged(nValue);
        }
    }

    public void scrollToView(int nRow) {
        if (!this.getVScrollbar().isShowing()) {
            return;
        }
        int nRowCount = this.m_arrItems.size();
        int nLastVisibleRow = this.getLastVisibleRow();
        Scrollbar scrV = this.getVScrollbar();
        if (nRow < this.m_nTopRow) {
            int nValue = scrV.getValue() - this.m_nTopRow + nRow + 2;
            if (nValue < scrV.getMinimum()) {
                nValue = scrV.getMinimum();
            }
            scrV.setValue(nValue);
            this.onTopRowChanged(nValue);
        } else if (nRow > nLastVisibleRow - 2) {
            int nValue = scrV.getValue() + nRow - nLastVisibleRow + 1;
            if (nValue > scrV.getMaximum() - 1) {
                nValue = scrV.getMaximum() - 1;
            }
            scrV.setValue(nValue);
            this.onTopRowChanged(nValue);
        }
        if (nRow == 0) {
            scrV.setValue(0);
            this.onTopRowChanged(0);
        }
    }

    public int getLastVisibleRow() {
        if (this.itemsThisPage(this.getGraphics()) != 0) {
            return this.m_nTopRow + this.itemsThisPage(this.getGraphics()) - 1;
        }
        return this.m_nTopRow;
    }

    public ListItem getSelected() {
        return this.getItemAt(this.selected[this.selected.length - 1]);
    }

    protected int getSelected(int x1, int y1) {
        int i;
        int xColLeft;
        ListItem pItem = new ListItem();
        Column pCol = new Column();
        Rectangle rcItem = new Rectangle();
        Rectangle rcInside = new Rectangle();
        Rectangle rcClient = new Rectangle();
        int nHitItem = -1;
        int nHitCol = -1;
        rcClient = this.getBounds();
        rcClient.x = 0;
        rcClient.y = 0;
        rcInside = new Rectangle();
        rcInside = this.getInsideRect();
        rcInside.x = 0;
        rcInside.y = this.isHeaderCtrlEnabled() ? this.m_cyHeader : 0;
        int nTopIndex = this.m_nTopRow;
        int xColRight = xColLeft = -this.m_ptViewportOrg.x;
        if (this.m_arrColumns.size() > 1) {
            for (i = 0; i < this.m_arrColumns.size(); ++i) {
                pCol = (Column)this.m_arrColumns.elementAt(i);
                if (x1 < xColLeft || x1 >= (xColRight += pCol.m_nCX)) continue;
                nHitCol = i;
                break;
            }
        } else {
            pCol = (Column)this.m_arrColumns.elementAt(0);
            nHitCol = 0;
        }
        if (y1 <= rcInside.y) {
            if (this.m_nDraggingState == 1) {
                int nCol = this.getColumnHit(x1);
                if (this.onStartTracking(nCol)) {
                    Graphics g = this.getGraphics();
                    g.setColor(Color.red);
                    g.setXORMode(this.getBackground());
                    this.m_rectDragging = new Rectangle(x1, this.m_cyHeader, 1, this.getInsideRect().height);
                    g.fillRect(this.m_rectDragging.x, this.m_rectDragging.y, this.m_rectDragging.width, this.m_rectDragging.height);
                    return -1;
                }
            } else {
                this.onHitColumnHeader(this.getColumnHit(x1));
            }
            Rectangle rcCol = new Rectangle();
            rcCol.y = rcClient.y;
            rcCol.x = -this.m_ptViewportOrg.x;
            rcCol.height = 0;
            rcCol.width = 0;
            int nColCount = this.m_arrColumns.size();
            for (i = 0; i < nColCount; ++i) {
                pCol = (Column)this.m_arrColumns.elementAt(i);
                rcCol.width += pCol.m_nCX;
                if (this.m_arrColumns.size() > 1) {
                    nHitItem = i - 1;
                    break;
                }
                if (rcCol.contains(new Point(x1, y1))) {
                    nHitItem = i - 1;
                    break;
                }
                rcCol.x += rcCol.width;
            }
        } else {
            rcItem.y = rcInside.y - 0 * this.m_nRowSpace;
            rcItem.x = -this.m_ptViewportOrg.x;
            rcItem.width = rcInside.width;
            rcItem.width = this.getLogicalSize().x;
            if (this.m_arrColumns.size() == 1) {
                rcItem.width = this.getLogicalSize().x;
            }
            rcItem.height = 0;
            for (i = nTopIndex; rcItem.y < rcInside.height + rcInside.y && i < this.m_arrItems.size(); ++i) {
                pItem = (ListItem)this.m_arrItems.elementAt(i);
                if (pItem.m_nCY == -1) {
                    pItem.m_nCY = this.measureItem(i, this.getGraphics());
                }
                rcItem.height = pItem.m_nCY + this.m_nRowSpace;
                if (rcItem.contains(new Point(x1, y1))) {
                    nHitItem = i;
                    int iSubItem = pCol.m_iSubItem;
                    if (iSubItem != 0) break;
                    Rectangle rcText = new Rectangle();
                    Rectangle rcIcon = new Rectangle();
                    rcText.y = rcItem.y;
                    rcText.height = rcItem.height + this.m_nRowSpace;
                    rcText.x = xColLeft + pItem.m_rcText.x;
                    rcText.width = pItem.m_rcText.width;
                    rcIcon.y = rcItem.y + rcIcon.y;
                    rcIcon.height = pItem.m_rcIcon.height;
                    rcIcon.x = xColLeft + pItem.m_rcIcon.x;
                    rcIcon.width = pItem.m_rcIcon.width;
                    break;
                }
                rcItem.y += rcItem.height;
            }
        }
        return nHitItem;
    }

    protected boolean onStartTracking(int nCol) {
        return true;
    }

    protected void onHitColumnHeader(int nCol) {
    }

    public synchronized boolean isSelected(int index) {
        int[] sel = this.getSelectedIndexes();
        for (int i = 0; i < sel.length; ++i) {
            if (sel[i] != index) continue;
            return true;
        }
        return false;
    }

    public synchronized void select(int index, boolean bUpdate) {
        this.select(index, bUpdate, false);
    }

    protected synchronized void select(int index, boolean bUpdate, boolean bScroll) {
        if (index < 0 || index >= this.getItemCount()) {
            return;
        }
        for (int i = 0; i < this.selected.length; ++i) {
            if (this.selected[i] != index) continue;
            return;
        }
        if (!this.m_bMultipleSelections) {
            this.selected = new int[1];
            this.selected[0] = index;
            this.prev = index;
        } else {
            int[] newsel = new int[this.selected.length + 1];
            System.arraycopy(this.selected, 0, newsel, 0, this.selected.length);
            newsel[this.selected.length] = index;
            this.selected = newsel;
            this.prev = index;
        }
        if (bScroll) {
            this.scrollToView(index);
        }
        if (bUpdate) {
            this.update();
        }
    }

    public synchronized void select(int index) {
        this.select(index, true, true);
    }

    public synchronized void deselect(int index) {
        for (int i = 0; i < this.selected.length; ++i) {
            if (this.selected[i] != index) continue;
            int[] newsel = new int[this.selected.length - 1];
            System.arraycopy(this.selected, 0, newsel, 0, i);
            System.arraycopy(this.selected, i + 1, newsel, i, this.selected.length - (i + 1));
            this.selected = newsel;
            return;
        }
        this.update();
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public synchronized void setItems(String[] its) {
        for (int i = 0; i < its.length; ++i) {
            this.addItem(its[i]);
        }
    }

    public String[] getItems() {
        int max = this.m_arrItems.size();
        String[] res = new String[max];
        for (int i = 0; i < max; ++i) {
            res[i] = (String)this.m_arrItems.elementAt(i);
        }
        return res;
    }
}

