/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.wireless.taglibs.mail;

import com.sun.portal.wireless.taglibs.base.Util;
import com.sun.portal.wireless.taglibs.mail.IndentParagraph;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.Vector;

public class TTSStrings {
    private final String NAME = this.getClass().getName();

    public Vector formatString(String s, String quoteString) {
        Vector lineVec = this.getLineVector(s, quoteString);
        this.processURLs(lineVec);
        Vector paraVec = this.processQuotedString(lineVec);
        this.processPunctuation(paraVec);
        return paraVec;
    }

    private void processPunctuation(Vector vec) {
        int numLines = vec.size();
        for (int i = 0; i < numLines; ++i) {
            IndentParagraph e = (IndentParagraph)vec.elementAt(i);
            String text = e.getParagraph();
            String newText = this.processPunctuation(text);
            e.setParagraph(newText);
            vec.set(i, e);
        }
    }

    public String processPunctuation(String str) {
        StringReader reader = new StringReader(str.toLowerCase());
        StringWriter writer = new StringWriter();
        try {
            int c;
            while ((c = reader.read()) > -1) {
                if (c == 34) {
                    writer.write("&quot;");
                    continue;
                }
                if (c == 39) {
                    writer.write("&#039;");
                    continue;
                }
                if (c == 38) {
                    writer.write("and");
                    continue;
                }
                if (c == 43) {
                    writer.write("plus");
                    continue;
                }
                if (c == 36) {
                    writer.write("\\$");
                    continue;
                }
                if (c == 92) {
                    writer.write("\\\\");
                    continue;
                }
                if (c == 60 || c == 62) {
                    writer.write(" ");
                    continue;
                }
                writer.write(c);
            }
        }
        catch (IOException e) {
            Util.logError((String)(this.NAME + ".processPunctuation(); error reading: " + e));
        }
        return writer.toString();
    }

    private Vector getLineVector(String str, String quoteStr) {
        StringTokenizer st = new StringTokenizer(str, "\r");
        StringBuffer sBuf = new StringBuffer();
        while (st.hasMoreTokens()) {
            sBuf.append(st.nextToken());
        }
        Vector<Object> lineVec = new Vector<Object>();
        st = new StringTokenizer(sBuf.toString(), "\n", true);
        boolean gotNewLine = false;
        while (st.hasMoreTokens()) {
            String tmpStr = st.nextToken();
            if (tmpStr.equals("\n")) {
                if (gotNewLine) {
                    lineVec.addElement("");
                    continue;
                }
                gotNewLine = true;
                continue;
            }
            gotNewLine = false;
            lineVec.addElement(tmpStr);
        }
        int numLines = lineVec.size();
        int len = quoteStr.length();
        for (int i = 0; i < numLines; ++i) {
            int level = 0;
            String tmpStr = (String)lineVec.elementAt(i);
            while (tmpStr.startsWith(quoteStr)) {
                ++level;
                tmpStr = tmpStr.substring(len);
            }
            IndentParagraph para = new IndentParagraph();
            para.setParagraph(tmpStr);
            para.setQuoteLevel(level);
            lineVec.setElementAt(para, i);
        }
        return lineVec;
    }

    private Vector processQuotedString(Vector lineVec) {
        Vector paraVec = new Vector();
        int numLines = lineVec.size();
        int prevLevel = -1;
        StringBuffer paraBuf = new StringBuffer();
        for (int i = 0; i < numLines; ++i) {
            IndentParagraph line = (IndentParagraph)lineVec.elementAt(i);
            String text = line.getParagraph().trim();
            int level = line.getQuoteLevel();
            if (level != prevLevel || text.equals("")) {
                this.makeParagraph(prevLevel, paraBuf, paraVec);
                paraBuf.setLength(0);
            }
            if (!text.equals("")) {
                paraBuf.append(text).append(" ");
            }
            prevLevel = level;
        }
        this.makeParagraph(prevLevel, paraBuf, paraVec);
        return paraVec;
    }

    private void makeParagraph(int level, StringBuffer text, Vector paraVec) {
        if (text.length() <= 0) {
            return;
        }
        IndentParagraph ePara = new IndentParagraph();
        ePara.setQuoteLevel(level);
        ePara.setParagraph(text.toString());
        paraVec.addElement(ePara);
    }

    private void processURLs(Vector vec) {
        for (int i = 0; i < vec.size(); ++i) {
            IndentParagraph linePara = (IndentParagraph)vec.elementAt(i);
            String str = linePara.getParagraph();
            String tmpStr = str.toLowerCase();
            int beg = tmpStr.indexOf("http://");
            if (beg < 0) continue;
            Vector urlVec = this.getURLPieces(linePara);
            vec.removeElementAt(i);
            vec.addAll(i, urlVec);
        }
    }

    private Vector getURLPieces(IndentParagraph para) {
        IndentParagraph ePara;
        Vector<IndentParagraph> newVec = new Vector<IndentParagraph>();
        int beg = 0;
        int end = 0;
        int last = 0;
        String str = para.getParagraph();
        String tmpStr = str.toLowerCase();
        int level = para.getQuoteLevel();
        while ((beg = tmpStr.indexOf("http://", end)) >= 0) {
            if (beg > 0) {
                ePara = new IndentParagraph();
                ePara.setParagraph(str.substring(last, beg));
                ePara.setQuoteLevel(level);
                newVec.addElement(ePara);
            }
            ePara = new IndentParagraph();
            ePara.setQuoteLevel(level);
            ePara.setParagraph("");
            newVec.addElement(ePara);
            int end1 = tmpStr.indexOf(" ", beg);
            int end2 = tmpStr.indexOf("\n", beg);
            if (end1 < 0) {
                end1 = tmpStr.length();
            }
            if (end2 < 0) {
                end2 = tmpStr.length();
            }
            end = end1 < end2 ? end1 : end2;
            String urlStr = tmpStr.substring(beg, end);
            String hostname = "unknown location";
            try {
                URL tmpURL = new URL(urlStr);
                String host = tmpURL.getHost();
                hostname = "";
                StringTokenizer st = new StringTokenizer(host, ".", true);
                while (st.hasMoreTokens()) {
                    String tmp = st.nextToken();
                    if (tmp.equals(".")) {
                        hostname = hostname + " dot ";
                        continue;
                    }
                    hostname = hostname + tmp;
                }
            }
            catch (Exception e) {
                Util.logError((String)(this.NAME + ".getURLPieces(): " + e));
            }
            String tmp = " an h.t.t.p. link to " + hostname;
            last = end;
            ePara = new IndentParagraph();
            ePara.setQuoteLevel(level);
            ePara.setParagraph(tmp);
            newVec.addElement(ePara);
            ePara = new IndentParagraph();
            ePara.setQuoteLevel(level);
            ePara.setParagraph("");
            newVec.addElement(ePara);
        }
        if (last > 0 && last < str.length()) {
            ePara = new IndentParagraph();
            ePara.setQuoteLevel(level);
            ePara.setParagraph(str.substring(last, str.length()));
            newVec.addElement(ePara);
        }
        return newVec;
    }
}

