/*
 * Decompiled with CFR 0.152.
 */
package com.sun.addressbook.wabp;

import com.iplanet.xslui.xslutil.XMLDOMBuilder;
import com.iplanet.xslui.xslutil.XMLProcessingException;
import com.iplanet.xslui.xslutil.XPathTools;
import com.iplanet.xslui.xslutil.XSLProcessingException;
import com.sun.addressbook.ABStoreException;
import com.sun.addressbook.Element;
import com.sun.addressbook.Entry;
import com.sun.addressbook.Group;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class WabpXmlUtil {
    private Entry abEntry = null;
    private Element abElement = null;

    public WabpXmlUtil(Entry entry) {
        this.abEntry = entry;
        this.abElement = entry;
    }

    public WabpXmlUtil(Group group) {
        this.abElement = group;
    }

    public StringBuffer getAbPersonXml() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getWabpXmlStart());
        buf.append(this.getWabpXmlAbPersonStart());
        buf.append(this.getWabpXmlMemberOfGroup());
        buf.append(this.getWabpXmlEntryElement());
        buf.append(this.getWabpXmlPersonElement());
        buf.append(this.getWabpXmlPhone());
        buf.append(this.getWabpXmlEmail());
        buf.append(this.getWabpXmlPostalAddressElement("home"));
        buf.append(this.getWabpXmlPostalAddressElement("work"));
        buf.append(this.getWabpXmlUriElement());
        buf.append(this.getWabpXmlAbPersonEnd());
        return buf;
    }

    public StringBuffer getGroupXml() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getWabpXmlStart());
        buf.append(this.getWabpXmlGroupStart());
        buf.append(this.getWabpXmlEntryElement());
        buf.append(this.getWabpXmlGroupEnd());
        return buf;
    }

    public String getWabpXmlStart() {
        return new String("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
    }

    public String getWabpXmlAbPersonStart() {
        return new String("<abperson>\n");
    }

    public String getWabpXmlAbPersonEnd() {
        return new String("</abperson>\n");
    }

    public String getWabpXmlEntryStart() {
        return new String("<entry>\n");
    }

    public String getWabpXmlEntryEnd() {
        return new String("</entry>\n");
    }

    public String getWabpXmlPersonStart() {
        return new String("<person>\n");
    }

    public String getWabpXmlPersonEnd() {
        return new String("</person>\n");
    }

    public String getWabpXmlGroupStart() {
        return new String("<group>\n");
    }

    public String getWabpXmlGroupEnd() {
        return new String("</group>\n");
    }

    public String getWabpXmlMemberOfGroup() {
        StringBuffer buf = new StringBuffer();
        String val = this.abEntry.getMemberofpabgroup();
        if (val != null) {
            buf.append("<memberofgroup>");
            buf.append(val);
            buf.append("</memberofgroup>");
            buf.append("\n");
        }
        return buf.toString();
    }

    public String getWabpXmlEntryElement() {
        StringBuffer buf = new StringBuffer();
        String cn = this.getWabpXmlDisplayName();
        String desc = this.getWabpXmlDescription();
        if (cn.length() > 0 || desc.length() > 0) {
            buf.append(this.getWabpXmlEntryStart());
            buf.append(cn);
            buf.append(desc);
            buf.append(this.getWabpXmlEntryEnd());
        }
        return buf.toString();
    }

    public String getWabpXmlPersonElement() {
        StringBuffer buf = new StringBuffer();
        String fn = this.getWabpXmlGivenName();
        String ln = this.getWabpXmlSurName();
        String dob = this.getWabpXmlDateBirthday();
        if (fn.length() > 0 || ln.length() > 0 || dob.length() > 0) {
            buf.append(this.getWabpXmlPersonStart());
            buf.append(fn);
            buf.append(ln);
            buf.append(dob);
            buf.append(this.getWabpXmlPersonEnd());
        }
        return buf.toString();
    }

    public String getWabpXmlDisplayName() {
        StringBuffer buf = new StringBuffer();
        String val = this.abElement.getCn();
        if (val != null) {
            buf.append("<displayname>");
            buf.append(val);
            buf.append("</displayname>");
            buf.append("\n");
        }
        return buf.toString();
    }

    public String getWabpXmlDescription() {
        StringBuffer buf = new StringBuffer();
        String val = this.abElement.getDescription();
        if (val != null) {
            buf.append("<description>");
            buf.append(val);
            buf.append("</description>");
            buf.append("\n");
        }
        return buf.toString();
    }

    public String getWabpXmlGivenName() {
        StringBuffer buf = new StringBuffer();
        String val = this.abEntry.getFn();
        if (val != null) {
            buf.append("<givenname>");
            buf.append(val);
            buf.append("</givenname>");
            buf.append("\n");
        }
        return buf.toString();
    }

    public String getWabpXmlSurName() {
        StringBuffer buf = new StringBuffer();
        String val = this.abEntry.getLn();
        if (val != null) {
            buf.append("<surname>");
            buf.append(val);
            buf.append("</surname>");
            buf.append("\n");
        }
        return buf.toString();
    }

    public String getWabpXmlDateBirthday() {
        StringBuffer buf = new StringBuffer();
        String val = this.abEntry.getDob();
        if (val != null) {
            buf.append("<date type=\"birthday\">");
            buf.append(val);
            buf.append("</date>");
            buf.append("\n");
        }
        return buf.toString();
    }

    public String getWabpXmlPhone() {
        StringBuffer buf = new StringBuffer();
        String bp = this.abEntry.getBp();
        String hp = this.abEntry.getHp();
        String mp = this.abEntry.getMp();
        String fp = this.abEntry.getFp();
        String pp = this.abEntry.getPp();
        int priority = 1;
        if (bp != null) {
            buf.append("<phone priority=\"");
            buf.append(priority);
            buf.append("\" type=\"work\">");
            buf.append(bp);
            buf.append("</phone>");
            buf.append("\n");
            ++priority;
        }
        if (hp != null) {
            buf.append("<phone priority=\"");
            buf.append(priority);
            buf.append("\" type=\"home\">");
            buf.append(hp);
            buf.append("</phone>");
            buf.append("\n");
            ++priority;
        }
        if (mp != null) {
            buf.append("<phone priority=\"");
            buf.append(priority);
            buf.append("\" type=\"mobile\">");
            buf.append(mp);
            buf.append("</phone>");
            buf.append("\n");
            ++priority;
        }
        if (pp != null) {
            buf.append("<phone priority=\"");
            buf.append(priority);
            buf.append("\" type=\"pager\">");
            buf.append(pp);
            buf.append("</phone>");
            buf.append("\n");
            ++priority;
        }
        if (fp != null) {
            buf.append("<phone priority=\"");
            buf.append(priority);
            buf.append("\" type=\"fax\">");
            buf.append(fp);
            buf.append("</phone>");
            buf.append("\n");
            ++priority;
        }
        return buf.toString();
    }

    public String getWabpXmlEmail() {
        StringBuffer buf = new StringBuffer();
        String em = this.abEntry.getEm();
        String sms = this.abEntry.getSmsId();
        if (em != null) {
            buf.append("<email priority=\"1\" type=\"work\">");
            buf.append(em);
            buf.append("</email>");
            buf.append("\n");
        }
        if (sms != null) {
            buf.append("<email priority=\"2\" type=\"sms\">");
            buf.append(sms);
            buf.append("</email>");
            buf.append("\n");
        }
        return buf.toString();
    }

    public String getWabpXmlPostalAddressElement(String type) {
        StringBuffer buf = new StringBuffer();
        String street = null;
        String city = null;
        String state = null;
        String zip = null;
        String country = null;
        if (type != null && type.equals("home")) {
            street = this.abEntry.getHomeStreet();
            city = this.abEntry.getHomeCity();
            state = this.abEntry.getHomeState();
            zip = this.abEntry.getHomeZip();
            country = this.abEntry.getHomeCountry();
        } else {
            street = this.abEntry.getBusinessStreet();
            city = this.abEntry.getBusinessCity();
            state = this.abEntry.getBusinessState();
            zip = this.abEntry.getBusinessZip();
            country = this.abEntry.getBusinessCountry();
        }
        if (street != null || city != null || state != null || zip != null || country != null) {
            buf.append("<postaladdress type=\"");
            buf.append(type);
            buf.append("\">\n");
            if (street != null) {
                buf.append("<street>");
                buf.append(street);
                buf.append("</street>");
                buf.append("\n");
            }
            if (city != null) {
                buf.append("<city>");
                buf.append(city);
                buf.append("</city>");
                buf.append("\n");
            }
            if (zip != null) {
                buf.append("<postalcode>");
                buf.append(zip);
                buf.append("</postalcode>");
                buf.append("\n");
            }
            if (state != null) {
                buf.append("<state>");
                buf.append(state);
                buf.append("</state>");
                buf.append("\n");
            }
            if (country != null) {
                buf.append("<country>");
                buf.append(country);
                buf.append("</country>");
                buf.append("\n");
            }
            buf.append("</postaladdress>\n");
        }
        return buf.toString();
    }

    public String getWabpXmlUriElement() {
        StringBuffer buf = new StringBuffer();
        String val = this.abEntry.getUri();
        if (val != null) {
            buf.append("<weburl priority=\"1\">\n");
            buf.append("<urladdr>");
            buf.append(val);
            buf.append("</urladdr>");
            buf.append("\n");
            buf.append("</weburl>\n");
        }
        return buf.toString();
    }

    public static org.w3c.dom.Element getElementFromWabpXml(StringBuffer xml, String type) throws ABStoreException {
        org.w3c.dom.Element element = null;
        XMLDOMBuilder builder = null;
        Document document = null;
        try {
            builder = new XMLDOMBuilder();
            document = builder.newDocument();
            document = builder.parse((InputStream)new ByteArrayInputStream(xml.toString().getBytes()), false);
            element = (org.w3c.dom.Element)XPathTools.getFirstNodeByXPath((Node)document, (String)type);
        }
        catch (XMLProcessingException xme) {
            throw new ABStoreException("WabpAddressBook: failed to parse wabp xml document. " + (Object)((Object)xme));
        }
        catch (XSLProcessingException xse) {
            throw new ABStoreException("WabpAddressBook: could not find element " + type + "in wabp xml document. " + (Object)((Object)xse));
        }
        return element;
    }
}

