/*
 * Decompiled with CFR 0.152.
 */
package com.sun.addressbook.wabp;

import com.iplanet.iabs.iabsapi.PStoreException;
import com.iplanet.xslui.xslutil.XPathTools;
import com.iplanet.xslui.xslutil.XSLProcessingException;
import com.sun.addressbook.ABDebug;
import com.sun.addressbook.ABFilter;
import com.sun.addressbook.ABSearchTerm;
import com.sun.addressbook.ABStore;
import com.sun.addressbook.ABStoreException;
import com.sun.addressbook.AddressBook;
import com.sun.addressbook.Element;
import com.sun.addressbook.Entry;
import com.sun.addressbook.Group;
import com.sun.addressbook.OperationNotSupportedException;
import com.sun.addressbook.wabp.WabpABConstants;
import com.sun.addressbook.wabp.WabpABSearchTerm;
import com.sun.addressbook.wabp.WabpABStore;
import com.sun.addressbook.wabp.WabpXmlUtil;
import java.util.ArrayList;
import java.util.Iterator;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class WabpAddressBook
extends AddressBook
implements WabpABConstants {
    protected WabpABStore abStore = null;
    protected String abStoreUser = null;

    public WabpAddressBook(ABStore store, String abID) {
        super(store, abID);
        this.abStore = (WabpABStore)store;
        this.abStoreUser = this.abStore.getStoreUser();
    }

    public Element[] fetch(ABFilter abFilter) throws ABStoreException, OperationNotSupportedException {
        org.w3c.dom.Element element = null;
        ArrayList fetchedElements = null;
        String filter = (String)abFilter.getSearchFilter();
        String sortBy = this.getWabpSearchEntrySort(abFilter);
        String[] types = this.getWabpSearchEntryType(abFilter);
        String[] returnAttrs = null;
        String filterInGroup = null;
        if (abFilter.getGroup() != null) {
            filterInGroup = "&(memberofgroup=" + abFilter.getGroup().getUn() + ")";
            filter = filterInGroup + filter;
            ABDebug.logMessage("WabpABSearchTerm: modified filter = " + filter);
        }
        try {
            element = this.abStore.getWABPClientPStore().search(this.getAbID(), filter, returnAttrs, types, sortBy);
            fetchedElements = this.convertNodeToElements(element, abFilter);
        }
        catch (XSLProcessingException xpe) {
            throw new ABStoreException("WabpAddressBook: xml fetch failed. " + (Object)((Object)xpe));
        }
        catch (Exception e) {
            throw new ABStoreException("WabpAddressBook: fetch failed. " + e);
        }
        return fetchedElements.toArray(new Element[fetchedElements.size()]);
    }

    public void add(Element element) throws ABStoreException, OperationNotSupportedException {
        String[] bookEntryIDs = new String[]{this.abID};
        WabpXmlUtil xmlutil = null;
        StringBuffer buf = null;
        String type = null;
        String id = null;
        String cn = element.getCn();
        if (element.getElementType() == 2) {
            xmlutil = new WabpXmlUtil((Group)element);
            buf = xmlutil.getGroupXml();
            type = "group";
        } else {
            if (cn == null) {
                String fn = ((Entry)element).getFn();
                String ln = ((Entry)element).getLn();
                element.setCn(this.getFormattedCn(fn, ln));
            }
            xmlutil = new WabpXmlUtil((Entry)element);
            buf = xmlutil.getAbPersonXml();
            type = "abperson";
        }
        ABDebug.logMessage("WabpAddressBook: " + this.abStoreUser + " address book " + bookEntryIDs[0] + " add element: \n" + buf.toString());
        id = this.wabpAddEntry(bookEntryIDs, buf, type);
        if (id != null) {
            ABDebug.logMessage("WabpAddressBook: " + this.abStoreUser + " added entry id " + id);
        }
    }

    public void addGroupMember(Element element, Group group) throws ABStoreException, OperationNotSupportedException {
        String groupUn = group.getUn();
        String elementUn = element.getUn();
        if (groupUn == null) {
            throw new ABStoreException("WabpAddressBook: could not add group member because group unique name is not defined.");
        }
        if (elementUn == null) {
            throw new ABStoreException("WabpAddressBook: could not add group member because element unique name is not defined.");
        }
        try {
            if (element.getElementType() == 2) {
                ABFilter gfilter = new ABFilter();
                gfilter.setSortBy("cn");
                gfilter.setSortOrder(1);
                Element[] elements = this.fetchGroupMembers(gfilter, (Group)element);
                ArrayList<String> memberList = new ArrayList<String>(elements.length);
                for (int i = 0; i < elements.length; ++i) {
                    Element member = elements[i];
                    if (member == null) continue;
                    memberList.add(member.getUn());
                }
                String[] mlist = memberList.toArray(new String[0]);
                this.abStore.getWABPClientPStore().addGroupMember(this.abID, groupUn, mlist);
                ABDebug.logMessage("WabpAddressBook: " + this.abStoreUser + " added group member " + memberList + " to group " + groupUn);
            } else {
                this.abStore.getWABPClientPStore().addGroupMember(this.abID, groupUn, new String[]{elementUn});
                ABDebug.logMessage("WabpAddressBook: " + this.abStoreUser + " added group member " + elementUn + " to group " + groupUn);
            }
        }
        catch (PStoreException pse) {
            throw new ABStoreException("WabpAddressBook: failed to add group member. " + (Object)((Object)pse));
        }
    }

    public void delete(Element element) throws ABStoreException, OperationNotSupportedException {
        String un = element.getUn();
        if (un == null) {
            throw new ABStoreException("WabpAddressBook: could not delete element because unique name is not defined.");
        }
        try {
            this.abStore.getWABPClientPStore().deleteEntry(this.abID, un);
        }
        catch (PStoreException pse) {
            throw new ABStoreException("WabpAddressBook: delete failed. " + (Object)((Object)pse));
        }
        ABDebug.logMessage("WabpAddressBook: " + this.abStoreUser + " deleted element id " + un);
    }

    public void deleteGroupMember(Element element, Group group) throws ABStoreException, OperationNotSupportedException {
        String groupUn = group.getUn();
        String elementUn = element.getUn();
        if (groupUn == null) {
            throw new ABStoreException("WabpAddressBook: could not delete group member because group unique name is not defined.");
        }
        if (elementUn == null) {
            throw new ABStoreException("WabpAddressBook: could not delete group member because element unique name is not defined.");
        }
        try {
            this.abStore.getWABPClientPStore().removeGroupMember(this.abID, groupUn, new String[]{elementUn});
        }
        catch (PStoreException pse) {
            throw new ABStoreException("WabpAddressBook: delete group member failed. " + (Object)((Object)pse));
        }
        ABDebug.logMessage("WabpAddressBook: " + this.abStoreUser + " deleted group member " + elementUn);
    }

    public Element[] fetchGroupMembers(ABFilter filter, Group group) throws ABStoreException, OperationNotSupportedException {
        String un = group.getUn();
        if (un == null) {
            throw new ABStoreException("WabpAddressBook: could not fetch group members because the group's unique name is not defined.");
        }
        ABDebug.logMessage("WabpAddressBook: " + this.abStoreUser + " fetching group members.");
        filter.setSearchTerm(this.newABSearchTerm("memberofgroup", un, true));
        filter.setGroup(group);
        Element[] elements = this.fetch(filter);
        filter.setGroup(null);
        return elements;
    }

    public void modify(Element oldElement, Element newElement) throws ABStoreException, OperationNotSupportedException {
        WabpXmlUtil xmlutil = null;
        StringBuffer buf = null;
        String type = null;
        String un = oldElement.getUn();
        if (newElement.getElementType() == 2) {
            xmlutil = new WabpXmlUtil((Group)newElement);
            buf = xmlutil.getGroupXml();
            type = "group";
        } else {
            xmlutil = new WabpXmlUtil((Entry)newElement);
            buf = xmlutil.getAbPersonXml();
            type = "abperson";
        }
        ABDebug.logMessage("WabpAddressBook: " + this.abStoreUser + " modify wabp xml. " + buf.toString());
        this.wabpModifyEntry(un, buf, type);
    }

    public ABSearchTerm newABSearchTerm(String name, String value, boolean exact) {
        return new WabpABSearchTerm(name, value, exact);
    }

    public ABSearchTerm newABSearchTerm(ABSearchTerm term, int op) throws ABStoreException {
        return new WabpABSearchTerm(term, op);
    }

    public ABSearchTerm newABSearchTerm(ABSearchTerm[] terms, int op) throws ABStoreException {
        return new WabpABSearchTerm(terms, op);
    }

    protected String wabpAddEntry(String[] bookEntryIDs, StringBuffer xml, String type) throws ABStoreException {
        String id = null;
        try {
            org.w3c.dom.Element element = WabpXmlUtil.getElementFromWabpXml(xml, type);
            id = this.abStore.getWABPClientPStore().addEntry(bookEntryIDs, element);
        }
        catch (PStoreException pse) {
            throw new ABStoreException("WabpAddressBook: add failed. " + (Object)((Object)pse));
        }
        return id;
    }

    public void wabpModifyEntry(String un, StringBuffer xml, String type) throws ABStoreException {
        try {
            org.w3c.dom.Element element = WabpXmlUtil.getElementFromWabpXml(xml, type);
            this.abStore.getWABPClientPStore().modifyEntry(this.abID, un, element);
        }
        catch (PStoreException pse) {
            throw new ABStoreException("WabpAddressBook: modify failed. " + (Object)((Object)pse));
        }
    }

    protected ArrayList convertNodeToElements(Node node, ABFilter abFilter) throws XSLProcessingException {
        ArrayList<Group> convertedElements = new ArrayList<Group>();
        ArrayList nodeList = null;
        int index = 0;
        nodeList = abFilter.getElementType() == 1 ? XPathTools.getNodesByXPath((Node)node, (String)"abperson") : (abFilter.getElementType() == 2 ? XPathTools.getNodesByXPath((Node)node, (String)"group") : XPathTools.getNodesByXPath((Node)node, (String)"*"));
        Iterator it = nodeList.iterator();
        while (it.hasNext()) {
            Node abNode = (Node)it.next();
            if (abNode != null) {
                String abType = abNode.getNodeName();
                Element element = null;
                element = abType.equals("group") ? this.convertNodeToGroup(abNode, index) : this.convertNodeToEntry(abNode, index);
                convertedElements.add((Group)element);
            }
            ++index;
        }
        return convertedElements;
    }

    protected Entry convertNodeToEntry(Node node, int index) throws XSLProcessingException {
        Entry entry = null;
        String un = null;
        String fn = null;
        String ln = null;
        String cn = null;
        String em = null;
        String description = null;
        String bp = null;
        String hp = null;
        String mp = null;
        String homeStreet = null;
        String homeCity = null;
        String homeState = null;
        String homeZip = null;
        String homeCountry = null;
        String workStreet = null;
        String workCity = null;
        String workState = null;
        String workZip = null;
        String workCountry = null;
        String fp = null;
        String pp = null;
        String dob = null;
        String uri = null;
        String memberofpab = null;
        String memberofpabgroup = null;
        String smsId = null;
        String entryid = Integer.toString(index);
        Node entryNode = XPathTools.getFirstNodeByXPath((Node)node, (String)"entry");
        NamedNodeMap entryMap = entryNode.getAttributes();
        Node entryIDNode = entryMap.getNamedItem("entryID");
        un = entryIDNode.getNodeValue();
        cn = XPathTools.getValueByXPath((Node)node, (String)"entry/displayname");
        description = XPathTools.getValueByXPath((Node)node, (String)"entry/description");
        fn = XPathTools.getValueByXPath((Node)node, (String)"person/givenname");
        ln = XPathTools.getValueByXPath((Node)node, (String)"person/surname");
        dob = XPathTools.getValueByXPath((Node)node, (String)"person/date[@type='birthday']");
        em = XPathTools.getValueByXPath((Node)node, (String)"email[@priority='1']");
        smsId = XPathTools.getValueByXPath((Node)node, (String)"email[@type='sms']");
        bp = XPathTools.getValueByXPath((Node)node, (String)"phone[@type='work']");
        hp = XPathTools.getValueByXPath((Node)node, (String)"phone[@type='home']");
        mp = XPathTools.getValueByXPath((Node)node, (String)"phone[@type='mobile']");
        fp = XPathTools.getValueByXPath((Node)node, (String)"phone[@type='fax']");
        pp = XPathTools.getValueByXPath((Node)node, (String)"phone[@type='pager']");
        homeStreet = XPathTools.getValueByXPath((Node)node, (String)"postaladdress[@type='home']/street");
        homeCity = XPathTools.getValueByXPath((Node)node, (String)"postaladdress[@type='home']/city");
        homeState = XPathTools.getValueByXPath((Node)node, (String)"postaladdress[@type='home']/state");
        homeZip = XPathTools.getValueByXPath((Node)node, (String)"postaladdress[@type='home']/postalcode");
        homeCountry = XPathTools.getValueByXPath((Node)node, (String)"postaladdress[@type='home']/country");
        workStreet = XPathTools.getValueByXPath((Node)node, (String)"postaladdress[@type='work']/street");
        workCity = XPathTools.getValueByXPath((Node)node, (String)"postaladdress[@type='work']/city");
        workState = XPathTools.getValueByXPath((Node)node, (String)"postaladdress[@type='work']/state");
        workZip = XPathTools.getValueByXPath((Node)node, (String)"postaladdress[@type='work']/postalcode");
        workCountry = XPathTools.getValueByXPath((Node)node, (String)"postaladdress[@type='work']/country");
        uri = XPathTools.getValueByXPath((Node)node, (String)"weburl[@priority='1']/urladdr");
        memberofpab = XPathTools.getValueByXPath((Node)node, (String)"memberofbook");
        memberofpabgroup = XPathTools.getValueByXPath((Node)node, (String)"memberofgroup");
        entry = new Entry(un, fn, ln, cn, em, description, bp, hp, mp, homeStreet, homeCity, homeState, homeZip, homeCountry, workStreet, workCity, workState, workZip, workCountry, fp, pp, dob, uri, memberofpab, memberofpabgroup, smsId, entryid);
        StringBuffer buf = new StringBuffer();
        buf.append("\n").append("\t un=").append(un).append("\n").append("\t fn=").append(fn).append("\n").append("\t ln=").append(ln).append("\n").append("\t cn=").append(cn).append("\n").append("\t em=").append(em).append("\n").append("\t description=").append(description).append("\n").append("\t bp=").append(bp).append("\n").append("\t bp=").append(bp).append("\n").append("\t hp=").append(hp).append("\n").append("\t mp=").append(mp).append("\n").append("\t homeStreet=").append(homeStreet).append("\n").append("\t homeState=").append(homeState).append("\n").append("\t homeZip=").append(homeZip).append("\n").append("\t homeCountry=").append(homeCountry).append("\n").append("\t workStreet=").append(workStreet).append("\n").append("\t workCity=").append(workCity).append("\n").append("\t workState=").append(workState).append("\n").append("\t workZip=").append(workZip).append("\n").append("\t workCountry=").append(workCountry).append("\n").append("\t fp=").append(fp).append("\n").append("\t pp=").append(pp).append("\n").append("\t dob=").append(dob).append("\n").append("\t uri=").append(uri).append("\n").append("\t memberofpab=").append(memberofpab).append("\n").append("\t memberofpabgroup=").append(memberofpabgroup).append("\n").append("\t smsId=").append(smsId).append("\n").append("\t entryId=").append(entryid).append("\n");
        ABDebug.logMessage("WabpAddressBook: " + this.abStoreUser + " entry: " + buf.toString());
        entry.setElementType(1);
        return entry;
    }

    public Group convertNodeToGroup(Node node, int index) throws XSLProcessingException {
        Group group = null;
        String un = null;
        String cn = null;
        String description = null;
        String entryid = Integer.toString(index);
        Node entryNode = XPathTools.getFirstNodeByXPath((Node)node, (String)"entry");
        NamedNodeMap entryMap = entryNode.getAttributes();
        Node entryIDNode = entryMap.getNamedItem("entryID");
        un = entryIDNode.getNodeValue();
        cn = XPathTools.getValueByXPath((Node)node, (String)"entry/displayname");
        description = XPathTools.getValueByXPath((Node)node, (String)"entry/description");
        group = new Group(un, cn, description, entryid);
        StringBuffer buf = new StringBuffer();
        buf.append("\n").append("\t un=").append(un).append("\n").append("\t cn=").append(cn).append("\n").append("\t description=").append(description).append("\n").append("\t entryId=").append(entryid).append("\n");
        ABDebug.logMessage("WabpAddressBook: " + this.abStoreUser + " group: " + buf.toString());
        group.setElementType(2);
        return group;
    }

    protected String[] getWabpSearchEntryType(ABFilter filter) {
        String[] types = null;
        types = filter.getElementType() == 1 ? new String[]{"abperson"} : (filter.getElementType() == 2 ? new String[]{"group"} : new String[]{"abperson", "group"});
        return types;
    }

    protected String getWabpSearchEntrySort(ABFilter filter) {
        String sort = "";
        String sortOrder = "";
        String sortBy = filter.getSortBy();
        switch (filter.getSortOrder()) {
            case 1: {
                sortOrder = "";
                break;
            }
            case 2: {
                sortOrder = "-";
                break;
            }
        }
        if (sortBy != null && sortBy.length() > 0) {
            if ((sortBy = sortBy.trim()).equalsIgnoreCase("cn")) {
                sortBy = "entry/displayname";
            } else if (sortBy.equalsIgnoreCase("fn")) {
                sortBy = "person/givenname";
            } else if (sortBy.equalsIgnoreCase("ln")) {
                sortBy = "person/surname";
            }
        } else {
            sortBy = "entry/displayname";
        }
        sort = sortOrder + sortBy;
        return sort;
    }

    public String getFormattedCn(String fn, String ln) {
        String str = " ";
        if (ln != null && fn != null) {
            str = ln + ", " + fn;
        } else if (ln != null && fn == null) {
            str = ln;
        } else if (fn != null && ln == null) {
            str = fn;
        }
        return str;
    }
}

