/*
 * Decompiled with CFR 0.152.
 */
package com.sun.addressbook;

import com.sun.addressbook.ABStore;
import com.sun.addressbook.ABStoreException;
import com.sun.addressbook.MissingPropertiesException;
import java.util.Properties;

public final class ABSession {
    private Properties props = null;
    private ABStore store = null;

    private ABSession(Properties props) {
        this.props = props;
    }

    public static ABSession getInstance(Properties props) throws MissingPropertiesException {
        String host = (String)props.get("ab.host");
        if (host == null) {
            throw new MissingPropertiesException("Missing ab.host Property");
        }
        return new ABSession(props);
    }

    public ABStore getABStore(String service) throws MissingPropertiesException, ABStoreException {
        ABStore store = null;
        try {
            store = (ABStore)Class.forName(service).newInstance();
            store.init(this);
        }
        catch (MissingPropertiesException e) {
            throw new MissingPropertiesException(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ABStoreException(e.getMessage());
        }
        return store;
    }

    public void setProperty(String id, String value) {
        this.props.put(id, value);
    }

    public String getProperty(String id) {
        return (String)this.props.get(id);
    }

    public void removeProperty(String id) {
        this.props.remove(id);
    }

    public Properties getProperties() {
        return this.props;
    }
}

