/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.wireless.taglibs.util;

import com.iplanet.am.util.AMClientDetector;
import com.iplanet.am.util.Locale;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.cdm.Client;
import com.iplanet.sso.SSOToken;
import com.sun.mobile.util.ResourceLookup;
import com.sun.portal.wireless.taglibs.base.Context;
import com.sun.portal.wireless.taglibs.base.Util;
import com.sun.portal.wireless.taglibs.dispatcher.Compressor;
import com.sun.portal.wireless.util.MAConfigProperties;
import com.sun.ssoadapter.SSOAdapter;
import com.sun.ssoadapter.config.ClientAwareUserContext;
import com.sun.ssoadapter.config.PSClientAwareContextFactory;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;

public class UtilContext
extends Context {
    protected static final String CONTEXT_CLASS_NAME = "com.sun.portal.wireless.taglibs.util.UtilContext";
    protected static final String CONTEXT_CACHE_CLASS_NAME = "com.sun.portal.wireless.taglibs.util.UtilContextCache";
    protected static final String CONTEXT_TYPE = "Util";
    private String jspDocRoot;
    private static HashMap lookupCache = new HashMap(100);
    private static int cacheDefeatCounter = 0;
    private Compressor compressor = null;
    private String filePath;
    private String locale = null;
    private String type = null;
    private String charset;
    private boolean rfc2396 = true;
    private boolean urlAmpEntity = true;
    private String counterName = null;
    private String escapeClassName = "com.sun.portal.desktop.encode.XMLEncoder";
    private String parmDelimiter = null;
    private HashMap attributes = new HashMap();
    private HashMap clientAttributeCache = new HashMap();

    public void init(HttpServletRequest request) throws Exception {
        String acceptCharSet;
        this.jspDocRoot = MAConfigProperties.get((String)"ps.jsp.doc.root", (String)"/jsp");
        AMClientDetector mapCD = new AMClientDetector();
        String clientType = mapCD.getClientType(request);
        Client clientObj = Client.getInstance((String)clientType);
        this.filePath = clientObj.getProperty("filePath");
        String escapeClassN = clientObj.getProperty("encoderClassName");
        if (escapeClassN != null) {
            this.escapeClassName = escapeClassN;
        }
        this.locale = SystemProperties.get((String)"com.iplanet.am.locale", (String)"en_US");
        if (this.charset == null) {
            this.charset = clientObj.getCharset(Locale.getLocale((String)this.locale));
        }
        if (this.charset == null && (acceptCharSet = request.getHeader("Accept-Charset")) != null) {
            StringTokenizer st = new StringTokenizer(acceptCharSet, ",");
            try {
                if (st.hasMoreTokens()) {
                    this.charset = st.nextToken();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.charset == null) {
            this.charset = "ISO-8859-1";
        }
        this.charSetString = this.charset;
    }

    public void init(HttpServletRequest request, SSOToken session, SSOAdapter ssoAdapter) throws Exception {
        this.jspDocRoot = MAConfigProperties.get((String)"ps.jsp.doc.root", (String)"/jsp");
        try {
            this.compressor = Compressor.getCompressor((SSOToken)session);
        }
        catch (Exception e) {
            Util.logWarning((String)(((Object)((Object)this)).getClass().getName() + ".init(): getCompressor() failed.  e=" + e));
            throw e;
        }
        try {
            super.init(request, session, ssoAdapter);
        }
        catch (Exception e) {
            Util.logWarning((String)(((Object)((Object)this)).getClass().getName() + ".init(): super.init() failed.  e=" + e));
            throw e;
        }
        try {
            this.profileDerivedSetup(request);
        }
        catch (Exception e) {
            Util.logWarning((String)(((Object)((Object)this)).getClass().getName() + ".init(): profileDerivedSetup() failed.  e=" + e));
            throw e;
        }
    }

    private void profileDerivedSetup(HttpServletRequest request) throws Exception {
        this.filePath = null;
        Client clientObj = null;
        try {
            clientObj = Client.getInstance((String)this.getClientType());
            this.filePath = clientObj.getProperty("filePath");
        }
        catch (Exception ee) {
            Util.logWarning((String)(((Object)((Object)this)).getClass().getName() + ".profileDerivedSetup(): getProperty(filePath) failed.  e=" + ee));
        }
        String escapeClassN = null;
        try {
            escapeClassN = clientObj.getProperty("encoderClassName");
            if (escapeClassN != null) {
                this.escapeClassName = escapeClassN;
            }
        }
        catch (Exception e) {
            Util.logWarning((String)(((Object)((Object)this)).getClass().getName() + ".profileDerivedSetup(): getProperty(encoderClassName) failed.  e=" + e));
        }
        this.locale = this.getUserLocaleString();
        try {
            HashMap<String, String> serviceMap = new HashMap<String, String>();
            serviceMap.put("serviceName", "SunPortalDesktopService");
            PSClientAwareContextFactory contextFactory = PSClientAwareContextFactory.getInstance();
            ClientAwareUserContext userContext = contextFactory.getClientAwareUserContext(request);
            this.type = userContext.getStringAttribute(serviceMap, "sunPortalDesktopType");
        }
        catch (Exception e) {
            Util.logWarning((String)(((Object)((Object)this)).getClass().getName() + ".profileDerivedSetup(): setup for SunPortalDesktopService failed.  e=" + e));
        }
        this.charset = super.getCharset();
    }

    public static UtilContext getContext(PageContext pageContext) throws Exception {
        pageContext.setAttribute("UtilconfigName", (Object)"UTILDEFAULT");
        try {
            return (UtilContext)Context.getContext((PageContext)pageContext, (String)CONTEXT_CLASS_NAME, (String)CONTEXT_CACHE_CLASS_NAME, (String)CONTEXT_TYPE);
        }
        catch (Exception e) {
            Util.logWarning((String)"com.sun.portal.wireless.taglibs.util.UtilContext.getContext():  creating session-less util context.");
            UtilContext context = new UtilContext();
            context.init((HttpServletRequest)pageContext.getRequest());
            pageContext.setAttribute(CONTEXT_CLASS_NAME, (Object)context);
            return context;
        }
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public String getURL(PageContext pageContext, String fileName, String compName, String parms) {
        String subCompName = null;
        try {
            Context context = (Context)pageContext.getAttribute(compName + "context");
            SSOAdapter ssoAdapter = context.getSSOAdapter();
            subCompName = ssoAdapter.getProperties().getProperty("subType");
        }
        catch (Exception e) {
            Util.logWarning((String)(((Object)((Object)this)).getClass().getName() + ".getURL(): failed to determine sub-component name."));
        }
        String resourceName = ResourceLookup.getFirstExisting((ServletContext)pageContext.getServletContext(), (String)this.type, (String)this.locale, (String)compName, (String)subCompName, (String)this.filePath, (String)fileName, (String)this.jspDocRoot, (boolean)true);
        String finalUrl = resourceName != null ? resourceName : this.jspDocRoot + "/" + fileName;
        if (parms != null) {
            finalUrl = finalUrl + "?" + parms;
        }
        return finalUrl;
    }

    public String getURL(String path, String parms) {
        String finalUrl = path;
        if (parms != null) {
            finalUrl = finalUrl + "?" + parms;
        }
        return finalUrl;
    }

    public Compressor getCompressor() {
        return this.compressor;
    }

    public String getClientAttribute(HttpServletRequest request, String serviceName, String attributeName) {
        String targetValue = null;
        String cacheKey = serviceName + attributeName;
        targetValue = (String)this.clientAttributeCache.get(cacheKey);
        if (targetValue != null) {
            return targetValue;
        }
        Object attributeValue = null;
        try {
            PSClientAwareContextFactory contextFactory = PSClientAwareContextFactory.getInstance();
            HashMap<String, String> serviceMap = new HashMap<String, String>();
            serviceMap.put("serviceName", serviceName);
            ClientAwareUserContext userContext = contextFactory.getClientAwareUserContext(request);
            targetValue = userContext.getStringAttribute(serviceMap, attributeName);
        }
        catch (Exception e) {
            Util.logWarning((String)(((Object)((Object)this)).getClass().getName() + ".getClientAttribute(): "), (Throwable)e);
            targetValue = "";
            return targetValue;
        }
        this.clientAttributeCache.put(cacheKey, targetValue);
        return targetValue;
    }

    public String getCounterString() {
        String count = Integer.toHexString(cacheDefeatCounter++ % 65536);
        switch (count.length()) {
            case 4: {
                return count;
            }
            case 3: {
                return "0" + count;
            }
            case 2: {
                return "00" + count;
            }
            case 1: {
                return "000" + count;
            }
        }
        return count;
    }

    public void setRfc2396(boolean b) {
        this.rfc2396 = b;
    }

    public boolean getRfc2396() {
        return this.rfc2396;
    }

    public void setUrlAmpEntity(boolean b) {
        this.urlAmpEntity = b;
    }

    public boolean getUrlAmpEntity() {
        return this.urlAmpEntity;
    }

    public void setCounterName(String s) {
        this.counterName = s != null && s.length() == 0 ? null : s;
    }

    public String getCounterName() {
        return this.counterName;
    }

    public void setParmDelimiter(String s) {
        this.parmDelimiter = s != null && s.length() == 0 ? null : s;
    }

    public String getParmDelimiter() {
        return this.parmDelimiter;
    }

    public void setEscapeClassName(String escapeClassNameParam) {
        this.escapeClassName = escapeClassNameParam;
    }

    public String getEscapeClassName() {
        return this.escapeClassName;
    }
}

