/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.client.jnlp.ui;

import com.sun.portal.netlet.client.common.ResourceProperties;
import com.sun.portal.netlet.client.jnlp.ClientManager;
import com.sun.portal.netlet.client.jnlp.ui.NetletTab;
import com.sun.portal.netlet.client.jnlp.ui.ProxyletTab;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class SRAContentPane
extends JPanel {
    private NetletTab netletTab = null;
    private ProxyletTab proxyletTab = null;
    private JButton closeButton;
    private GridBagConstraints gbc = new GridBagConstraints();

    public SRAContentPane() {
        super(new GridBagLayout());
        this.gbc.fill = 2;
        this.gbc.weightx = 0.5;
        this.load();
    }

    private void load() {
        this.addTabbedPane();
        this.addActionPanel();
    }

    private void addTabbedPane() {
        JTabbedPane tabbedPane = new JTabbedPane();
        if (ClientManager.getNetletHandler().netletClientLoaded()) {
            this.netletTab = new NetletTab();
            this.netletTab.setOpaque(true);
            tabbedPane.addTab(ResourceProperties.getString("jws.netletTab"), this.netletTab);
        }
        if (ClientManager.getProxyletHandler().proxyletClientLoaded()) {
            this.proxyletTab = new ProxyletTab();
            this.proxyletTab.setOpaque(true);
            tabbedPane.addTab(ResourceProperties.getString("jws.proxyletTab"), this.proxyletTab);
        }
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.add((Component)tabbedPane, this.gbc);
    }

    private void addActionPanel() {
        JPanel actionPanel = new JPanel(new FlowLayout(1));
        SRAPaneActionListener al = new SRAPaneActionListener();
        this.closeButton = new JButton(ResourceProperties.getString("jws.sraPaneClose"));
        this.closeButton.addActionListener(al);
        actionPanel.add(this.closeButton);
        this.gbc.gridx = 0;
        this.gbc.gridy = 1;
        this.add((Component)actionPanel, this.gbc);
    }

    public void refreshNetletTab() {
        this.netletTab.refresh();
    }

    public void refreshProxyletTab() {
        this.proxyletTab.refresh();
    }

    public void refresh() {
        this.removeAll();
        this.load();
        ClientManager.getSRAClientWindow().pack();
    }

    class SRAPaneActionListener
    implements ActionListener {
        SRAPaneActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            SRAContentPane.this.closeButton.setEnabled(false);
            ClientManager.stopProcessing();
        }
    }
}

